/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.PotDecorations;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class DecoratedPotBlock
extends BlockTileEntity
implements IBlockWaterlogged {
    public static final MapCodec<DecoratedPotBlock> a = DecoratedPotBlock.b(DecoratedPotBlock::new);
    public static final MinecraftKey b = MinecraftKey.b("sherds");
    private static final VoxelShape d = Block.a(1.0, 0.0, 1.0, 15.0, 16.0, 15.0);
    private static final BlockStateDirection e = BlockProperties.R;
    public static final BlockStateBoolean c = BlockProperties.bw;
    private static final BlockStateBoolean f = BlockProperties.C;

    public MapCodec<DecoratedPotBlock> a() {
        return a;
    }

    protected DecoratedPotBlock(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.k((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.E.b()).a(e, EnumDirection.c)).a(f, false)).a(c, false));
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        if (iblockdata.c(f).booleanValue()) {
            generatoraccess.a(blockposition, FluidTypes.c, FluidTypes.c.a(generatoraccess));
        }
        return super.a(iblockdata, enumdirection, iblockdata1, generatoraccess, blockposition, blockposition1);
    }

    @Override
    public IBlockData a(BlockActionContext blockactioncontext) {
        Fluid fluid = blockactioncontext.q().b_(blockactioncontext.a());
        return (IBlockData)((IBlockData)((IBlockData)this.o().a(e, blockactioncontext.g())).a(f, fluid.a() == FluidTypes.c)).a(c, false);
    }

    @Override
    protected ItemInteractionResult a(ItemStack itemstack, IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, EnumHand enumhand, MovingObjectPositionBlock movingobjectpositionblock) {
        TileEntity tileentity = world.c_(blockposition);
        if (tileentity instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity decoratedpotblockentity = (DecoratedPotBlockEntity)tileentity;
            if (world.B) {
                return ItemInteractionResult.b;
            }
            ItemStack itemstack1 = decoratedpotblockentity.f();
            if (!itemstack.e() && (itemstack1.e() || ItemStack.c(itemstack1, itemstack) && itemstack1.H() < itemstack1.j())) {
                float f2;
                decoratedpotblockentity.a(DecoratedPotBlockEntity.a.a);
                entityhuman.b(StatisticList.c.b(itemstack.g()));
                ItemStack itemstack2 = itemstack.b(1, (EntityLiving)entityhuman);
                if (decoratedpotblockentity.c()) {
                    decoratedpotblockentity.b(itemstack2);
                    f2 = (float)itemstack2.H() / (float)itemstack2.j();
                } else {
                    itemstack1.g(1);
                    f2 = (float)itemstack1.H() / (float)itemstack1.j();
                }
                world.a((EntityHuman)null, blockposition, SoundEffects.gy, SoundCategory.e, 1.0f, 0.7f + 0.5f * f2);
                if (world instanceof WorldServer) {
                    WorldServer worldserver = (WorldServer)world;
                    worldserver.a(Particles.aX, (double)blockposition.u() + 0.5, (double)blockposition.v() + 1.2, (double)blockposition.w() + 0.5, 7, 0.0, 0.0, 0.0, 0.0);
                }
                decoratedpotblockentity.e();
                world.a((Entity)entityhuman, GameEvent.c, blockposition);
                return ItemInteractionResult.a;
            }
            return ItemInteractionResult.d;
        }
        return ItemInteractionResult.e;
    }

    @Override
    protected EnumInteractionResult a(IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, MovingObjectPositionBlock movingobjectpositionblock) {
        TileEntity tileentity = world.c_(blockposition);
        if (tileentity instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity decoratedpotblockentity = (DecoratedPotBlockEntity)tileentity;
            world.a((EntityHuman)null, blockposition, SoundEffects.gz, SoundCategory.e, 1.0f, 1.0f);
            decoratedpotblockentity.a(DecoratedPotBlockEntity.a.b);
            world.a((Entity)entityhuman, GameEvent.c, blockposition);
            return EnumInteractionResult.a;
        }
        return EnumInteractionResult.e;
    }

    @Override
    protected boolean a(IBlockData iblockdata, PathMode pathmode) {
        return false;
    }

    @Override
    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return d;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(e, f, c);
    }

    @Override
    @Nullable
    public TileEntity a(BlockPosition blockposition, IBlockData iblockdata) {
        return new DecoratedPotBlockEntity(blockposition, iblockdata);
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        InventoryUtils.a(iblockdata, iblockdata1, world, blockposition);
        super.a(iblockdata, world, blockposition, iblockdata1, flag);
    }

    @Override
    protected List<ItemStack> a(IBlockData iblockdata, LootParams.a lootparams_a) {
        TileEntity tileentity = lootparams_a.b(LootContextParameters.h);
        if (tileentity instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity decoratedpotblockentity = (DecoratedPotBlockEntity)tileentity;
            lootparams_a.a(b, (Consumer<ItemStack> consumer) -> {
                for (Item item : decoratedpotblockentity.l().a()) {
                    consumer.accept(item.w());
                }
            });
        }
        return super.a(iblockdata, lootparams_a);
    }

    @Override
    public IBlockData a(World world, BlockPosition blockposition, IBlockData iblockdata, EntityHuman entityhuman) {
        ItemStack itemstack = entityhuman.eT();
        IBlockData iblockdata1 = iblockdata;
        if (itemstack.a(TagsItem.bv) && !EnchantmentManager.a(itemstack, EnchantmentTags.r)) {
            iblockdata1 = (IBlockData)iblockdata.a(c, true);
            world.a(blockposition, iblockdata1, 4);
        }
        return super.a(world, blockposition, iblockdata1, entityhuman);
    }

    @Override
    protected Fluid b_(IBlockData iblockdata) {
        return iblockdata.c(f) != false ? FluidTypes.c.a(false) : super.b_(iblockdata);
    }

    @Override
    protected SoundEffectType g_(IBlockData iblockdata) {
        return iblockdata.c(c) != false ? SoundEffectType.bc : SoundEffectType.bb;
    }

    @Override
    public void a(ItemStack itemstack, Item.b item_b, List<IChatBaseComponent> list, TooltipFlag tooltipflag) {
        super.a(itemstack, item_b, list, tooltipflag);
        PotDecorations potdecorations = itemstack.a(DataComponents.aa, PotDecorations.a);
        if (!potdecorations.equals(PotDecorations.a)) {
            list.add(CommonComponents.a);
            Stream.of(potdecorations.e(), potdecorations.c(), potdecorations.d(), potdecorations.b()).forEach(optional -> list.add(new ItemStack(optional.orElse(Items.qL), 1).w().e().a(EnumChatFormat.h)));
        }
    }

    @Override
    protected void a(World world, IBlockData iblockdata, MovingObjectPositionBlock movingobjectpositionblock, IProjectile iprojectile) {
        BlockPosition blockposition = movingobjectpositionblock.a();
        if (!world.B && iprojectile.a(world, blockposition) && iprojectile.b(world)) {
            if (!CraftEventFactory.callEntityChangeBlockEvent(iprojectile, blockposition, this.b_(iblockdata).g())) {
                return;
            }
            world.a(blockposition, (IBlockData)iblockdata.a(c, true), 4);
            world.a(blockposition, true, iprojectile);
        }
    }

    @Override
    public ItemStack a(IWorldReader iworldreader, BlockPosition blockposition, IBlockData iblockdata) {
        TileEntity tileentity = iworldreader.c_(blockposition);
        if (tileentity instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity decoratedpotblockentity = (DecoratedPotBlockEntity)tileentity;
            return decoratedpotblockentity.u();
        }
        return super.a(iworldreader, blockposition, iblockdata);
    }

    @Override
    protected boolean c_(IBlockData iblockdata) {
        return true;
    }

    @Override
    protected int a(IBlockData iblockdata, World world, BlockPosition blockposition) {
        return Container.a(world.c_(blockposition));
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, EnumBlockRotation enumblockrotation) {
        return (IBlockData)iblockdata.a(e, enumblockrotation.a(iblockdata.c(e)));
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, EnumBlockMirror enumblockmirror) {
        return iblockdata.a(enumblockmirror.a(iblockdata.c(e)));
    }
}

