/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCauldron;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockStates;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.CauldronLevelChangeEvent;

public class LayeredCauldronBlock
extends AbstractCauldronBlock {
    public static final MapCodec<LayeredCauldronBlock> d = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BiomeBase.Precipitation.d.fieldOf("precipitation").forGetter(layeredcauldronblock -> layeredcauldronblock.j), (App)CauldronInteraction.b.fieldOf("interactions").forGetter(layeredcauldronblock -> layeredcauldronblock.c), LayeredCauldronBlock.u()).apply((Applicative)instance, LayeredCauldronBlock::new));
    public static final int e = 1;
    public static final int f = 3;
    public static final BlockStateInteger g = BlockProperties.aK;
    private static final int h = 6;
    private static final double i = 3.0;
    private final BiomeBase.Precipitation j;

    public MapCodec<LayeredCauldronBlock> a() {
        return d;
    }

    public LayeredCauldronBlock(BiomeBase.Precipitation biomebase_precipitation, CauldronInteraction.a cauldroninteraction_a, BlockBase.Info blockbase_info) {
        super(blockbase_info, cauldroninteraction_a);
        this.j = biomebase_precipitation;
        this.k((IBlockData)((IBlockData)this.E.b()).a(g, 1));
    }

    @Override
    public boolean d(IBlockData iblockdata) {
        return iblockdata.c(g) == 3;
    }

    @Override
    protected boolean a(FluidType fluidtype) {
        return fluidtype == FluidTypes.c && this.j == BiomeBase.Precipitation.b;
    }

    @Override
    protected double b(IBlockData iblockdata) {
        return (6.0 + (double)iblockdata.c(g).intValue() * 3.0) / 16.0;
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, net.minecraft.world.entity.Entity entity) {
        if (!world.B && entity.bR() && this.a(iblockdata, blockposition, entity)) {
            if (entity.a(world, blockposition) && !LayeredCauldronBlock.lowerFillLevel(iblockdata, world, blockposition, entity, CauldronLevelChangeEvent.ChangeReason.EXTINGUISH)) {
                return;
            }
            entity.aD();
        }
    }

    private void e(IBlockData iblockdata, World world, BlockPosition blockposition) {
        if (this.j == BiomeBase.Precipitation.c) {
            LayeredCauldronBlock.d((IBlockData)Blocks.fu.o().a(g, iblockdata.c(g)), world, blockposition);
        } else {
            LayeredCauldronBlock.d(iblockdata, world, blockposition);
        }
    }

    public static void d(IBlockData iblockdata, World world, BlockPosition blockposition) {
        LayeredCauldronBlock.lowerFillLevel(iblockdata, world, blockposition, null, CauldronLevelChangeEvent.ChangeReason.UNKNOWN);
    }

    public static boolean lowerFillLevel(IBlockData iblockdata, World world, BlockPosition blockposition, net.minecraft.world.entity.Entity entity, CauldronLevelChangeEvent.ChangeReason reason) {
        int i2 = iblockdata.c(g) - 1;
        IBlockData iblockdata1 = i2 == 0 ? Blocks.ft.o() : (IBlockData)iblockdata.a(g, i2);
        return LayeredCauldronBlock.changeLevel(iblockdata, world, blockposition, iblockdata1, entity, reason);
    }

    public static boolean changeLevel(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData newBlock, net.minecraft.world.entity.Entity entity, CauldronLevelChangeEvent.ChangeReason reason) {
        CraftBlockState newState = CraftBlockStates.getBlockState(world, blockposition);
        newState.setData(newBlock);
        CauldronLevelChangeEvent event = new CauldronLevelChangeEvent(world.getWorld().getBlockAt(blockposition.u(), blockposition.v(), blockposition.w()), (Entity)(entity == null ? null : entity.getBukkitEntity()), reason, (BlockState)newState);
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        newState.update(true);
        world.a(GameEvent.c, blockposition, GameEvent.a.a(newBlock));
        return true;
    }

    @Override
    public void a(IBlockData iblockdata, World world, BlockPosition blockposition, BiomeBase.Precipitation biomebase_precipitation) {
        if (BlockCauldron.a(world, biomebase_precipitation) && iblockdata.c(g) != 3 && biomebase_precipitation == this.j) {
            IBlockData iblockdata1 = (IBlockData)iblockdata.a(g);
            LayeredCauldronBlock.changeLevel(iblockdata, world, blockposition, iblockdata1, null, CauldronLevelChangeEvent.ChangeReason.NATURAL_FILL);
        }
    }

    @Override
    protected int a(IBlockData iblockdata, World world, BlockPosition blockposition) {
        return iblockdata.c(g);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(new IBlockState[]{g});
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, FluidType fluidtype) {
        if (!this.d(iblockdata)) {
            IBlockData iblockdata1 = (IBlockData)iblockdata.a(g, iblockdata.c(g) + 1);
            if (!LayeredCauldronBlock.changeLevel(iblockdata, world, blockposition, iblockdata1, null, CauldronLevelChangeEvent.ChangeReason.NATURAL_FILL)) {
                return;
            }
            world.c(1047, blockposition, 0);
        }
    }
}

