/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.RodBlock;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;

public class LightningRodBlock
extends RodBlock
implements IBlockWaterlogged {
    public static final MapCodec<LightningRodBlock> b = LightningRodBlock.b(LightningRodBlock::new);
    public static final BlockStateBoolean c = BlockProperties.C;
    public static final BlockStateBoolean d = BlockProperties.w;
    private static final int k = 8;
    public static final int e = 128;
    private static final int l = 200;

    public MapCodec<LightningRodBlock> a() {
        return b;
    }

    public LightningRodBlock(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.k((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.E.b()).a(a, EnumDirection.b)).a(c, false)).a(d, false));
    }

    @Override
    public IBlockData a(BlockActionContext blockactioncontext) {
        Fluid fluid = blockactioncontext.q().b_(blockactioncontext.a());
        boolean flag = fluid.a() == FluidTypes.c;
        return (IBlockData)((IBlockData)this.o().a(a, blockactioncontext.k())).a(c, flag);
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        if (iblockdata.c(c).booleanValue()) {
            generatoraccess.a(blockposition, FluidTypes.c, FluidTypes.c.a(generatoraccess));
        }
        return super.a(iblockdata, enumdirection, iblockdata1, generatoraccess, blockposition, blockposition1);
    }

    @Override
    protected Fluid b_(IBlockData iblockdata) {
        return iblockdata.c(c) != false ? FluidTypes.c.a(false) : super.b_(iblockdata);
    }

    @Override
    protected int a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
        return iblockdata.c(d) != false ? 15 : 0;
    }

    @Override
    protected int b(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
        return iblockdata.c(d) != false && iblockdata.c(a) == enumdirection ? 15 : 0;
    }

    public void d(IBlockData iblockdata, World world, BlockPosition blockposition) {
        boolean powered = iblockdata.c(d);
        int old = powered ? 15 : 0;
        int current = !powered ? 15 : 0;
        BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent((org.bukkit.block.Block)CraftBlock.at(world, blockposition), old, current);
        world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
        if (eventRedstone.getNewCurrent() <= 0) {
            return;
        }
        world.a(blockposition, (IBlockData)iblockdata.a(d, true), 3);
        this.e(iblockdata, world, blockposition);
        world.a(blockposition, (Block)this, 8);
        world.c(3002, blockposition, iblockdata.c(a).o().ordinal());
    }

    private void e(IBlockData iblockdata, World world, BlockPosition blockposition) {
        world.a(blockposition.a(iblockdata.c(a).g()), this);
    }

    @Override
    protected void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        worldserver.a(blockposition, (IBlockData)iblockdata.a(d, false), 3);
        this.e(iblockdata, worldserver, blockposition);
    }

    @Override
    public void a(IBlockData iblockdata, World world, BlockPosition blockposition, RandomSource randomsource) {
        if (world.ac() && (long)world.z.a(200) <= world.Z() % 200L && blockposition.v() == world.a(HeightMap.Type.b, blockposition.u(), blockposition.w()) - 1) {
            ParticleUtils.a(iblockdata.c(a).o(), world, blockposition, 0.125, Particles.aT, UniformInt.a(1, 2));
        }
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        if (!iblockdata.a(iblockdata1.b())) {
            if (iblockdata.c(d).booleanValue()) {
                this.e(iblockdata, world, blockposition);
            }
            super.a(iblockdata, world, blockposition, iblockdata1, flag);
        }
    }

    @Override
    protected void b(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        if (!iblockdata.a(iblockdata1.b()) && iblockdata.c(d).booleanValue() && !world.P().a(blockposition, this)) {
            world.a(blockposition, (IBlockData)iblockdata.a(d, false), 18);
        }
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(a, d, c);
    }

    @Override
    protected boolean e_(IBlockData iblockdata) {
        return true;
    }
}

