/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.MapCodec;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class PointedDripstoneBlock
extends Block
implements Fallable,
IBlockWaterlogged {
    public static final MapCodec<PointedDripstoneBlock> a = PointedDripstoneBlock.b(PointedDripstoneBlock::new);
    public static final BlockStateDirection b = BlockProperties.bm;
    public static final BlockStateEnum<DripstoneThickness> c = BlockProperties.bn;
    public static final BlockStateBoolean d = BlockProperties.C;
    private static final int e = 11;
    private static final int f = 2;
    private static final float g = 0.02f;
    private static final float h = 0.12f;
    private static final int i = 11;
    private static final float j = 0.17578125f;
    private static final float k = 0.05859375f;
    private static final double l = 0.6;
    private static final float m = 1.0f;
    private static final int n = 40;
    private static final int o = 6;
    private static final float F = 2.0f;
    private static final int G = 2;
    private static final float H = 5.0f;
    private static final float I = 0.011377778f;
    private static final int J = 7;
    private static final int K = 10;
    private static final float L = 0.6875f;
    private static final VoxelShape M = Block.a(5.0, 0.0, 5.0, 11.0, 16.0, 11.0);
    private static final VoxelShape N = Block.a(5.0, 0.0, 5.0, 11.0, 11.0, 11.0);
    private static final VoxelShape O = Block.a(5.0, 5.0, 5.0, 11.0, 16.0, 11.0);
    private static final VoxelShape P = Block.a(4.0, 0.0, 4.0, 12.0, 16.0, 12.0);
    private static final VoxelShape Q = Block.a(3.0, 0.0, 3.0, 13.0, 16.0, 13.0);
    private static final VoxelShape R = Block.a(2.0, 0.0, 2.0, 14.0, 16.0, 14.0);
    private static final float S = 0.125f;
    private static final VoxelShape T = Block.a(6.0, 0.0, 6.0, 10.0, 16.0, 10.0);

    public MapCodec<PointedDripstoneBlock> a() {
        return a;
    }

    public PointedDripstoneBlock(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.k((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.E.b()).a(b, EnumDirection.b)).a(c, DripstoneThickness.b)).a(d, false));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(b, c, d);
    }

    @Override
    protected boolean a(IBlockData iblockdata, IWorldReader iworldreader, BlockPosition blockposition) {
        return PointedDripstoneBlock.c(iworldreader, blockposition, iblockdata.c(b));
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        if (iblockdata.c(d).booleanValue()) {
            generatoraccess.a(blockposition, FluidTypes.c, FluidTypes.c.a(generatoraccess));
        }
        if (enumdirection != EnumDirection.b && enumdirection != EnumDirection.a) {
            return iblockdata;
        }
        EnumDirection enumdirection1 = iblockdata.c(b);
        if (enumdirection1 == EnumDirection.a && generatoraccess.P().a(blockposition, this)) {
            return iblockdata;
        }
        if (enumdirection == enumdirection1.g() && !this.a(iblockdata, generatoraccess, blockposition)) {
            if (enumdirection1 == EnumDirection.a) {
                generatoraccess.a(blockposition, this, 2);
            } else {
                generatoraccess.a(blockposition, this, 1);
            }
            return iblockdata;
        }
        boolean flag = iblockdata.c(c) == DripstoneThickness.a;
        DripstoneThickness dripstonethickness = PointedDripstoneBlock.a(generatoraccess, blockposition, enumdirection1, flag);
        return (IBlockData)iblockdata.a(c, dripstonethickness);
    }

    @Override
    protected void a(World world, IBlockData iblockdata, MovingObjectPositionBlock movingobjectpositionblock, IProjectile iprojectile) {
        BlockPosition blockposition;
        if (!world.B && iprojectile.a(world, blockposition = movingobjectpositionblock.a()) && iprojectile.b(world) && iprojectile instanceof EntityThrownTrident && iprojectile.dr().f() > 0.6) {
            if (!CraftEventFactory.callEntityChangeBlockEvent(iprojectile, blockposition, Blocks.a.o())) {
                return;
            }
            world.b(blockposition, true);
        }
    }

    @Override
    public void a(World world, IBlockData iblockdata, BlockPosition blockposition, Entity entity, float f2) {
        if (iblockdata.c(b) == EnumDirection.b && iblockdata.c(c) == DripstoneThickness.b) {
            entity.a(f2 + 2.0f, 2.0f, world.aj().v().directBlock(world, blockposition));
        } else {
            super.a(world, iblockdata, blockposition, entity, f2);
        }
    }

    @Override
    public void a(IBlockData iblockdata, World world, BlockPosition blockposition, RandomSource randomsource) {
        float f2;
        if (PointedDripstoneBlock.m(iblockdata) && (f2 = randomsource.i()) <= 0.12f) {
            PointedDripstoneBlock.b(world, blockposition, iblockdata).filter(pointeddripstoneblock_a -> f2 < 0.02f || PointedDripstoneBlock.a(pointeddripstoneblock_a.b)).ifPresent(pointeddripstoneblock_a -> PointedDripstoneBlock.a(world, blockposition, iblockdata, pointeddripstoneblock_a.b));
        }
    }

    @Override
    protected void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        if (PointedDripstoneBlock.o(iblockdata) && !this.a(iblockdata, (IWorldReader)worldserver, blockposition)) {
            worldserver.b(blockposition, true);
        } else {
            PointedDripstoneBlock.a(iblockdata, worldserver, blockposition);
        }
    }

    @Override
    protected void b(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        PointedDripstoneBlock.a(iblockdata, worldserver, blockposition, randomsource.i());
        if (randomsource.i() < 0.011377778f && PointedDripstoneBlock.b(iblockdata, (IWorldReader)worldserver, blockposition)) {
            PointedDripstoneBlock.c(iblockdata, worldserver, blockposition, randomsource);
        }
    }

    @VisibleForTesting
    public static void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, float f2) {
        Optional<a> optional;
        if ((f2 <= 0.17578125f || f2 <= 0.05859375f) && PointedDripstoneBlock.b(iblockdata, (IWorldReader)worldserver, blockposition) && !(optional = PointedDripstoneBlock.b(worldserver, blockposition, iblockdata)).isEmpty()) {
            BlockPosition blockposition1;
            float f1;
            FluidType fluidtype = optional.get().b;
            if (fluidtype == FluidTypes.c) {
                f1 = 0.17578125f;
            } else {
                if (fluidtype != FluidTypes.e) {
                    return;
                }
                f1 = 0.05859375f;
            }
            if (f2 < f1 && (blockposition1 = PointedDripstoneBlock.a(iblockdata, worldserver, blockposition, 11, false)) != null) {
                if (optional.get().c.a(Blocks.sI) && fluidtype == FluidTypes.c) {
                    IBlockData iblockdata1 = Blocks.dR.o();
                    worldserver.b(optional.get().a, iblockdata1);
                    Block.a(optional.get().c, iblockdata1, worldserver, optional.get().a);
                    worldserver.a(GameEvent.c, optional.get().a, GameEvent.a.a(iblockdata1));
                    worldserver.c(1504, blockposition1, 0);
                } else {
                    BlockPosition blockposition2 = PointedDripstoneBlock.a((World)worldserver, blockposition1, fluidtype);
                    if (blockposition2 != null) {
                        worldserver.c(1504, blockposition1, 0);
                        int i2 = blockposition1.v() - blockposition2.v();
                        int j2 = 50 + i2;
                        IBlockData iblockdata2 = worldserver.a_(blockposition2);
                        worldserver.a(blockposition2, iblockdata2.b(), j2);
                    }
                }
            }
        }
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext blockactioncontext) {
        EnumDirection enumdirection;
        BlockPosition blockposition;
        World world = blockactioncontext.q();
        EnumDirection enumdirection1 = PointedDripstoneBlock.b((IWorldReader)world, blockposition = blockactioncontext.a(), enumdirection = blockactioncontext.e().g());
        if (enumdirection1 == null) {
            return null;
        }
        boolean flag = !blockactioncontext.h();
        DripstoneThickness dripstonethickness = PointedDripstoneBlock.a((IWorldReader)world, blockposition, enumdirection1, flag);
        return dripstonethickness == null ? null : (IBlockData)((IBlockData)((IBlockData)this.o().a(b, enumdirection1)).a(c, dripstonethickness)).a(d, world.b_(blockposition).a() == FluidTypes.c);
    }

    @Override
    protected Fluid b_(IBlockData iblockdata) {
        return iblockdata.c(d) != false ? FluidTypes.c.a(false) : super.b_(iblockdata);
    }

    @Override
    protected VoxelShape f(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return VoxelShapes.a();
    }

    @Override
    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        DripstoneThickness dripstonethickness = iblockdata.c(c);
        VoxelShape voxelshape = dripstonethickness == DripstoneThickness.a ? M : (dripstonethickness == DripstoneThickness.b ? (iblockdata.c(b) == EnumDirection.a ? O : N) : (dripstonethickness == DripstoneThickness.c ? P : (dripstonethickness == DripstoneThickness.d ? Q : R)));
        Vec3D vec3d = iblockdata.n(iblockaccess, blockposition);
        return voxelshape.a(vec3d.c, 0.0, vec3d.e);
    }

    @Override
    protected boolean c(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return false;
    }

    @Override
    protected float av_() {
        return 0.125f;
    }

    @Override
    public void a(World world, BlockPosition blockposition, EntityFallingBlock entityfallingblock) {
        if (!entityfallingblock.aX()) {
            world.c(1045, blockposition, 0);
        }
    }

    @Override
    public DamageSource a(Entity entity) {
        return entity.dP().c(entity);
    }

    private static void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = blockposition.k();
        IBlockData iblockdata1 = iblockdata;
        while (PointedDripstoneBlock.n(iblockdata1)) {
            EntityFallingBlock entityfallingblock = EntityFallingBlock.a(worldserver, blockposition_mutableblockposition, iblockdata1);
            if (PointedDripstoneBlock.a(iblockdata1, true)) {
                int i2 = Math.max(1 + blockposition.v() - blockposition_mutableblockposition.v(), 6);
                float f2 = 1.0f * (float)i2;
                entityfallingblock.b(f2, 40);
                break;
            }
            blockposition_mutableblockposition.c(EnumDirection.a);
            iblockdata1 = worldserver.a_(blockposition_mutableblockposition);
        }
    }

    @VisibleForTesting
    public static void c(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        IBlockData iblockdata3;
        BlockPosition blockposition1;
        IBlockData iblockdata2;
        IBlockData iblockdata1 = worldserver.a_(blockposition.b(1));
        if (PointedDripstoneBlock.a(iblockdata1, iblockdata2 = worldserver.a_(blockposition.b(2))) && (blockposition1 = PointedDripstoneBlock.a(iblockdata, worldserver, blockposition, 7, false)) != null && PointedDripstoneBlock.m(iblockdata3 = worldserver.a_(blockposition1)) && PointedDripstoneBlock.b(iblockdata3, worldserver, blockposition1)) {
            if (randomsource.h()) {
                PointedDripstoneBlock.a(worldserver, blockposition1, EnumDirection.a);
            } else {
                PointedDripstoneBlock.b(worldserver, blockposition1);
            }
        }
    }

    private static void b(WorldServer worldserver, BlockPosition blockposition) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = blockposition.k();
        for (int i2 = 0; i2 < 10; ++i2) {
            blockposition_mutableblockposition.c(EnumDirection.a);
            IBlockData iblockdata = worldserver.a_(blockposition_mutableblockposition);
            if (!iblockdata.u().c()) {
                return;
            }
            if (PointedDripstoneBlock.a(iblockdata, EnumDirection.b) && PointedDripstoneBlock.b(iblockdata, worldserver, (BlockPosition)blockposition_mutableblockposition)) {
                PointedDripstoneBlock.a(worldserver, (BlockPosition)blockposition_mutableblockposition, EnumDirection.b);
                return;
            }
            if (PointedDripstoneBlock.c(worldserver, blockposition_mutableblockposition, EnumDirection.b) && !worldserver.z(blockposition_mutableblockposition.e())) {
                PointedDripstoneBlock.a(worldserver, blockposition_mutableblockposition.e(), EnumDirection.b);
                return;
            }
            if (PointedDripstoneBlock.a((IBlockAccess)worldserver, (BlockPosition)blockposition_mutableblockposition, iblockdata)) continue;
            return;
        }
    }

    private static void a(WorldServer worldserver, BlockPosition blockposition, EnumDirection enumdirection) {
        BlockPosition blockposition1 = blockposition.a(enumdirection);
        IBlockData iblockdata = worldserver.a_(blockposition1);
        if (PointedDripstoneBlock.a(iblockdata, enumdirection.g())) {
            PointedDripstoneBlock.a(iblockdata, (GeneratorAccess)worldserver, blockposition1);
        } else if (iblockdata.i() || iblockdata.a(Blocks.G)) {
            PointedDripstoneBlock.createDripstone(worldserver, blockposition1, enumdirection, DripstoneThickness.b, blockposition);
        }
    }

    private static void createDripstone(GeneratorAccess generatoraccess, BlockPosition blockposition, EnumDirection enumdirection, DripstoneThickness dripstonethickness, BlockPosition source) {
        IBlockData iblockdata = (IBlockData)((IBlockData)((IBlockData)Blocks.st.o().a(b, enumdirection)).a(c, dripstonethickness)).a(d, generatoraccess.b_(blockposition).a() == FluidTypes.c);
        CraftEventFactory.handleBlockSpreadEvent(generatoraccess, source, blockposition, iblockdata, 3);
    }

    private static void a(IBlockData iblockdata, GeneratorAccess generatoraccess, BlockPosition blockposition) {
        BlockPosition blockposition2;
        BlockPosition blockposition1;
        if (iblockdata.c(b) == EnumDirection.b) {
            blockposition1 = blockposition;
            blockposition2 = blockposition.d();
        } else {
            blockposition2 = blockposition;
            blockposition1 = blockposition.e();
        }
        PointedDripstoneBlock.createDripstone(generatoraccess, blockposition2, EnumDirection.a, DripstoneThickness.a, blockposition);
        PointedDripstoneBlock.createDripstone(generatoraccess, blockposition1, EnumDirection.b, DripstoneThickness.a, blockposition);
    }

    public static void a(World world, BlockPosition blockposition, IBlockData iblockdata) {
        PointedDripstoneBlock.b(world, blockposition, iblockdata).ifPresent(pointeddripstoneblock_a -> PointedDripstoneBlock.a(world, blockposition, iblockdata, pointeddripstoneblock_a.b));
    }

    private static void a(World world, BlockPosition blockposition, IBlockData iblockdata, FluidType fluidtype) {
        Vec3D vec3d = iblockdata.n(world, blockposition);
        double d0 = 0.0625;
        double d1 = (double)blockposition.u() + 0.5 + vec3d.c;
        double d2 = (double)((float)(blockposition.v() + 1) - 0.6875f) - 0.0625;
        double d3 = (double)blockposition.w() + 0.5 + vec3d.e;
        FluidType fluidtype1 = PointedDripstoneBlock.a(world, fluidtype);
        ParticleType particletype = fluidtype1.a(TagsFluid.b) ? Particles.aL : Particles.aN;
        world.a(particletype, d1, d2, d3, 0.0, 0.0, 0.0);
    }

    @Nullable
    private static BlockPosition a(IBlockData iblockdata, GeneratorAccess generatoraccess, BlockPosition blockposition, int i2, boolean flag) {
        if (PointedDripstoneBlock.a(iblockdata, flag)) {
            return blockposition;
        }
        EnumDirection enumdirection = iblockdata.c(b);
        BiPredicate<BlockPosition, IBlockData> bipredicate = (blockposition1, iblockdata1) -> iblockdata1.a(Blocks.st) && iblockdata1.c(b) == enumdirection;
        return PointedDripstoneBlock.a(generatoraccess, blockposition, enumdirection.f(), bipredicate, (IBlockData iblockdata1) -> PointedDripstoneBlock.a(iblockdata1, flag), i2).orElse(null);
    }

    @Nullable
    private static EnumDirection b(IWorldReader iworldreader, BlockPosition blockposition, EnumDirection enumdirection) {
        EnumDirection enumdirection1;
        if (PointedDripstoneBlock.c(iworldreader, blockposition, enumdirection)) {
            enumdirection1 = enumdirection;
        } else {
            if (!PointedDripstoneBlock.c(iworldreader, blockposition, enumdirection.g())) {
                return null;
            }
            enumdirection1 = enumdirection.g();
        }
        return enumdirection1;
    }

    private static DripstoneThickness a(IWorldReader iworldreader, BlockPosition blockposition, EnumDirection enumdirection, boolean flag) {
        EnumDirection enumdirection1 = enumdirection.g();
        IBlockData iblockdata = iworldreader.a_(blockposition.a(enumdirection));
        if (PointedDripstoneBlock.b(iblockdata, enumdirection1)) {
            return !flag && iblockdata.c(c) != DripstoneThickness.a ? DripstoneThickness.b : DripstoneThickness.a;
        }
        if (!PointedDripstoneBlock.b(iblockdata, enumdirection)) {
            return DripstoneThickness.b;
        }
        DripstoneThickness dripstonethickness = iblockdata.c(c);
        if (dripstonethickness != DripstoneThickness.b && dripstonethickness != DripstoneThickness.a) {
            IBlockData iblockdata1 = iworldreader.a_(blockposition.a(enumdirection1));
            return !PointedDripstoneBlock.b(iblockdata1, enumdirection) ? DripstoneThickness.e : DripstoneThickness.d;
        }
        return DripstoneThickness.c;
    }

    public static boolean m(IBlockData iblockdata) {
        return PointedDripstoneBlock.n(iblockdata) && iblockdata.c(c) == DripstoneThickness.b && iblockdata.c(d) == false;
    }

    private static boolean b(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition) {
        EnumDirection enumdirection = iblockdata.c(b);
        BlockPosition blockposition1 = blockposition.a(enumdirection);
        IBlockData iblockdata1 = worldserver.a_(blockposition1);
        return !iblockdata1.u().c() ? false : (iblockdata1.i() ? true : PointedDripstoneBlock.a(iblockdata1, enumdirection.g()));
    }

    private static Optional<BlockPosition> a(World world, BlockPosition blockposition, IBlockData iblockdata, int i2) {
        EnumDirection enumdirection = iblockdata.c(b);
        BiPredicate<BlockPosition, IBlockData> bipredicate = (blockposition1, iblockdata1) -> iblockdata1.a(Blocks.st) && iblockdata1.c(b) == enumdirection;
        return PointedDripstoneBlock.a(world, blockposition, enumdirection.g().f(), bipredicate, (IBlockData iblockdata1) -> !iblockdata1.a(Blocks.st), i2);
    }

    private static boolean c(IWorldReader iworldreader, BlockPosition blockposition, EnumDirection enumdirection) {
        BlockPosition blockposition1 = blockposition.a(enumdirection.g());
        IBlockData iblockdata = iworldreader.a_(blockposition1);
        return iblockdata.d(iworldreader, blockposition1, enumdirection) || PointedDripstoneBlock.b(iblockdata, enumdirection);
    }

    private static boolean a(IBlockData iblockdata, boolean flag) {
        if (!iblockdata.a(Blocks.st)) {
            return false;
        }
        DripstoneThickness dripstonethickness = iblockdata.c(c);
        return dripstonethickness == DripstoneThickness.b || flag && dripstonethickness == DripstoneThickness.a;
    }

    private static boolean a(IBlockData iblockdata, EnumDirection enumdirection) {
        return PointedDripstoneBlock.a(iblockdata, false) && iblockdata.c(b) == enumdirection;
    }

    private static boolean n(IBlockData iblockdata) {
        return PointedDripstoneBlock.b(iblockdata, EnumDirection.a);
    }

    private static boolean o(IBlockData iblockdata) {
        return PointedDripstoneBlock.b(iblockdata, EnumDirection.b);
    }

    private static boolean b(IBlockData iblockdata, IWorldReader iworldreader, BlockPosition blockposition) {
        return PointedDripstoneBlock.n(iblockdata) && !iworldreader.a_(blockposition.d()).a(Blocks.st);
    }

    @Override
    protected boolean a(IBlockData iblockdata, PathMode pathmode) {
        return false;
    }

    private static boolean b(IBlockData iblockdata, EnumDirection enumdirection) {
        return iblockdata.a(Blocks.st) && iblockdata.c(b) == enumdirection;
    }

    @Nullable
    private static BlockPosition a(World world, BlockPosition blockposition, FluidType fluidtype) {
        Predicate<IBlockData> predicate = iblockdata -> iblockdata.b() instanceof AbstractCauldronBlock && ((AbstractCauldronBlock)iblockdata.b()).a(fluidtype);
        BiPredicate<BlockPosition, IBlockData> bipredicate = (blockposition1, iblockdata) -> PointedDripstoneBlock.a((IBlockAccess)world, blockposition1, iblockdata);
        return PointedDripstoneBlock.a(world, blockposition, EnumDirection.a.f(), bipredicate, predicate, 11).orElse(null);
    }

    @Nullable
    public static BlockPosition a(World world, BlockPosition blockposition) {
        BiPredicate<BlockPosition, IBlockData> bipredicate = (blockposition1, iblockdata) -> PointedDripstoneBlock.a((IBlockAccess)world, blockposition1, iblockdata);
        return PointedDripstoneBlock.a(world, blockposition, EnumDirection.b.f(), bipredicate, PointedDripstoneBlock::m, 11).orElse(null);
    }

    public static FluidType a(WorldServer worldserver, BlockPosition blockposition) {
        return PointedDripstoneBlock.b(worldserver, blockposition, worldserver.a_(blockposition)).map(pointeddripstoneblock_a -> pointeddripstoneblock_a.b).filter(PointedDripstoneBlock::a).orElse(FluidTypes.a);
    }

    private static Optional<a> b(World world, BlockPosition blockposition, IBlockData iblockdata) {
        return !PointedDripstoneBlock.n(iblockdata) ? Optional.empty() : PointedDripstoneBlock.a(world, blockposition, iblockdata, 11).map(blockposition1 -> {
            BlockPosition blockposition2 = blockposition1.d();
            IBlockData iblockdata1 = world.a_(blockposition2);
            FluidType object = iblockdata1.a(Blocks.sI) && !world.D_().i() ? FluidTypes.c : world.b_(blockposition2).a();
            return new a(blockposition2, object, iblockdata1);
        });
    }

    private static boolean a(FluidType fluidtype) {
        return fluidtype == FluidTypes.e || fluidtype == FluidTypes.c;
    }

    private static boolean a(IBlockData iblockdata, IBlockData iblockdata1) {
        return iblockdata.a(Blocks.su) && iblockdata1.a(Blocks.G) && iblockdata1.u().b();
    }

    private static FluidType a(World world, FluidType fluidtype) {
        return fluidtype.a(FluidTypes.a) ? (world.D_().i() ? FluidTypes.e : FluidTypes.c) : fluidtype;
    }

    private static Optional<BlockPosition> a(GeneratorAccess generatoraccess, BlockPosition blockposition, EnumDirection.EnumAxisDirection enumdirection_enumaxisdirection, BiPredicate<BlockPosition, IBlockData> bipredicate, Predicate<IBlockData> predicate, int i2) {
        EnumDirection enumdirection = EnumDirection.a(enumdirection_enumaxisdirection, EnumDirection.EnumAxis.b);
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = blockposition.k();
        for (int j2 = 1; j2 < i2; ++j2) {
            blockposition_mutableblockposition.c(enumdirection);
            IBlockData iblockdata = generatoraccess.a_(blockposition_mutableblockposition);
            if (predicate.test(iblockdata)) {
                return Optional.of(blockposition_mutableblockposition.j());
            }
            if (!generatoraccess.d(blockposition_mutableblockposition.v()) && bipredicate.test(blockposition_mutableblockposition, iblockdata)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static boolean a(IBlockAccess iblockaccess, BlockPosition blockposition, IBlockData iblockdata) {
        if (iblockdata.i()) {
            return true;
        }
        if (iblockdata.i(iblockaccess, blockposition)) {
            return false;
        }
        if (!iblockdata.u().c()) {
            return false;
        }
        VoxelShape voxelshape = iblockdata.k(iblockaccess, blockposition);
        return !VoxelShapes.c(T, voxelshape, OperatorBoolean.i);
    }

    record a(BlockPosition a, FluidType b, IBlockData c) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "pos;fluid;sourceState", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "pos;fluid;sourceState", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "pos;fluid;sourceState", "a", "b", "c"}, this, o2);
        }
    }
}

