/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.EndFeatures;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityEnderPortal;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenEndGatewayConfiguration;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class TileEntityEndGateway
extends TileEntityEnderPortal {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = 200;
    private static final int c = 40;
    private static final int d = 2400;
    private static final int e = 1;
    private static final int f = 10;
    public long g;
    private int h;
    @Nullable
    public BlockPosition i;
    public boolean j;

    public TileEntityEndGateway(BlockPosition blockposition, IBlockData iblockdata) {
        super(TileEntityTypes.v, blockposition, iblockdata);
    }

    @Override
    protected void b(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.b(nbttagcompound, holderlookup_a);
        nbttagcompound.a("Age", this.g);
        if (this.i != null) {
            nbttagcompound.a("exit_portal", GameProfileSerializer.a(this.i));
        }
        if (this.j) {
            nbttagcompound.a("ExactTeleport", true);
        }
    }

    @Override
    protected void a(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.a(nbttagcompound, holderlookup_a);
        this.g = nbttagcompound.i("Age");
        GameProfileSerializer.a(nbttagcompound, "exit_portal").filter(World::l).ifPresent(blockposition -> {
            this.i = blockposition;
        });
        this.j = nbttagcompound.q("ExactTeleport");
    }

    public static void a(World world, BlockPosition blockposition, IBlockData iblockdata, TileEntityEndGateway tileentityendgateway) {
        ++tileentityendgateway.g;
        if (tileentityendgateway.c()) {
            --tileentityendgateway.h;
        }
    }

    public static void b(World world, BlockPosition blockposition, IBlockData iblockdata, TileEntityEndGateway tileentityendgateway) {
        boolean flag = tileentityendgateway.b();
        boolean flag1 = tileentityendgateway.c();
        ++tileentityendgateway.g;
        if (flag1) {
            --tileentityendgateway.h;
        } else if (tileentityendgateway.g % 2400L == 0L) {
            TileEntityEndGateway.c(world, blockposition, iblockdata, tileentityendgateway);
        }
        if (flag != tileentityendgateway.b() || flag1 != tileentityendgateway.c()) {
            TileEntityEndGateway.a(world, blockposition, iblockdata);
        }
    }

    public boolean b() {
        return this.g < 200L;
    }

    public boolean c() {
        return this.h > 0;
    }

    public float a(float f2) {
        return MathHelper.a(((float)this.g + f2) / 200.0f, 0.0f, 1.0f);
    }

    public float b(float f2) {
        return 1.0f - MathHelper.a(((float)this.h - f2) / 40.0f, 0.0f, 1.0f);
    }

    public PacketPlayOutTileEntityData d() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    public NBTTagCompound a(HolderLookup.a holderlookup_a) {
        return this.e(holderlookup_a);
    }

    public static void c(World world, BlockPosition blockposition, IBlockData iblockdata, TileEntityEndGateway tileentityendgateway) {
        if (!world.B) {
            tileentityendgateway.h = 40;
            world.a(blockposition, iblockdata.b(), 1, 0);
            TileEntityEndGateway.a(world, blockposition, iblockdata);
        }
    }

    @Override
    public boolean a_(int i2, int j2) {
        if (i2 == 1) {
            this.h = 40;
            return true;
        }
        return super.a_(i2, j2);
    }

    @Nullable
    public Vec3D a(WorldServer worldserver, BlockPosition blockposition) {
        BlockPosition blockposition1;
        if (this.i == null && worldserver.getTypeKey() == WorldDimension.d) {
            blockposition1 = TileEntityEndGateway.b(worldserver, blockposition);
            blockposition1 = blockposition1.b(10);
            a.debug("Creating portal at {}", (Object)blockposition1);
            TileEntityEndGateway.a(worldserver, blockposition1, WorldGenEndGatewayConfiguration.a(blockposition, false));
            this.a(blockposition1, this.j);
        }
        if (this.i != null) {
            blockposition1 = this.j ? this.i : TileEntityEndGateway.a((World)worldserver, this.i);
            return blockposition1.c();
        }
        return null;
    }

    private static BlockPosition a(World world, BlockPosition blockposition) {
        BlockPosition blockposition1 = TileEntityEndGateway.a((IBlockAccess)world, blockposition.b(0, 2, 0), 5, false);
        a.debug("Best exit position for portal at {} is {}", (Object)blockposition, (Object)blockposition1);
        return blockposition1.d();
    }

    private static BlockPosition b(WorldServer worldserver, BlockPosition blockposition) {
        Vec3D vec3d = TileEntityEndGateway.c(worldserver, blockposition);
        Chunk chunk = TileEntityEndGateway.a((World)worldserver, vec3d);
        BlockPosition blockposition1 = TileEntityEndGateway.a(chunk);
        if (blockposition1 == null) {
            BlockPosition blockposition2 = BlockPosition.a(vec3d.c + 0.5, 75.0, vec3d.e + 0.5);
            a.debug("Failed to find a suitable block to teleport to, spawning an island on {}", (Object)blockposition2);
            worldserver.H_().c(Registries.aI).flatMap(iregistry -> iregistry.b(EndFeatures.f)).ifPresent(holder_c -> ((WorldGenFeatureConfigured)holder_c.a()).a(worldserver, worldserver.l().g(), RandomSource.a(blockposition2.a()), blockposition2));
            blockposition1 = blockposition2;
        } else {
            a.debug("Found suitable block to teleport to: {}", (Object)blockposition1);
        }
        return TileEntityEndGateway.a((IBlockAccess)worldserver, blockposition1, 16, true);
    }

    private static Vec3D c(WorldServer worldserver, BlockPosition blockposition) {
        Vec3D vec3d = new Vec3D(blockposition.u(), 0.0, blockposition.w()).d();
        boolean flag = true;
        Vec3D vec3d1 = vec3d.a(1024.0);
        int i2 = 16;
        while (!TileEntityEndGateway.a(worldserver, vec3d1) && i2-- > 0) {
            a.debug("Skipping backwards past nonempty chunk at {}", (Object)vec3d1);
            vec3d1 = vec3d1.e(vec3d.a(-16.0));
        }
        i2 = 16;
        while (TileEntityEndGateway.a(worldserver, vec3d1) && i2-- > 0) {
            a.debug("Skipping forward past empty chunk at {}", (Object)vec3d1);
            vec3d1 = vec3d1.e(vec3d.a(16.0));
        }
        a.debug("Found chunk at {}", (Object)vec3d1);
        return vec3d1;
    }

    private static boolean a(WorldServer worldserver, Vec3D vec3d) {
        return TileEntityEndGateway.a((World)worldserver, vec3d).a() == -1;
    }

    private static BlockPosition a(IBlockAccess iblockaccess, BlockPosition blockposition, int i2, boolean flag) {
        BaseBlockPosition blockposition1 = null;
        for (int j2 = -i2; j2 <= i2; ++j2) {
            block1: for (int k2 = -i2; k2 <= i2; ++k2) {
                if (j2 == 0 && k2 == 0 && !flag) continue;
                for (int l2 = iblockaccess.am() - 1; l2 > (blockposition1 == null ? iblockaccess.I_() : blockposition1.v()); --l2) {
                    BlockPosition blockposition2 = new BlockPosition(blockposition.u() + j2, l2, blockposition.w() + k2);
                    IBlockData iblockdata = iblockaccess.a_(blockposition2);
                    if (!iblockdata.r(iblockaccess, blockposition2) || !flag && iblockdata.a(Blocks.F)) continue;
                    blockposition1 = blockposition2;
                    continue block1;
                }
            }
        }
        return blockposition1 == null ? blockposition : blockposition1;
    }

    private static Chunk a(World world, Vec3D vec3d) {
        return world.d(MathHelper.a(vec3d.c / 16.0), MathHelper.a(vec3d.e / 16.0));
    }

    @Nullable
    private static BlockPosition a(Chunk chunk) {
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        BlockPosition blockposition = new BlockPosition(chunkcoordintpair.d(), 30, chunkcoordintpair.e());
        int i2 = chunk.b() + 16 - 1;
        BlockPosition blockposition1 = new BlockPosition(chunkcoordintpair.f(), i2, chunkcoordintpair.g());
        BlockPosition blockposition2 = null;
        double d0 = 0.0;
        for (BlockPosition blockposition3 : BlockPosition.c(blockposition, blockposition1)) {
            IBlockData iblockdata = chunk.a_(blockposition3);
            BlockPosition blockposition4 = blockposition3.d();
            BlockPosition blockposition5 = blockposition3.b(2);
            if (!iblockdata.a(Blocks.fz) || chunk.a_(blockposition4).r(chunk, blockposition4) || chunk.a_(blockposition5).r(chunk, blockposition5)) continue;
            double d1 = blockposition3.c(0.0, 0.0, 0.0);
            if (blockposition2 != null && !(d1 < d0)) continue;
            blockposition2 = blockposition3;
            d0 = d1;
        }
        return blockposition2;
    }

    private static void a(WorldServer worldserver, BlockPosition blockposition, WorldGenEndGatewayConfiguration worldgenendgatewayconfiguration) {
        WorldGenerator.M.a(worldgenendgatewayconfiguration, worldserver, worldserver.l().g(), RandomSource.a(), blockposition);
    }

    @Override
    public boolean a(EnumDirection enumdirection) {
        return Block.a(this.n(), this.n, this.aD_(), enumdirection, this.aD_().a(enumdirection));
    }

    public int f() {
        int i2 = 0;
        for (EnumDirection enumdirection : EnumDirection.values()) {
            i2 += this.a(enumdirection) ? 1 : 0;
        }
        return i2;
    }

    public void a(BlockPosition blockposition, boolean flag) {
        this.j = flag;
        this.i = blockposition;
        this.e();
    }
}

