/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.IInventoryHolder;
import net.minecraft.world.IWorldInventory;
import net.minecraft.world.InventoryLargeChest;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerHopper;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockHopper;
import net.minecraft.world.level.block.entity.IHopper;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryDoubleChest;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.inventory.HopperInventorySearchEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class TileEntityHopper
extends TileEntityLootable
implements IHopper {
    public static final int d = 8;
    public static final int e = 5;
    private static final int[][] f = new int[54][];
    private NonNullList<net.minecraft.world.item.ItemStack> g;
    private int h = -1;
    private long i;
    private EnumDirection j;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 99;

    @Override
    public List<net.minecraft.world.item.ItemStack> getContents() {
        return this.g;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int al_() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    public TileEntityHopper(BlockPosition blockposition, IBlockData iblockdata) {
        super(TileEntityTypes.r, blockposition, iblockdata);
        this.g = NonNullList.a(5, net.minecraft.world.item.ItemStack.l);
        this.j = iblockdata.c(BlockHopper.b);
    }

    @Override
    protected void a(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.a(nbttagcompound, holderlookup_a);
        this.g = NonNullList.a(this.b(), net.minecraft.world.item.ItemStack.l);
        if (!this.b_(nbttagcompound)) {
            ContainerUtil.b(nbttagcompound, this.g, holderlookup_a);
        }
        this.h = nbttagcompound.h("TransferCooldown");
    }

    @Override
    protected void b(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.b(nbttagcompound, holderlookup_a);
        if (!this.c_(nbttagcompound)) {
            ContainerUtil.a(nbttagcompound, this.g, holderlookup_a);
        }
        nbttagcompound.a("TransferCooldown", this.h);
    }

    @Override
    public int b() {
        return this.g.size();
    }

    @Override
    public net.minecraft.world.item.ItemStack a(int i2, int j2) {
        this.e_((EntityHuman)null);
        return ContainerUtil.a(this.j(), i2, j2);
    }

    @Override
    public void a(int i2, net.minecraft.world.item.ItemStack itemstack) {
        this.e_((EntityHuman)null);
        this.j().set(i2, itemstack);
        itemstack.f(this.e_(itemstack));
    }

    @Override
    public void c(IBlockData iblockdata) {
        super.c(iblockdata);
        this.j = iblockdata.c(BlockHopper.b);
    }

    @Override
    protected IChatBaseComponent k() {
        return IChatBaseComponent.c("container.hopper");
    }

    public static void a(World world, BlockPosition blockposition, IBlockData iblockdata, TileEntityHopper tileentityhopper) {
        --tileentityhopper.h;
        tileentityhopper.i = world.Z();
        if (!tileentityhopper.u()) {
            tileentityhopper.d(0);
            boolean result = TileEntityHopper.a(world, blockposition, iblockdata, tileentityhopper, () -> TileEntityHopper.a(world, tileentityhopper));
            if (!result && tileentityhopper.n.spigotConfig.hopperCheck > 1) {
                tileentityhopper.d(tileentityhopper.n.spigotConfig.hopperCheck);
            }
        }
    }

    private static boolean a(World world, BlockPosition blockposition, IBlockData iblockdata, TileEntityHopper tileentityhopper, BooleanSupplier booleansupplier) {
        if (world.B) {
            return false;
        }
        if (!tileentityhopper.u() && iblockdata.c(BlockHopper.c).booleanValue()) {
            boolean flag = false;
            if (!tileentityhopper.c()) {
                flag = TileEntityHopper.a(world, blockposition, tileentityhopper);
            }
            if (!tileentityhopper.l()) {
                flag |= booleansupplier.getAsBoolean();
            }
            if (flag) {
                tileentityhopper.d(world.spigotConfig.hopperTransfer);
                TileEntityHopper.a(world, blockposition, iblockdata);
                return true;
            }
        }
        return false;
    }

    private boolean l() {
        net.minecraft.world.item.ItemStack itemstack;
        Iterator iterator = this.g.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while (!(itemstack = (net.minecraft.world.item.ItemStack)iterator.next()).e() && itemstack.H() == itemstack.j());
        return false;
    }

    private static boolean a(World world, BlockPosition blockposition, TileEntityHopper tileentityhopper) {
        IInventory iinventory = TileEntityHopper.b(world, blockposition, tileentityhopper);
        if (iinventory == null) {
            return false;
        }
        EnumDirection enumdirection = tileentityhopper.j.g();
        if (TileEntityHopper.b(iinventory, enumdirection)) {
            return false;
        }
        for (int i2 = 0; i2 < tileentityhopper.b(); ++i2) {
            net.minecraft.world.item.ItemStack itemstack = tileentityhopper.a(i2);
            if (itemstack.e()) continue;
            int j2 = itemstack.H();
            net.minecraft.world.item.ItemStack original = itemstack.s();
            CraftItemStack oitemstack = CraftItemStack.asCraftMirror(tileentityhopper.a(i2, world.spigotConfig.hopperAmount));
            Object destinationInventory = iinventory instanceof InventoryLargeChest ? new CraftInventoryDoubleChest((InventoryLargeChest)iinventory) : (iinventory.getOwner() != null ? iinventory.getOwner().getInventory() : new CraftInventory(iinventory));
            InventoryMoveItemEvent event = new InventoryMoveItemEvent(tileentityhopper.getOwner().getInventory(), (ItemStack)oitemstack, (Inventory)destinationInventory, true);
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                tileentityhopper.a(i2, original);
                tileentityhopper.d(world.spigotConfig.hopperTransfer);
                return false;
            }
            int origCount = event.getItem().getAmount();
            net.minecraft.world.item.ItemStack itemstack1 = TileEntityHopper.a((IInventory)tileentityhopper, iinventory, CraftItemStack.asNMSCopy(event.getItem()), enumdirection);
            if (itemstack1.e()) {
                iinventory.e();
                return true;
            }
            itemstack.e(j2);
            itemstack.h(origCount - itemstack1.H());
            if (j2 > world.spigotConfig.hopperAmount) continue;
            tileentityhopper.a(i2, itemstack);
        }
        return false;
    }

    private static int[] a(IInventory iinventory, EnumDirection enumdirection) {
        if (iinventory instanceof IWorldInventory) {
            IWorldInventory iworldinventory = (IWorldInventory)iinventory;
            return iworldinventory.a(enumdirection);
        }
        int i2 = iinventory.b();
        if (i2 < f.length) {
            int[] aint = f[i2];
            if (aint != null) {
                return aint;
            }
            int[] aint1 = TileEntityHopper.c(i2);
            TileEntityHopper.f[i2] = aint1;
            return aint1;
        }
        return TileEntityHopper.c(i2);
    }

    private static int[] c(int i2) {
        int[] aint = new int[i2];
        int j2 = 0;
        while (j2 < aint.length) {
            aint[j2] = j2++;
        }
        return aint;
    }

    private static boolean b(IInventory iinventory, EnumDirection enumdirection) {
        int[] aint;
        int[] aint1 = aint = TileEntityHopper.a(iinventory, enumdirection);
        int i2 = aint.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            int k2 = aint1[j2];
            net.minecraft.world.item.ItemStack itemstack = iinventory.a(k2);
            if (itemstack.H() >= itemstack.j()) continue;
            return false;
        }
        return true;
    }

    public static boolean a(World world, IHopper ihopper) {
        boolean flag;
        IBlockData iblockdata;
        BlockPosition blockposition = BlockPosition.a(ihopper.H(), ihopper.I() + 1.0, ihopper.J());
        IInventory iinventory = TileEntityHopper.a(world, ihopper, blockposition, iblockdata = world.a_(blockposition));
        if (iinventory != null) {
            EnumDirection enumdirection = EnumDirection.a;
            for (int k2 : TileEntityHopper.a(iinventory, enumdirection)) {
                if (!TileEntityHopper.tryTakeInItemFromSlot(ihopper, iinventory, k2, enumdirection, world)) continue;
                return true;
            }
            return false;
        }
        boolean bl = flag = ihopper.K() && iblockdata.r(world, blockposition) && !iblockdata.a(TagsBlock.cA);
        if (!flag) {
            for (EntityItem entityitem : TileEntityHopper.b(world, ihopper)) {
                if (!TileEntityHopper.a((IInventory)ihopper, entityitem)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean tryTakeInItemFromSlot(IHopper ihopper, IInventory iinventory, int i2, EnumDirection enumdirection, World world) {
        net.minecraft.world.item.ItemStack itemstack = iinventory.a(i2);
        if (!itemstack.e() && TileEntityHopper.a(ihopper, iinventory, itemstack, i2, enumdirection)) {
            int j2 = itemstack.H();
            net.minecraft.world.item.ItemStack original = itemstack.s();
            CraftItemStack oitemstack = CraftItemStack.asCraftMirror(iinventory.a(i2, world.spigotConfig.hopperAmount));
            Object sourceInventory = iinventory instanceof InventoryLargeChest ? new CraftInventoryDoubleChest((InventoryLargeChest)iinventory) : (iinventory.getOwner() != null ? iinventory.getOwner().getInventory() : new CraftInventory(iinventory));
            InventoryMoveItemEvent event = new InventoryMoveItemEvent((Inventory)sourceInventory, (ItemStack)oitemstack, ihopper.getOwner().getInventory(), false);
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                iinventory.a(i2, original);
                if (ihopper instanceof TileEntityHopper) {
                    ((TileEntityHopper)ihopper).d(world.spigotConfig.hopperTransfer);
                }
                return false;
            }
            int origCount = event.getItem().getAmount();
            net.minecraft.world.item.ItemStack itemstack1 = TileEntityHopper.a(iinventory, (IInventory)ihopper, CraftItemStack.asNMSCopy(event.getItem()), null);
            if (itemstack1.e()) {
                iinventory.e();
                return true;
            }
            itemstack.e(j2);
            itemstack.h(origCount - itemstack1.H());
            if (j2 <= world.spigotConfig.hopperAmount) {
                iinventory.a(i2, itemstack);
            }
        }
        return false;
    }

    public static boolean a(IInventory iinventory, EntityItem entityitem) {
        boolean flag = false;
        InventoryPickupItemEvent event = new InventoryPickupItemEvent(iinventory.getOwner().getInventory(), (Item)entityitem.getBukkitEntity());
        entityitem.dO().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        net.minecraft.world.item.ItemStack itemstack = entityitem.p().s();
        net.minecraft.world.item.ItemStack itemstack1 = TileEntityHopper.a((IInventory)null, iinventory, itemstack, (EnumDirection)null);
        if (itemstack1.e()) {
            flag = true;
            entityitem.a(net.minecraft.world.item.ItemStack.l);
            entityitem.discard(EntityRemoveEvent.Cause.PICKUP);
        } else {
            entityitem.a(itemstack1);
        }
        return flag;
    }

    public static net.minecraft.world.item.ItemStack a(@Nullable IInventory iinventory, IInventory iinventory1, net.minecraft.world.item.ItemStack itemstack, @Nullable EnumDirection enumdirection) {
        if (iinventory1 instanceof IWorldInventory) {
            IWorldInventory iworldinventory = (IWorldInventory)iinventory1;
            if (enumdirection != null) {
                int[] aint = iworldinventory.a(enumdirection);
                for (int i2 = 0; i2 < aint.length && !itemstack.e(); ++i2) {
                    itemstack = TileEntityHopper.b(iinventory, iinventory1, itemstack, aint[i2], enumdirection);
                }
                return itemstack;
            }
        }
        int j2 = iinventory1.b();
        for (int i3 = 0; i3 < j2 && !itemstack.e(); ++i3) {
            itemstack = TileEntityHopper.b(iinventory, iinventory1, itemstack, i3, enumdirection);
        }
        return itemstack;
    }

    private static boolean a(IInventory iinventory, net.minecraft.world.item.ItemStack itemstack, int i2, @Nullable EnumDirection enumdirection) {
        IWorldInventory iworldinventory;
        if (!iinventory.b(i2, itemstack)) {
            return false;
        }
        if (iinventory instanceof IWorldInventory && !(iworldinventory = (IWorldInventory)iinventory).a(i2, itemstack, enumdirection)) {
            boolean flag = false;
            return flag;
        }
        boolean flag = true;
        return flag;
    }

    private static boolean a(IInventory iinventory, IInventory iinventory1, net.minecraft.world.item.ItemStack itemstack, int i2, EnumDirection enumdirection) {
        IWorldInventory iworldinventory;
        if (!iinventory1.a(iinventory, i2, itemstack)) {
            return false;
        }
        if (iinventory1 instanceof IWorldInventory && !(iworldinventory = (IWorldInventory)iinventory1).b(i2, itemstack, enumdirection)) {
            boolean flag = false;
            return flag;
        }
        boolean flag = true;
        return flag;
    }

    private static net.minecraft.world.item.ItemStack b(@Nullable IInventory iinventory, IInventory iinventory1, net.minecraft.world.item.ItemStack itemstack, int i2, @Nullable EnumDirection enumdirection) {
        net.minecraft.world.item.ItemStack itemstack1 = iinventory1.a(i2);
        if (TileEntityHopper.a(iinventory1, itemstack, i2, enumdirection)) {
            boolean flag = false;
            boolean flag1 = iinventory1.c();
            if (itemstack1.e()) {
                if (!itemstack.e() && itemstack.H() > iinventory1.al_()) {
                    itemstack = itemstack.a(iinventory1.al_());
                }
                iinventory1.a(i2, itemstack);
                itemstack = net.minecraft.world.item.ItemStack.l;
                flag = true;
            } else if (TileEntityHopper.a(itemstack1, itemstack)) {
                int j2 = itemstack.j() - itemstack1.H();
                int k2 = Math.min(itemstack.H(), j2);
                itemstack.h(k2);
                itemstack1.g(k2);
                boolean bl = flag = k2 > 0;
            }
            if (flag) {
                TileEntityHopper tileentityhopper;
                if (flag1 && iinventory1 instanceof TileEntityHopper && !(tileentityhopper = (TileEntityHopper)iinventory1).v()) {
                    int b0 = 0;
                    if (iinventory instanceof TileEntityHopper) {
                        TileEntityHopper tileentityhopper1 = (TileEntityHopper)iinventory;
                        if (tileentityhopper.i >= tileentityhopper1.i) {
                            b0 = 1;
                        }
                    }
                    tileentityhopper.d(tileentityhopper.n.spigotConfig.hopperTransfer - b0);
                }
                iinventory1.e();
            }
        }
        return itemstack;
    }

    @Nullable
    private static IInventory runHopperInventorySearchEvent(IInventory inventory, CraftBlock hopper, CraftBlock searchLocation, HopperInventorySearchEvent.ContainerType containerType) {
        HopperInventorySearchEvent event = new HopperInventorySearchEvent((Inventory)(inventory != null ? new CraftInventory(inventory) : null), containerType, (org.bukkit.block.Block)hopper, (org.bukkit.block.Block)searchLocation);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        CraftInventory craftInventory = (CraftInventory)event.getInventory();
        return craftInventory != null ? craftInventory.getInventory() : null;
    }

    @Nullable
    private static IInventory b(World world, BlockPosition blockposition, TileEntityHopper tileentityhopper) {
        BlockPosition searchPosition = blockposition.a(tileentityhopper.j);
        IInventory inventory = TileEntityHopper.a(world, searchPosition);
        CraftBlock hopper = CraftBlock.at(world, blockposition);
        CraftBlock searchBlock = CraftBlock.at(world, searchPosition);
        return TileEntityHopper.runHopperInventorySearchEvent(inventory, hopper, searchBlock, HopperInventorySearchEvent.ContainerType.DESTINATION);
    }

    @Nullable
    private static IInventory a(World world, IHopper ihopper, BlockPosition blockposition, IBlockData iblockdata) {
        IInventory inventory = TileEntityHopper.a(world, blockposition, iblockdata, ihopper.H(), ihopper.I() + 1.0, ihopper.J());
        BlockPosition blockPosition = BlockPosition.a(ihopper.H(), ihopper.I(), ihopper.J());
        CraftBlock hopper = CraftBlock.at(world, blockPosition);
        CraftBlock container = CraftBlock.at(world, blockPosition.d());
        return TileEntityHopper.runHopperInventorySearchEvent(inventory, hopper, container, HopperInventorySearchEvent.ContainerType.SOURCE);
    }

    public static List<EntityItem> b(World world, IHopper ihopper) {
        AxisAlignedBB axisalignedbb = ihopper.am_().d(ihopper.H() - 0.5, ihopper.I() - 0.5, ihopper.J() - 0.5);
        return world.a(EntityItem.class, axisalignedbb, IEntitySelector.a);
    }

    @Nullable
    public static IInventory a(World world, BlockPosition blockposition) {
        return TileEntityHopper.a(world, blockposition, world.a_(blockposition), (double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5);
    }

    @Nullable
    private static IInventory a(World world, BlockPosition blockposition, IBlockData iblockdata, double d0, double d1, double d2) {
        IInventory iinventory = TileEntityHopper.b(world, blockposition, iblockdata);
        if (iinventory == null) {
            iinventory = TileEntityHopper.a(world, d0, d1, d2);
        }
        return iinventory;
    }

    @Nullable
    private static IInventory b(World world, BlockPosition blockposition, IBlockData iblockdata) {
        TileEntity tileentity;
        if (!world.spigotConfig.hopperCanLoadChunks && !world.B(blockposition)) {
            return null;
        }
        Block block = iblockdata.b();
        if (block instanceof IInventoryHolder) {
            return ((IInventoryHolder)((Object)block)).a(iblockdata, world, blockposition);
        }
        if (iblockdata.t() && (tileentity = world.c_(blockposition)) instanceof IInventory) {
            IInventory iinventory = (IInventory)((Object)tileentity);
            if (iinventory instanceof TileEntityChest && block instanceof BlockChest) {
                iinventory = BlockChest.a((BlockChest)block, iblockdata, world, blockposition, true);
            }
            return iinventory;
        }
        return null;
    }

    @Nullable
    private static IInventory a(World world, double d0, double d1, double d2) {
        List<Entity> list = world.a((Entity)null, new AxisAlignedBB(d0 - 0.5, d1 - 0.5, d2 - 0.5, d0 + 0.5, d1 + 0.5, d2 + 0.5), IEntitySelector.d);
        return !list.isEmpty() ? (IInventory)((Object)list.get(world.z.a(list.size()))) : null;
    }

    private static boolean a(net.minecraft.world.item.ItemStack itemstack, net.minecraft.world.item.ItemStack itemstack1) {
        return itemstack.H() <= itemstack.j() && net.minecraft.world.item.ItemStack.c(itemstack, itemstack1);
    }

    @Override
    public double H() {
        return (double)this.o.u() + 0.5;
    }

    @Override
    public double I() {
        return (double)this.o.v() + 0.5;
    }

    @Override
    public double J() {
        return (double)this.o.w() + 0.5;
    }

    @Override
    public boolean K() {
        return true;
    }

    private void d(int i2) {
        this.h = i2;
    }

    private boolean u() {
        return this.h > 0;
    }

    private boolean v() {
        return this.h > 8;
    }

    @Override
    protected NonNullList<net.minecraft.world.item.ItemStack> j() {
        return this.g;
    }

    @Override
    protected void a(NonNullList<net.minecraft.world.item.ItemStack> nonnulllist) {
        this.g = nonnulllist;
    }

    public static void a(World world, BlockPosition blockposition, IBlockData iblockdata, Entity entity, TileEntityHopper tileentityhopper) {
        EntityItem entityitem;
        if (entity instanceof EntityItem && !(entityitem = (EntityItem)entity).p().e() && entity.cK().d(-blockposition.u(), -blockposition.v(), -blockposition.w()).c(tileentityhopper.am_())) {
            TileEntityHopper.a(world, blockposition, iblockdata, tileentityhopper, () -> TileEntityHopper.a((IInventory)tileentityhopper, entityitem));
        }
    }

    @Override
    protected Container a(int i2, PlayerInventory playerinventory) {
        return new ContainerHopper(i2, playerinventory, this);
    }
}

