/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawner;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import org.bukkit.event.entity.EntityRemoveEvent;

public class TrialSpawnerData {
    public static final String a = "spawn_data";
    private static final String m = "next_mob_spawns_at";
    private static final int n = 20;
    private static final int o = 18000;
    public static MapCodec<TrialSpawnerData> b = RecordCodecBuilder.mapCodec(instance -> instance.group((App)UUIDUtil.b.lenientOptionalFieldOf("registered_players", (Object)Sets.newHashSet()).forGetter(trialspawnerdata -> trialspawnerdata.c), (App)UUIDUtil.b.lenientOptionalFieldOf("current_mobs", (Object)Sets.newHashSet()).forGetter(trialspawnerdata -> trialspawnerdata.d), (App)Codec.LONG.lenientOptionalFieldOf("cooldown_ends_at", (Object)0L).forGetter(trialspawnerdata -> trialspawnerdata.e), (App)Codec.LONG.lenientOptionalFieldOf(m, (Object)0L).forGetter(trialspawnerdata -> trialspawnerdata.f), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).lenientOptionalFieldOf("total_mobs_spawned", (Object)0).forGetter(trialspawnerdata -> trialspawnerdata.g), (App)MobSpawnerData.b.lenientOptionalFieldOf(a).forGetter(trialspawnerdata -> trialspawnerdata.h), (App)ResourceKey.a(Registries.bc).lenientOptionalFieldOf("ejecting_loot_table").forGetter(trialspawnerdata -> trialspawnerdata.i)).apply((Applicative)instance, TrialSpawnerData::new));
    public final Set<UUID> c = new HashSet<UUID>();
    public final Set<UUID> d = new HashSet<UUID>();
    protected long e;
    protected long f;
    protected int g;
    public Optional<MobSpawnerData> h;
    protected Optional<ResourceKey<LootTable>> i;
    @Nullable
    protected Entity j;
    @Nullable
    private SimpleWeightedRandomList<ItemStack> p;
    protected double k;
    protected double l;

    public TrialSpawnerData() {
        this(Collections.emptySet(), Collections.emptySet(), 0L, 0L, 0, Optional.empty(), Optional.empty());
    }

    public TrialSpawnerData(Set<UUID> set, Set<UUID> set1, long i2, long j2, int k2, Optional<MobSpawnerData> optional, Optional<ResourceKey<LootTable>> optional1) {
        this.c.addAll(set);
        this.d.addAll(set1);
        this.e = i2;
        this.f = j2;
        this.g = k2;
        this.h = optional;
        this.i = optional1;
    }

    public void a() {
        this.c.clear();
        this.g = 0;
        this.f = 0L;
        this.e = 0L;
        this.d.clear();
        this.h = Optional.empty();
    }

    public boolean a(TrialSpawner trialspawner, RandomSource randomsource) {
        boolean flag = this.b(trialspawner, randomsource).a().b("id", 8);
        return flag || !trialspawner.b().h().d();
    }

    public boolean a(TrialSpawnerConfig trialspawnerconfig, int i2) {
        return this.g >= trialspawnerconfig.a(i2);
    }

    public boolean b() {
        return this.d.isEmpty();
    }

    public boolean a(WorldServer worldserver, TrialSpawnerConfig trialspawnerconfig, int i2) {
        return worldserver.Z() >= this.f && this.d.size() < trialspawnerconfig.b(i2);
    }

    public int a(BlockPosition blockposition) {
        if (this.c.isEmpty()) {
            SystemUtils.b("Trial Spawner at " + String.valueOf(blockposition) + " has no detected players");
        }
        return Math.max(0, this.c.size() - 1);
    }

    public void a(WorldServer worldserver, BlockPosition blockposition, TrialSpawner trialspawner) {
        boolean flag;
        boolean bl = flag = (blockposition.a() + worldserver.Z()) % 20L != 0L;
        if (!(flag || trialspawner.i().equals(TrialSpawnerState.f) && trialspawner.e())) {
            boolean flag1;
            List<UUID> list = trialspawner.k().detect(worldserver, trialspawner.l(), blockposition, trialspawner.h(), true);
            if (!trialspawner.e() && !list.isEmpty()) {
                Optional<Pair<EntityHuman, Holder<MobEffectList>>> optional = TrialSpawnerData.a(worldserver, list);
                optional.ifPresent(pair -> {
                    EntityHuman entityhuman = (EntityHuman)pair.getFirst();
                    if (pair.getSecond() == MobEffects.E) {
                        TrialSpawnerData.a(entityhuman);
                    }
                    worldserver.c(3020, BlockPosition.a(entityhuman.by()), 0);
                    trialspawner.a(worldserver, blockposition);
                });
                flag1 = optional.isPresent();
            } else {
                flag1 = false;
            }
            if (!trialspawner.i().equals(TrialSpawnerState.f) || flag1) {
                List<UUID> list1;
                boolean flag2 = trialspawner.f().c.isEmpty();
                List<UUID> list2 = list1 = flag2 ? list : trialspawner.k().detect(worldserver, trialspawner.l(), blockposition, trialspawner.h(), false);
                if (this.c.addAll(list1)) {
                    this.f = Math.max(worldserver.Z() + 40L, this.f);
                    if (!flag1) {
                        int i2 = trialspawner.e() ? 3019 : 3013;
                        worldserver.c(i2, blockposition, this.c.size());
                    }
                }
            }
        }
    }

    private static Optional<Pair<EntityHuman, Holder<MobEffectList>>> a(WorldServer worldserver, List<UUID> list) {
        EntityHuman entityhuman = null;
        for (UUID uuid : list) {
            EntityHuman entityhuman1 = worldserver.b(uuid);
            if (entityhuman1 == null) continue;
            Holder<MobEffectList> holder = MobEffects.H;
            if (entityhuman1.b(holder)) {
                return Optional.of(Pair.of((Object)entityhuman1, holder));
            }
            if (!entityhuman1.b(MobEffects.E)) continue;
            entityhuman = entityhuman1;
        }
        return Optional.ofNullable(entityhuman).map(entityhuman2 -> Pair.of((Object)entityhuman2, MobEffects.E));
    }

    public void a(TrialSpawner trialspawner, WorldServer worldserver) {
        Stream stream = this.d.stream();
        Objects.requireNonNull(worldserver);
        stream.map(worldserver::a).forEach(entity -> {
            if (entity != null) {
                worldserver.c(3012, entity.do(), TrialSpawner.a.a.a());
                if (entity instanceof EntityInsentient) {
                    EntityInsentient entityinsentient = (EntityInsentient)entity;
                    entityinsentient.fQ();
                }
                entity.remove(Entity.RemovalReason.b, EntityRemoveEvent.Cause.DESPAWN);
            }
        });
        if (!trialspawner.d().h().d()) {
            this.h = Optional.empty();
        }
        this.g = 0;
        this.d.clear();
        this.f = worldserver.Z() + (long)trialspawner.d().g();
        trialspawner.j();
        this.e = worldserver.Z() + trialspawner.d().a();
    }

    private static void a(EntityHuman entityhuman) {
        MobEffect mobeffect = entityhuman.c(MobEffects.E);
        if (mobeffect != null) {
            int i2 = mobeffect.e() + 1;
            int j2 = 18000 * i2;
            entityhuman.e(MobEffects.E);
            entityhuman.b(new MobEffect(MobEffects.H, j2, 0));
        }
    }

    public boolean a(WorldServer worldserver, float f2, int i2) {
        long j2 = this.e - (long)i2;
        return (float)worldserver.Z() >= (float)j2 + f2;
    }

    public boolean b(WorldServer worldserver, float f2, int i2) {
        long j2 = this.e - (long)i2;
        return (float)(worldserver.Z() - j2) % f2 == 0.0f;
    }

    public boolean a(WorldServer worldserver) {
        return worldserver.Z() >= this.e;
    }

    public void a(TrialSpawner trialspawner, RandomSource randomsource, EntityTypes<?> entitytypes) {
        this.b(trialspawner, randomsource).a().a("id", BuiltInRegistries.f.b(entitytypes).toString());
    }

    protected MobSpawnerData b(TrialSpawner trialspawner, RandomSource randomsource) {
        if (this.h.isPresent()) {
            return this.h.get();
        }
        SimpleWeightedRandomList<MobSpawnerData> simpleweightedrandomlist = trialspawner.b().h();
        Optional<MobSpawnerData> optional = simpleweightedrandomlist.d() ? this.h : simpleweightedrandomlist.b(randomsource).map(WeightedEntry.b::b);
        this.h = Optional.of(optional.orElseGet(MobSpawnerData::new));
        trialspawner.j();
        return this.h.get();
    }

    @Nullable
    public Entity a(TrialSpawner trialspawner, World world, TrialSpawnerState trialspawnerstate) {
        NBTTagCompound nbttagcompound;
        if (!trialspawnerstate.d()) {
            return null;
        }
        if (this.j == null && (nbttagcompound = this.b(trialspawner, world.E_()).a()).b("id", 8)) {
            this.j = EntityTypes.a(nbttagcompound, world, Function.identity());
        }
        return this.j;
    }

    public NBTTagCompound a(TrialSpawnerState trialspawnerstate) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        if (trialspawnerstate == TrialSpawnerState.c) {
            nbttagcompound.a(m, this.f);
        }
        this.h.ifPresent(mobspawnerdata -> nbttagcompound.a(a, (NBTBase)MobSpawnerData.b.encodeStart((DynamicOps)DynamicOpsNBT.a, mobspawnerdata).result().orElseThrow(() -> new IllegalStateException("Invalid SpawnData"))));
        return nbttagcompound;
    }

    public double c() {
        return this.k;
    }

    public double d() {
        return this.l;
    }

    SimpleWeightedRandomList<ItemStack> a(WorldServer worldserver, TrialSpawnerConfig trialspawnerconfig, BlockPosition blockposition) {
        long i2;
        LootParams lootparams;
        if (this.p != null) {
            return this.p;
        }
        LootTable loottable = worldserver.o().be().b(trialspawnerconfig.j());
        ObjectArrayList<ItemStack> objectarraylist = loottable.a(lootparams = new LootParams.a(worldserver).a(LootContextParameterSets.b), i2 = TrialSpawnerData.a(worldserver, blockposition));
        if (objectarraylist.isEmpty()) {
            return SimpleWeightedRandomList.b();
        }
        SimpleWeightedRandomList.a<ItemStack> simpleweightedrandomlist_a = new SimpleWeightedRandomList.a<ItemStack>();
        for (ItemStack itemstack : objectarraylist) {
            simpleweightedrandomlist_a.a(itemstack.c(1), itemstack.H());
        }
        this.p = simpleweightedrandomlist_a.a();
        return this.p;
    }

    private static long a(WorldServer worldserver, BlockPosition blockposition) {
        BlockPosition blockposition1 = new BlockPosition(MathHelper.d((float)blockposition.u() / 30.0f), MathHelper.d((float)blockposition.v() / 20.0f), MathHelper.d((float)blockposition.w() / 30.0f));
        return worldserver.C() + blockposition1.a();
    }
}

