/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.vault;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.VaultBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.entity.vault.VaultClientData;
import net.minecraft.world.level.block.entity.vault.VaultConfig;
import net.minecraft.world.level.block.entity.vault.VaultServerData;
import net.minecraft.world.level.block.entity.vault.VaultSharedData;
import net.minecraft.world.level.block.entity.vault.VaultState;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.event.block.BlockDispenseLootEvent;
import org.bukkit.event.block.VaultDisplayItemEvent;
import org.slf4j.Logger;

public class VaultBlockEntity
extends TileEntity {
    private static final Logger a = LogUtils.getLogger();
    private final VaultServerData b = new VaultServerData();
    private final VaultSharedData c = new VaultSharedData();
    private final VaultClientData d = new VaultClientData();
    private VaultConfig e = VaultConfig.b;

    public VaultBlockEntity(BlockPosition blockposition, IBlockData iblockdata) {
        super(TileEntityTypes.R, blockposition, iblockdata);
    }

    @Override
    @Nullable
    public Packet<PacketListenerPlayOut> az_() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    public NBTTagCompound a(HolderLookup.a holderlookup_a) {
        return SystemUtils.a(new NBTTagCompound(), (? super T nbttagcompound) -> nbttagcompound.a("shared_data", VaultBlockEntity.a(VaultSharedData.b, this.c, holderlookup_a)));
    }

    @Override
    protected void b(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.b(nbttagcompound, holderlookup_a);
        nbttagcompound.a("config", VaultBlockEntity.a(VaultConfig.c, this.e, holderlookup_a));
        nbttagcompound.a("shared_data", VaultBlockEntity.a(VaultSharedData.b, this.c, holderlookup_a));
        nbttagcompound.a("server_data", VaultBlockEntity.a(VaultServerData.b, this.b, holderlookup_a));
    }

    private static <T> NBTBase a(Codec<T> codec, T t0, HolderLookup.a holderlookup_a) {
        return (NBTBase)codec.encodeStart(holderlookup_a.a(DynamicOpsNBT.a), t0).getOrThrow();
    }

    @Override
    protected void a(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        Optional optional;
        Logger logger;
        DataResult dataresult;
        super.a(nbttagcompound, holderlookup_a);
        RegistryOps<NBTBase> dynamicops = holderlookup_a.a(DynamicOpsNBT.a);
        if (nbttagcompound.e("server_data")) {
            dataresult = VaultServerData.b.parse(dynamicops, (Object)nbttagcompound.c("server_data"));
            logger = a;
            Objects.requireNonNull(logger);
            optional = dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0));
            VaultServerData vaultserverdata = this.b;
            Objects.requireNonNull(this.b);
            optional.ifPresent(vaultserverdata::a);
        }
        if (nbttagcompound.e("config")) {
            dataresult = VaultConfig.c.parse(dynamicops, (Object)nbttagcompound.c("config"));
            logger = a;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(vaultconfig -> {
                this.e = vaultconfig;
            });
        }
        if (nbttagcompound.e("shared_data")) {
            dataresult = VaultSharedData.b.parse(dynamicops, (Object)nbttagcompound.c("shared_data"));
            logger = a;
            Objects.requireNonNull(logger);
            optional = dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0));
            VaultSharedData vaultshareddata = this.c;
            Objects.requireNonNull(this.c);
            optional.ifPresent(vaultshareddata::a);
        }
    }

    @Nullable
    public VaultServerData b() {
        return this.n != null && !this.n.B ? this.b : null;
    }

    public VaultSharedData c() {
        return this.c;
    }

    public VaultClientData d() {
        return this.d;
    }

    public VaultConfig f() {
        return this.e;
    }

    @VisibleForTesting
    public void a(VaultConfig vaultconfig) {
        this.e = vaultconfig;
    }

    public static final class b {
        private static final int a = 14;
        private static final int b = 20;
        private static final int c = 15;

        public static void a(WorldServer worldserver, BlockPosition blockposition, IBlockData iblockdata, VaultConfig vaultconfig, VaultServerData vaultserverdata, VaultSharedData vaultshareddata) {
            VaultState vaultstate = iblockdata.c(VaultBlock.b);
            if (net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(worldserver.Z(), vaultstate)) {
                net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(worldserver, vaultstate, vaultconfig, vaultshareddata, blockposition);
            }
            IBlockData iblockdata1 = iblockdata;
            if (worldserver.Z() >= vaultserverdata.c() && !iblockdata.equals(iblockdata1 = (IBlockData)iblockdata.a(VaultBlock.b, vaultstate.a(worldserver, blockposition, vaultconfig, vaultserverdata, vaultshareddata)))) {
                net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(worldserver, blockposition, iblockdata, iblockdata1, vaultconfig, vaultshareddata);
            }
            if (vaultserverdata.c || vaultshareddata.c) {
                VaultBlockEntity.a(worldserver, blockposition, iblockdata);
                if (vaultshareddata.c) {
                    worldserver.a(blockposition, iblockdata, iblockdata1, 2);
                }
                vaultserverdata.c = false;
                vaultshareddata.c = false;
            }
        }

        public static void a(WorldServer worldserver, BlockPosition blockposition, IBlockData iblockdata, VaultConfig vaultconfig, VaultServerData vaultserverdata, VaultSharedData vaultshareddata, EntityHuman entityhuman, ItemStack itemstack) {
            VaultState vaultstate = iblockdata.c(VaultBlock.b);
            if (net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(vaultconfig, vaultstate)) {
                if (!net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(vaultconfig, itemstack)) {
                    net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(worldserver, vaultserverdata, blockposition, SoundEffects.AK);
                } else if (vaultserverdata.a(entityhuman)) {
                    net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(worldserver, vaultserverdata, blockposition, SoundEffects.AG);
                } else {
                    List<ItemStack> list = net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(worldserver, vaultconfig, blockposition, entityhuman);
                    if (!list.isEmpty()) {
                        entityhuman.b(StatisticList.c.b(itemstack.g()));
                        itemstack.a(vaultconfig.e().H(), (EntityLiving)entityhuman);
                        BlockDispenseLootEvent vaultDispenseLootEvent = CraftEventFactory.callBlockDispenseLootEvent(worldserver, blockposition, entityhuman, list);
                        if (vaultDispenseLootEvent.isCancelled()) {
                            return;
                        }
                        list = vaultDispenseLootEvent.getDispensedLoot().stream().map(CraftItemStack::asNMSCopy).toList();
                        net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(worldserver, iblockdata, blockposition, vaultconfig, vaultserverdata, vaultshareddata, list);
                        vaultserverdata.b(entityhuman);
                        vaultshareddata.a(worldserver, blockposition, vaultserverdata, vaultconfig, vaultconfig.d());
                    }
                }
            }
        }

        static void a(WorldServer worldserver, BlockPosition blockposition, IBlockData iblockdata, IBlockData iblockdata1, VaultConfig vaultconfig, VaultSharedData vaultshareddata) {
            VaultState vaultstate = iblockdata.c(VaultBlock.b);
            VaultState vaultstate1 = iblockdata1.c(VaultBlock.b);
            worldserver.a(blockposition, iblockdata1, 3);
            vaultstate.a(worldserver, blockposition, vaultstate1, vaultconfig, vaultshareddata, iblockdata1.c(VaultBlock.d));
        }

        static void a(WorldServer worldserver, VaultState vaultstate, VaultConfig vaultconfig, VaultSharedData vaultshareddata, BlockPosition blockposition) {
            if (!net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(vaultconfig, vaultstate)) {
                vaultshareddata.a(ItemStack.l);
            } else {
                ItemStack itemstack = net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(worldserver, blockposition, vaultconfig.f().orElse(vaultconfig.b()));
                VaultDisplayItemEvent event = CraftEventFactory.callVaultDisplayItemEvent(worldserver, blockposition, itemstack);
                if (event.isCancelled()) {
                    return;
                }
                itemstack = CraftItemStack.asNMSCopy(event.getDisplayItem());
                vaultshareddata.a(itemstack);
            }
        }

        private static ItemStack a(WorldServer worldserver, BlockPosition blockposition, ResourceKey<LootTable> resourcekey) {
            LootParams lootparams;
            LootTable loottable = worldserver.o().be().b(resourcekey);
            ObjectArrayList<ItemStack> list = loottable.a(lootparams = new LootParams.a(worldserver).a(LootContextParameters.f, Vec3D.b(blockposition)).a(LootContextParameterSets.l), worldserver.E_());
            return list.isEmpty() ? ItemStack.l : SystemUtils.a(list, worldserver.E_());
        }

        private static void a(WorldServer worldserver, IBlockData iblockdata, BlockPosition blockposition, VaultConfig vaultconfig, VaultServerData vaultserverdata, VaultSharedData vaultshareddata, List<ItemStack> list) {
            vaultserverdata.a(list);
            vaultshareddata.a(vaultserverdata.f());
            vaultserverdata.b(worldserver.Z() + 14L);
            net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(worldserver, blockposition, iblockdata, (IBlockData)iblockdata.a(VaultBlock.b, VaultState.c), vaultconfig, vaultshareddata);
        }

        private static List<ItemStack> a(WorldServer worldserver, VaultConfig vaultconfig, BlockPosition blockposition, EntityHuman entityhuman) {
            LootTable loottable = worldserver.o().be().b(vaultconfig.b());
            LootParams lootparams = new LootParams.a(worldserver).a(LootContextParameters.f, Vec3D.b(blockposition)).a(entityhuman.gu()).a(LootContextParameters.a, entityhuman).a(LootContextParameterSets.l);
            return loottable.a(lootparams);
        }

        private static boolean a(VaultConfig vaultconfig, VaultState vaultstate) {
            return vaultconfig.b() != LootTables.a && !vaultconfig.e().e() && vaultstate != VaultState.a;
        }

        private static boolean a(VaultConfig vaultconfig, ItemStack itemstack) {
            return ItemStack.c(itemstack, vaultconfig.e()) && itemstack.H() >= vaultconfig.e().H();
        }

        private static boolean a(long i2, VaultState vaultstate) {
            return i2 % 20L == 0L && vaultstate == VaultState.b;
        }

        private static void a(WorldServer worldserver, VaultServerData vaultserverdata, BlockPosition blockposition, SoundEffect soundeffect) {
            if (worldserver.Z() >= vaultserverdata.a() + 15L) {
                worldserver.a((EntityHuman)null, blockposition, soundeffect, SoundCategory.e);
                vaultserverdata.a(worldserver.Z());
            }
        }
    }

    public static final class a {
        private static final int a = 20;
        private static final float b = 0.5f;
        private static final float c = 0.02f;
        private static final int d = 20;
        private static final int e = 20;

        public static void a(World world, BlockPosition blockposition, IBlockData iblockdata, VaultClientData vaultclientdata, VaultSharedData vaultshareddata) {
            vaultclientdata.c();
            if (world.Z() % 20L == 0L) {
                net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(world, blockposition, iblockdata, vaultshareddata);
            }
            net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(world, blockposition, vaultshareddata, iblockdata.c(VaultBlock.d) != false ? Particles.L : Particles.aJ);
            net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(world, blockposition, vaultshareddata);
        }

        public static void a(World world, BlockPosition blockposition, IBlockData iblockdata, VaultSharedData vaultshareddata, ParticleParam particleparam) {
            net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(world, blockposition, iblockdata, vaultshareddata);
            RandomSource randomsource = world.z;
            for (int i2 = 0; i2 < 20; ++i2) {
                Vec3D vec3d = net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.b(blockposition, randomsource);
                world.a(Particles.ae, vec3d.a(), vec3d.b(), vec3d.c(), 0.0, 0.0, 0.0);
                world.a(particleparam, vec3d.a(), vec3d.b(), vec3d.c(), 0.0, 0.0, 0.0);
            }
        }

        public static void a(World world, BlockPosition blockposition, ParticleParam particleparam) {
            RandomSource randomsource = world.z;
            for (int i2 = 0; i2 < 20; ++i2) {
                Vec3D vec3d = net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(blockposition, randomsource);
                Vec3D vec3d1 = new Vec3D(randomsource.k() * 0.02, randomsource.k() * 0.02, randomsource.k() * 0.02);
                world.a(particleparam, vec3d.a(), vec3d.b(), vec3d.c(), vec3d1.a(), vec3d1.b(), vec3d1.c());
            }
        }

        private static void a(World world, BlockPosition blockposition, VaultSharedData vaultshareddata, ParticleParam particleparam) {
            RandomSource randomsource = world.E_();
            if (randomsource.i() <= 0.5f) {
                Vec3D vec3d = net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.b(blockposition, randomsource);
                world.a(Particles.ae, vec3d.a(), vec3d.b(), vec3d.c(), 0.0, 0.0, 0.0);
                if (net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(vaultshareddata)) {
                    world.a(particleparam, vec3d.a(), vec3d.b(), vec3d.c(), 0.0, 0.0, 0.0);
                }
            }
        }

        private static void a(World world, Vec3D vec3d, EntityHuman entityhuman) {
            RandomSource randomsource = world.z;
            Vec3D vec3d1 = vec3d.a(entityhuman.dm().b(0.0, entityhuman.dk() / 2.0f, 0.0));
            int i2 = MathHelper.a(randomsource, 2, 5);
            for (int j2 = 0; j2 < i2; ++j2) {
                Vec3D vec3d2 = vec3d1.a(randomsource, 1.0f);
                world.a(Particles.ba, vec3d.a(), vec3d.b(), vec3d.c(), vec3d2.a(), vec3d2.b(), vec3d2.c());
            }
        }

        private static void a(World world, BlockPosition blockposition, IBlockData iblockdata, VaultSharedData vaultshareddata) {
            Set<UUID> set = vaultshareddata.d();
            if (!set.isEmpty()) {
                Vec3D vec3d = net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(blockposition, iblockdata.c(VaultBlock.c));
                for (UUID uuid : set) {
                    EntityHuman entityhuman = world.b(uuid);
                    if (entityhuman == null || !net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(blockposition, vaultshareddata, entityhuman)) continue;
                    net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(world, vec3d, entityhuman);
                }
            }
        }

        private static boolean a(BlockPosition blockposition, VaultSharedData vaultshareddata, EntityHuman entityhuman) {
            return entityhuman.do().j(blockposition) <= MathHelper.k(vaultshareddata.e());
        }

        private static void a(World world, BlockPosition blockposition, VaultSharedData vaultshareddata) {
            RandomSource randomsource;
            if (net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(vaultshareddata) && (randomsource = world.E_()).i() <= 0.02f) {
                world.a(blockposition, SoundEffects.AB, SoundCategory.e, randomsource.i() * 0.25f + 0.75f, randomsource.i() + 0.5f, false);
            }
        }

        public static boolean a(VaultSharedData vaultshareddata) {
            return vaultshareddata.b();
        }

        private static Vec3D a(BlockPosition blockposition, RandomSource randomsource) {
            return Vec3D.a(blockposition).b(MathHelper.a(randomsource, 0.4, 0.6), MathHelper.a(randomsource, 0.4, 0.6), MathHelper.a(randomsource, 0.4, 0.6));
        }

        private static Vec3D b(BlockPosition blockposition, RandomSource randomsource) {
            return Vec3D.a(blockposition).b(MathHelper.a(randomsource, 0.1, 0.9), MathHelper.a(randomsource, 0.25, 0.75), MathHelper.a(randomsource, 0.1, 0.9));
        }

        private static Vec3D a(BlockPosition blockposition, EnumDirection enumdirection) {
            return Vec3D.c(blockposition).b((double)enumdirection.j() * 0.5, 1.75, (double)enumdirection.l() * 0.5);
        }
    }
}

