/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.gameevent.GameEventListenerRegistry;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.lighting.ChunkSkyLightSources;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.ticks.SerializableTickContainer;
import net.minecraft.world.ticks.TickContainerAccess;
import org.bukkit.craftbukkit.v1_21_R1.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_21_R1.persistence.DirtyCraftPersistentDataContainer;
import org.slf4j.Logger;

public abstract class IChunkAccess
implements IBlockAccess,
BiomeManager.Provider,
LightChunk,
StructureAccess {
    public static final int a = -1;
    private static final Logger n = LogUtils.getLogger();
    private static final LongSet o = new LongOpenHashSet();
    protected final ShortList[] b;
    protected volatile boolean c;
    private volatile boolean p;
    protected final ChunkCoordIntPair d;
    private long q;
    @Nullable
    @Deprecated
    private BiomeSettingsGeneration r;
    @Nullable
    protected NoiseChunk e;
    protected final ChunkConverter f;
    @Nullable
    protected BlendingData g;
    public final Map<HeightMap.Type, HeightMap> h = Maps.newEnumMap(HeightMap.Type.class);
    protected ChunkSkyLightSources i;
    private final Map<Structure, StructureStart> s = Maps.newHashMap();
    private final Map<Structure, LongSet> t = Maps.newHashMap();
    protected final Map<BlockPosition, NBTTagCompound> j = Maps.newHashMap();
    public final Map<BlockPosition, TileEntity> k = new Object2ObjectOpenHashMap();
    protected final LevelHeightAccessor l;
    protected final ChunkSection[] m;
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    public DirtyCraftPersistentDataContainer persistentDataContainer = new DirtyCraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    public final IRegistry<BiomeBase> biomeRegistry;

    public IChunkAccess(ChunkCoordIntPair chunkcoordintpair, ChunkConverter chunkconverter, LevelHeightAccessor levelheightaccessor, IRegistry<BiomeBase> iregistry, long i2, @Nullable ChunkSection[] achunksection, @Nullable BlendingData blendingdata) {
        this.d = chunkcoordintpair;
        this.f = chunkconverter;
        this.l = levelheightaccessor;
        this.m = new ChunkSection[levelheightaccessor.an()];
        this.q = i2;
        this.b = new ShortList[levelheightaccessor.an()];
        this.g = blendingdata;
        this.i = new ChunkSkyLightSources(levelheightaccessor);
        if (achunksection != null) {
            if (this.m.length == achunksection.length) {
                System.arraycopy(achunksection, 0, this.m, 0, this.m.length);
            } else {
                n.warn("Could not set level chunk sections, array length is {} instead of {}", (Object)achunksection.length, (Object)this.m.length);
            }
        }
        IChunkAccess.a(iregistry, this.m);
        this.biomeRegistry = iregistry;
    }

    private static void a(IRegistry<BiomeBase> iregistry, ChunkSection[] achunksection) {
        for (int i2 = 0; i2 < achunksection.length; ++i2) {
            if (achunksection[i2] != null) continue;
            achunksection[i2] = new ChunkSection(iregistry);
        }
    }

    public GameEventListenerRegistry a(int i2) {
        return GameEventListenerRegistry.a;
    }

    @Nullable
    public abstract IBlockData a(BlockPosition var1, IBlockData var2, boolean var3);

    public abstract void a(TileEntity var1);

    public abstract void a(Entity var1);

    public int a() {
        ChunkSection[] achunksection = this.d();
        for (int i2 = achunksection.length - 1; i2 >= 0; --i2) {
            ChunkSection chunksection = achunksection[i2];
            if (chunksection.c()) continue;
            return i2;
        }
        return -1;
    }

    @Deprecated(forRemoval=true)
    public int b() {
        int i2 = this.a();
        return i2 == -1 ? this.I_() : SectionPosition.c(this.g(i2));
    }

    public Set<BlockPosition> c() {
        HashSet set = Sets.newHashSet(this.j.keySet());
        set.addAll(this.k.keySet());
        return set;
    }

    public ChunkSection[] d() {
        return this.m;
    }

    public ChunkSection b(int i2) {
        return this.d()[i2];
    }

    public Collection<Map.Entry<HeightMap.Type, HeightMap>> e() {
        return Collections.unmodifiableSet(this.h.entrySet());
    }

    public void a(HeightMap.Type heightmap_type, long[] along) {
        this.a(heightmap_type).a(this, heightmap_type, along);
    }

    public HeightMap a(HeightMap.Type heightmap_type) {
        return this.h.computeIfAbsent(heightmap_type, heightmap_type1 -> new HeightMap(this, (HeightMap.Type)heightmap_type1));
    }

    public boolean b(HeightMap.Type heightmap_type) {
        return this.h.get(heightmap_type) != null;
    }

    public int a(HeightMap.Type heightmap_type, int i2, int j2) {
        HeightMap heightmap = this.h.get(heightmap_type);
        if (heightmap == null) {
            if (SharedConstants.aV && this instanceof Chunk) {
                n.error("Unprimed heightmap: " + String.valueOf(heightmap_type) + " " + i2 + " " + j2);
            }
            HeightMap.a(this, EnumSet.of(heightmap_type));
            heightmap = this.h.get(heightmap_type);
        }
        return heightmap.a(i2 & 0xF, j2 & 0xF) - 1;
    }

    public ChunkCoordIntPair f() {
        return this.d;
    }

    @Override
    @Nullable
    public StructureStart a(Structure structure) {
        return this.s.get(structure);
    }

    @Override
    public void a(Structure structure, StructureStart structurestart) {
        this.s.put(structure, structurestart);
        this.c = true;
    }

    public Map<Structure, StructureStart> g() {
        return Collections.unmodifiableMap(this.s);
    }

    public void a(Map<Structure, StructureStart> map) {
        this.s.clear();
        this.s.putAll(map);
        this.c = true;
    }

    @Override
    public LongSet b(Structure structure) {
        return this.t.getOrDefault(structure, o);
    }

    @Override
    public void a(Structure structure, long i2) {
        this.t.computeIfAbsent(structure, structure1 -> new LongOpenHashSet()).add(i2);
        this.c = true;
    }

    @Override
    public Map<Structure, LongSet> h() {
        return Collections.unmodifiableMap(this.t);
    }

    @Override
    public void b(Map<Structure, LongSet> map) {
        this.t.clear();
        this.t.putAll(map);
        this.c = true;
    }

    public boolean a(int i2, int j2) {
        if (i2 < this.I_()) {
            i2 = this.I_();
        }
        if (j2 >= this.am()) {
            j2 = this.am() - 1;
        }
        for (int k2 = i2; k2 <= j2; k2 += 16) {
            if (this.b(this.e(k2)).c()) continue;
            return false;
        }
        return true;
    }

    public boolean c(int i2) {
        return this.b(this.f(i2)).c();
    }

    public void a(boolean flag) {
        this.c = flag;
        if (!flag) {
            this.persistentDataContainer.dirty(false);
        }
    }

    public boolean i() {
        return this.c || this.persistentDataContainer.dirty();
    }

    public abstract ChunkStatus j();

    public ChunkStatus k() {
        ChunkStatus chunkstatus = this.j();
        BelowZeroRetrogen belowzeroretrogen = this.x();
        if (belowzeroretrogen != null) {
            ChunkStatus chunkstatus1 = belowzeroretrogen.a();
            return ChunkStatus.a(chunkstatus1, chunkstatus);
        }
        return chunkstatus;
    }

    public abstract void d(BlockPosition var1);

    public void e(BlockPosition blockposition) {
        n.warn("Trying to mark a block for PostProcessing @ {}, but this operation is not supported.", (Object)blockposition);
    }

    public ShortList[] n() {
        return this.b;
    }

    public void a(short short0, int i2) {
        IChunkAccess.a(this.n(), i2).add(short0);
    }

    public void a(NBTTagCompound nbttagcompound) {
        this.j.put(TileEntity.b(nbttagcompound), nbttagcompound);
    }

    @Nullable
    public NBTTagCompound f(BlockPosition blockposition) {
        return this.j.get(blockposition);
    }

    @Nullable
    public abstract NBTTagCompound a(BlockPosition var1, HolderLookup.a var2);

    @Override
    public final void a(BiConsumer<BlockPosition, IBlockData> biconsumer) {
        this.a((IBlockData iblockdata) -> iblockdata.h() != 0, biconsumer);
    }

    public void a(Predicate<IBlockData> predicate, BiConsumer<BlockPosition, IBlockData> biconsumer) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int i2 = this.ao(); i2 < this.ap(); ++i2) {
            ChunkSection chunksection = this.b(this.f(i2));
            if (!chunksection.a(predicate)) continue;
            BlockPosition blockposition = SectionPosition.a(this.d, i2).j();
            for (int j2 = 0; j2 < 16; ++j2) {
                for (int k2 = 0; k2 < 16; ++k2) {
                    for (int l2 = 0; l2 < 16; ++l2) {
                        IBlockData iblockdata = chunksection.a(l2, j2, k2);
                        if (!predicate.test(iblockdata)) continue;
                        biconsumer.accept(blockposition_mutableblockposition.a(blockposition, l2, j2, k2), iblockdata);
                    }
                }
            }
        }
    }

    public abstract TickContainerAccess<Block> o();

    public abstract TickContainerAccess<FluidType> p();

    public abstract a q();

    public ChunkConverter r() {
        return this.f;
    }

    public boolean s() {
        return this.g != null;
    }

    @Nullable
    public BlendingData t() {
        return this.g;
    }

    public void a(BlendingData blendingdata) {
        this.g = blendingdata;
    }

    public long u() {
        return this.q;
    }

    public void a(long i2) {
        this.q += i2;
    }

    public void b(long i2) {
        this.q = i2;
    }

    public static ShortList a(ShortList[] ashortlist, int i2) {
        if (ashortlist[i2] == null) {
            ashortlist[i2] = new ShortArrayList();
        }
        return ashortlist[i2];
    }

    public boolean v() {
        return this.p;
    }

    public void b(boolean flag) {
        this.p = flag;
        this.a(true);
    }

    @Override
    public int I_() {
        return this.l.I_();
    }

    @Override
    public int J_() {
        return this.l.J_();
    }

    public NoiseChunk a(Function<IChunkAccess, NoiseChunk> function) {
        if (this.e == null) {
            this.e = function.apply(this);
        }
        return this.e;
    }

    @Deprecated
    public BiomeSettingsGeneration a(Supplier<BiomeSettingsGeneration> supplier) {
        if (this.r == null) {
            this.r = supplier.get();
        }
        return this.r;
    }

    @Override
    public Holder<BiomeBase> getNoiseBiome(int i2, int j2, int k2) {
        try {
            int l2 = QuartPos.a(this.I_());
            int i1 = l2 + QuartPos.a(this.J_()) - 1;
            int j1 = MathHelper.a(j2, l2, i1);
            int k1 = this.e(QuartPos.c(j1));
            return this.m[k1].c(i2 & 3, j1 & 3, k2 & 3);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Getting biome");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Biome being got");
            crashreportsystemdetails.a("Location", () -> CrashReportSystemDetails.a((LevelHeightAccessor)this, i2, j2, k2));
            throw new ReportedException(crashreport);
        }
    }

    public void setBiome(int i2, int j2, int k2, Holder<BiomeBase> biome) {
        try {
            int l2 = QuartPos.a(this.I_());
            int i1 = l2 + QuartPos.a(this.J_()) - 1;
            int j1 = MathHelper.a(j2, l2, i1);
            int k1 = this.e(QuartPos.c(j1));
            this.m[k1].setBiome(i2 & 3, j1 & 3, k2 & 3, biome);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Setting biome");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Biome being set");
            crashreportsystemdetails.a("Location", () -> CrashReportSystemDetails.a((LevelHeightAccessor)this, i2, j2, k2));
            throw new ReportedException(crashreport);
        }
    }

    public void a(BiomeResolver biomeresolver, Climate.Sampler climate_sampler) {
        ChunkCoordIntPair chunkcoordintpair = this.f();
        int i2 = QuartPos.a(chunkcoordintpair.d());
        int j2 = QuartPos.a(chunkcoordintpair.e());
        LevelHeightAccessor levelheightaccessor = this.z();
        for (int k2 = levelheightaccessor.ao(); k2 < levelheightaccessor.ap(); ++k2) {
            ChunkSection chunksection = this.b(this.f(k2));
            int l2 = QuartPos.d(k2);
            chunksection.a(biomeresolver, climate_sampler, i2, l2, j2);
        }
    }

    public boolean w() {
        return !this.h().isEmpty();
    }

    @Nullable
    public BelowZeroRetrogen x() {
        return null;
    }

    public boolean y() {
        return this.x() != null;
    }

    public LevelHeightAccessor z() {
        return this;
    }

    public void A() {
        this.i.a(this);
    }

    @Override
    public ChunkSkyLightSources B() {
        return this.i;
    }

    public record a(SerializableTickContainer<Block> a, SerializableTickContainer<FluidType> b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "blocks;fluids", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "blocks;fluids", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "blocks;fluids", "a", "b"}, this, o2);
        }
    }
}

