/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NbtException;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.ProtoChunkTickList;
import org.slf4j.Logger;

public class ChunkRegionLoader {
    public static final Codec<DataPaletteBlock<IBlockData>> h = DataPaletteBlock.a(Block.q, IBlockData.b, DataPaletteBlock.d.d, Blocks.a.o());
    private static final Logger i = LogUtils.getLogger();
    private static final String j = "UpgradeData";
    private static final String k = "block_ticks";
    private static final String l = "fluid_ticks";
    public static final String a = "xPos";
    public static final String b = "zPos";
    public static final String c = "Heightmaps";
    public static final String d = "isLightOn";
    public static final String e = "sections";
    public static final String f = "BlockLight";
    public static final String g = "SkyLight";

    public static ProtoChunk a(WorldServer worldserver, VillagePlace villageplace, RegionStorageInfo regionstorageinfo, ChunkCoordIntPair chunkcoordintpair, NBTTagCompound nbttagcompound) {
        int i1;
        NBTTagList nbttaglist2;
        IChunkAccess object1;
        BlendingData blendingdata;
        ChunkCoordIntPair chunkcoordintpair1 = new ChunkCoordIntPair(nbttagcompound.h(a), nbttagcompound.h(b));
        if (!Objects.equals(chunkcoordintpair, chunkcoordintpair1)) {
            i.error("Chunk file at {} is in the wrong location; relocating. (Expected {}, got {})", new Object[]{chunkcoordintpair, chunkcoordintpair, chunkcoordintpair1});
            worldserver.o().a(chunkcoordintpair1, chunkcoordintpair, regionstorageinfo);
        }
        ChunkConverter chunkconverter = nbttagcompound.b(j, 10) ? new ChunkConverter(nbttagcompound.p(j), worldserver) : ChunkConverter.a;
        boolean flag = nbttagcompound.q(d);
        NBTTagList nbttaglist = nbttagcompound.c(e, 10);
        int i2 = worldserver.an();
        ChunkSection[] achunksection = new ChunkSection[i2];
        boolean flag1 = worldserver.D_().g();
        ChunkProviderServer chunkproviderserver = worldserver.l();
        LightEngineThreaded levellightengine = chunkproviderserver.a();
        IRegistry<BiomeBase> iregistry = worldserver.H_().d(Registries.aF);
        Codec<DataPaletteBlock<Holder<BiomeBase>>> codec = ChunkRegionLoader.makeBiomeCodecRW(iregistry);
        boolean flag2 = false;
        for (int j2 = 0; j2 < nbttaglist.size(); ++j2) {
            boolean flag4;
            NBTTagCompound nbttagcompound1 = nbttaglist.a(j2);
            byte b0 = nbttagcompound1.f("Y");
            int k2 = worldserver.f(b0);
            if (k2 >= 0 && k2 < achunksection.length) {
                ChunkSection chunksection;
                DataPaletteBlock datapaletteblock = nbttagcompound1.b("block_states", 10) ? (DataPaletteBlock)h.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbttagcompound1.p("block_states")).promotePartial(s2 -> ChunkRegionLoader.a(chunkcoordintpair, b0, s2)).getOrThrow(a::new) : new DataPaletteBlock(Block.q, Blocks.a.o(), DataPaletteBlock.d.d);
                DataPaletteBlock object = nbttagcompound1.b("biomes", 10) ? (DataPaletteBlock)codec.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbttagcompound1.p("biomes")).promotePartial(s2 -> ChunkRegionLoader.a(chunkcoordintpair, b0, s2)).getOrThrow(a::new) : new DataPaletteBlock(iregistry.u(), iregistry.g(Biomes.b), DataPaletteBlock.d.e);
                achunksection[k2] = chunksection = new ChunkSection(datapaletteblock, object);
                SectionPosition sectionposition = SectionPosition.a(chunkcoordintpair, (int)b0);
                villageplace.a(sectionposition, chunksection);
            }
            boolean flag3 = nbttagcompound1.b(f, 7);
            boolean bl = flag4 = flag1 && nbttagcompound1.b(g, 7);
            if (!flag3 && !flag4) continue;
            if (!flag2) {
                ((LevelLightEngine)levellightengine).b(chunkcoordintpair, true);
                flag2 = true;
            }
            if (flag3) {
                ((LevelLightEngine)levellightengine).a(EnumSkyBlock.b, SectionPosition.a(chunkcoordintpair, (int)b0), new NibbleArray(nbttagcompound1.m(f)));
            }
            if (!flag4) continue;
            ((LevelLightEngine)levellightengine).a(EnumSkyBlock.a, SectionPosition.a(chunkcoordintpair, (int)b0), new NibbleArray(nbttagcompound1.m(g)));
        }
        long l2 = nbttagcompound.i("InhabitedTime");
        ChunkType chunktype = ChunkRegionLoader.a(nbttagcompound);
        if (nbttagcompound.b("blending_data", 10)) {
            DataResult dataresult = BlendingData.e.parse(new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)nbttagcompound.p("blending_data")));
            Logger logger = i;
            Objects.requireNonNull(logger);
            blendingdata = dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).orElse(null);
        } else {
            blendingdata = null;
        }
        if (chunktype == ChunkType.b) {
            LevelChunkTicks<Block> levelchunkticks = LevelChunkTicks.a(nbttagcompound.c(k, 10), (String s2) -> BuiltInRegistries.e.b(MinecraftKey.c(s2)), chunkcoordintpair);
            LevelChunkTicks<FluidType> levelchunkticks1 = LevelChunkTicks.a(nbttagcompound.c(l, 10), (String s2) -> BuiltInRegistries.c.b(MinecraftKey.c(s2)), chunkcoordintpair);
            object1 = new Chunk(worldserver.E(), chunkcoordintpair, chunkconverter, levelchunkticks, levelchunkticks1, l2, achunksection, ChunkRegionLoader.a(worldserver, nbttagcompound), blendingdata);
        } else {
            ProtoChunkTickList<Block> protochunkticklist = ProtoChunkTickList.a(nbttagcompound.c(k, 10), (String s2) -> BuiltInRegistries.e.b(MinecraftKey.c(s2)), chunkcoordintpair);
            ProtoChunkTickList<FluidType> protochunkticklist1 = ProtoChunkTickList.a(nbttagcompound.c(l, 10), (String s2) -> BuiltInRegistries.c.b(MinecraftKey.c(s2)), chunkcoordintpair);
            ProtoChunk protochunk = new ProtoChunk(chunkcoordintpair, chunkconverter, achunksection, protochunkticklist, protochunkticklist1, worldserver, iregistry, blendingdata);
            object1 = protochunk;
            protochunk.b(l2);
            if (nbttagcompound.b("below_zero_retrogen", 10)) {
                DataResult dataresult = BelowZeroRetrogen.a.parse(new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)nbttagcompound.p("below_zero_retrogen")));
                Logger logger = i;
                Objects.requireNonNull(logger);
                Optional optional = dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0));
                Objects.requireNonNull(protochunk);
                optional.ifPresent(protochunk::a);
            }
            ChunkStatus chunkstatus = ChunkStatus.a(nbttagcompound.l("Status"));
            protochunk.a(chunkstatus);
            if (chunkstatus.a(ChunkStatus.k)) {
                protochunk.a(levellightengine);
            }
        }
        NBTBase persistentBase = nbttagcompound.c("ChunkBukkitValues");
        if (persistentBase instanceof NBTTagCompound) {
            ((IChunkAccess)object1).persistentDataContainer.putAll((NBTTagCompound)persistentBase);
        }
        ((IChunkAccess)object1).b(flag);
        NBTTagCompound nbttagcompound2 = nbttagcompound.p(c);
        EnumSet<HeightMap.Type> enumset = EnumSet.noneOf(HeightMap.Type.class);
        for (HeightMap.Type heightmap_type : ((IChunkAccess)object1).j().e()) {
            String s3 = heightmap_type.a();
            if (nbttagcompound2.b(s3, 12)) {
                ((IChunkAccess)object1).a(heightmap_type, nbttagcompound2.o(s3));
                continue;
            }
            enumset.add(heightmap_type);
        }
        HeightMap.a(object1, enumset);
        NBTTagCompound nbttagcompound3 = nbttagcompound.p("structures");
        ((IChunkAccess)object1).a(ChunkRegionLoader.a(StructurePieceSerializationContext.a(worldserver), nbttagcompound3, worldserver.C()));
        ((IChunkAccess)object1).b(ChunkRegionLoader.a(worldserver.H_(), chunkcoordintpair, nbttagcompound3));
        if (nbttagcompound.q("shouldSave")) {
            ((IChunkAccess)object1).a(true);
        }
        NBTTagList nbttaglist1 = nbttagcompound.c("PostProcessing", 9);
        for (int j1 = 0; j1 < nbttaglist1.size(); ++j1) {
            nbttaglist2 = nbttaglist1.b(j1);
            for (i1 = 0; i1 < nbttaglist2.size(); ++i1) {
                ((IChunkAccess)object1).a(nbttaglist2.d(i1), j1);
            }
        }
        if (chunktype == ChunkType.b) {
            return new ProtoChunkExtension((Chunk)object1, false);
        }
        IChunkAccess protochunk1 = object1;
        nbttaglist2 = nbttagcompound.c("entities", 10);
        for (i1 = 0; i1 < nbttaglist2.size(); ++i1) {
            ((ProtoChunk)protochunk1).b(nbttaglist2.a(i1));
        }
        NBTTagList nbttaglist3 = nbttagcompound.c("block_entities", 10);
        for (int k1 = 0; k1 < nbttaglist3.size(); ++k1) {
            NBTTagCompound nbttagcompound4 = nbttaglist3.a(k1);
            object1.a(nbttagcompound4);
        }
        NBTTagCompound nbttagcompound5 = nbttagcompound.p("CarvingMasks");
        for (String s1 : nbttagcompound5.e()) {
            WorldGenStage.Features worldgenstage_features = WorldGenStage.Features.valueOf(s1);
            ((ProtoChunk)protochunk1).a(worldgenstage_features, new CarvingMask(nbttagcompound5.o(s1), object1.I_()));
        }
        return protochunk1;
    }

    private static void a(ChunkCoordIntPair chunkcoordintpair, int i2, String s2) {
        i.error("Recoverable errors when loading section [{}, {}, {}]: {}", new Object[]{chunkcoordintpair.e, i2, chunkcoordintpair.f, s2});
    }

    private static Codec<PalettedContainerRO<Holder<BiomeBase>>> a(IRegistry<BiomeBase> iregistry) {
        return DataPaletteBlock.b(iregistry.u(), iregistry.s(), DataPaletteBlock.d.e, iregistry.g(Biomes.b));
    }

    private static Codec<DataPaletteBlock<Holder<BiomeBase>>> makeBiomeCodecRW(IRegistry<BiomeBase> iregistry) {
        return DataPaletteBlock.a(iregistry.u(), iregistry.s(), DataPaletteBlock.d.e, iregistry.g(Biomes.b));
    }

    public static NBTTagCompound a(WorldServer worldserver, IChunkAccess ichunkaccess) {
        ChunkConverter chunkconverter;
        BelowZeroRetrogen belowzeroretrogen;
        Logger logger;
        DataResult dataresult;
        ChunkCoordIntPair chunkcoordintpair = ichunkaccess.f();
        NBTTagCompound nbttagcompound = GameProfileSerializer.e(new NBTTagCompound());
        nbttagcompound.a(a, chunkcoordintpair.e);
        nbttagcompound.a("yPos", ichunkaccess.ao());
        nbttagcompound.a(b, chunkcoordintpair.f);
        nbttagcompound.a("LastUpdate", worldserver.Z());
        nbttagcompound.a("InhabitedTime", ichunkaccess.u());
        nbttagcompound.a("Status", BuiltInRegistries.l.b(ichunkaccess.j()).toString());
        BlendingData blendingdata = ichunkaccess.t();
        if (blendingdata != null) {
            dataresult = BlendingData.e.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)blendingdata);
            logger = i;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbttagcompound.a("blending_data", (NBTBase)nbtbase));
        }
        if ((belowzeroretrogen = ichunkaccess.x()) != null) {
            dataresult = BelowZeroRetrogen.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)belowzeroretrogen);
            logger = i;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbttagcompound.a("below_zero_retrogen", (NBTBase)nbtbase));
        }
        if (!(chunkconverter = ichunkaccess.r()).a()) {
            nbttagcompound.a(j, chunkconverter.b());
        }
        ChunkSection[] achunksection = ichunkaccess.d();
        NBTTagList nbttaglist = new NBTTagList();
        LightEngineThreaded lightenginethreaded = worldserver.l().a();
        IRegistry<BiomeBase> iregistry = worldserver.H_().d(Registries.aF);
        Codec<PalettedContainerRO<Holder<BiomeBase>>> codec = ChunkRegionLoader.a(iregistry);
        boolean flag = ichunkaccess.v();
        for (int i2 = lightenginethreaded.d(); i2 < lightenginethreaded.e(); ++i2) {
            int j2 = ichunkaccess.f(i2);
            boolean flag1 = j2 >= 0 && j2 < achunksection.length;
            NibbleArray nibblearray = lightenginethreaded.a(EnumSkyBlock.b).a(SectionPosition.a(chunkcoordintpair, i2));
            NibbleArray nibblearray1 = lightenginethreaded.a(EnumSkyBlock.a).a(SectionPosition.a(chunkcoordintpair, i2));
            if (!flag1 && nibblearray == null && nibblearray1 == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            if (flag1) {
                ChunkSection chunksection = achunksection[j2];
                nbttagcompound1.a("block_states", (NBTBase)h.encodeStart((DynamicOps)DynamicOpsNBT.a, chunksection.h()).getOrThrow());
                nbttagcompound1.a("biomes", (NBTBase)codec.encodeStart((DynamicOps)DynamicOpsNBT.a, chunksection.i()).getOrThrow());
            }
            if (nibblearray != null && !nibblearray.d()) {
                nbttagcompound1.a(f, nibblearray.a());
            }
            if (nibblearray1 != null && !nibblearray1.d()) {
                nbttagcompound1.a(g, nibblearray1.a());
            }
            if (nbttagcompound1.g()) continue;
            nbttagcompound1.a("Y", (byte)i2);
            nbttaglist.add(nbttagcompound1);
        }
        nbttagcompound.a(e, nbttaglist);
        if (flag) {
            nbttagcompound.a(d, true);
        }
        NBTTagList nbttaglist1 = new NBTTagList();
        for (BlockPosition blockposition : ichunkaccess.c()) {
            NBTTagCompound nbttagcompound2 = ichunkaccess.a(blockposition, worldserver.H_());
            if (nbttagcompound2 == null) continue;
            nbttaglist1.add(nbttagcompound2);
        }
        nbttagcompound.a("block_entities", nbttaglist1);
        if (ichunkaccess.j().d() == ChunkType.a) {
            ProtoChunk protochunk = (ProtoChunk)ichunkaccess;
            NBTTagList nbttaglist2 = new NBTTagList();
            nbttaglist2.addAll(protochunk.E());
            nbttagcompound.a("entities", nbttaglist2);
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            for (WorldGenStage.Features worldgenstage_features : WorldGenStage.Features.values()) {
                CarvingMask carvingmask = protochunk.a(worldgenstage_features);
                if (carvingmask == null) continue;
                nbttagcompound2.a(worldgenstage_features.toString(), carvingmask.a());
            }
            nbttagcompound.a("CarvingMasks", nbttagcompound2);
        }
        ChunkRegionLoader.a(worldserver, nbttagcompound, ichunkaccess.q());
        nbttagcompound.a("PostProcessing", ChunkRegionLoader.a(ichunkaccess.n()));
        NBTTagCompound nbttagcompound3 = new NBTTagCompound();
        for (Map.Entry<HeightMap.Type, HeightMap> entry : ichunkaccess.e()) {
            if (!ichunkaccess.j().e().contains(entry.getKey())) continue;
            nbttagcompound3.a(entry.getKey().a(), new NBTTagLongArray(entry.getValue().a()));
        }
        nbttagcompound.a(c, nbttagcompound3);
        nbttagcompound.a("structures", ChunkRegionLoader.a(StructurePieceSerializationContext.a(worldserver), chunkcoordintpair, ichunkaccess.g(), ichunkaccess.h()));
        if (!ichunkaccess.persistentDataContainer.isEmpty()) {
            nbttagcompound.a("ChunkBukkitValues", ichunkaccess.persistentDataContainer.toTagCompound());
        }
        return nbttagcompound;
    }

    private static void a(WorldServer worldserver, NBTTagCompound nbttagcompound, IChunkAccess.a ichunkaccess_a) {
        long i2 = worldserver.A_().c();
        nbttagcompound.a(k, ichunkaccess_a.a().b(i2, block -> BuiltInRegistries.e.b((Block)block).toString()));
        nbttagcompound.a(l, ichunkaccess_a.b().b(i2, fluidtype -> BuiltInRegistries.c.b((FluidType)fluidtype).toString()));
    }

    public static ChunkType a(@Nullable NBTTagCompound nbttagcompound) {
        return nbttagcompound != null ? ChunkStatus.a(nbttagcompound.l("Status")).d() : ChunkType.a;
    }

    @Nullable
    private static Chunk.c a(WorldServer worldserver, NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist = ChunkRegionLoader.a(nbttagcompound, "entities");
        NBTTagList nbttaglist1 = ChunkRegionLoader.a(nbttagcompound, "block_entities");
        return nbttaglist == null && nbttaglist1 == null ? null : chunk -> {
            worldserver.timings.syncChunkLoadEntitiesTimer.startTiming();
            if (nbttaglist != null) {
                worldserver.a(EntityTypes.a(nbttaglist, (World)worldserver));
            }
            worldserver.timings.syncChunkLoadEntitiesTimer.stopTiming();
            worldserver.timings.syncChunkLoadTileEntitiesTimer.startTiming();
            if (nbttaglist1 != null) {
                for (int i2 = 0; i2 < nbttaglist1.size(); ++i2) {
                    NBTTagCompound nbttagcompound1 = nbttaglist1.a(i2);
                    boolean flag = nbttagcompound1.q("keepPacked");
                    if (flag) {
                        chunk.a(nbttagcompound1);
                        continue;
                    }
                    BlockPosition blockposition = TileEntity.b(nbttagcompound1);
                    TileEntity tileentity = TileEntity.a(blockposition, chunk.a_(blockposition), nbttagcompound1, worldserver.H_());
                    if (tileentity == null) continue;
                    chunk.a(tileentity);
                }
            }
            worldserver.timings.syncChunkLoadTileEntitiesTimer.stopTiming();
        };
    }

    @Nullable
    private static NBTTagList a(NBTTagCompound nbttagcompound, String s2) {
        NBTTagList nbttaglist = nbttagcompound.c(s2, 10);
        return nbttaglist.isEmpty() ? null : nbttaglist;
    }

    private static NBTTagCompound a(StructurePieceSerializationContext structurepieceserializationcontext, ChunkCoordIntPair chunkcoordintpair, Map<Structure, StructureStart> map, Map<Structure, LongSet> map1) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        IRegistry<Structure> iregistry = structurepieceserializationcontext.b().d(Registries.aR);
        for (Map.Entry<Structure, StructureStart> entry : map.entrySet()) {
            MinecraftKey minecraftkey = iregistry.b(entry.getKey());
            nbttagcompound1.a(minecraftkey.toString(), entry.getValue().a(structurepieceserializationcontext, chunkcoordintpair));
        }
        nbttagcompound.a("starts", nbttagcompound1);
        NBTTagCompound nbttagcompound2 = new NBTTagCompound();
        for (Map.Entry<Structure, LongSet> entry1 : map1.entrySet()) {
            if (entry1.getValue().isEmpty()) continue;
            MinecraftKey minecraftkey1 = iregistry.b(entry1.getKey());
            nbttagcompound2.a(minecraftkey1.toString(), new NBTTagLongArray(entry1.getValue()));
        }
        nbttagcompound.a("References", nbttagcompound2);
        return nbttagcompound;
    }

    private static Map<Structure, StructureStart> a(StructurePieceSerializationContext structurepieceserializationcontext, NBTTagCompound nbttagcompound, long i2) {
        HashMap map = Maps.newHashMap();
        IRegistry<Structure> iregistry = structurepieceserializationcontext.b().d(Registries.aR);
        NBTTagCompound nbttagcompound1 = nbttagcompound.p("starts");
        for (String s2 : nbttagcompound1.e()) {
            MinecraftKey minecraftkey = MinecraftKey.c(s2);
            Structure structure = iregistry.a(minecraftkey);
            if (structure == null) {
                i.error("Unknown structure start: {}", (Object)minecraftkey);
                continue;
            }
            StructureStart structurestart = StructureStart.a(structurepieceserializationcontext, nbttagcompound1.p(s2), i2);
            if (structurestart == null) continue;
            NBTBase persistentBase = nbttagcompound1.p(s2).c("StructureBukkitValues");
            if (persistentBase instanceof NBTTagCompound) {
                structurestart.persistentDataContainer.putAll((NBTTagCompound)persistentBase);
            }
            map.put(structure, structurestart);
        }
        return map;
    }

    private static Map<Structure, LongSet> a(IRegistryCustom iregistrycustom, ChunkCoordIntPair chunkcoordintpair, NBTTagCompound nbttagcompound) {
        HashMap map = Maps.newHashMap();
        IRegistry<Structure> iregistry = iregistrycustom.d(Registries.aR);
        NBTTagCompound nbttagcompound1 = nbttagcompound.p("References");
        for (String s2 : nbttagcompound1.e()) {
            MinecraftKey minecraftkey = MinecraftKey.c(s2);
            Structure structure = iregistry.a(minecraftkey);
            if (structure == null) {
                i.warn("Found reference to unknown structure '{}' in chunk {}, discarding", (Object)minecraftkey, (Object)chunkcoordintpair);
                continue;
            }
            long[] along = nbttagcompound1.o(s2);
            if (along.length == 0) continue;
            map.put(structure, new LongOpenHashSet(Arrays.stream(along).filter(i2 -> {
                ChunkCoordIntPair chunkcoordintpair1 = new ChunkCoordIntPair(i2);
                if (chunkcoordintpair1.a(chunkcoordintpair) > 8) {
                    i.warn("Found invalid structure reference [ {} @ {} ] for chunk {}.", new Object[]{minecraftkey, chunkcoordintpair1, chunkcoordintpair});
                    return false;
                }
                return true;
            }).toArray()));
        }
        return map;
    }

    public static NBTTagList a(ShortList[] ashortlist) {
        NBTTagList nbttaglist = new NBTTagList();
        ShortList[] ashortlist1 = ashortlist;
        int i2 = ashortlist.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            ShortList shortlist = ashortlist1[j2];
            NBTTagList nbttaglist1 = new NBTTagList();
            if (shortlist != null) {
                for (Short oshort : shortlist) {
                    nbttaglist1.add(NBTTagShort.a(oshort));
                }
            }
            nbttaglist.add(nbttaglist1);
        }
        return nbttaglist;
    }

    public static class a
    extends NbtException {
        public a(String s2) {
            super(s2);
        }
    }
}

