/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.annotation.Nullable;
import net.minecraft.FileUtils;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.util.ExceptionSuppressor;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;

public final class RegionFileCache
implements AutoCloseable {
    public static final String a = ".mca";
    private static final int b = 256;
    public final Long2ObjectLinkedOpenHashMap<RegionFile> c = new Long2ObjectLinkedOpenHashMap();
    private final RegionStorageInfo d;
    private final Path e;
    private final boolean f;

    RegionFileCache(RegionStorageInfo regionstorageinfo, Path path, boolean flag) {
        this.e = path;
        this.f = flag;
        this.d = regionstorageinfo;
    }

    private RegionFile getRegionFile(ChunkCoordIntPair chunkcoordintpair, boolean existingOnly) throws IOException {
        long i2 = ChunkCoordIntPair.c(chunkcoordintpair.h(), chunkcoordintpair.i());
        RegionFile regionfile = (RegionFile)this.c.getAndMoveToFirst(i2);
        if (regionfile != null) {
            return regionfile;
        }
        if (this.c.size() >= 256) {
            ((RegionFile)this.c.removeLast()).close();
        }
        FileUtils.c(this.e);
        Path path = this.e;
        int j2 = chunkcoordintpair.h();
        Path path1 = path.resolve("r." + j2 + "." + chunkcoordintpair.i() + a);
        if (existingOnly && !Files.exists(path1, new LinkOption[0])) {
            return null;
        }
        RegionFile regionfile1 = new RegionFile(this.d, path1, this.e, this.f);
        this.c.putAndMoveToFirst(i2, (Object)regionfile1);
        return regionfile1;
    }

    @Nullable
    public NBTTagCompound a(ChunkCoordIntPair chunkcoordintpair) throws IOException {
        NBTTagCompound nbttagcompound;
        block8: {
            NBTTagCompound nbttagcompound2;
            RegionFile regionfile = this.getRegionFile(chunkcoordintpair, true);
            if (regionfile == null) {
                return null;
            }
            try (DataInputStream datainputstream = regionfile.a(chunkcoordintpair);){
                if (datainputstream != null) {
                    nbttagcompound = NBTCompressedStreamTools.a(datainputstream);
                    break block8;
                }
                nbttagcompound2 = null;
            }
            return nbttagcompound2;
        }
        return nbttagcompound;
    }

    public void a(ChunkCoordIntPair chunkcoordintpair, StreamTagVisitor streamtagvisitor) throws IOException {
        RegionFile regionfile = this.getRegionFile(chunkcoordintpair, true);
        if (regionfile == null) {
            return;
        }
        try (DataInputStream datainputstream = regionfile.a(chunkcoordintpair);){
            if (datainputstream != null) {
                NBTCompressedStreamTools.a((DataInput)datainputstream, streamtagvisitor, NBTReadLimiter.a());
            }
        }
    }

    protected void a(ChunkCoordIntPair chunkcoordintpair, @Nullable NBTTagCompound nbttagcompound) throws IOException {
        RegionFile regionfile = this.getRegionFile(chunkcoordintpair, false);
        if (nbttagcompound == null) {
            regionfile.d(chunkcoordintpair);
        } else {
            try (DataOutputStream dataoutputstream = regionfile.c(chunkcoordintpair);){
                NBTCompressedStreamTools.a(nbttagcompound, (DataOutput)dataoutputstream);
            }
        }
    }

    @Override
    public void close() throws IOException {
        ExceptionSuppressor<IOException> exceptionsuppressor = new ExceptionSuppressor<IOException>();
        for (RegionFile regionfile : this.c.values()) {
            try {
                regionfile.close();
            }
            catch (IOException ioexception) {
                exceptionsuppressor.a(ioexception);
            }
        }
        exceptionsuppressor.a();
    }

    public void a() throws IOException {
        for (RegionFile regionfile : this.c.values()) {
            regionfile.b();
        }
    }

    public RegionStorageInfo b() {
        return this.d;
    }
}

