/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Suppliers;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.QuartPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import org.apache.commons.lang3.mutable.MutableObject;

public final class ChunkGeneratorAbstract
extends ChunkGenerator {
    public static final MapCodec<ChunkGeneratorAbstract> c = RecordCodecBuilder.mapCodec(instance -> instance.group((App)WorldChunkManager.a.fieldOf("biome_source").forGetter(chunkgeneratorabstract -> chunkgeneratorabstract.b), (App)GeneratorSettingBase.b.fieldOf("settings").forGetter(chunkgeneratorabstract -> chunkgeneratorabstract.e)).apply((Applicative)instance, instance.stable(ChunkGeneratorAbstract::new)));
    private static final IBlockData d = Blocks.a.o();
    public final Holder<GeneratorSettingBase> e;
    private final Supplier<Aquifer.a> f;

    public ChunkGeneratorAbstract(WorldChunkManager worldchunkmanager, Holder<GeneratorSettingBase> holder) {
        super(worldchunkmanager);
        this.e = holder;
        this.f = Suppliers.memoize(() -> ChunkGeneratorAbstract.a((GeneratorSettingBase)holder.a()));
    }

    private static Aquifer.a a(GeneratorSettingBase generatorsettingbase) {
        Aquifer.b aquifer_b = new Aquifer.b(-54, Blocks.H.o());
        int i2 = generatorsettingbase.l();
        Aquifer.b aquifer_b1 = new Aquifer.b(i2, generatorsettingbase.h());
        Aquifer.b aquifer_b2 = new Aquifer.b(DimensionManager.e * 2, Blocks.a.o());
        return (j2, k2, l2) -> k2 < Math.min(-54, i2) ? aquifer_b : aquifer_b1;
    }

    @Override
    public CompletableFuture<IChunkAccess> a(RandomState randomstate, Blender blender, StructureManager structuremanager, IChunkAccess ichunkaccess) {
        return CompletableFuture.supplyAsync(SystemUtils.a("init_biomes", () -> {
            this.b(blender, randomstate, structuremanager, ichunkaccess);
            return ichunkaccess;
        }), SystemUtils.g());
    }

    private void b(Blender blender, RandomState randomstate, StructureManager structuremanager, IChunkAccess ichunkaccess) {
        NoiseChunk noisechunk = ichunkaccess.a((IChunkAccess ichunkaccess1) -> this.a((IChunkAccess)ichunkaccess1, structuremanager, blender, randomstate));
        BiomeResolver biomeresolver = BelowZeroRetrogen.a(blender.a(this.b), ichunkaccess);
        ichunkaccess.a(biomeresolver, noisechunk.a(randomstate.a(), this.e.a().k()));
    }

    private NoiseChunk a(IChunkAccess ichunkaccess, StructureManager structuremanager, Blender blender, RandomState randomstate) {
        return NoiseChunk.a(ichunkaccess, randomstate, Beardifier.a(structuremanager, ichunkaccess.f()), this.e.a(), this.f.get(), blender);
    }

    @Override
    protected MapCodec<? extends ChunkGenerator> b() {
        return c;
    }

    public Holder<GeneratorSettingBase> h() {
        return this.e;
    }

    public boolean a(ResourceKey<GeneratorSettingBase> resourcekey) {
        return this.e.a(resourcekey);
    }

    @Override
    public int a(int i2, int j2, HeightMap.Type heightmap_type, LevelHeightAccessor levelheightaccessor, RandomState randomstate) {
        return this.a(levelheightaccessor, randomstate, i2, j2, (MutableObject<BlockColumn>)((MutableObject)null), heightmap_type.e()).orElse(levelheightaccessor.I_());
    }

    @Override
    public BlockColumn a(int i2, int j2, LevelHeightAccessor levelheightaccessor, RandomState randomstate) {
        MutableObject mutableobject = new MutableObject();
        this.a(levelheightaccessor, randomstate, i2, j2, (MutableObject<BlockColumn>)mutableobject, null);
        return (BlockColumn)mutableobject.getValue();
    }

    @Override
    public void a(List<String> list, RandomState randomstate, BlockPosition blockposition) {
        DecimalFormat decimalformat = new DecimalFormat("0.000");
        NoiseRouter noiserouter = randomstate.a();
        DensityFunction.e densityfunction_e = new DensityFunction.e(blockposition.u(), blockposition.v(), blockposition.w());
        double d0 = noiserouter.j().a(densityfunction_e);
        String s2 = decimalformat.format(noiserouter.e().a(densityfunction_e));
        list.add("NoiseRouter T: " + s2 + " V: " + decimalformat.format(noiserouter.f().a(densityfunction_e)) + " C: " + decimalformat.format(noiserouter.g().a(densityfunction_e)) + " E: " + decimalformat.format(noiserouter.h().a(densityfunction_e)) + " D: " + decimalformat.format(noiserouter.i().a(densityfunction_e)) + " W: " + decimalformat.format(d0) + " PV: " + decimalformat.format(NoiseRouterData.a((float)d0)) + " AS: " + decimalformat.format(noiserouter.k().a(densityfunction_e)) + " N: " + decimalformat.format(noiserouter.l().a(densityfunction_e)));
    }

    private OptionalInt a(LevelHeightAccessor levelheightaccessor, RandomState randomstate, int i2, int j2, @Nullable MutableObject<BlockColumn> mutableobject, @Nullable Predicate<IBlockData> predicate) {
        IBlockData[] aiblockdata;
        NoiseSettings noisesettings = this.e.a().f().a(levelheightaccessor);
        int k2 = noisesettings.a();
        int l2 = noisesettings.c();
        int i1 = MathHelper.a(l2, k2);
        int j1 = MathHelper.a(noisesettings.d(), k2);
        if (j1 <= 0) {
            return OptionalInt.empty();
        }
        if (mutableobject == null) {
            aiblockdata = null;
        } else {
            aiblockdata = new IBlockData[noisesettings.d()];
            mutableobject.setValue((Object)new BlockColumn(l2, aiblockdata));
        }
        int k1 = noisesettings.b();
        int l1 = Math.floorDiv(i2, k1);
        int i22 = Math.floorDiv(j2, k1);
        int j22 = Math.floorMod(i2, k1);
        int k22 = Math.floorMod(j2, k1);
        int l22 = l1 * k1;
        int i3 = i22 * k1;
        double d0 = (double)j22 / (double)k1;
        double d1 = (double)k22 / (double)k1;
        NoiseChunk noisechunk = new NoiseChunk(1, randomstate, l22, i3, noisesettings, DensityFunctions.b.a, this.e.a(), this.f.get(), Blender.a());
        noisechunk.f();
        noisechunk.b(0);
        for (int j3 = j1 - 1; j3 >= 0; --j3) {
            noisechunk.b(j3, 0);
            for (int k3 = k2 - 1; k3 >= 0; --k3) {
                IBlockData iblockdata1;
                int l3 = (i1 + j3) * k2 + k3;
                double d2 = (double)k3 / (double)k2;
                noisechunk.a(l3, d2);
                noisechunk.b(i2, d0);
                noisechunk.c(j2, d1);
                IBlockData iblockdata = noisechunk.e();
                IBlockData iBlockData = iblockdata1 = iblockdata == null ? this.e.a().g() : iblockdata;
                if (aiblockdata != null) {
                    int i4 = j3 * k2 + k3;
                    aiblockdata[i4] = iblockdata1;
                }
                if (predicate == null || !predicate.test(iblockdata1)) continue;
                noisechunk.g();
                return OptionalInt.of(l3 + 1);
            }
        }
        noisechunk.g();
        return OptionalInt.empty();
    }

    @Override
    public void a(RegionLimitedWorldAccess regionlimitedworldaccess, StructureManager structuremanager, RandomState randomstate, IChunkAccess ichunkaccess) {
        if (!SharedConstants.a(ichunkaccess.f())) {
            WorldGenerationContext worldgenerationcontext = new WorldGenerationContext(this, regionlimitedworldaccess);
            this.a(ichunkaccess, worldgenerationcontext, randomstate, structuremanager, regionlimitedworldaccess.F_(), regionlimitedworldaccess.H_().d(Registries.aF), Blender.a(regionlimitedworldaccess));
        }
    }

    @VisibleForTesting
    public void a(IChunkAccess ichunkaccess, WorldGenerationContext worldgenerationcontext, RandomState randomstate, StructureManager structuremanager, BiomeManager biomemanager, IRegistry<BiomeBase> iregistry, Blender blender) {
        NoiseChunk noisechunk = ichunkaccess.a((IChunkAccess ichunkaccess1) -> this.a((IChunkAccess)ichunkaccess1, structuremanager, blender, randomstate));
        GeneratorSettingBase generatorsettingbase = this.e.a();
        randomstate.c().a(randomstate, biomemanager, iregistry, generatorsettingbase.n(), worldgenerationcontext, ichunkaccess, noisechunk, generatorsettingbase.j());
    }

    @Override
    public void a(RegionLimitedWorldAccess regionlimitedworldaccess, long i2, RandomState randomstate, BiomeManager biomemanager, StructureManager structuremanager, IChunkAccess ichunkaccess, WorldGenStage.Features worldgenstage_features) {
        BiomeManager biomemanager1 = biomemanager.a((int j2, int k2, int l2) -> this.b.getNoiseBiome(j2, k2, l2, randomstate.b()));
        SeededRandom seededrandom = new SeededRandom(new LegacyRandomSource(RandomSupport.a()));
        boolean flag = true;
        ChunkCoordIntPair chunkcoordintpair = ichunkaccess.f();
        NoiseChunk noisechunk = ichunkaccess.a((IChunkAccess ichunkaccess1) -> this.a((IChunkAccess)ichunkaccess1, structuremanager, Blender.a(regionlimitedworldaccess), randomstate));
        Aquifer aquifer = noisechunk.i();
        CarvingContext carvingcontext = new CarvingContext(this, regionlimitedworldaccess.H_(), ichunkaccess.z(), noisechunk, randomstate, this.e.a().j());
        CarvingMask carvingmask = ((ProtoChunk)ichunkaccess).b(worldgenstage_features);
        for (int j3 = -8; j3 <= 8; ++j3) {
            for (int k3 = -8; k3 <= 8; ++k3) {
                ChunkCoordIntPair chunkcoordintpair1 = new ChunkCoordIntPair(chunkcoordintpair.e + j3, chunkcoordintpair.f + k3);
                IChunkAccess ichunkaccess12 = regionlimitedworldaccess.a(chunkcoordintpair1.e, chunkcoordintpair1.f);
                BiomeSettingsGeneration biomesettingsgeneration = ichunkaccess12.a(() -> this.a(this.b.getNoiseBiome(QuartPos.a(chunkcoordintpair1.d()), 0, QuartPos.a(chunkcoordintpair1.e()), randomstate.b())));
                Iterable<Holder<WorldGenCarverWrapper<?>>> iterable = biomesettingsgeneration.a(worldgenstage_features);
                int l3 = 0;
                for (Holder<WorldGenCarverWrapper<?>> holder : iterable) {
                    WorldGenCarverWrapper<?> worldgencarverwrapper = holder.a();
                    seededrandom.c(i2 + (long)l3, chunkcoordintpair1.e, chunkcoordintpair1.f);
                    if (worldgencarverwrapper.a(seededrandom)) {
                        Objects.requireNonNull(biomemanager1);
                        worldgencarverwrapper.a(carvingcontext, ichunkaccess, biomemanager1::a, seededrandom, aquifer, chunkcoordintpair1, carvingmask);
                    }
                    ++l3;
                }
            }
        }
    }

    @Override
    public CompletableFuture<IChunkAccess> a(Blender blender, RandomState randomstate, StructureManager structuremanager, IChunkAccess ichunkaccess) {
        NoiseSettings noisesettings = this.e.a().f().a(ichunkaccess.z());
        int i2 = noisesettings.c();
        int j2 = MathHelper.a(i2, noisesettings.a());
        int k2 = MathHelper.a(noisesettings.d(), noisesettings.a());
        return k2 <= 0 ? CompletableFuture.completedFuture(ichunkaccess) : CompletableFuture.supplyAsync(SystemUtils.a("wgen_fill_noise", () -> {
            IChunkAccess ichunkaccess1;
            int l2 = ichunkaccess.e(k2 * noisesettings.a() - 1 + i2);
            int i1 = ichunkaccess.e(i2);
            HashSet set = Sets.newHashSet();
            for (int j1 = l2; j1 >= i1; --j1) {
                ChunkSection chunksection = ichunkaccess.b(j1);
                chunksection.a();
                set.add(chunksection);
            }
            boolean flag = false;
            try {
                flag = true;
                ichunkaccess1 = this.a(blender, structuremanager, randomstate, ichunkaccess, j2, k2);
                flag = false;
            }
            finally {
                if (flag) {
                    for (ChunkSection chunksection1 : set) {
                        chunksection1.b();
                    }
                }
            }
            for (ChunkSection chunksection2 : set) {
                chunksection2.b();
            }
            return ichunkaccess1;
        }), SystemUtils.g());
    }

    private IChunkAccess a(Blender blender, StructureManager structuremanager, RandomState randomstate, IChunkAccess ichunkaccess, int i2, int j2) {
        NoiseChunk noisechunk = ichunkaccess.a((IChunkAccess ichunkaccess1) -> this.a((IChunkAccess)ichunkaccess1, structuremanager, blender, randomstate));
        HeightMap heightmap = ichunkaccess.a(HeightMap.Type.c);
        HeightMap heightmap1 = ichunkaccess.a(HeightMap.Type.a);
        ChunkCoordIntPair chunkcoordintpair = ichunkaccess.f();
        int k2 = chunkcoordintpair.d();
        int l2 = chunkcoordintpair.e();
        Aquifer aquifer = noisechunk.i();
        noisechunk.f();
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        int i1 = noisechunk.j();
        int j1 = noisechunk.k();
        int k1 = 16 / i1;
        int l1 = 16 / i1;
        for (int i22 = 0; i22 < k1; ++i22) {
            noisechunk.b(i22);
            for (int j22 = 0; j22 < l1; ++j22) {
                int k22 = ichunkaccess.an() - 1;
                ChunkSection chunksection = ichunkaccess.b(k22);
                for (int l22 = j2 - 1; l22 >= 0; --l22) {
                    noisechunk.b(l22, j22);
                    for (int i3 = j1 - 1; i3 >= 0; --i3) {
                        int j3 = (i2 + l22) * j1 + i3;
                        int k3 = j3 & 0xF;
                        int l3 = ichunkaccess.e(j3);
                        if (k22 != l3) {
                            k22 = l3;
                            chunksection = ichunkaccess.b(l3);
                        }
                        double d0 = (double)i3 / (double)j1;
                        noisechunk.a(j3, d0);
                        for (int i4 = 0; i4 < i1; ++i4) {
                            int j4 = k2 + i22 * i1 + i4;
                            int k4 = j4 & 0xF;
                            double d1 = (double)i4 / (double)i1;
                            noisechunk.b(j4, d1);
                            for (int l4 = 0; l4 < i1; ++l4) {
                                int i5 = l2 + j22 * i1 + l4;
                                int j5 = i5 & 0xF;
                                double d2 = (double)l4 / (double)i1;
                                noisechunk.c(i5, d2);
                                IBlockData iblockdata = noisechunk.e();
                                if (iblockdata == null) {
                                    iblockdata = this.e.a().g();
                                }
                                if ((iblockdata = this.a(noisechunk, j4, j3, i5, iblockdata)) == d || SharedConstants.a(ichunkaccess.f())) continue;
                                chunksection.a(k4, k3, j5, iblockdata, false);
                                heightmap.a(k4, j3, j5, iblockdata);
                                heightmap1.a(k4, j3, j5, iblockdata);
                                if (!aquifer.a() || iblockdata.u().c()) continue;
                                blockposition_mutableblockposition.d(j4, j3, i5);
                                ichunkaccess.e(blockposition_mutableblockposition);
                            }
                        }
                    }
                }
            }
            noisechunk.h();
        }
        noisechunk.g();
        return ichunkaccess;
    }

    private IBlockData a(NoiseChunk noisechunk, int i2, int j2, int k2, IBlockData iblockdata) {
        return iblockdata;
    }

    @Override
    public int e() {
        return this.e.a().f().d();
    }

    @Override
    public int f() {
        return this.e.a().l();
    }

    @Override
    public int g() {
        return this.e.a().f().c();
    }

    @Override
    public void a(RegionLimitedWorldAccess regionlimitedworldaccess) {
        if (!this.e.a().a()) {
            ChunkCoordIntPair chunkcoordintpair = regionlimitedworldaccess.a();
            Holder<BiomeBase> holder = regionlimitedworldaccess.t(chunkcoordintpair.l().h(regionlimitedworldaccess.am() - 1));
            SeededRandom seededrandom = new SeededRandom(new LegacyRandomSource(RandomSupport.a()));
            seededrandom.a(regionlimitedworldaccess.C(), chunkcoordintpair.d(), chunkcoordintpair.e());
            SpawnerCreature.a(regionlimitedworldaccess, holder, chunkcoordintpair, seededrandom);
        }
    }
}

