/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IWorldWriter;
import net.minecraft.world.level.VirtualLevelReadable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.BlockColumnFeature;
import net.minecraft.world.level.levelgen.feature.DiskFeature;
import net.minecraft.world.level.levelgen.feature.DripstoneClusterFeature;
import net.minecraft.world.level.levelgen.feature.EndPlatformFeature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.FossilFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.GeodeFeature;
import net.minecraft.world.level.levelgen.feature.LargeDripstoneFeature;
import net.minecraft.world.level.levelgen.feature.MultifaceGrowthFeature;
import net.minecraft.world.level.levelgen.feature.PointedDripstoneFeature;
import net.minecraft.world.level.levelgen.feature.RootSystemFeature;
import net.minecraft.world.level.levelgen.feature.ScatteredOreFeature;
import net.minecraft.world.level.levelgen.feature.SculkPatchFeature;
import net.minecraft.world.level.levelgen.feature.UnderwaterMagmaFeature;
import net.minecraft.world.level.levelgen.feature.VegetationPatchFeature;
import net.minecraft.world.level.levelgen.feature.WaterloggedVegetationPatchFeature;
import net.minecraft.world.level.levelgen.feature.WorldGenBonusChest;
import net.minecraft.world.level.levelgen.feature.WorldGenDesertWell;
import net.minecraft.world.level.levelgen.feature.WorldGenDungeons;
import net.minecraft.world.level.levelgen.feature.WorldGenEndGateway;
import net.minecraft.world.level.levelgen.feature.WorldGenEndIsland;
import net.minecraft.world.level.levelgen.feature.WorldGenEnder;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureBamboo;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureBasaltColumns;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureBasaltPillar;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureBlock;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureBlockPile;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureBlueIce;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureChoice;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureChorusPlant;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureCoralClaw;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureCoralMushroom;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureCoralTree;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureDelta;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureEmpty;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureEndPlatform;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureFill;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureHugeFungi;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureHugeFungiConfiguration;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureIceSnow;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureIceburg;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureKelp;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureNetherForestVegetation;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureNetherrackReplaceBlobs;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureRandom2Configuration;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureRandomChoice;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureRandomPatch;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureReplaceBlock;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureSeaGrass;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureSeaPickel;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureTwistingVines;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureWeepingVines;
import net.minecraft.world.level.levelgen.feature.WorldGenFossils;
import net.minecraft.world.level.levelgen.feature.WorldGenHugeMushroomBrown;
import net.minecraft.world.level.levelgen.feature.WorldGenHugeMushroomRed;
import net.minecraft.world.level.levelgen.feature.WorldGenLakes;
import net.minecraft.world.level.levelgen.feature.WorldGenLightStone1;
import net.minecraft.world.level.levelgen.feature.WorldGenLiquids;
import net.minecraft.world.level.levelgen.feature.WorldGenMinable;
import net.minecraft.world.level.levelgen.feature.WorldGenPackedIce2;
import net.minecraft.world.level.levelgen.feature.WorldGenTaigaStructure;
import net.minecraft.world.level.levelgen.feature.WorldGenTrees;
import net.minecraft.world.level.levelgen.feature.WorldGenVines;
import net.minecraft.world.level.levelgen.feature.configurations.BlockColumnConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.DripstoneClusterConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.GeodeConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.LargeDripstoneConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.MultifaceGrowthConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NetherForestVegetationConfig;
import net.minecraft.world.level.levelgen.feature.configurations.PointedDripstoneConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RootSystemConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SculkPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TwistingVinesConfig;
import net.minecraft.world.level.levelgen.feature.configurations.UnderwaterMagmaConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.VegetationPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenDecoratorFrequencyConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenEndGatewayConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureBasaltColumnsConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureBlockPileConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureChoiceConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureCircleConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfigurationChance;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureDeltaConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureEmptyConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureEndSpikeConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureFillConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureHellFlowingLavaConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureLakeConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureMushroomConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureOreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureRadiusConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureRandom2;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureRandomChoiceConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureRandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureReplaceBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureTreeConfiguration;

public abstract class WorldGenerator<FC extends WorldGenFeatureConfiguration> {
    public static final WorldGenerator<WorldGenFeatureEmptyConfiguration> e = WorldGenerator.a("no_op", new WorldGenFeatureEmpty(WorldGenFeatureEmptyConfiguration.a));
    public static final WorldGenerator<WorldGenFeatureTreeConfiguration> f = WorldGenerator.a("tree", new WorldGenTrees(WorldGenFeatureTreeConfiguration.a));
    public static final WorldGenerator<WorldGenFeatureRandomPatchConfiguration> g = WorldGenerator.a("flower", new WorldGenFeatureRandomPatch(WorldGenFeatureRandomPatchConfiguration.a));
    public static final WorldGenerator<WorldGenFeatureRandomPatchConfiguration> h = WorldGenerator.a("no_bonemeal_flower", new WorldGenFeatureRandomPatch(WorldGenFeatureRandomPatchConfiguration.a));
    public static final WorldGenerator<WorldGenFeatureRandomPatchConfiguration> i = WorldGenerator.a("random_patch", new WorldGenFeatureRandomPatch(WorldGenFeatureRandomPatchConfiguration.a));
    public static final WorldGenerator<WorldGenFeatureBlockPileConfiguration> j = WorldGenerator.a("block_pile", new WorldGenFeatureBlockPile(WorldGenFeatureBlockPileConfiguration.a));
    public static final WorldGenerator<WorldGenFeatureHellFlowingLavaConfiguration> k = WorldGenerator.a("spring_feature", new WorldGenLiquids(WorldGenFeatureHellFlowingLavaConfiguration.a));
    public static final WorldGenerator<WorldGenFeatureEmptyConfiguration> l = WorldGenerator.a("chorus_plant", new WorldGenFeatureChorusPlant(WorldGenFeatureEmptyConfiguration.a));
    public static final WorldGenerator<WorldGenFeatureReplaceBlockConfiguration> m = WorldGenerator.a("replace_single_block", new WorldGenFeatureReplaceBlock(WorldGenFeatureReplaceBlockConfiguration.a));
    public static final WorldGenerator<WorldGenFeatureEmptyConfiguration> n = WorldGenerator.a("void_start_platform", new WorldGenFeatureEndPlatform(WorldGenFeatureEmptyConfiguration.a));
    public static final WorldGenerator<WorldGenFeatureEmptyConfiguration> o = WorldGenerator.a("desert_well", new WorldGenDesertWell(WorldGenFeatureEmptyConfiguration.a));
    public static final WorldGenerator<FossilFeatureConfiguration> p = WorldGenerator.a("fossil", new WorldGenFossils(FossilFeatureConfiguration.a));
    public static final WorldGenerator<WorldGenFeatureMushroomConfiguration> q = WorldGenerator.a("huge_red_mushroom", new WorldGenHugeMushroomRed(WorldGenFeatureMushroomConfiguration.a));
    public static final WorldGenerator<WorldGenFeatureMushroomConfiguration> r = WorldGenerator.a("huge_brown_mushroom", new WorldGenHugeMushroomBrown(WorldGenFeatureMushroomConfiguration.a));
    public static final WorldGenerator<WorldGenFeatureEmptyConfiguration> s = WorldGenerator.a("ice_spike", new WorldGenPackedIce2(WorldGenFeatureEmptyConfiguration.a));
    public static final WorldGenerator<WorldGenFeatureEmptyConfiguration> t = WorldGenerator.a("glowstone_blob", new WorldGenLightStone1(WorldGenFeatureEmptyConfiguration.a));
    public static final WorldGenerator<WorldGenFeatureEmptyConfiguration> u = WorldGenerator.a("freeze_top_layer", new WorldGenFeatureIceSnow(WorldGenFeatureEmptyConfiguration.a));
    public static final WorldGenerator<WorldGenFeatureEmptyConfiguration> v = WorldGenerator.a("vines", new WorldGenVines(WorldGenFeatureEmptyConfiguration.a));
    public static final WorldGenerator<BlockColumnConfiguration> w = WorldGenerator.a("block_column", new BlockColumnFeature(BlockColumnConfiguration.a));
    public static final WorldGenerator<VegetationPatchConfiguration> x = WorldGenerator.a("vegetation_patch", new VegetationPatchFeature(VegetationPatchConfiguration.a));
    public static final WorldGenerator<VegetationPatchConfiguration> y = WorldGenerator.a("waterlogged_vegetation_patch", new WaterloggedVegetationPatchFeature(VegetationPatchConfiguration.a));
    public static final WorldGenerator<RootSystemConfiguration> z = WorldGenerator.a("root_system", new RootSystemFeature(RootSystemConfiguration.a));
    public static final WorldGenerator<MultifaceGrowthConfiguration> A = WorldGenerator.a("multiface_growth", new MultifaceGrowthFeature(MultifaceGrowthConfiguration.a));
    public static final WorldGenerator<UnderwaterMagmaConfiguration> B = WorldGenerator.a("underwater_magma", new UnderwaterMagmaFeature(UnderwaterMagmaConfiguration.a));
    public static final WorldGenerator<WorldGenFeatureEmptyConfiguration> C = WorldGenerator.a("monster_room", new WorldGenDungeons(WorldGenFeatureEmptyConfiguration.a));
    public static final WorldGenerator<WorldGenFeatureEmptyConfiguration> D = WorldGenerator.a("blue_ice", new WorldGenFeatureBlueIce(WorldGenFeatureEmptyConfiguration.a));
    public static final WorldGenerator<WorldGenFeatureLakeConfiguration> E = WorldGenerator.a("iceberg", new WorldGenFeatureIceburg(WorldGenFeatureLakeConfiguration.a));
    public static final WorldGenerator<WorldGenFeatureLakeConfiguration> F = WorldGenerator.a("forest_rock", new WorldGenTaigaStructure(WorldGenFeatureLakeConfiguration.a));
    public static final WorldGenerator<WorldGenFeatureCircleConfiguration> G = WorldGenerator.a("disk", new DiskFeature(WorldGenFeatureCircleConfiguration.a));
    public static final WorldGenerator<WorldGenLakes.a> H = WorldGenerator.a("lake", new WorldGenLakes(WorldGenLakes.a.a));
    public static final WorldGenerator<WorldGenFeatureOreConfiguration> I = WorldGenerator.a("ore", new WorldGenMinable(WorldGenFeatureOreConfiguration.a));
    public static final WorldGenerator<WorldGenFeatureEmptyConfiguration> J = WorldGenerator.a("end_platform", new EndPlatformFeature(WorldGenFeatureEmptyConfiguration.a));
    public static final WorldGenerator<WorldGenFeatureEndSpikeConfiguration> K = WorldGenerator.a("end_spike", new WorldGenEnder(WorldGenFeatureEndSpikeConfiguration.a));
    public static final WorldGenerator<WorldGenFeatureEmptyConfiguration> L = WorldGenerator.a("end_island", new WorldGenEndIsland(WorldGenFeatureEmptyConfiguration.a));
    public static final WorldGenerator<WorldGenEndGatewayConfiguration> M = WorldGenerator.a("end_gateway", new WorldGenEndGateway(WorldGenEndGatewayConfiguration.a));
    public static final WorldGenFeatureSeaGrass N = WorldGenerator.a("seagrass", new WorldGenFeatureSeaGrass(WorldGenFeatureConfigurationChance.k));
    public static final WorldGenerator<WorldGenFeatureEmptyConfiguration> O = WorldGenerator.a("kelp", new WorldGenFeatureKelp(WorldGenFeatureEmptyConfiguration.a));
    public static final WorldGenerator<WorldGenFeatureEmptyConfiguration> P = WorldGenerator.a("coral_tree", new WorldGenFeatureCoralTree(WorldGenFeatureEmptyConfiguration.a));
    public static final WorldGenerator<WorldGenFeatureEmptyConfiguration> Q = WorldGenerator.a("coral_mushroom", new WorldGenFeatureCoralMushroom(WorldGenFeatureEmptyConfiguration.a));
    public static final WorldGenerator<WorldGenFeatureEmptyConfiguration> R = WorldGenerator.a("coral_claw", new WorldGenFeatureCoralClaw(WorldGenFeatureEmptyConfiguration.a));
    public static final WorldGenerator<WorldGenDecoratorFrequencyConfiguration> S = WorldGenerator.a("sea_pickle", new WorldGenFeatureSeaPickel(WorldGenDecoratorFrequencyConfiguration.a));
    public static final WorldGenerator<WorldGenFeatureBlockConfiguration> T = WorldGenerator.a("simple_block", new WorldGenFeatureBlock(WorldGenFeatureBlockConfiguration.a));
    public static final WorldGenerator<WorldGenFeatureConfigurationChance> U = WorldGenerator.a("bamboo", new WorldGenFeatureBamboo(WorldGenFeatureConfigurationChance.k));
    public static final WorldGenerator<WorldGenFeatureHugeFungiConfiguration> V = WorldGenerator.a("huge_fungus", new WorldGenFeatureHugeFungi(WorldGenFeatureHugeFungiConfiguration.a));
    public static final WorldGenerator<NetherForestVegetationConfig> W = WorldGenerator.a("nether_forest_vegetation", new WorldGenFeatureNetherForestVegetation(NetherForestVegetationConfig.c));
    public static final WorldGenerator<WorldGenFeatureEmptyConfiguration> X = WorldGenerator.a("weeping_vines", new WorldGenFeatureWeepingVines(WorldGenFeatureEmptyConfiguration.a));
    public static final WorldGenerator<TwistingVinesConfig> Y = WorldGenerator.a("twisting_vines", new WorldGenFeatureTwistingVines(TwistingVinesConfig.a));
    public static final WorldGenerator<WorldGenFeatureBasaltColumnsConfiguration> Z = WorldGenerator.a("basalt_columns", new WorldGenFeatureBasaltColumns(WorldGenFeatureBasaltColumnsConfiguration.a));
    public static final WorldGenerator<WorldGenFeatureDeltaConfiguration> aa = WorldGenerator.a("delta_feature", new WorldGenFeatureDelta(WorldGenFeatureDeltaConfiguration.a));
    public static final WorldGenerator<WorldGenFeatureRadiusConfiguration> ab = WorldGenerator.a("netherrack_replace_blobs", new WorldGenFeatureNetherrackReplaceBlobs(WorldGenFeatureRadiusConfiguration.a));
    public static final WorldGenerator<WorldGenFeatureFillConfiguration> ac = WorldGenerator.a("fill_layer", new WorldGenFeatureFill(WorldGenFeatureFillConfiguration.a));
    public static final WorldGenBonusChest ad = WorldGenerator.a("bonus_chest", new WorldGenBonusChest(WorldGenFeatureEmptyConfiguration.a));
    public static final WorldGenerator<WorldGenFeatureEmptyConfiguration> ae = WorldGenerator.a("basalt_pillar", new WorldGenFeatureBasaltPillar(WorldGenFeatureEmptyConfiguration.a));
    public static final WorldGenerator<WorldGenFeatureOreConfiguration> af = WorldGenerator.a("scattered_ore", new ScatteredOreFeature(WorldGenFeatureOreConfiguration.a));
    public static final WorldGenerator<WorldGenFeatureRandomChoiceConfiguration> ag = WorldGenerator.a("random_selector", new WorldGenFeatureRandomChoice(WorldGenFeatureRandomChoiceConfiguration.a));
    public static final WorldGenerator<WorldGenFeatureRandom2> ah = WorldGenerator.a("simple_random_selector", new WorldGenFeatureRandom2Configuration(WorldGenFeatureRandom2.a));
    public static final WorldGenerator<WorldGenFeatureChoiceConfiguration> ai = WorldGenerator.a("random_boolean_selector", new WorldGenFeatureChoice(WorldGenFeatureChoiceConfiguration.a));
    public static final WorldGenerator<GeodeConfiguration> aj = WorldGenerator.a("geode", new GeodeFeature(GeodeConfiguration.b));
    public static final WorldGenerator<DripstoneClusterConfiguration> ak = WorldGenerator.a("dripstone_cluster", new DripstoneClusterFeature(DripstoneClusterConfiguration.a));
    public static final WorldGenerator<LargeDripstoneConfiguration> al = WorldGenerator.a("large_dripstone", new LargeDripstoneFeature(LargeDripstoneConfiguration.a));
    public static final WorldGenerator<PointedDripstoneConfiguration> am = WorldGenerator.a("pointed_dripstone", new PointedDripstoneFeature(PointedDripstoneConfiguration.a));
    public static final WorldGenerator<SculkPatchConfiguration> an = WorldGenerator.a("sculk_patch", new SculkPatchFeature(SculkPatchConfiguration.a));
    private final MapCodec<WorldGenFeatureConfigured<FC, WorldGenerator<FC>>> a;

    private static <C extends WorldGenFeatureConfiguration, F extends WorldGenerator<C>> F a(String var0, F var1) {
        return (F)IRegistry.a(BuiltInRegistries.O, var0, var1);
    }

    public WorldGenerator(Codec<FC> var02) {
        this.a = var02.fieldOf("config").xmap(var0 -> new WorldGenFeatureConfigured<WorldGenFeatureConfiguration, WorldGenerator>(this, (WorldGenFeatureConfiguration)var0), WorldGenFeatureConfigured::c);
    }

    public MapCodec<WorldGenFeatureConfigured<FC, WorldGenerator<FC>>> a() {
        return this.a;
    }

    protected void a(IWorldWriter var0, BlockPosition var1, IBlockData var2) {
        var0.a(var1, var2, 3);
    }

    public static Predicate<IBlockData> a(TagKey<Block> var0) {
        return var1 -> !var1.a(var0);
    }

    protected void a(GeneratorAccessSeed var0, BlockPosition var1, IBlockData var2, Predicate<IBlockData> var3) {
        if (var3.test(var0.a_(var1))) {
            var0.a(var1, var2, 2);
        }
    }

    public abstract boolean a(FeaturePlaceContext<FC> var1);

    public boolean a(FC var0, GeneratorAccessSeed var1, ChunkGenerator var2, RandomSource var3, BlockPosition var4) {
        if (var1.f_(var4)) {
            return this.a(new FeaturePlaceContext<FC>(Optional.empty(), var1, var2, var3, var4, var0));
        }
        return false;
    }

    protected static boolean a(IBlockData var0) {
        return var0.a(TagsBlock.bf);
    }

    public static boolean b(IBlockData var0) {
        return var0.a(TagsBlock.ag);
    }

    public static boolean a(VirtualLevelReadable var0, BlockPosition var1) {
        return var0.a(var1, WorldGenerator::b);
    }

    public static boolean a(Function<BlockPosition, IBlockData> var0, BlockPosition var1, Predicate<IBlockData> var2) {
        BlockPosition.MutableBlockPosition var3 = new BlockPosition.MutableBlockPosition();
        for (EnumDirection var7 : EnumDirection.values()) {
            var3.a((BaseBlockPosition)var1, var7);
            if (!var2.test(var0.apply(var3))) continue;
            return true;
        }
        return false;
    }

    public static boolean a(Function<BlockPosition, IBlockData> var0, BlockPosition var1) {
        return WorldGenerator.a(var0, var1, BlockBase.BlockData::i);
    }

    protected void a(GeneratorAccessSeed var0, BlockPosition var1) {
        BlockPosition.MutableBlockPosition var2 = var1.k();
        for (int var3 = 0; var3 < 2; ++var3) {
            var2.c(EnumDirection.b);
            if (var0.a_(var2).i()) {
                return;
            }
            var0.y(var2).e(var2);
        }
    }
}

