/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.saveddata.maps;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutMap;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.MapDecorations;
import net.minecraft.world.item.component.MapItemColor;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.saveddata.maps.MapIcon;
import net.minecraft.world.level.saveddata.maps.MapIconBanner;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMapFrame;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.map.CraftMapCursor;
import org.bukkit.craftbukkit.v1_21_R1.map.CraftMapView;
import org.bukkit.craftbukkit.v1_21_R1.map.RenderData;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftChatMessage;
import org.bukkit.map.MapCursor;
import org.slf4j.Logger;

public class WorldMap
extends PersistentBase {
    private static final Logger i = LogUtils.getLogger();
    private static final int j = 128;
    private static final int k = 64;
    public static final int a = 4;
    public static final int b = 256;
    private static final String l = "frame-";
    public int c;
    public int d;
    public ResourceKey<World> e;
    public boolean m;
    public boolean n;
    public byte f;
    public byte[] g = new byte[16384];
    public boolean h;
    public final List<WorldMapHumanTracker> o = Lists.newArrayList();
    public final Map<EntityHuman, WorldMapHumanTracker> p = Maps.newHashMap();
    private final Map<String, MapIconBanner> q = Maps.newHashMap();
    public final Map<String, MapIcon> r = Maps.newLinkedHashMap();
    private final Map<String, WorldMapFrame> s = Maps.newHashMap();
    private int t;
    public final CraftMapView mapView;
    private CraftServer server;
    public UUID uniqueId = null;
    public MapId id;

    public static PersistentBase.a<WorldMap> a() {
        return new PersistentBase.a<WorldMap>(() -> {
            throw new IllegalStateException("Should never create an empty map saved data");
        }, WorldMap::b, DataFixTypes.j);
    }

    private WorldMap(int i2, int j2, byte b0, boolean flag, boolean flag1, boolean flag2, ResourceKey<World> resourcekey) {
        this.f = b0;
        this.c = i2;
        this.d = j2;
        this.e = resourcekey;
        this.m = flag;
        this.n = flag1;
        this.h = flag2;
        this.c();
        this.mapView = new CraftMapView(this);
        this.server = (CraftServer)Bukkit.getServer();
    }

    public static WorldMap a(double d0, double d1, byte b0, boolean flag, boolean flag1, ResourceKey<World> resourcekey) {
        int i2 = 128 * (1 << b0);
        int j2 = MathHelper.a((d0 + 64.0) / (double)i2);
        int k2 = MathHelper.a((d1 + 64.0) / (double)i2);
        int l2 = j2 * i2 + i2 / 2 - 64;
        int i1 = k2 * i2 + i2 / 2 - 64;
        return new WorldMap(l2, i1, b0, flag, flag1, false, resourcekey);
    }

    public static WorldMap a(byte b0, boolean flag, ResourceKey<World> resourcekey) {
        return new WorldMap(0, 0, b0, false, false, flag, resourcekey);
    }

    public static WorldMap b(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        DataResult<ResourceKey<World>> dataresult = DimensionManager.a(new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)nbttagcompound.c("dimension")));
        Logger logger = i;
        Objects.requireNonNull(logger);
        ResourceKey resourcekey = dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).orElseGet(() -> {
            UUID uniqueId;
            CraftWorld world;
            long least = nbttagcompound.i("UUIDLeast");
            long most = nbttagcompound.i("UUIDMost");
            if (least != 0L && most != 0L && (world = (CraftWorld)Bukkit.getWorld((UUID)(uniqueId = new UUID(most, least)))) != null) {
                return world.getHandle().af();
            }
            throw new IllegalArgumentException("Invalid map dimension: " + String.valueOf(nbttagcompound.c("dimension")));
        });
        int i2 = nbttagcompound.h("xCenter");
        int j2 = nbttagcompound.h("zCenter");
        byte b0 = (byte)MathHelper.a((int)nbttagcompound.f("scale"), 0, 4);
        boolean flag = !nbttagcompound.b("trackingPosition", 1) || nbttagcompound.q("trackingPosition");
        boolean flag1 = nbttagcompound.q("unlimitedTracking");
        boolean flag2 = nbttagcompound.q("locked");
        WorldMap worldmap = new WorldMap(i2, j2, b0, flag, flag1, flag2, resourcekey);
        byte[] abyte = nbttagcompound.m("colors");
        if (abyte.length == 16384) {
            worldmap.g = abyte;
        }
        RegistryOps<NBTBase> registryops = holderlookup_a.a(DynamicOpsNBT.a);
        List list = MapIconBanner.b.parse(registryops, (Object)nbttagcompound.c("banners")).resultOrPartial(s2 -> i.warn("Failed to parse map banner: '{}'", s2)).orElse(List.of());
        for (MapIconBanner mapiconbanner : list) {
            worldmap.q.put(mapiconbanner.b(), mapiconbanner);
            worldmap.a(mapiconbanner.a(), null, mapiconbanner.b(), mapiconbanner.c().u(), mapiconbanner.c().w(), 180.0, mapiconbanner.e().orElse(null));
        }
        NBTTagList nbttaglist = nbttagcompound.c("frames", 10);
        for (int k2 = 0; k2 < nbttaglist.size(); ++k2) {
            WorldMapFrame worldmapframe = WorldMapFrame.a(nbttaglist.a(k2));
            if (worldmapframe == null) continue;
            worldmap.s.put(worldmapframe.e(), worldmapframe);
            worldmap.a(MapDecorationTypes.b, null, WorldMap.b(worldmapframe.d()), worldmapframe.b().u(), worldmapframe.b().w(), worldmapframe.c(), null);
        }
        return worldmap;
    }

    @Override
    public NBTTagCompound a(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        DataResult dataresult = MinecraftKey.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.e.a());
        Logger logger = i;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbttagcompound.a("dimension", (NBTBase)nbtbase));
        if (this.uniqueId == null) {
            for (org.bukkit.World world : this.server.getWorlds()) {
                CraftWorld cWorld = (CraftWorld)world;
                if (cWorld.getHandle().af() != this.e) continue;
                this.uniqueId = cWorld.getUID();
                break;
            }
        }
        if (this.uniqueId != null) {
            nbttagcompound.a("UUIDLeast", this.uniqueId.getLeastSignificantBits());
            nbttagcompound.a("UUIDMost", this.uniqueId.getMostSignificantBits());
        }
        nbttagcompound.a("xCenter", this.c);
        nbttagcompound.a("zCenter", this.d);
        nbttagcompound.a("scale", this.f);
        nbttagcompound.a("colors", this.g);
        nbttagcompound.a("trackingPosition", this.m);
        nbttagcompound.a("unlimitedTracking", this.n);
        nbttagcompound.a("locked", this.h);
        RegistryOps<NBTBase> registryops = holderlookup_a.a(DynamicOpsNBT.a);
        nbttagcompound.a("banners", (NBTBase)MapIconBanner.b.encodeStart(registryops, List.copyOf(this.q.values())).getOrThrow());
        NBTTagList nbttaglist = new NBTTagList();
        for (WorldMapFrame worldmapframe : this.s.values()) {
            nbttaglist.add(worldmapframe.a());
        }
        nbttagcompound.a("frames", nbttaglist);
        return nbttagcompound;
    }

    public WorldMap b() {
        WorldMap worldmap = new WorldMap(this.c, this.d, this.f, this.m, this.n, true, this.e);
        worldmap.q.putAll(this.q);
        worldmap.r.putAll(this.r);
        worldmap.t = this.t;
        System.arraycopy(this.g, 0, worldmap.g, 0, this.g.length);
        worldmap.c();
        return worldmap;
    }

    public WorldMap e() {
        return WorldMap.a(this.c, this.d, (byte)MathHelper.a(this.f + 1, 0, 4), this.m, this.n, this.e);
    }

    private static Predicate<ItemStack> a(ItemStack itemstack) {
        MapId mapid = itemstack.a(DataComponents.B);
        return itemstack1 -> itemstack1 == itemstack ? true : itemstack1.a(itemstack.g()) && Objects.equals(mapid, itemstack1.a(DataComponents.B));
    }

    public void a(EntityHuman entityhuman, ItemStack itemstack) {
        if (!this.p.containsKey(entityhuman)) {
            WorldMapHumanTracker worldmap_worldmaphumantracker = new WorldMapHumanTracker(entityhuman);
            this.p.put(entityhuman, worldmap_worldmaphumantracker);
            this.o.add(worldmap_worldmaphumantracker);
        }
        Predicate<ItemStack> predicate = WorldMap.a(itemstack);
        if (!entityhuman.fY().b(predicate)) {
            this.a(entityhuman.ah().getString());
        }
        for (int i2 = 0; i2 < this.o.size(); ++i2) {
            WorldMapHumanTracker worldmap_worldmaphumantracker1 = this.o.get(i2);
            String s2 = worldmap_worldmaphumantracker1.a.ah().getString();
            if (!worldmap_worldmaphumantracker1.a.dJ() && (worldmap_worldmaphumantracker1.a.fY().b(predicate) || itemstack.C())) {
                if (itemstack.C() || worldmap_worldmaphumantracker1.a.dO().af() != this.e || !this.m) continue;
                this.a(MapDecorationTypes.a, worldmap_worldmaphumantracker1.a.dO(), s2, worldmap_worldmaphumantracker1.a.dt(), worldmap_worldmaphumantracker1.a.dz(), worldmap_worldmaphumantracker1.a.dE(), null);
                continue;
            }
            this.p.remove(worldmap_worldmaphumantracker1.a);
            this.o.remove(worldmap_worldmaphumantracker1);
            this.a(s2);
        }
        if (itemstack.C() && this.m) {
            EntityItemFrame entityitemframe = itemstack.D();
            BlockPosition blockposition = entityitemframe.t();
            WorldMapFrame worldmapframe = this.s.get(WorldMapFrame.a(blockposition));
            if (worldmapframe != null && entityitemframe.an() != worldmapframe.d() && this.s.containsKey(worldmapframe.e())) {
                this.a(WorldMap.b(worldmapframe.d()));
            }
            WorldMapFrame worldmapframe1 = new WorldMapFrame(blockposition, entityitemframe.cH().e() * 90, entityitemframe.an());
            this.a(MapDecorationTypes.b, entityhuman.dO(), WorldMap.b(entityitemframe.an()), blockposition.u(), blockposition.w(), entityitemframe.cH().e() * 90, null);
            this.s.put(worldmapframe1.e(), worldmapframe1);
        }
        MapDecorations mapdecorations = itemstack.a(DataComponents.C, MapDecorations.a);
        if (!this.r.keySet().containsAll(mapdecorations.a().keySet())) {
            mapdecorations.a().forEach((s1, mapdecorations_a) -> {
                if (!this.r.containsKey(s1)) {
                    this.a(mapdecorations_a.a(), entityhuman.dO(), (String)s1, mapdecorations_a.b(), mapdecorations_a.c(), mapdecorations_a.d(), null);
                }
            });
        }
    }

    private void a(String s2) {
        MapIcon mapicon = this.r.remove(s2);
        if (mapicon != null && mapicon.c().a().f()) {
            --this.t;
        }
        this.i();
    }

    public static void a(ItemStack itemstack, BlockPosition blockposition, String s2, Holder<MapDecorationType> holder) {
        MapDecorations.a mapdecorations_a = new MapDecorations.a(holder, blockposition.u(), blockposition.w(), 180.0f);
        itemstack.a(DataComponents.C, MapDecorations.a, mapdecorations -> mapdecorations.a(s2, mapdecorations_a));
        if (holder.a().a()) {
            itemstack.b(DataComponents.A, new MapItemColor(holder.a().d()));
        }
    }

    private void a(Holder<MapDecorationType> holder, @Nullable GeneratorAccess generatoraccess, String s2, double d0, double d1, double d2, @Nullable IChatBaseComponent ichatbasecomponent) {
        MapIcon mapicon1;
        MapIcon mapicon;
        byte b2;
        int i2 = 1 << this.f;
        float f2 = (float)(d0 - (double)this.c) / (float)i2;
        float f1 = (float)(d1 - (double)this.d) / (float)i2;
        byte b0 = (byte)((double)(f2 * 2.0f) + 0.5);
        byte b1 = (byte)((double)(f1 * 2.0f) + 0.5);
        boolean flag = true;
        if (f2 >= -63.0f && f1 >= -63.0f && f2 <= 63.0f && f1 <= 63.0f) {
            b2 = (byte)((d2 += d2 < 0.0 ? -8.0 : 8.0) * 16.0 / 360.0);
            if (this.e == World.i && generatoraccess != null) {
                int j2 = (int)(generatoraccess.A_().d() / 10L);
                b2 = (byte)(j2 * j2 * 34187121 + j2 * 121 >> 15 & 0xF);
            }
        } else {
            if (!holder.a(MapDecorationTypes.a)) {
                this.a(s2);
                return;
            }
            boolean flag1 = true;
            if (Math.abs(f2) < 320.0f && Math.abs(f1) < 320.0f) {
                holder = MapDecorationTypes.g;
            } else {
                if (!this.n) {
                    this.a(s2);
                    return;
                }
                holder = MapDecorationTypes.h;
            }
            b2 = 0;
            if (f2 <= -63.0f) {
                b0 = -128;
            }
            if (f1 <= -63.0f) {
                b1 = -128;
            }
            if (f2 >= 63.0f) {
                b0 = 127;
            }
            if (f1 >= 63.0f) {
                b1 = 127;
            }
        }
        if (!(mapicon = new MapIcon(holder, b0, b1, b2, Optional.ofNullable(ichatbasecomponent))).equals(mapicon1 = this.r.put(s2, mapicon))) {
            if (mapicon1 != null && mapicon1.c().a().f()) {
                --this.t;
            }
            if (holder.a().f()) {
                ++this.t;
            }
            this.i();
        }
    }

    @Nullable
    public Packet<?> a(MapId mapid, EntityHuman entityhuman) {
        WorldMapHumanTracker worldmap_worldmaphumantracker = this.p.get(entityhuman);
        return worldmap_worldmaphumantracker == null ? null : worldmap_worldmaphumantracker.a(mapid);
    }

    public void a(int i2, int j2) {
        this.c();
        for (WorldMapHumanTracker worldmap_worldmaphumantracker : this.o) {
            worldmap_worldmaphumantracker.a(i2, j2);
        }
    }

    public void i() {
        this.c();
        this.o.forEach(WorldMapHumanTracker::b);
    }

    public WorldMapHumanTracker a(EntityHuman entityhuman) {
        WorldMapHumanTracker worldmap_worldmaphumantracker = this.p.get(entityhuman);
        if (worldmap_worldmaphumantracker == null) {
            worldmap_worldmaphumantracker = new WorldMapHumanTracker(entityhuman);
            this.p.put(entityhuman, worldmap_worldmaphumantracker);
            this.o.add(worldmap_worldmaphumantracker);
        }
        return worldmap_worldmaphumantracker;
    }

    public boolean a(GeneratorAccess generatoraccess, BlockPosition blockposition) {
        double d0 = (double)blockposition.u() + 0.5;
        double d1 = (double)blockposition.w() + 0.5;
        int i2 = 1 << this.f;
        double d2 = (d0 - (double)this.c) / (double)i2;
        double d3 = (d1 - (double)this.d) / (double)i2;
        boolean flag = true;
        if (d2 >= -63.0 && d3 >= -63.0 && d2 <= 63.0 && d3 <= 63.0) {
            MapIconBanner mapiconbanner = MapIconBanner.a(generatoraccess, blockposition);
            if (mapiconbanner == null) {
                return false;
            }
            if (this.q.remove(mapiconbanner.b(), mapiconbanner)) {
                this.a(mapiconbanner.b());
                return true;
            }
            if (!this.a(256)) {
                this.q.put(mapiconbanner.b(), mapiconbanner);
                this.a(mapiconbanner.a(), generatoraccess, mapiconbanner.b(), d0, d1, 180.0, mapiconbanner.e().orElse(null));
                return true;
            }
        }
        return false;
    }

    public void a(IBlockAccess iblockaccess, int i2, int j2) {
        Iterator<MapIconBanner> iterator = this.q.values().iterator();
        while (iterator.hasNext()) {
            MapIconBanner mapiconbanner1;
            MapIconBanner mapiconbanner = iterator.next();
            if (mapiconbanner.c().u() != i2 || mapiconbanner.c().w() != j2 || mapiconbanner.equals(mapiconbanner1 = MapIconBanner.a(iblockaccess, mapiconbanner.c()))) continue;
            iterator.remove();
            this.a(mapiconbanner.b());
        }
    }

    public Collection<MapIconBanner> f() {
        return this.q.values();
    }

    public void a(BlockPosition blockposition, int i2) {
        this.a(WorldMap.b(i2));
        this.s.remove(WorldMapFrame.a(blockposition));
    }

    public boolean a(int i2, int j2, byte b0) {
        byte b1 = this.g[i2 + j2 * 128];
        if (b1 != b0) {
            this.b(i2, j2, b0);
            return true;
        }
        return false;
    }

    public void b(int i2, int j2, byte b0) {
        this.g[i2 + j2 * 128] = b0;
        this.a(i2, j2);
    }

    public boolean g() {
        MapIcon mapicon;
        Iterator<MapIcon> iterator = this.r.values().iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!(mapicon = iterator.next()).c().a().e());
        return true;
    }

    public void a(List<MapIcon> list) {
        this.r.clear();
        this.t = 0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            MapIcon mapicon = list.get(i2);
            this.r.put("icon-" + i2, mapicon);
            if (!mapicon.c().a().f()) continue;
            ++this.t;
        }
    }

    public Iterable<MapIcon> h() {
        return this.r.values();
    }

    public boolean a(int i2) {
        return this.t >= i2;
    }

    private static String b(int i2) {
        return l + i2;
    }

    public class WorldMapHumanTracker {
        public final EntityHuman a;
        private boolean d = true;
        private int e;
        private int f;
        private int g = 127;
        private int h = 127;
        private boolean i = true;
        private int j;
        public int b;

        WorldMapHumanTracker(EntityHuman entityhuman) {
            this.a = entityhuman;
        }

        private b createPatch(byte[] buffer) {
            int i2 = this.e;
            int j2 = this.f;
            int k2 = this.g + 1 - this.e;
            int l2 = this.h + 1 - this.f;
            byte[] abyte = new byte[k2 * l2];
            for (int i1 = 0; i1 < k2; ++i1) {
                for (int j1 = 0; j1 < l2; ++j1) {
                    abyte[i1 + j1 * k2] = buffer[i2 + i1 + (j2 + j1) * 128];
                }
            }
            return new b(i2, j2, k2, l2, abyte);
        }

        @Nullable
        Packet<?> a(MapId mapid) {
            ArrayList<MapIcon> collection;
            b worldmap_b;
            RenderData render = WorldMap.this.mapView.render((CraftPlayer)this.a.getBukkitEntity());
            if (this.d) {
                this.d = false;
                worldmap_b = this.createPatch(render.buffer);
            } else {
                worldmap_b = null;
            }
            if (this.j++ % 5 == 0) {
                this.i = false;
                ArrayList<MapIcon> icons = new ArrayList<MapIcon>();
                for (MapCursor cursor : render.cursors) {
                    if (!cursor.isVisible()) continue;
                    icons.add(new MapIcon(CraftMapCursor.CraftType.bukkitToMinecraftHolder(cursor.getType()), cursor.getX(), cursor.getY(), cursor.getDirection(), CraftChatMessage.fromStringOrOptional(cursor.getCaption())));
                }
                collection = icons;
            } else {
                collection = null;
            }
            return collection == null && worldmap_b == null ? null : new PacketPlayOutMap(mapid, WorldMap.this.f, WorldMap.this.h, collection, worldmap_b);
        }

        void a(int i2, int j2) {
            if (this.d) {
                this.e = Math.min(this.e, i2);
                this.f = Math.min(this.f, j2);
                this.g = Math.max(this.g, i2);
                this.h = Math.max(this.h, j2);
            } else {
                this.d = true;
                this.e = i2;
                this.f = j2;
                this.g = i2;
                this.h = j2;
            }
        }

        private void b() {
            this.i = true;
        }
    }

    public static final class b
    extends Record {
        private final int b;
        private final int c;
        private final int d;
        private final int e;
        private final byte[] f;
        public static final StreamCodec<ByteBuf, Optional<b>> a = StreamCodec.a(b::a, b::a);

        public b(int startX, int startY, int width, int height, byte[] mapColors) {
            this.b = startX;
            this.c = startY;
            this.d = width;
            this.e = height;
            this.f = mapColors;
        }

        private static void a(ByteBuf bytebuf, Optional<b> optional) {
            if (optional.isPresent()) {
                b worldmap_b = optional.get();
                bytebuf.writeByte(worldmap_b.d);
                bytebuf.writeByte(worldmap_b.e);
                bytebuf.writeByte(worldmap_b.b);
                bytebuf.writeByte(worldmap_b.c);
                PacketDataSerializer.a(bytebuf, worldmap_b.f);
            } else {
                bytebuf.writeByte(0);
            }
        }

        private static Optional<b> a(ByteBuf bytebuf) {
            short short0 = bytebuf.readUnsignedByte();
            if (short0 > 0) {
                short short1 = bytebuf.readUnsignedByte();
                short short2 = bytebuf.readUnsignedByte();
                short short3 = bytebuf.readUnsignedByte();
                byte[] abyte = PacketDataSerializer.a(bytebuf);
                return Optional.of(new b(short2, short3, short0, short1, abyte));
            }
            return Optional.empty();
        }

        public void a(WorldMap worldmap) {
            for (int i2 = 0; i2 < this.d; ++i2) {
                for (int j2 = 0; j2 < this.e; ++j2) {
                    worldmap.b(this.b + i2, this.c + j2, this.f[i2 + j2 * this.d]);
                }
            }
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "startX;startY;width;height;mapColors", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "startX;startY;width;height;mapColors", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "startX;startY;width;height;mapColors", "b", "c", "d", "e", "f"}, this, o2);
        }

        public int a() {
            return this.b;
        }

        public int b() {
            return this.c;
        }

        public int c() {
            return this.d;
        }

        public int d() {
            return this.e;
        }

        public byte[] e() {
            return this.f;
        }
    }
}

