/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.block;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.block.entity.TrialSpawnerBlockEntity;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerData;
import org.bukkit.block.spawner.SpawnRule;
import org.bukkit.block.spawner.SpawnerEntry;
import org.bukkit.craftbukkit.v1_21_R1.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntitySnapshot;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntityType;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;
import org.bukkit.loot.LootTable;
import org.bukkit.spawner.TrialSpawnerConfiguration;

public class CraftTrialSpawnerConfiguration
implements TrialSpawnerConfiguration {
    private final TrialSpawnerBlockEntity snapshot;
    private int spawnRange;
    private float totalMobs;
    private float simultaneousMobs;
    private float totalMobsAddedPerPlayer;
    private float simultaneousMobsAddedPerPlayer;
    private int ticksBetweenSpawn;
    private SimpleWeightedRandomList<MobSpawnerData> spawnPotentialsDefinition;
    private SimpleWeightedRandomList<ResourceKey<net.minecraft.world.level.storage.loot.LootTable>> lootTablesToEject;
    private ResourceKey<net.minecraft.world.level.storage.loot.LootTable> itemsToDropWhenOminous;

    public CraftTrialSpawnerConfiguration(TrialSpawnerConfig minecraft, TrialSpawnerBlockEntity snapshot) {
        this.snapshot = snapshot;
        this.spawnRange = minecraft.b();
        this.totalMobs = minecraft.c();
        this.simultaneousMobs = minecraft.d();
        this.totalMobsAddedPerPlayer = minecraft.e();
        this.simultaneousMobsAddedPerPlayer = minecraft.f();
        this.ticksBetweenSpawn = minecraft.g();
        this.spawnPotentialsDefinition = minecraft.h();
        this.lootTablesToEject = minecraft.i();
        this.itemsToDropWhenOminous = minecraft.j();
    }

    public EntityType getSpawnedType() {
        if (this.spawnPotentialsDefinition.d()) {
            return null;
        }
        Optional<EntityTypes<?>> type = EntityTypes.a(((MobSpawnerData)((WeightedEntry.b)this.spawnPotentialsDefinition.e().get(0)).b()).a());
        return type.map(CraftEntityType::minecraftToBukkit).orElse(null);
    }

    public void setSpawnedType(EntityType entityType) {
        if (entityType == null) {
            this.getTrialData().h = Optional.empty();
            this.spawnPotentialsDefinition = SimpleWeightedRandomList.b();
            return;
        }
        Preconditions.checkArgument((entityType != EntityType.UNKNOWN ? 1 : 0) != 0, (String)"Can't spawn EntityType %s from mob spawners!", (Object)entityType);
        MobSpawnerData data = new MobSpawnerData();
        data.a().a("id", BuiltInRegistries.f.b(CraftEntityType.bukkitToMinecraft(entityType)).toString());
        this.getTrialData().h = Optional.of(data);
        this.spawnPotentialsDefinition = SimpleWeightedRandomList.a(data);
    }

    public float getBaseSpawnsBeforeCooldown() {
        return this.totalMobs;
    }

    public void setBaseSpawnsBeforeCooldown(float amount) {
        this.totalMobs = amount;
    }

    public float getBaseSimultaneousEntities() {
        return this.simultaneousMobs;
    }

    public void setBaseSimultaneousEntities(float amount) {
        this.simultaneousMobs = amount;
    }

    public float getAdditionalSpawnsBeforeCooldown() {
        return this.totalMobsAddedPerPlayer;
    }

    public void setAdditionalSpawnsBeforeCooldown(float amount) {
        this.totalMobsAddedPerPlayer = amount;
    }

    public float getAdditionalSimultaneousEntities() {
        return this.simultaneousMobsAddedPerPlayer;
    }

    public void setAdditionalSimultaneousEntities(float amount) {
        this.simultaneousMobsAddedPerPlayer = amount;
    }

    public int getDelay() {
        return this.ticksBetweenSpawn;
    }

    public void setDelay(int delay) {
        Preconditions.checkArgument((delay >= 0 ? 1 : 0) != 0, (Object)"Delay cannot be less than 0");
        this.ticksBetweenSpawn = delay;
    }

    public int getSpawnRange() {
        return this.spawnRange;
    }

    public void setSpawnRange(int spawnRange) {
        this.spawnRange = spawnRange;
    }

    public EntitySnapshot getSpawnedEntity() {
        SimpleWeightedRandomList<MobSpawnerData> potentials = this.spawnPotentialsDefinition;
        if (potentials.d()) {
            return null;
        }
        return CraftEntitySnapshot.create(((MobSpawnerData)((WeightedEntry.b)potentials.e().get(0)).b()).a());
    }

    public void setSpawnedEntity(EntitySnapshot snapshot) {
        this.setSpawnedEntity(snapshot, null, null);
    }

    public void setSpawnedEntity(SpawnerEntry spawnerEntry) {
        Preconditions.checkArgument((spawnerEntry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        this.setSpawnedEntity(spawnerEntry.getSnapshot(), spawnerEntry.getSpawnRule(), spawnerEntry.getEquipment());
    }

    private void setSpawnedEntity(EntitySnapshot snapshot, SpawnRule spawnRule, SpawnerEntry.Equipment equipment) {
        if (snapshot == null) {
            this.getTrialData().h = Optional.empty();
            this.spawnPotentialsDefinition = SimpleWeightedRandomList.b();
            return;
        }
        NBTTagCompound compoundTag = ((CraftEntitySnapshot)snapshot).getData();
        MobSpawnerData data = new MobSpawnerData(compoundTag, Optional.ofNullable(CraftCreatureSpawner.toMinecraftRule(spawnRule)), CraftCreatureSpawner.getEquipment(equipment));
        this.getTrialData().h = Optional.of(data);
        this.spawnPotentialsDefinition = SimpleWeightedRandomList.a(data);
    }

    public void addPotentialSpawn(EntitySnapshot snapshot, int weight, SpawnRule spawnRule) {
        this.addPotentialSpawn(snapshot, weight, spawnRule, null);
    }

    private void addPotentialSpawn(EntitySnapshot snapshot, int weight, SpawnRule spawnRule, SpawnerEntry.Equipment equipment) {
        Preconditions.checkArgument((snapshot != null ? 1 : 0) != 0, (Object)"Snapshot cannot be null");
        NBTTagCompound compoundTag = ((CraftEntitySnapshot)snapshot).getData();
        SimpleWeightedRandomList.a<MobSpawnerData> builder = SimpleWeightedRandomList.a();
        this.spawnPotentialsDefinition.e().forEach(entry -> builder.a((MobSpawnerData)entry.b(), entry.a().a()));
        builder.a(new MobSpawnerData(compoundTag, Optional.ofNullable(CraftCreatureSpawner.toMinecraftRule(spawnRule)), CraftCreatureSpawner.getEquipment(equipment)), weight);
        this.spawnPotentialsDefinition = builder.a();
    }

    public void addPotentialSpawn(SpawnerEntry spawnerEntry) {
        Preconditions.checkArgument((spawnerEntry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        this.addPotentialSpawn(spawnerEntry.getSnapshot(), spawnerEntry.getSpawnWeight(), spawnerEntry.getSpawnRule(), spawnerEntry.getEquipment());
    }

    public void setPotentialSpawns(Collection<SpawnerEntry> entries) {
        Preconditions.checkArgument((entries != null ? 1 : 0) != 0, (Object)"Entries cannot be null");
        SimpleWeightedRandomList.a<MobSpawnerData> builder = SimpleWeightedRandomList.a();
        for (SpawnerEntry spawnerEntry : entries) {
            NBTTagCompound compoundTag = ((CraftEntitySnapshot)spawnerEntry.getSnapshot()).getData();
            builder.a(new MobSpawnerData(compoundTag, Optional.ofNullable(CraftCreatureSpawner.toMinecraftRule(spawnerEntry.getSpawnRule())), CraftCreatureSpawner.getEquipment(spawnerEntry.getEquipment())), spawnerEntry.getSpawnWeight());
        }
        this.spawnPotentialsDefinition = builder.a();
    }

    public List<SpawnerEntry> getPotentialSpawns() {
        ArrayList<SpawnerEntry> entries = new ArrayList<SpawnerEntry>();
        for (WeightedEntry.b entry : this.spawnPotentialsDefinition.e()) {
            CraftEntitySnapshot snapshot = CraftEntitySnapshot.create(((MobSpawnerData)entry.b()).a());
            if (snapshot == null) continue;
            SpawnRule rule = ((MobSpawnerData)entry.b()).e().map(CraftCreatureSpawner::fromMinecraftRule).orElse(null);
            entries.add(new SpawnerEntry((EntitySnapshot)snapshot, entry.a().a(), rule));
        }
        return entries;
    }

    public Map<LootTable, Integer> getPossibleRewards() {
        HashMap<LootTable, Integer> tables = new HashMap<LootTable, Integer>();
        for (WeightedEntry.b entry : this.lootTablesToEject.e()) {
            LootTable table = CraftLootTable.minecraftToBukkit((ResourceKey)entry.b());
            if (table == null) continue;
            tables.put(table, entry.a().a());
        }
        return tables;
    }

    public void addPossibleReward(LootTable table, int weight) {
        Preconditions.checkArgument((table != null ? 1 : 0) != 0, (Object)"Table cannot be null");
        Preconditions.checkArgument((weight >= 1 ? 1 : 0) != 0, (Object)"Weight must be at least 1");
        SimpleWeightedRandomList.a<ResourceKey<net.minecraft.world.level.storage.loot.LootTable>> builder = SimpleWeightedRandomList.a();
        this.lootTablesToEject.e().forEach(entry -> builder.a((ResourceKey)entry.b(), entry.a().a()));
        builder.a(CraftLootTable.bukkitToMinecraft(table), weight);
        this.lootTablesToEject = builder.a();
    }

    public void removePossibleReward(LootTable table) {
        Preconditions.checkArgument((table != null ? 1 : 0) != 0, (Object)"Key cannot be null");
        ResourceKey<net.minecraft.world.level.storage.loot.LootTable> minecraftKey = CraftLootTable.bukkitToMinecraft(table);
        SimpleWeightedRandomList.a<ResourceKey> builder = SimpleWeightedRandomList.a();
        for (WeightedEntry.b entry : this.lootTablesToEject.e()) {
            if (((ResourceKey)entry.b()).equals(minecraftKey)) continue;
            builder.a((ResourceKey)entry.b(), entry.a().a());
        }
        this.lootTablesToEject = builder.a();
    }

    public void setPossibleRewards(Map<LootTable, Integer> rewards) {
        if (rewards == null || rewards.isEmpty()) {
            this.lootTablesToEject = SimpleWeightedRandomList.b();
            return;
        }
        SimpleWeightedRandomList.a builder = SimpleWeightedRandomList.a();
        rewards.forEach((table, weight) -> {
            Preconditions.checkArgument((table != null ? 1 : 0) != 0, (Object)"Table cannot be null");
            Preconditions.checkArgument((weight >= 1 ? 1 : 0) != 0, (Object)"Weight must be at least 1");
            builder.a(CraftLootTable.bukkitToMinecraft(table), (int)weight);
        });
        this.lootTablesToEject = builder.a();
    }

    public int getRequiredPlayerRange() {
        return this.snapshot.b.h();
    }

    public void setRequiredPlayerRange(int requiredPlayerRange) {
        this.snapshot.b.l = requiredPlayerRange;
    }

    private TrialSpawnerData getTrialData() {
        return this.snapshot.c().f();
    }

    protected TrialSpawnerConfig toMinecraft() {
        return new TrialSpawnerConfig(this.spawnRange, this.totalMobs, this.simultaneousMobs, this.totalMobsAddedPerPlayer, this.simultaneousMobsAddedPerPlayer, this.ticksBetweenSpawn, this.spawnPotentialsDefinition, this.lootTablesToEject, this.itemsToDropWhenOminous);
    }
}

