/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.entity;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.projectile.EntityTippedArrow;
import net.minecraft.world.item.alchemy.PotionContents;
import org.bukkit.Color;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftAbstractArrow;
import org.bukkit.craftbukkit.v1_21_R1.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_21_R1.potion.CraftPotionType;
import org.bukkit.craftbukkit.v1_21_R1.potion.CraftPotionUtil;
import org.bukkit.entity.Arrow;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class CraftArrow
extends CraftAbstractArrow
implements Arrow {
    public CraftArrow(CraftServer server, EntityTippedArrow entity) {
        super(server, entity);
    }

    @Override
    public EntityTippedArrow getHandle() {
        return (EntityTippedArrow)this.entity;
    }

    @Override
    public String toString() {
        return "CraftTippedArrow";
    }

    public boolean addCustomEffect(PotionEffect effect, boolean override) {
        if (this.hasCustomEffect(effect.getType())) {
            if (!override) {
                return false;
            }
            this.removeCustomEffect(effect.getType());
        }
        this.getHandle().a(CraftPotionUtil.fromBukkit(effect));
        this.getHandle().K();
        return true;
    }

    public void clearCustomEffects() {
        PotionContents old = this.getHandle().J();
        this.getHandle().a(new PotionContents(old.e(), old.f(), List.of()));
        this.getHandle().K();
    }

    public List<PotionEffect> getCustomEffects() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (MobEffect effect : this.getHandle().J().d()) {
            builder.add((Object)CraftPotionUtil.toBukkit(effect));
        }
        return builder.build();
    }

    public boolean hasCustomEffect(PotionEffectType type) {
        for (MobEffect effect : this.getHandle().J().d()) {
            if (!CraftPotionUtil.equals(effect.c(), type)) continue;
            return true;
        }
        return false;
    }

    public boolean hasCustomEffects() {
        return !this.getHandle().J().d().isEmpty();
    }

    public boolean removeCustomEffect(PotionEffectType effect) {
        if (!this.hasCustomEffect(effect)) {
            return false;
        }
        Holder<MobEffectList> minecraft = CraftPotionEffectType.bukkitToMinecraftHolder(effect);
        PotionContents old = this.getHandle().J();
        this.getHandle().a(new PotionContents(old.e(), old.f(), old.d().stream().filter(mobEffect -> !mobEffect.c().equals(minecraft)).toList()));
        return true;
    }

    public void setBasePotionData(PotionData data) {
        this.setBasePotionType(CraftPotionUtil.fromBukkit(data));
    }

    public PotionData getBasePotionData() {
        return CraftPotionUtil.toBukkit(this.getBasePotionType());
    }

    public void setBasePotionType(PotionType potionType) {
        if (potionType != null) {
            this.getHandle().a(this.getHandle().J().b(CraftPotionType.bukkitToMinecraftHolder(potionType)));
        } else {
            PotionContents old = this.getHandle().J();
            this.getHandle().a(new PotionContents(Optional.empty(), old.f(), old.d()));
        }
    }

    public PotionType getBasePotionType() {
        return this.getHandle().J().e().map(CraftPotionType::minecraftHolderToBukkit).orElse(null);
    }

    public void setColor(Color color) {
        int colorRGB = color == null ? -1 : color.asRGB();
        PotionContents old = this.getHandle().J();
        this.getHandle().a(new PotionContents(old.e(), Optional.of(colorRGB), old.d()));
    }

    public Color getColor() {
        if (this.getHandle().F() <= -1) {
            return null;
        }
        return Color.fromRGB((int)this.getHandle().F());
    }
}

