/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.entity;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.world.entity.animal.EntityFox;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftAnimals;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Player;

public class CraftFox
extends CraftAnimals
implements Fox {
    public CraftFox(CraftServer server, EntityFox entity) {
        super(server, entity);
    }

    @Override
    public EntityFox getHandle() {
        return (EntityFox)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftFox";
    }

    public Fox.Type getFoxType() {
        return Fox.Type.values()[this.getHandle().t().ordinal()];
    }

    public void setFoxType(Fox.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type");
        this.getHandle().a(EntityFox.Type.values()[type.ordinal()]);
    }

    public boolean isCrouching() {
        return this.getHandle().cb();
    }

    public void setCrouching(boolean crouching) {
        this.getHandle().z(crouching);
    }

    public boolean isSitting() {
        return this.getHandle().x();
    }

    public void setSitting(boolean sitting) {
        this.getHandle().x(sitting);
    }

    public void setSleeping(boolean sleeping) {
        this.getHandle().D(sleeping);
    }

    public AnimalTamer getFirstTrustedPlayer() {
        UUID uuid = this.getHandle().ar().a(EntityFox.cm).orElse(null);
        if (uuid == null) {
            return null;
        }
        Player player = this.getServer().getPlayer(uuid);
        if (player == null) {
            player = this.getServer().getOfflinePlayer(uuid);
        }
        return player;
    }

    public void setFirstTrustedPlayer(AnimalTamer player) {
        if (player == null) {
            Preconditions.checkState((boolean)this.getHandle().ar().a(EntityFox.cn).isEmpty(), (Object)"Must remove second trusted player first");
        }
        this.getHandle().ar().a(EntityFox.cm, player == null ? Optional.empty() : Optional.of(player.getUniqueId()));
    }

    public AnimalTamer getSecondTrustedPlayer() {
        UUID uuid = this.getHandle().ar().a(EntityFox.cn).orElse(null);
        if (uuid == null) {
            return null;
        }
        Player player = this.getServer().getPlayer(uuid);
        if (player == null) {
            player = this.getServer().getOfflinePlayer(uuid);
        }
        return player;
    }

    public void setSecondTrustedPlayer(AnimalTamer player) {
        if (player != null) {
            Preconditions.checkState((boolean)this.getHandle().ar().a(EntityFox.cm).isPresent(), (Object)"Must add first trusted player first");
        }
        this.getHandle().ar().a(EntityFox.cn, player == null ? Optional.empty() : Optional.of(player.getUniqueId()));
    }

    public boolean isFaceplanted() {
        return this.getHandle().gk();
    }
}

