/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.inventory;

import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAnvil;
import net.minecraft.world.inventory.ContainerBeacon;
import net.minecraft.world.inventory.ContainerBlastFurnace;
import net.minecraft.world.inventory.ContainerBrewingStand;
import net.minecraft.world.inventory.ContainerCartography;
import net.minecraft.world.inventory.ContainerChest;
import net.minecraft.world.inventory.ContainerDispenser;
import net.minecraft.world.inventory.ContainerEnchantTable;
import net.minecraft.world.inventory.ContainerFurnaceFurnace;
import net.minecraft.world.inventory.ContainerGrindstone;
import net.minecraft.world.inventory.ContainerHopper;
import net.minecraft.world.inventory.ContainerLectern;
import net.minecraft.world.inventory.ContainerLoom;
import net.minecraft.world.inventory.ContainerMerchant;
import net.minecraft.world.inventory.ContainerProperties;
import net.minecraft.world.inventory.ContainerShulkerBox;
import net.minecraft.world.inventory.ContainerSmoker;
import net.minecraft.world.inventory.ContainerWorkbench;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.CrafterMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftAbstractInventoryView;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryCustom;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftMenuType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.MenuType;

public class CraftContainer
extends Container {
    private final InventoryView view;
    private InventoryType cachedType;
    private Container delegate;

    public CraftContainer(InventoryView view, EntityHuman player, int id) {
        super(CraftContainer.getNotchInventoryType(view.getTopInventory()), id);
        this.view = view;
        IInventory top = ((CraftInventory)view.getTopInventory()).getInventory();
        PlayerInventory bottom = (PlayerInventory)((CraftInventory)view.getBottomInventory()).getInventory();
        this.cachedType = view.getType();
        this.setupSlots(top, bottom, player);
    }

    public CraftContainer(final Inventory inventory, final EntityHuman player, int id) {
        this(new CraftAbstractInventoryView(){
            private final String originalTitle;
            private String title;
            {
                this.title = this.originalTitle = inventory instanceof CraftInventoryCustom ? ((CraftInventoryCustom.MinecraftInventory)((CraftInventory)inventory).getInventory()).getTitle() : inventory.getType().getDefaultTitle();
            }

            public Inventory getTopInventory() {
                return inventory;
            }

            public Inventory getBottomInventory() {
                return this.getPlayer().getInventory();
            }

            public HumanEntity getPlayer() {
                return player.getBukkitEntity();
            }

            public InventoryType getType() {
                return inventory.getType();
            }

            public String getTitle() {
                return this.title;
            }

            public String getOriginalTitle() {
                return this.originalTitle;
            }

            public void setTitle(String title) {
                CraftInventoryView.sendInventoryTitleChange(this, title);
                this.title = title;
            }
        }, player, id);
    }

    @Override
    public InventoryView getBukkitView() {
        return this.view;
    }

    public static Containers getNotchInventoryType(Inventory inventory) {
        InventoryType type = inventory.getType();
        switch (type) {
            case PLAYER: 
            case CHEST: 
            case ENDER_CHEST: 
            case BARREL: {
                switch (inventory.getSize()) {
                    case 9: {
                        return Containers.a;
                    }
                    case 18: {
                        return Containers.b;
                    }
                    case 27: {
                        return Containers.c;
                    }
                    case 36: 
                    case 41: {
                        return Containers.d;
                    }
                    case 45: {
                        return Containers.e;
                    }
                    case 54: {
                        return Containers.f;
                    }
                }
                throw new IllegalArgumentException("Unsupported custom inventory size " + inventory.getSize());
            }
        }
        MenuType menu = type.getMenuType();
        if (menu == null) {
            return Containers.c;
        }
        return ((CraftMenuType)menu).getHandle();
    }

    private void setupSlots(IInventory top, PlayerInventory bottom, EntityHuman entityhuman) {
        int windowId = -1;
        switch (this.cachedType) {
            case CREATIVE: {
                break;
            }
            case PLAYER: 
            case CHEST: 
            case ENDER_CHEST: 
            case BARREL: {
                this.delegate = new ContainerChest(Containers.c, windowId, bottom, top, top.b() / 9);
                break;
            }
            case DISPENSER: 
            case DROPPER: {
                this.delegate = new ContainerDispenser(windowId, bottom, top);
                break;
            }
            case FURNACE: {
                this.delegate = new ContainerFurnaceFurnace(windowId, bottom, top, new ContainerProperties(4));
                break;
            }
            case CRAFTING: 
            case WORKBENCH: {
                this.setupWorkbench(top, bottom);
                break;
            }
            case ENCHANTING: {
                this.delegate = new ContainerEnchantTable(windowId, bottom);
                break;
            }
            case BREWING: {
                this.delegate = new ContainerBrewingStand(windowId, bottom, top, new ContainerProperties(2));
                break;
            }
            case HOPPER: {
                this.delegate = new ContainerHopper(windowId, bottom, top);
                break;
            }
            case ANVIL: {
                this.setupAnvil(top, bottom);
                break;
            }
            case BEACON: {
                this.delegate = new ContainerBeacon(windowId, bottom);
                break;
            }
            case SHULKER_BOX: {
                this.delegate = new ContainerShulkerBox(windowId, bottom, top);
                break;
            }
            case BLAST_FURNACE: {
                this.delegate = new ContainerBlastFurnace(windowId, bottom, top, new ContainerProperties(4));
                break;
            }
            case LECTERN: {
                this.delegate = new ContainerLectern(windowId, top, new ContainerProperties(1), bottom);
                break;
            }
            case SMOKER: {
                this.delegate = new ContainerSmoker(windowId, bottom, top, new ContainerProperties(4));
                break;
            }
            case LOOM: {
                this.delegate = new ContainerLoom(windowId, bottom);
                break;
            }
            case CARTOGRAPHY: {
                this.delegate = new ContainerCartography(windowId, bottom);
                break;
            }
            case GRINDSTONE: {
                this.delegate = new ContainerGrindstone(windowId, bottom);
                break;
            }
            case STONECUTTER: {
                this.setupStoneCutter(top, bottom);
                break;
            }
            case MERCHANT: {
                this.delegate = new ContainerMerchant(windowId, bottom);
                break;
            }
            case SMITHING: 
            case SMITHING_NEW: {
                this.setupSmithing(top, bottom);
                break;
            }
            case CRAFTER: {
                this.delegate = new CrafterMenu(windowId, bottom);
            }
        }
        if (this.delegate != null) {
            this.l = this.delegate.l;
            this.i = this.delegate.i;
            this.o = this.delegate.o;
        }
        switch (this.cachedType) {
            case WORKBENCH: {
                this.delegate = new ContainerWorkbench(windowId, bottom);
                break;
            }
            case ANVIL: {
                this.delegate = new ContainerAnvil(windowId, bottom);
            }
        }
    }

    private void setupWorkbench(IInventory top, IInventory bottom) {
        int col;
        int row;
        this.a(new Slot(top, 0, 124, 35));
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 3; ++col) {
                this.a(new Slot(top, 1 + col + row * 3, 30 + col * 18, 17 + row * 18));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.a(new Slot(bottom, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.a(new Slot(bottom, col, 8 + col * 18, 142));
        }
    }

    private void setupAnvil(IInventory top, IInventory bottom) {
        int row;
        this.a(new Slot(top, 0, 27, 47));
        this.a(new Slot(top, 1, 76, 47));
        this.a(new Slot(top, 2, 134, 47));
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.a(new Slot(bottom, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (row = 0; row < 9; ++row) {
            this.a(new Slot(bottom, row, 8 + row * 18, 142));
        }
    }

    private void setupSmithing(IInventory top, IInventory bottom) {
        int row;
        this.a(new Slot(top, 0, 8, 48));
        this.a(new Slot(top, 1, 26, 48));
        this.a(new Slot(top, 2, 44, 48));
        this.a(new Slot(top, 3, 98, 48));
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.a(new Slot(bottom, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (row = 0; row < 9; ++row) {
            this.a(new Slot(bottom, row, 8 + row * 18, 142));
        }
    }

    private void setupStoneCutter(IInventory top, IInventory bottom) {
        int row;
        this.a(new Slot(top, 0, 20, 33));
        this.a(new Slot(top, 1, 143, 33));
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.a(new Slot(bottom, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (row = 0; row < 9; ++row) {
            this.a(new Slot(bottom, row, 8 + row * 18, 142));
        }
    }

    @Override
    public ItemStack b(EntityHuman entityhuman, int i2) {
        return this.delegate != null ? this.delegate.b(entityhuman, i2) : ItemStack.l;
    }

    @Override
    public boolean b(EntityHuman entity) {
        return true;
    }

    @Override
    public Containers<?> a() {
        return CraftContainer.getNotchInventoryType(this.view.getTopInventory());
    }
}

