/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.asm.rules.generate;

import io.papermc.asm.rules.RewriteRule;
import io.papermc.asm.rules.generate.GeneratedMethodHolder;
import io.papermc.asm.util.OpcodeUtils;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public interface GeneratedMethodSource<C>
extends GeneratedMethodHolder {
    public static final ClassDesc VOID = Void.TYPE.describeConstable().orElseThrow();

    public MethodTypeDesc transformInvokedDescriptor(MethodTypeDesc var1, C var2);

    default public void generateParameters(GeneratorAdapter methodGenerator, MethodTypeDesc descriptor, C context) {
        for (int i = 0; i < descriptor.parameterCount(); ++i) {
            methodGenerator.loadArg(i);
        }
    }

    @Override
    default public void generateConstructor(RewriteRule.GeneratorAdapterFactory factory, GeneratedMethodHolder.MethodCallData modified, GeneratedMethodHolder.ConstructorCallData original) {
        ClassDesc methodOwner = original.owner();
        C context = this.createNewContext();
        GeneratorAdapter methodGenerator = factory.create(4105, modified.name(), modified.descriptor().descriptorString());
        MethodTypeDesc transformedInvokedDescriptor = this.transformInvokedDescriptor(modified.descriptor(), context);
        Type type = Type.getType((String)methodOwner.descriptorString());
        methodGenerator.newInstance(type);
        methodGenerator.dup();
        this.generateParameters(methodGenerator, modified.descriptor(), context);
        methodGenerator.invokeConstructor(type, new Method("<init>", transformedInvokedDescriptor.changeReturnType(VOID).descriptorString()));
        this.generateReturnValue(methodGenerator, original);
        methodGenerator.endMethod();
    }

    @Override
    default public void generateMethod(RewriteRule.GeneratorAdapterFactory factory, GeneratedMethodHolder.MethodCallData modified, GeneratedMethodHolder.MethodCallData original) {
        ClassDesc methodOwner = original.owner();
        C context = this.createNewContext();
        GeneratorAdapter methodGenerator = factory.create(4105, modified.name(), modified.descriptor().descriptorString());
        MethodTypeDesc transformedInvokedDescriptor = this.transformInvokedDescriptor(modified.descriptor(), context);
        boolean isInterfaceCall = OpcodeUtils.isInterface(original.opcode(), original.isInvokeDynamic());
        if (OpcodeUtils.isVirtual(original.opcode(), original.isInvokeDynamic()) || isInterfaceCall) {
            transformedInvokedDescriptor = transformedInvokedDescriptor.dropParameterTypes(0, 1);
        }
        this.generateParameters(methodGenerator, modified.descriptor(), context);
        Method method = new Method(original.name(), transformedInvokedDescriptor.descriptorString());
        Type originalOwner = Type.getType((String)methodOwner.descriptorString());
        boolean isStaticCall = OpcodeUtils.isStatic(original.opcode(), original.isInvokeDynamic());
        if (isInterfaceCall) {
            methodGenerator.invokeInterface(originalOwner, method);
        } else if (!isStaticCall) {
            methodGenerator.invokeVirtual(originalOwner, method);
        } else {
            methodGenerator.invokeStatic(originalOwner, method);
        }
        this.generateReturnValue(methodGenerator, original);
        methodGenerator.endMethod();
    }

    default public void generateReturnValue(GeneratorAdapter methodGenerator, GeneratedMethodHolder.CallData insn) {
        methodGenerator.returnValue();
    }

    public C createNewContext();

    public static interface NoContext
    extends GeneratedMethodSource<Void> {
        @Override
        default public Void createNewContext() {
            return null;
        }
    }
}

