/*
 * Decompiled with CFR 0.152.
 */
package de.xtkq.voidgen;

import de.xtkq.voidgen.ChunkGenVersion;
import de.xtkq.voidgen.events.EventManager;
import de.xtkq.voidgen.generator.annotations.VoidChunkGenInfo;
import de.xtkq.voidgen.generator.instances.VoidChunkGen_1_15;
import de.xtkq.voidgen.generator.instances.VoidChunkGen_1_17;
import de.xtkq.voidgen.generator.instances.VoidChunkGen_1_17_1;
import de.xtkq.voidgen.generator.instances.VoidChunkGen_1_19;
import de.xtkq.voidgen.generator.instances.VoidChunkGen_1_21_3;
import de.xtkq.voidgen.generator.instances.VoidChunkGen_1_8_8;
import de.xtkq.voidgen.libs.folialib.FoliaLib;
import de.xtkq.voidgen.settings.ConfigManager;
import de.xtkq.voidgen.utils.MetricsUtils;
import de.xtkq.voidgen.utils.UpdateUtils;
import java.util.Arrays;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class VoidGen
extends JavaPlugin {
    private FoliaLib foliaLib;
    private ChunkGenVersion chunkGenVersion;
    private EventManager eventManager;

    public ChunkGenerator getDefaultWorldGenerator(@NotNull String worldName, String id) {
        return switch (this.chunkGenVersion) {
            case ChunkGenVersion.VERSION_1_8 -> {
                this.setEnabled(false);
                throw new UnsupportedOperationException("VoidGen is not supported anymore for versions bellow 1.15!");
            }
            case ChunkGenVersion.VERSION_1_15 -> new VoidChunkGen_1_15(this, id, worldName);
            case ChunkGenVersion.VERSION_1_17 -> new VoidChunkGen_1_17(this, id, worldName);
            case ChunkGenVersion.VERSION_1_17_1 -> new VoidChunkGen_1_17_1(this, id, worldName);
            case ChunkGenVersion.VERSION_1_19 -> new VoidChunkGen_1_19(this, id, worldName);
            default -> new VoidChunkGen_1_21_3(this, id, worldName);
        };
    }

    public void onEnable() {
        this.foliaLib = new FoliaLib((Plugin)this);
        this.chunkGenVersion = this.setupVoidChunkGen();
        this.getLogger().info("Using VoidChunkGen: " + this.chunkGenVersion.name());
        ConfigManager configManager = new ConfigManager(this);
        UpdateUtils updateUtils = new UpdateUtils(this);
        this.eventManager = new EventManager(this);
        if (configManager.getConfiguration().getCheckForUpdates()) {
            updateUtils.checkForUpdates();
            this.eventManager.initialize();
        }
        if (configManager.getConfiguration().getMetrics()) {
            new MetricsUtils((Plugin)this, 26816);
        }
    }

    public void onDisable() {
        this.foliaLib.getScheduler().cancelAllTasks();
        this.eventManager.terminate();
    }

    private ChunkGenVersion setupVoidChunkGen() {
        String bukkitVersion = Bukkit.getBukkitVersion().split("-")[0];
        VoidChunkGenInfo annotation = VoidChunkGen_1_8_8.class.getAnnotation(VoidChunkGenInfo.class);
        if (Arrays.asList(annotation.versions()).contains(bukkitVersion)) {
            return ChunkGenVersion.VERSION_1_8;
        }
        annotation = VoidChunkGen_1_15.class.getAnnotation(VoidChunkGenInfo.class);
        if (Arrays.asList(annotation.versions()).contains(bukkitVersion)) {
            return ChunkGenVersion.VERSION_1_15;
        }
        annotation = VoidChunkGen_1_17.class.getAnnotation(VoidChunkGenInfo.class);
        if (Arrays.asList(annotation.versions()).contains(bukkitVersion)) {
            return ChunkGenVersion.VERSION_1_17;
        }
        annotation = VoidChunkGen_1_17_1.class.getAnnotation(VoidChunkGenInfo.class);
        if (Arrays.asList(annotation.versions()).contains(bukkitVersion)) {
            return ChunkGenVersion.VERSION_1_17_1;
        }
        annotation = VoidChunkGen_1_19.class.getAnnotation(VoidChunkGenInfo.class);
        if (Arrays.asList(annotation.versions()).contains(bukkitVersion)) {
            return ChunkGenVersion.VERSION_1_19;
        }
        annotation = VoidChunkGen_1_21_3.class.getAnnotation(VoidChunkGenInfo.class);
        if (Arrays.asList(annotation.versions()).contains(bukkitVersion)) {
            return ChunkGenVersion.VERSION_1_21_3;
        }
        return ChunkGenVersion.VERSION_UNKNOWN;
    }

    @Generated
    public FoliaLib getFoliaLib() {
        return this.foliaLib;
    }
}

