/*
 * Decompiled with CFR 0.152.
 */
package me.uwpctf;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import me.uwpctf.GameProperties;
import me.uwpctf.Helpers;
import me.uwpctf.Players;
import me.uwpctf.Teams;
import me.uwpctf.YamlHandler;
import me.uwpctf.dbHandler;
import me.uwpctf.values;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class FlagLogic
implements Listener {
    private static final int captureDistance = 1;
    static YamlHandler yamlHandler = new YamlHandler();
    private static values val = yamlHandler.readYaml();
    static World gameWorld = Bukkit.getWorld((String)val.getGameWorld());
    static Location blue = new Location(gameWorld, (double)val.getBlueNetheriteX(), (double)val.getBlueNetheriteY(), (double)val.getBlueNetheriteZ());
    static Location red = new Location(gameWorld, (double)val.getRedNetheriteX(), (double)val.getRedNetheriteY(), (double)val.getRedNetheriteZ());
    private static final long BONUS_CAPTURE_SECONDS = 15L;
    private static final Map<String, Long> bonusCaptureStarts = new HashMap<String, Long>();
    private static final Map<String, BossBar> bonusTimerBars = new HashMap<String, BossBar>();

    public static void calculateCaptures() {
        for (Player p : Players.getPlayers()) {
            boolean cantCollectFlags;
            boolean bl = cantCollectFlags = p.isDead() || p.getGameMode() == GameMode.SPECTATOR;
            if (FlagLogic.playerCanStealThisFlag(p, "Red")) {
                FlagLogic.playerStoleRedFlagTasks(p);
            }
            if (FlagLogic.playerCanStealThisFlag(p, "Blue")) {
                FlagLogic.playerStoleBlueFlagTasks(p);
            }
            if (FlagLogic.playerCanRecoverThisFlag(p, "Red")) {
                FlagLogic.playerRecoveredRedFlagTasks(p);
            }
            if (FlagLogic.playerCanRecoverThisFlag(p, "Blue")) {
                FlagLogic.playerRecoveredBlueFlagTasks(p);
            }
            if (FlagLogic.playerCanCaptureThisFlag(p, "Red")) {
                FlagLogic.playerCapturedRedFlagTasks(p);
            }
            if (FlagLogic.playerCanCaptureThisFlag(p, "Blue")) {
                FlagLogic.playerCapturedBlueFlagTasks(p);
            }
            if (FlagLogic.playerCanCaptureThisFlag(p, "Bonus")) {
                FlagLogic.playerCapturedBonusFlagTasks(p);
            }
            if (GameProperties.getBonusFlagCarrier() != null) {
                BossBar b = bonusTimerBars.remove(p.getName());
                if (b != null) {
                    b.removePlayer(p);
                    b.setVisible(false);
                }
                bonusCaptureStarts.remove(p.getName());
                continue;
            }
            if (!Helpers.withinDistance(p.getLocation(), GameProperties.getBonusFlagCurrentLocation(), 1)) {
                bonusCaptureStarts.remove(p.getName());
                BossBar b = bonusTimerBars.remove(p.getName());
                if (b == null) continue;
                b.removePlayer(p);
                b.setVisible(false);
                continue;
            }
            long nowSeconds = System.currentTimeMillis() / 1000L;
            Long start = bonusCaptureStarts.get(p.getName());
            if (start == null && !cantCollectFlags) {
                bonusCaptureStarts.put(p.getName(), nowSeconds);
                BossBar bar = Bukkit.createBossBar((String)(String.valueOf(ChatColor.YELLOW) + "Stealing Bonus Flag: 15 seconds left"), (BarColor)BarColor.YELLOW, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
                bar.addPlayer(p);
                bar.setVisible(true);
                bonusTimerBars.put(p.getName(), bar);
                bar.setTitle(String.valueOf(ChatColor.YELLOW) + "Stealing Bonus Flag: 15s left");
                for (Player players : Players.getPlayers()) {
                    players.sendMessage(String.valueOf(net.md_5.bungee.api.ChatColor.YELLOW) + p.getName() + " is trying to steal the bonus flag!");
                }
                bar.setProgress(0.0);
                continue;
            }
            long elapsedSeconds = 0L;
            long remainingSeconds = 0L;
            try {
                Objects.requireNonNull(start);
                elapsedSeconds = nowSeconds - start;
                remainingSeconds = Math.max(0L, 15L - elapsedSeconds);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (elapsedSeconds >= 15L) {
                bonusCaptureStarts.remove(p.getName());
                BossBar bar = bonusTimerBars.remove(p.getName());
                if (bar != null) {
                    bar.removePlayer(p);
                    bar.setVisible(false);
                }
                FlagLogic.playerStoleBonusFlagTasks(p);
                continue;
            }
            double progress = Math.max(0.0, Math.min(1.0, (double)elapsedSeconds / 15.0));
            BossBar bar = bonusTimerBars.get(p.getName());
            if (bar == null) continue;
            bar.setProgress(progress);
            bar.setTitle(String.valueOf(ChatColor.YELLOW) + "Stealing Bonus Flag: " + remainingSeconds + "s left");
        }
    }

    public static void spawnBlueFlag(Location loc) {
        loc.getBlock().setType(Material.BLUE_BANNER);
    }

    public static void spawnRedFlag(Location loc) {
        loc.getBlock().setType(Material.RED_BANNER);
    }

    public static void removeBlueFlag(Location loc) {
        if (loc != null) {
            loc.getBlock().setType(Material.AIR);
        }
    }

    public static void removeRedFlag(Location loc) {
        if (loc != null) {
            loc.getBlock().setType(Material.AIR);
        }
    }

    public static void removeBonusFlag(Location loc) {
        if (loc == null || loc.getWorld() == null) {
            return;
        }
        if (Bukkit.isPrimaryThread()) {
            try {
                Chunk chunk = loc.getChunk();
                if (!chunk.isLoaded()) {
                    chunk.load(true);
                }
                loc.getBlock().setType(Material.AIR);
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.WARNING, "Failed to set block safely at " + String.valueOf(loc) + ": " + ex.getMessage(), ex);
            }
        }
    }

    private static boolean playerCanRecoverThisFlag(Player p, String team) {
        if (p.isDead() || p.getGameMode() == GameMode.SPECTATOR) {
            return false;
        }
        if (team.equalsIgnoreCase("Blue") && Teams.getTeam(p).equalsIgnoreCase("Blue") && GameProperties.blueFlagOnGround().booleanValue() && Helpers.withinDistance(p.getLocation(), GameProperties.blueFlagCurrentLocation(), 1) && !GameProperties.blueFlagLocationBase().equals((Object)GameProperties.blueFlagCurrentLocation())) {
            return true;
        }
        return team.equalsIgnoreCase("Red") && Teams.getTeam(p).equalsIgnoreCase("Red") && GameProperties.redFlagOnGround() != false && Helpers.withinDistance(p.getLocation(), GameProperties.redFlagCurrentLocation(), 1) && !GameProperties.redFlagLocationBase().equals((Object)GameProperties.redFlagCurrentLocation());
    }

    private static boolean playerCanStealThisFlag(Player p, String flag) {
        if (p.isDead() || p.getGameMode() == GameMode.SPECTATOR) {
            return false;
        }
        if (flag.equalsIgnoreCase("Blue") && Teams.getTeam(p).equalsIgnoreCase("Red") && GameProperties.blueFlagOnGround().booleanValue() && Helpers.withinDistance(p.getLocation(), GameProperties.blueFlagCurrentLocation(), 1)) {
            return true;
        }
        return flag.equalsIgnoreCase("Red") && Teams.getTeam(p).equalsIgnoreCase("Blue") && GameProperties.redFlagOnGround() != false && Helpers.withinDistance(p.getLocation(), GameProperties.redFlagCurrentLocation(), 1);
    }

    private static boolean playerCanCaptureThisFlag(Player p, String flag) {
        if (p.isDead() || p.getGameMode() == GameMode.SPECTATOR) {
            return false;
        }
        if (flag.equalsIgnoreCase("Blue") && Teams.getTeam(p).equalsIgnoreCase("Red") && p.equals((Object)GameProperties.blueFlagCarrier()) && Helpers.withinDistance(p.getLocation(), red, 1)) {
            GameProperties.setBlueFlagCarrier(null);
            return true;
        }
        if (flag.equalsIgnoreCase("Red") && Teams.getTeam(p).equalsIgnoreCase("Blue") && p.equals((Object)GameProperties.redFlagCarrier()) && Helpers.withinDistance(p.getLocation(), blue, 1)) {
            GameProperties.setRedFlagCarrier(null);
            return true;
        }
        if (flag.equalsIgnoreCase("Bonus")) {
            if (Teams.getTeam(p).equalsIgnoreCase("Blue") && p.equals((Object)GameProperties.getBonusFlagCarrier()) && Helpers.withinDistance(p.getLocation(), blue, 1)) {
                GameProperties.setBonusFlagCarrier(null);
                return true;
            }
            if (Teams.getTeam(p).equalsIgnoreCase("Red") && p.equals((Object)GameProperties.getBonusFlagCarrier()) && Helpers.withinDistance(p.getLocation(), red, 1)) {
                GameProperties.setBonusFlagCarrier(null);
                return true;
            }
        }
        return false;
    }

    private static void playerRecoveredRedFlagTasks(Player p) {
        FlagLogic.removeRedFlag(GameProperties.redFlagCurrentLocation());
        GameProperties.setRedFlagCurrentLocation(GameProperties.redFlagLocationBase());
        p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_XYLOPHONE, 1.0f, 1.0f);
        String playerWhoStole = p.getName();
        for (Player player : Players.getPlayers()) {
            if (Teams.red.getEntries().contains(p.getName())) {
                player.sendMessage(String.valueOf(net.md_5.bungee.api.ChatColor.GREEN) + playerWhoStole + " has recovered the flag!");
                continue;
            }
            if (!Teams.blue.getEntries().contains(p.getName())) continue;
            player.sendMessage(String.valueOf(net.md_5.bungee.api.ChatColor.RED) + playerWhoStole + " returned flag to red!");
        }
    }

    private static void playerRecoveredBlueFlagTasks(Player p) {
        FlagLogic.removeBlueFlag(GameProperties.blueFlagCurrentLocation());
        GameProperties.setBlueFlagCurrentLocation(GameProperties.blueFlagLocationBase());
        p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_XYLOPHONE, 1.0f, 1.0f);
        String playerWhoStole = p.getName();
        for (Player player : Players.getPlayers()) {
            if (Teams.blue.getEntries().contains(p.getName())) {
                player.sendMessage(String.valueOf(net.md_5.bungee.api.ChatColor.GREEN) + playerWhoStole + " has recovered the flag!");
                continue;
            }
            if (!Teams.red.getEntries().contains(p.getName())) continue;
            player.sendMessage(String.valueOf(net.md_5.bungee.api.ChatColor.RED) + playerWhoStole + " returned flag to blue!");
        }
    }

    private static void playerStoleRedFlagTasks(Player p) {
        FlagLogic.removeRedFlag(GameProperties.redFlagCurrentLocation());
        GameProperties.setRedFlagCarrier(p);
        GameProperties.setRedFlagCurrentLocation(null);
        GameProperties.setRedFlagOnGround(false);
        p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_XYLOPHONE, 1.0f, 1.0f);
        p.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, Integer.MAX_VALUE, 1));
        Teams.playAlarm("Red");
        String playerWhoStole = p.getName();
        for (Player player : Players.getPlayers()) {
            if (Teams.blue.getEntries().contains(player.getName())) {
                player.sendMessage(String.valueOf(net.md_5.bungee.api.ChatColor.GREEN) + playerWhoStole + " stole red team's flag!");
                continue;
            }
            if (!Teams.red.getEntries().contains(player.getName())) continue;
            player.sendMessage(String.valueOf(net.md_5.bungee.api.ChatColor.RED) + playerWhoStole + " stole your flag!");
        }
    }

    private static void playerStoleBonusFlagTasks(Player p) {
        FlagLogic.removeBonusFlag(GameProperties.getBonusFlagCurrentLocation());
        GameProperties.setBonusFlagCarrier(p);
        GameProperties.setBonusFlagCurrentLocation(null);
        GameProperties.setBonusFlagOnGround(false);
        p.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, Integer.MAX_VALUE, 1));
        p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_XYLOPHONE, 1.0f, 1.0f);
        String playerWhoStole = p.getName();
        p.getWorld().strikeLightning(p.getLocation());
        for (Player player : Players.getPlayers()) {
            player.sendMessage(String.valueOf(net.md_5.bungee.api.ChatColor.GOLD) + playerWhoStole + " stole bonus flag!");
        }
    }

    private static void playerStoleBlueFlagTasks(Player p) {
        FlagLogic.removeBlueFlag(GameProperties.blueFlagCurrentLocation());
        GameProperties.setBlueFlagCarrier(p);
        GameProperties.setBlueFlagCurrentLocation(null);
        GameProperties.setBlueFlagOnGround(false);
        p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_XYLOPHONE, 1.0f, 1.0f);
        p.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, Integer.MAX_VALUE, 1));
        Teams.playAlarm("Blue");
        String playerWhoStole = p.getName();
        for (Player player : Players.getPlayers()) {
            if (Teams.red.getEntries().contains(player.getName())) {
                player.sendMessage(String.valueOf(net.md_5.bungee.api.ChatColor.GREEN) + playerWhoStole + " stole blue team's flag!");
                continue;
            }
            if (!Teams.blue.getEntries().contains(player.getName())) continue;
            player.sendMessage(String.valueOf(net.md_5.bungee.api.ChatColor.RED) + playerWhoStole + " stole your flag!");
        }
    }

    private static void playerCapturedRedFlagTasks(Player p) {
        GameProperties.setRedFlagCarrier(null);
        GameProperties.setBlueTeamScore(GameProperties.blueTeamScore() + 1);
        Teams.playVictory("Blue");
        p.removePotionEffect(PotionEffectType.GLOWING);
        String playerWhoStole = p.getName();
        for (Player player : Players.getPlayers()) {
            if (Teams.blue.getEntries().contains(player.getName())) {
                player.sendMessage(String.valueOf(net.md_5.bungee.api.ChatColor.GREEN) + playerWhoStole + " captured red team's flag!");
                continue;
            }
            if (!Teams.red.getEntries().contains(player.getName())) continue;
            player.sendMessage(String.valueOf(net.md_5.bungee.api.ChatColor.RED) + playerWhoStole + " captured your flag!");
        }
        World gameWorld = Bukkit.getWorld((String)val.getGameWorld());
        dbHandler dbHandler2 = new dbHandler();
        if (GameProperties.redFlagOnGround().booleanValue()) {
            FlagLogic.removeRedFlag(GameProperties.redFlagCurrentLocation());
        }
        if (GameProperties.blueFlagOnGround().booleanValue()) {
            FlagLogic.removeBlueFlag(GameProperties.blueFlagCurrentLocation());
        }
        double[] redCoordinates = dbHandler2.get_random_red();
        double[] blueCoordinates = dbHandler2.get_random_blue();
        if (GameProperties.blueFlagOnGround().booleanValue()) {
            GameProperties.setBlueFlagLocationBase(new Location(gameWorld, blueCoordinates[0], blueCoordinates[1], blueCoordinates[2]));
            GameProperties.setBlueFlagCurrentLocation(GameProperties.blueFlagLocationBase());
            GameProperties.setBlueFlagOnGround(true);
        }
        GameProperties.setRedFlagLocationBase(new Location(gameWorld, redCoordinates[0], redCoordinates[1], redCoordinates[2]));
        GameProperties.setRedFlagCurrentLocation(GameProperties.redFlagLocationBase());
        GameProperties.setRedFlagOnGround(true);
    }

    private static void playerCapturedBlueFlagTasks(Player p) {
        GameProperties.setBlueFlagCarrier(null);
        GameProperties.setRedTeamScore(GameProperties.redTeamScore() + 1);
        Teams.playVictory("Red");
        p.removePotionEffect(PotionEffectType.GLOWING);
        String playerWhoStole = p.getName();
        for (Player player : Players.getPlayers()) {
            if (Teams.red.getEntries().contains(player.getName())) {
                player.sendMessage(String.valueOf(net.md_5.bungee.api.ChatColor.GREEN) + playerWhoStole + " captured blue team's flag!");
                continue;
            }
            if (!Teams.blue.getEntries().contains(player.getName())) continue;
            player.sendMessage(String.valueOf(net.md_5.bungee.api.ChatColor.RED) + playerWhoStole + " captured your flag!");
        }
        World gameWorld = Bukkit.getWorld((String)val.getGameWorld());
        dbHandler dbHandler2 = new dbHandler();
        if (GameProperties.redFlagOnGround().booleanValue()) {
            FlagLogic.removeRedFlag(GameProperties.redFlagCurrentLocation());
        }
        if (GameProperties.blueFlagOnGround().booleanValue()) {
            FlagLogic.removeBlueFlag(GameProperties.blueFlagCurrentLocation());
        }
        double[] redCoordinates = dbHandler2.get_random_red();
        double[] blueCoordinates = dbHandler2.get_random_blue();
        if (GameProperties.redFlagOnGround().booleanValue()) {
            GameProperties.setRedFlagLocationBase(new Location(gameWorld, redCoordinates[0], redCoordinates[1], redCoordinates[2]));
            GameProperties.setRedFlagCurrentLocation(GameProperties.redFlagLocationBase());
            GameProperties.setRedFlagOnGround(true);
        }
        GameProperties.setBlueFlagLocationBase(new Location(gameWorld, blueCoordinates[0], blueCoordinates[1], blueCoordinates[2]));
        GameProperties.setBlueFlagCurrentLocation(GameProperties.blueFlagLocationBase());
        GameProperties.setBlueFlagOnGround(true);
    }

    private static void playerCapturedBonusFlagTasks(Player p) {
        GameProperties.setBonusFlagCarrier(null);
        String playerWhoStole = p.getName();
        dbHandler d = new dbHandler();
        if (Teams.getTeam(p).equalsIgnoreCase("Blue")) {
            GameProperties.setBlueTeamScore(GameProperties.blueTeamScore() + 2);
            p.removePotionEffect(PotionEffectType.GLOWING);
            Teams.playVictory("Blue");
            for (Player player : Players.getPlayers()) {
                if (Teams.blue.getEntries().contains(player.getName())) {
                    player.sendMessage(String.valueOf(net.md_5.bungee.api.ChatColor.GREEN) + playerWhoStole + " captured bonus flag!");
                    continue;
                }
                if (!Teams.red.getEntries().contains(player.getName())) continue;
                player.sendMessage(String.valueOf(net.md_5.bungee.api.ChatColor.RED) + playerWhoStole + " captured bonus flag!");
            }
        }
        if (Teams.getTeam(p).equalsIgnoreCase("Red")) {
            GameProperties.setRedTeamScore(GameProperties.redTeamScore() + 2);
            p.removePotionEffect(PotionEffectType.GLOWING);
            Teams.playVictory("Red");
            for (Player player : Players.getPlayers()) {
                if (Teams.red.getEntries().contains(player.getName())) {
                    player.sendMessage(String.valueOf(net.md_5.bungee.api.ChatColor.GREEN) + playerWhoStole + " captured bonus flag!");
                    continue;
                }
                if (!Teams.blue.getEntries().contains(player.getName())) continue;
                player.sendMessage(String.valueOf(net.md_5.bungee.api.ChatColor.RED) + playerWhoStole + " captured bonus flag!");
            }
        }
        if (GameProperties.getBonusFlagOnGround().booleanValue()) {
            FlagLogic.removeBonusFlag(GameProperties.getBonusFlagCurrentLocation());
        }
        double[] bonus = d.get_bonus_flag();
        Location loc = new Location(gameWorld, bonus[0], bonus[1], bonus[2]);
        GameProperties.setBonusFlagCurrentLocation(loc);
        GameProperties.setBonusFlagOnGround(true);
        if (loc.getWorld() != null) {
            Chunk chunk = loc.getChunk();
            if (!chunk.isLoaded()) {
                chunk.load(true);
            }
            loc.getBlock().setType(Material.ORANGE_BANNER);
        }
    }
}

