/*
 * Decompiled with CFR 0.152.
 */
package me.uwpctf;

import java.util.ArrayList;
import me.uwpctf.FlagLogic;
import me.uwpctf.GameProperties;
import me.uwpctf.InventoryPages.KitSelectorPage;
import me.uwpctf.Players;
import me.uwpctf.Powerups.PowerupManager;
import me.uwpctf.Powerups.PowerupRunnable;
import me.uwpctf.ResetWorld;
import me.uwpctf.Runnable;
import me.uwpctf.Teams;
import me.uwpctf.UwpCTF;
import me.uwpctf.YamlHandler;
import me.uwpctf.dbHandler;
import me.uwpctf.preGameQueue;
import me.uwpctf.values;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class GameManager
extends JavaPlugin {
    static YamlHandler yamlHandler = new YamlHandler();
    static values val = yamlHandler.readYaml();

    public static void startGame() {
        GameProperties.setBlueFlagOnGround(true);
        GameProperties.setRedFlagOnGround(true);
        GameProperties.setBonusFlagOnGround(true);
        GameProperties.setBlueFlagCurrentLocation(GameProperties.blueFlagLocationBase());
        GameProperties.setRedFlagCurrentLocation(GameProperties.redFlagLocationBase());
        dbHandler d = new dbHandler();
        double[] coords = d.get_bonus_flag();
        Location loc = new Location(Bukkit.getWorld((String)val.getGameWorld()), coords[0], coords[1], coords[2]);
        GameProperties.setBonusFlagCurrentLocation(loc);
        loc.getBlock().setType(Material.ORANGE_BANNER);
        World gameWorld = Bukkit.getWorld((String)val.getGameWorld());
        for (Player p : Players.getPlayers()) {
            p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_COW_BELL, 1.0f, 1.0f);
            p.setHealth(20.0);
            p.setFoodLevel(20);
            if (Teams.getTeam(p).equals("Red")) {
                p.teleport(new Location(gameWorld, (double)val.getRedTeamSpawnX(), (double)val.getRedTeamSpawnY(), (double)val.getRedTeamSpawnZ()));
            } else if (Teams.getTeam(p).equals("Blue")) {
                p.teleport(new Location(gameWorld, (double)val.getBlueTeamSpawnX(), (double)val.getBlueTeamSpawnY(), (double)val.getBlueTeamSpawnZ()));
            }
            KitSelectorPage k = new KitSelectorPage();
            k.SelectKit(p);
        }
        GameProperties.setMainGameRunning(true);
        GameProperties.setMinutesUntilGameEnd(GameProperties.gameTimer());
        PowerupRunnable.StartSpawnCycle();
        PowerupRunnable.StartPowerupRotationTask();
        PowerupRunnable.PowerupListener();
        Runnable.gameTimer(0, GameProperties.gameTimer());
    }

    public static void pauseGame() {
        GameProperties.setGamePaused(true);
        Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.GREEN) + "Game Paused"));
    }

    public static void resumeGame() {
        GameProperties.setGamePaused(false);
        Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.GREEN) + "Game Resumed"));
    }

    public static void endGame() {
        for (Player p : Players.getPlayers()) {
            p.removePotionEffect(PotionEffectType.GLOWING);
        }
        GameProperties.setBlueFlagCarrier(null);
        GameProperties.setRedFlagCarrier(null);
        FlagLogic.removeBlueFlag(GameProperties.blueFlagCurrentLocation());
        FlagLogic.removeRedFlag(GameProperties.redFlagCurrentLocation());
        GameProperties.setRedFlagCurrentLocation(null);
        GameProperties.setBlueFlagCurrentLocation(null);
        GameProperties.setRedFlagOnGround(false);
        GameProperties.setBlueFlagOnGround(false);
        GameProperties.setMainGameRunning(false);
        GameProperties.setGamePaused(false);
        if (GameProperties.blueTeamScore() > GameProperties.redTeamScore()) {
            for (Player p : Players.getPlayers()) {
                p.sendMessage(String.valueOf(ChatColor.BLUE) + "Blue" + String.valueOf(ChatColor.GREEN) + " Team Wins!");
                p.setGameMode(GameMode.SPECTATOR);
            }
        } else if (GameProperties.redTeamScore() > GameProperties.blueTeamScore()) {
            for (Player p : Players.getPlayers()) {
                p.sendMessage(String.valueOf(ChatColor.RED) + "Red" + String.valueOf(ChatColor.GREEN) + " Team Wins!");
                p.setGameMode(GameMode.SPECTATOR);
            }
        } else {
            for (Player p : Players.getPlayers()) {
                p.sendMessage(String.valueOf(ChatColor.GREEN) + "Tie Game!");
                p.setGameMode(GameMode.SPECTATOR);
            }
        }
        for (Player p : Players.getPlayers()) {
            p.getInventory().clear();
            KitSelectorPage.kitsSelected.add(p);
            p.closeInventory();
            KitSelectorPage.kitsSelected.remove(p);
        }
        preGameQueue.ResetGameRunning();
        preGameQueue.resetStartUpState();
        PowerupManager.resetValues();
        GameManager.GameCleanup();
    }

    public static void GameCleanup() {
        new BukkitRunnable(){

            public void run() {
                YamlHandler yamlHandler = new YamlHandler();
                values val2 = yamlHandler.readYaml();
                World spawnWorld = Bukkit.getWorld((String)val2.getSpawnWorld());
                KitSelectorPage.resetKitsSelected();
                ArrayList<Player> playersCopy = new ArrayList<Player>(Players.getPlayers());
                for (Player p : playersCopy) {
                    if (p == null || !p.isOnline()) continue;
                    p.teleport(new Location(spawnWorld, (double)val2.getSpawnLocX(), (double)val2.getSpawnLocY(), (double)val2.getSpawnLocZ()));
                }
                Players.getPlayers().clear();
                Teams.hideAllScoreBoard();
                ResetWorld.reloadWorld();
            }
        }.runTaskLater((Plugin)UwpCTF.getInstance(), 200L);
    }
}

