/*
 * Decompiled with CFR 0.152.
 */
package me.uwpctf;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Objects;
import me.uwpctf.UwpCTF;
import me.uwpctf.YamlHandler;
import me.uwpctf.values;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ResetWorld
implements Listener {
    public static void reloadWorld() {
        YamlHandler yamlHandler = new YamlHandler();
        final values val2 = yamlHandler.readYaml();
        World gameWorld = Bukkit.getWorld((String)val2.getGameWorld());
        File backupFolder = new File(UwpCTF.getInstance().getDataFolder(), "backups/" + val2.getGameWorld());
        if (backupFolder.exists()) {
            if (gameWorld != null) {
                Bukkit.getLogger().info("Unloading world: " + val2.getGameWorld());
                Bukkit.unloadWorld((World)gameWorld, (boolean)false);
            } else {
                Bukkit.getLogger().warning("World not found: " + val2.getGameWorld());
            }
            File worldFolder = new File(Bukkit.getServer().getWorldContainer(), val2.getGameWorld());
            if (worldFolder.exists()) {
                ResetWorld.deleteWorld(worldFolder);
            } else {
                Bukkit.getLogger().warning("World folder does not exist: " + worldFolder.getAbsolutePath());
            }
            ResetWorld.copyWorld(backupFolder, worldFolder);
            new BukkitRunnable(){

                public void run() {
                    if (Bukkit.getWorld((String)val2.getGameWorld()) == null) {
                        WorldCreator creator = new WorldCreator(val2.getGameWorld());
                        creator.environment(World.Environment.NORMAL);
                        World newWorld = Bukkit.createWorld((WorldCreator)creator);
                        if (newWorld != null) {
                            Bukkit.getLogger().info("World created successfully: " + newWorld.getName());
                        } else {
                            Bukkit.getLogger().warning("Failed to create world: " + val2.getGameWorld());
                        }
                    }
                }
            }.runTaskLater((Plugin)UwpCTF.getInstance(), 1L);
        }
    }

    private static void copyWorld(File source, File destination) {
        try {
            if (!destination.exists()) {
                destination.mkdirs();
            }
            if (source.isDirectory()) {
                for (File file : Objects.requireNonNull(source.listFiles())) {
                    ResetWorld.copyWorld(file, new File(destination, file.getName()));
                }
            } else {
                Files.copy(source.toPath(), destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void deleteWorld(File worldFolder) {
        if (worldFolder.isDirectory()) {
            File[] files = worldFolder.listFiles();
            if (files != null) {
                for (File file : files) {
                    ResetWorld.deleteWorld(file);
                }
            } else {
                Bukkit.getLogger().warning("Could not list files in directory: " + worldFolder.getAbsolutePath());
            }
        }
        if (worldFolder.delete()) {
            Bukkit.getLogger().info("Deleted: " + worldFolder.getAbsolutePath());
        } else {
            Bukkit.getLogger().severe("Failed to delete: " + worldFolder.getAbsolutePath());
        }
    }
}

