/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.command.context.issueraware;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.bukkit.entity.Player;
import org.mvplugins.multiverse.core.command.context.issueraware.IssuerAwareValue;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.external.acf.commands.BukkitCommandExecutionContext;
import org.mvplugins.multiverse.external.acf.commands.BukkitCommandIssuer;
import org.mvplugins.multiverse.external.acf.commands.InvalidCommandArgument;
import org.mvplugins.multiverse.external.acf.commands.contexts.IssuerAwareContextResolver;
import org.mvplugins.multiverse.external.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="5.1")
public final class IssuerAwareContextBuilder<T> {
    private BiFunction<BukkitCommandExecutionContext, Player, T> fromPlayer;
    private BiFunction<BukkitCommandExecutionContext, String, T> fromInput;
    private Function<BukkitCommandExecutionContext, Message> issuerOnlyFailMessage = context -> Message.of("This command can only be used by a player.", new MessageReplacement[0]);
    private BiFunction<BukkitCommandExecutionContext, Player, Message> issuerAwarePlayerFailMessage = (context, player) -> Message.of("Unable to resolve context for player '" + player.getName() + "'.", new MessageReplacement[0]);
    private BiFunction<BukkitCommandExecutionContext, String, Message> issuerAwareInputFailMessage = (context, input) -> Message.of("Unable to resolve context for input '" + input + "'.", new MessageReplacement[0]);
    private BiFunction<BukkitCommandExecutionContext, String, Message> inputOnlyFailMessage = (context, input) -> Message.of("Unable to resolve context for input '" + input + "'.", new MessageReplacement[0]);

    @ApiStatus.AvailableSince(value="5.1")
    public IssuerAwareContextBuilder<T> fromPlayer(BiFunction<BukkitCommandExecutionContext, Player, T> fromInput) {
        this.fromPlayer = fromInput;
        return this;
    }

    @ApiStatus.AvailableSince(value="5.1")
    public IssuerAwareContextBuilder<T> fromInput(BiFunction<BukkitCommandExecutionContext, String, T> fromInput) {
        this.fromInput = fromInput;
        return this;
    }

    @ApiStatus.AvailableSince(value="5.1")
    public IssuerAwareContextBuilder<T> issuerOnlyFailMessage(Function<BukkitCommandExecutionContext, Message> issuerOnlyFailMessage) {
        this.issuerOnlyFailMessage = issuerOnlyFailMessage;
        return this;
    }

    @ApiStatus.AvailableSince(value="5.1")
    public IssuerAwareContextBuilder<T> issuerAwarePlayerFailMessage(BiFunction<BukkitCommandExecutionContext, Player, Message> issuerAwarePlayerFailMessage) {
        this.issuerAwarePlayerFailMessage = issuerAwarePlayerFailMessage;
        return this;
    }

    @ApiStatus.AvailableSince(value="5.1")
    public IssuerAwareContextBuilder<T> issuerAwareInputFailMessage(BiFunction<BukkitCommandExecutionContext, String, Message> issuerAwareInputFailMessage) {
        this.issuerAwareInputFailMessage = issuerAwareInputFailMessage;
        return this;
    }

    @ApiStatus.AvailableSince(value="5.1")
    public IssuerAwareContextBuilder<T> inputOnlyFailMessage(BiFunction<BukkitCommandExecutionContext, String, Message> inputOnlyFailMessage) {
        this.inputOnlyFailMessage = inputOnlyFailMessage;
        return this;
    }

    @ApiStatus.AvailableSince(value="5.1")
    public IssuerAwareContextResolver<T, BukkitCommandExecutionContext> generateContext() {
        Objects.requireNonNull(this.fromPlayer);
        Objects.requireNonNull(this.fromInput);
        Objects.requireNonNull(this.issuerOnlyFailMessage);
        Objects.requireNonNull(this.issuerAwarePlayerFailMessage);
        Objects.requireNonNull(this.issuerAwareInputFailMessage);
        Objects.requireNonNull(this.inputOnlyFailMessage);
        return context -> {
            BukkitCommandIssuer issuer = (BukkitCommandIssuer)context.getIssuer();
            String resolve = context.getFlagValue("resolve", "");
            if (resolve.equals("issuerOnly")) {
                T result;
                if (issuer.isPlayer() && (result = this.fromPlayer.apply((BukkitCommandExecutionContext)context, issuer.getPlayer())) != null) {
                    return result;
                }
                throw new InvalidCommandArgument(this.issuerOnlyFailMessage.apply((BukkitCommandExecutionContext)context).formatted(issuer));
            }
            String input = context.getFirstArg();
            T result = this.fromInput.apply((BukkitCommandExecutionContext)context, input);
            if (result != null) {
                context.popFirstArg();
                return result;
            }
            if (resolve.equals("issuerAware")) {
                if (issuer.isPlayer()) {
                    Player player = issuer.getPlayer();
                    result = this.fromPlayer.apply((BukkitCommandExecutionContext)context, player);
                    if (result != null) {
                        return result;
                    }
                    throw new InvalidCommandArgument(this.issuerAwarePlayerFailMessage.apply((BukkitCommandExecutionContext)context, player).formatted(issuer));
                }
                throw new InvalidCommandArgument(this.issuerAwareInputFailMessage.apply((BukkitCommandExecutionContext)context, input).formatted(issuer));
            }
            throw new InvalidCommandArgument(this.inputOnlyFailMessage.apply((BukkitCommandExecutionContext)context, input).formatted(issuer));
        };
    }

    @ApiStatus.AvailableSince(value="5.1")
    public <I extends IssuerAwareValue> IssuerAwareContextResolver<I, BukkitCommandExecutionContext> generateContext(BiFunction<Boolean, T, I> createValue) {
        Objects.requireNonNull(this.fromPlayer);
        Objects.requireNonNull(this.fromInput);
        Objects.requireNonNull(this.issuerOnlyFailMessage);
        Objects.requireNonNull(this.issuerAwarePlayerFailMessage);
        Objects.requireNonNull(this.issuerAwareInputFailMessage);
        Objects.requireNonNull(this.inputOnlyFailMessage);
        return context -> {
            BukkitCommandIssuer issuer = (BukkitCommandIssuer)context.getIssuer();
            String resolve = context.getFlagValue("resolve", "");
            if (resolve.equals("issuerOnly")) {
                T result;
                if (issuer.isPlayer() && (result = this.fromPlayer.apply((BukkitCommandExecutionContext)context, issuer.getPlayer())) != null) {
                    return (IssuerAwareValue)createValue.apply(true, result);
                }
                throw new InvalidCommandArgument(this.issuerOnlyFailMessage.apply((BukkitCommandExecutionContext)context).formatted(issuer));
            }
            String input = context.getFirstArg();
            T result = this.fromInput.apply((BukkitCommandExecutionContext)context, input);
            if (result != null) {
                context.popFirstArg();
                return (IssuerAwareValue)createValue.apply(false, result);
            }
            if (resolve.equals("issuerAware")) {
                if (issuer.isPlayer()) {
                    Player player = issuer.getPlayer();
                    result = this.fromPlayer.apply((BukkitCommandExecutionContext)context, player);
                    if (result != null) {
                        return (IssuerAwareValue)createValue.apply(true, result);
                    }
                    throw new InvalidCommandArgument(this.issuerAwarePlayerFailMessage.apply((BukkitCommandExecutionContext)context, player).formatted(issuer));
                }
                throw new InvalidCommandArgument(this.issuerAwareInputFailMessage.apply((BukkitCommandExecutionContext)context, input).formatted(issuer));
            }
            throw new InvalidCommandArgument(this.inputOnlyFailMessage.apply((BukkitCommandExecutionContext)context, input).formatted(issuer));
        };
    }
}

