/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.commands;

import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.command.flag.CommandFlag;
import org.mvplugins.multiverse.core.command.flag.CommandFlagsManager;
import org.mvplugins.multiverse.core.command.flag.ParsedCommandFlags;
import org.mvplugins.multiverse.core.command.flags.RemovePlayerFlags;
import org.mvplugins.multiverse.core.commands.CoreCommand;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.utils.result.AsyncAttemptsAggregate;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.core.world.helpers.PlayerWorldTeleporter;
import org.mvplugins.multiverse.core.world.options.RemoveWorldOptions;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Optional;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
class RemoveCommand
extends CoreCommand {
    private final WorldManager worldManager;
    private final PlayerWorldTeleporter playerWorldTeleporter;
    private final Flags flags;

    @Inject
    RemoveCommand(@NotNull WorldManager worldManager, @NotNull PlayerWorldTeleporter playerWorldTeleporter, @NotNull Flags flags) {
        this.worldManager = worldManager;
        this.playerWorldTeleporter = playerWorldTeleporter;
        this.flags = flags;
    }

    @Subcommand(value="remove")
    @CommandPermission(value="multiverse.core.remove")
    @CommandCompletion(value="@mvworlds:scope=both @flags:groupName=mvremove")
    @Syntax(value="<world>")
    @Description(value="{@@mv-core.remove.description}")
    void onRemoveCommand(MVCommandIssuer issuer, @Syntax(value="<world>") @Description(value="{@@mv-core.remove.world.description}") MultiverseWorld world, @Optional @Syntax(value="[--remove-players]") @Description(value="") String[] flagArray) {
        ParsedCommandFlags parsedFlags = this.flags.parse(flagArray);
        AsyncAttemptsAggregate future = parsedFlags.hasFlag(this.flags.removePlayers) ? this.worldManager.getLoadedWorld(world).map(this.playerWorldTeleporter::removeFromWorld).getOrElse(AsyncAttemptsAggregate::emptySuccess) : AsyncAttemptsAggregate.emptySuccess();
        future.onSuccess(() -> this.doWorldRemoving(issuer, world, parsedFlags)).onFailure(() -> issuer.sendError("Failed to teleport one or more players out of the world!", new MessageReplacement[0]));
    }

    private void doWorldRemoving(MVCommandIssuer issuer, MultiverseWorld world, ParsedCommandFlags parsedFlags) {
        this.worldManager.removeWorld(RemoveWorldOptions.world(world).saveBukkitWorld(!parsedFlags.hasFlag(this.flags.noSave)).unloadBukkitWorld(!parsedFlags.hasFlag(this.flags.noUnloadBukkitWorld))).onSuccess(removedWorldName -> {
            CoreLogging.fine("World remove success: " + removedWorldName, new Object[0]);
            issuer.sendInfo((MessageKeyProvider)MVCorei18n.REMOVE_SUCCESS, MessageReplacement.Replace.WORLD.with(removedWorldName));
        }).onFailure(failure -> {
            CoreLogging.fine("World remove failure: " + String.valueOf(failure), new Object[0]);
            issuer.sendError(failure.getFailureMessage());
        });
    }

    @Service
    private static final class Flags
    extends RemovePlayerFlags {
        private static final String NAME = "mvremove";
        private final CommandFlag noUnloadBukkitWorld = this.flag(((CommandFlag.Builder)CommandFlag.builder("--no-unload-bukkit-world").addAlias("-b")).build());
        private final CommandFlag noSave = this.flag(((CommandFlag.Builder)CommandFlag.builder("--no-save").addAlias("-n")).build());

        @Inject
        private Flags(@NotNull CommandFlagsManager flagsManager) {
            super(NAME, flagsManager);
        }
    }

    @Service
    private static final class LegacyAlias
    extends RemoveCommand
    implements LegacyAliasCommand {
        @Inject
        LegacyAlias(@NotNull WorldManager worldManager, @NotNull PlayerWorldTeleporter playerWorldTeleporter, @NotNull Flags flags) {
            super(worldManager, playerWorldTeleporter, flags);
        }

        @Override
        @CommandAlias(value="mvremove")
        void onRemoveCommand(MVCommandIssuer issuer, MultiverseWorld world, String[] flags) {
            super.onRemoveCommand(issuer, world, flags);
        }
    }
}

