/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.config.migration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.mvplugins.multiverse.core.config.migration.VersionMigrator;
import org.mvplugins.multiverse.core.config.node.ValueNode;
import org.mvplugins.multiverse.core.utils.CoreLogging;

public class ConfigMigrator {
    private final ValueNode<Double> versionNode;
    private final List<VersionMigrator> versionMigrators;

    public static Builder builder(ValueNode<Double> versionNode) {
        return new Builder(versionNode);
    }

    protected ConfigMigrator(ValueNode<Double> versionNode, List<VersionMigrator> versionMigrators) {
        this.versionNode = versionNode;
        this.versionMigrators = versionMigrators;
    }

    public void migrate(ConfigurationSection config) {
        if (config.getKeys(false).isEmpty()) {
            config.set(this.versionNode.getPath(), (Object)this.getLatestVersion());
            return;
        }
        for (VersionMigrator versionMigrator : this.versionMigrators) {
            double versionNumber = config.getDouble(this.versionNode.getPath());
            if (!(versionNumber < versionMigrator.getVersion())) continue;
            CoreLogging.info("Migrating config from version %s to %s...", versionNumber, versionMigrator.getVersion());
            versionMigrator.migrate(config);
            config.set(this.versionNode.getPath(), (Object)versionMigrator.getVersion());
        }
    }

    private double getLatestVersion() {
        if (this.versionMigrators.isEmpty()) {
            return 0.0;
        }
        return this.versionMigrators.get(this.versionMigrators.size() - 1).getVersion();
    }

    public static class Builder {
        private final ValueNode<Double> versionNode;
        private final List<VersionMigrator> versionMigrators;

        public Builder(ValueNode<Double> versionNode) {
            this.versionNode = versionNode;
            this.versionMigrators = new ArrayList<VersionMigrator>();
        }

        public Builder addVersionMigrator(VersionMigrator versionMigrator) {
            this.versionMigrators.add(versionMigrator);
            return this;
        }

        public ConfigMigrator build() {
            Collections.sort(this.versionMigrators);
            return new ConfigMigrator(this.versionNode, this.versionMigrators);
        }
    }
}

