/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.converters.poi;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import java.util.function.Predicate;

public final class ConverterPoiDelete
extends DataConverter<MapType<String>, MapType<String>> {
    private final Predicate<String> delete;

    public ConverterPoiDelete(int toVersion, Predicate<String> delete) {
        super(toVersion);
        this.delete = delete;
    }

    public ConverterPoiDelete(int toVersion, int versionStep, Predicate<String> delete) {
        super(toVersion, versionStep);
        this.delete = delete;
    }

    @Override
    public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
        MapType sections = data.getMap("Sections");
        if (sections == null) {
            return null;
        }
        for (String key : sections.keys()) {
            MapType section = sections.getMap(key);
            ListType records = section.getList("Records", ObjectType.MAP);
            if (records == null) continue;
            int i = 0;
            while (i < records.size()) {
                MapType record = records.getMap(i);
                String type = record.getString("type");
                if (type != null && this.delete.test(type)) {
                    records.remove(i);
                    continue;
                }
                ++i;
            }
        }
        return null;
    }
}

