/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system.io.datacontroller;

import ca.spottedleaf.moonrise.patches.chunk_system.io.RegionFileIOThread;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.RegionFileStorage;

public final class ChunkDataController
extends RegionFileIOThread.ChunkDataController {
    private final ServerLevel world;

    public ChunkDataController(ServerLevel world) {
        super(RegionFileIOThread.RegionFileType.CHUNK_DATA);
        this.world = world;
    }

    @Override
    public RegionFileStorage getCache() {
        return this.world.getChunkSource().chunkMap.moonrise$getRegionStorage();
    }

    @Override
    public void writeData(int chunkX, int chunkZ, CompoundTag compound) throws IOException {
        CompletableFuture<Void> future = this.world.getChunkSource().chunkMap.write(new ChunkPos(chunkX, chunkZ), compound);
        try {
            if (future != null) {
                future.join();
            }
        }
        catch (CompletionException ex) {
            Throwable throwable = ex.getCause();
            if (throwable instanceof IOException) {
                IOException ioException = (IOException)throwable;
                throw ioException;
            }
            throw ex;
        }
    }

    @Override
    public CompoundTag readData(int chunkX, int chunkZ) throws IOException {
        try {
            return this.world.getChunkSource().chunkMap.read(new ChunkPos(chunkX, chunkZ)).join().orElse(null);
        }
        catch (CompletionException ex) {
            Throwable throwable = ex.getCause();
            if (throwable instanceof IOException) {
                IOException ioException = (IOException)throwable;
                throw ioException;
            }
            throw ex;
        }
    }
}

