/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.network;

import com.destroystokyo.paper.network.NetworkClient;
import java.net.InetSocketAddress;
import javax.annotation.Nullable;
import net.minecraft.network.Connection;

public class PaperNetworkClient
implements NetworkClient {
    private final Connection networkManager;

    PaperNetworkClient(Connection networkManager) {
        this.networkManager = networkManager;
    }

    public InetSocketAddress getAddress() {
        return (InetSocketAddress)this.networkManager.getRemoteAddress();
    }

    public int getProtocolVersion() {
        return this.networkManager.protocolVersion;
    }

    @Nullable
    public InetSocketAddress getVirtualHost() {
        return this.networkManager.virtualHost;
    }

    public static InetSocketAddress prepareVirtualHost(String host, int port) {
        int len = host.length();
        int pos = host.indexOf(0);
        if (pos >= 0) {
            len = pos;
        }
        if (len > 0 && host.charAt(len - 1) == '.') {
            --len;
        }
        return InetSocketAddress.createUnresolved(host.substring(0, len), port);
    }
}

