/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.profile;

import com.destroystokyo.paper.event.profile.FillProfileEvent;
import com.destroystokyo.paper.event.profile.PreFillProfileEvent;
import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.mojang.authlib.Environment;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.authlib.yggdrasil.ServicesKeySet;
import com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService;
import io.papermc.paper.annotation.DoNotUse;
import java.net.Proxy;
import java.util.Collections;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class PaperMinecraftSessionService
extends YggdrasilMinecraftSessionService {
    protected PaperMinecraftSessionService(ServicesKeySet servicesKeySet, Proxy proxy, Environment environment) {
        super(servicesKeySet, proxy, environment);
    }

    @Nullable
    public ProfileResult fetchProfile(GameProfile profile, boolean requireSecure) {
        CraftPlayerProfile playerProfile = (CraftPlayerProfile)CraftPlayerProfile.asBukkitMirror(profile);
        new PreFillProfileEvent((PlayerProfile)playerProfile).callEvent();
        profile = playerProfile.getGameProfile();
        if (profile.getProperties().containsKey((Object)"textures")) {
            return new ProfileResult(profile, Collections.emptySet());
        }
        ProfileResult result = super.fetchProfile(profile.getId(), requireSecure);
        if (result != null) {
            new FillProfileEvent(CraftPlayerProfile.asBukkitMirror(result.profile())).callEvent();
        }
        return result;
    }

    @DoNotUse
    @Deprecated
    @Nullable
    public ProfileResult fetchProfile(UUID profileId, boolean requireSecure) {
        return super.fetchProfile(profileId, requireSecure);
    }
}

