/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration.serializer;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.MobCategory;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.serialize.ScalarSerializer;
import org.spongepowered.configurate.serialize.SerializationException;

public final class StringRepresentableSerializer
extends ScalarSerializer<StringRepresentable> {
    private static final Map<Type, Function<String, StringRepresentable>> TYPES = Collections.synchronizedMap(Map.ofEntries(StringRepresentableSerializer.createEntry(MobCategory.class)));

    public StringRepresentableSerializer() {
        super(StringRepresentable.class);
    }

    public static boolean isValidFor(Type type) {
        return TYPES.containsKey(type);
    }

    private static <E extends Enum<E>> Map.Entry<Type, Function<String, @Nullable StringRepresentable>> createEntry(Class<E> type) {
        return Map.entry(type, s -> {
            for (Enum value : (Enum[])type.getEnumConstants()) {
                if (!((StringRepresentable)((Object)value)).getSerializedName().equals(s)) continue;
                return (StringRepresentable)((Object)value);
            }
            return null;
        });
    }

    public StringRepresentable deserialize(Type type, Object obj) throws SerializationException {
        Function<String, StringRepresentable> function = TYPES.get(type);
        if (function == null) {
            throw new SerializationException(String.valueOf(type) + " isn't registered");
        }
        return function.apply(obj.toString());
    }

    protected Object serialize(StringRepresentable item, Predicate<Class<?>> typeSupported) {
        return item.getSerializedName();
    }
}

