/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.manager;

import io.papermc.paper.plugin.manager.PaperPluginManagerImpl;
import io.papermc.paper.plugin.provider.type.PluginFileType;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginLoader;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.plugin.UnknownDependencyException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class DummyBukkitPluginLoader
implements PluginLoader {
    private static final Pattern[] PATTERNS = new Pattern[0];

    @NotNull
    public Plugin loadPlugin(@NotNull File file) throws InvalidPluginException, UnknownDependencyException {
        try {
            return PaperPluginManagerImpl.getInstance().loadPlugin(file);
        }
        catch (InvalidDescriptionException e) {
            throw new InvalidPluginException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public PluginDescriptionFile getPluginDescription(@NotNull File file) throws InvalidDescriptionException {
        try (JarFile jar = new JarFile(file);){
            PluginDescriptionFile pluginDescriptionFile;
            PluginFileType<?, ?> type = PluginFileType.guessType(jar);
            if (type == null) {
                throw new InvalidDescriptionException((Throwable)new FileNotFoundException("Jar does not contain plugin.yml"));
            }
            Object meta = type.getConfig(jar);
            if (!(meta instanceof PluginDescriptionFile)) throw new InvalidDescriptionException("Plugin type does not use plugin.yml. Cannot read file description.");
            PluginDescriptionFile pluginDescriptionFile2 = pluginDescriptionFile = (PluginDescriptionFile)meta;
            return pluginDescriptionFile2;
        }
        catch (Exception e) {
            throw new InvalidDescriptionException((Throwable)e);
        }
    }

    @NotNull
    public Pattern[] getPluginFileFilters() {
        return PATTERNS;
    }

    @NotNull
    public Map<Class<? extends Event>, Set<RegisteredListener>> createRegisteredListeners(@NotNull Listener listener, @NotNull Plugin plugin) {
        return PaperPluginManagerImpl.getInstance().paperEventManager.createRegisteredListeners(listener, plugin);
    }

    public void enablePlugin(@NotNull Plugin plugin) {
        Bukkit.getPluginManager().enablePlugin(plugin);
    }

    public void disablePlugin(@NotNull Plugin plugin) {
        Bukkit.getPluginManager().disablePlugin(plugin);
    }
}

