/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry;

import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.data.PaperEnchantmentRegistryEntry;
import io.papermc.paper.registry.data.PaperGameEventRegistryEntry;
import io.papermc.paper.registry.entry.RegistryEntry;
import io.papermc.paper.registry.tag.TagKey;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import org.bukkit.GameEvent;
import org.bukkit.JukeboxSong;
import org.bukkit.Keyed;
import org.bukkit.MusicInstrument;
import org.bukkit.Registry;
import org.bukkit.block.BlockType;
import org.bukkit.block.banner.PatternType;
import org.bukkit.craftbukkit.CraftGameEvent;
import org.bukkit.craftbukkit.CraftJukeboxSong;
import org.bukkit.craftbukkit.CraftMusicInstrument;
import org.bukkit.craftbukkit.block.CraftBlockType;
import org.bukkit.craftbukkit.block.banner.CraftPatternType;
import org.bukkit.craftbukkit.damage.CraftDamageType;
import org.bukkit.craftbukkit.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.entity.CraftCat;
import org.bukkit.craftbukkit.entity.CraftFrog;
import org.bukkit.craftbukkit.entity.CraftVillager;
import org.bukkit.craftbukkit.entity.CraftWolf;
import org.bukkit.craftbukkit.generator.structure.CraftStructure;
import org.bukkit.craftbukkit.generator.structure.CraftStructureType;
import org.bukkit.craftbukkit.inventory.CraftItemType;
import org.bukkit.craftbukkit.inventory.CraftMenuType;
import org.bukkit.craftbukkit.inventory.trim.CraftTrimMaterial;
import org.bukkit.craftbukkit.inventory.trim.CraftTrimPattern;
import org.bukkit.craftbukkit.legacy.FieldRename;
import org.bukkit.craftbukkit.map.CraftMapCursor;
import org.bukkit.craftbukkit.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.damage.DamageType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.generator.structure.Structure;
import org.bukkit.generator.structure.StructureType;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.MenuType;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.map.MapCursor;
import org.bukkit.potion.PotionEffectType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public final class PaperRegistries {
    static final List<RegistryEntry<?, ?>> REGISTRY_ENTRIES = List.of(RegistryEntry.writable(Registries.GAME_EVENT, RegistryKey.GAME_EVENT, GameEvent.class, CraftGameEvent::new, PaperGameEventRegistryEntry.PaperBuilder::new), RegistryEntry.entry(Registries.STRUCTURE_TYPE, RegistryKey.STRUCTURE_TYPE, StructureType.class, CraftStructureType::new), RegistryEntry.entry(Registries.INSTRUMENT, RegistryKey.INSTRUMENT, MusicInstrument.class, CraftMusicInstrument::new), RegistryEntry.entry(Registries.MOB_EFFECT, RegistryKey.MOB_EFFECT, PotionEffectType.class, CraftPotionEffectType::new), RegistryEntry.entry(Registries.BLOCK, RegistryKey.BLOCK, BlockType.class, CraftBlockType::new), RegistryEntry.entry(Registries.ITEM, RegistryKey.ITEM, ItemType.class, CraftItemType::new), RegistryEntry.entry(Registries.CAT_VARIANT, RegistryKey.CAT_VARIANT, Cat.Type.class, CraftCat.CraftType::new), RegistryEntry.entry(Registries.FROG_VARIANT, RegistryKey.FROG_VARIANT, Frog.Variant.class, CraftFrog.CraftVariant::new), RegistryEntry.entry(Registries.VILLAGER_PROFESSION, RegistryKey.VILLAGER_PROFESSION, Villager.Profession.class, CraftVillager.CraftProfession::new), RegistryEntry.entry(Registries.VILLAGER_TYPE, RegistryKey.VILLAGER_TYPE, Villager.Type.class, CraftVillager.CraftType::new), RegistryEntry.entry(Registries.MAP_DECORATION_TYPE, RegistryKey.MAP_DECORATION_TYPE, MapCursor.Type.class, CraftMapCursor.CraftType::new), RegistryEntry.entry(Registries.MENU, RegistryKey.MENU, MenuType.class, CraftMenuType::new), RegistryEntry.entry(Registries.STRUCTURE, RegistryKey.STRUCTURE, Structure.class, CraftStructure::new).delayed(), RegistryEntry.entry(Registries.TRIM_MATERIAL, RegistryKey.TRIM_MATERIAL, TrimMaterial.class, CraftTrimMaterial::new).delayed(), RegistryEntry.entry(Registries.TRIM_PATTERN, RegistryKey.TRIM_PATTERN, TrimPattern.class, CraftTrimPattern::new).delayed(), RegistryEntry.entry(Registries.DAMAGE_TYPE, RegistryKey.DAMAGE_TYPE, DamageType.class, CraftDamageType::new).delayed(), RegistryEntry.entry(Registries.WOLF_VARIANT, RegistryKey.WOLF_VARIANT, Wolf.Variant.class, CraftWolf.CraftVariant::new).delayed(), RegistryEntry.writable(Registries.ENCHANTMENT, RegistryKey.ENCHANTMENT, Enchantment.class, CraftEnchantment::new, PaperEnchantmentRegistryEntry.PaperBuilder::new).withSerializationUpdater(FieldRename.ENCHANTMENT_RENAME).delayed(), RegistryEntry.entry(Registries.JUKEBOX_SONG, RegistryKey.JUKEBOX_SONG, JukeboxSong.class, CraftJukeboxSong::new).delayed(), RegistryEntry.entry(Registries.BANNER_PATTERN, RegistryKey.BANNER_PATTERN, PatternType.class, CraftPatternType::new).delayed(), RegistryEntry.apiOnly(Registries.BIOME, RegistryKey.BIOME, () -> Registry.BIOME), RegistryEntry.apiOnly(Registries.PAINTING_VARIANT, RegistryKey.PAINTING_VARIANT, () -> Registry.ART), RegistryEntry.apiOnly(Registries.ATTRIBUTE, RegistryKey.ATTRIBUTE, () -> Registry.ATTRIBUTE), RegistryEntry.apiOnly(Registries.ENTITY_TYPE, RegistryKey.ENTITY_TYPE, () -> Registry.ENTITY_TYPE), RegistryEntry.apiOnly(Registries.PARTICLE_TYPE, RegistryKey.PARTICLE_TYPE, () -> Registry.PARTICLE_TYPE), RegistryEntry.apiOnly(Registries.POTION, RegistryKey.POTION, () -> Registry.POTION), RegistryEntry.apiOnly(Registries.SOUND_EVENT, RegistryKey.SOUND_EVENT, () -> Registry.SOUNDS), RegistryEntry.apiOnly(Registries.MEMORY_MODULE_TYPE, RegistryKey.MEMORY_MODULE_TYPE, () -> Registry.MEMORY_MODULE_TYPE), RegistryEntry.apiOnly(Registries.FLUID, RegistryKey.FLUID, () -> Registry.FLUID));
    private static final Map<RegistryKey<?>, RegistryEntry<?, ?>> BY_REGISTRY_KEY;
    private static final Map<ResourceKey<?>, RegistryEntry<?, ?>> BY_RESOURCE_KEY;

    public static <M, T extends Keyed> @Nullable RegistryEntry<M, T> getEntry(ResourceKey<? extends net.minecraft.core.Registry<M>> resourceKey) {
        return BY_RESOURCE_KEY.get(resourceKey);
    }

    public static <M, T extends Keyed> @Nullable RegistryEntry<M, T> getEntry(RegistryKey<? super T> registryKey) {
        return BY_REGISTRY_KEY.get(registryKey);
    }

    public static <M, T> RegistryKey<T> registryFromNms(ResourceKey<? extends net.minecraft.core.Registry<M>> registryResourceKey) {
        return Objects.requireNonNull(BY_RESOURCE_KEY.get(registryResourceKey), String.valueOf(registryResourceKey) + " doesn't have an api RegistryKey").apiKey();
    }

    public static <M, T> ResourceKey<? extends net.minecraft.core.Registry<M>> registryToNms(RegistryKey<T> registryKey) {
        return Objects.requireNonNull(BY_REGISTRY_KEY.get(registryKey), String.valueOf(registryKey) + " doesn't have an mc registry ResourceKey").mcKey();
    }

    public static <M, T> TypedKey<T> fromNms(ResourceKey<M> resourceKey) {
        return TypedKey.create(PaperRegistries.registryFromNms(resourceKey.registryKey()), (Key)CraftNamespacedKey.fromMinecraft(resourceKey.location()));
    }

    public static <M, T> ResourceKey<M> toNms(TypedKey<T> typedKey) {
        return ResourceKey.create(PaperRegistries.registryToNms(typedKey.registryKey()), PaperAdventure.asVanilla(typedKey.key()));
    }

    public static <M, T> TagKey<T> fromNms(net.minecraft.tags.TagKey<M> tagKey) {
        return TagKey.create(PaperRegistries.registryFromNms(tagKey.registry()), (Key)CraftNamespacedKey.fromMinecraft(tagKey.location()));
    }

    public static <M, T> net.minecraft.tags.TagKey<M> toNms(TagKey<T> tagKey) {
        return net.minecraft.tags.TagKey.create(PaperRegistries.registryToNms(tagKey.registryKey()), PaperAdventure.asVanilla(tagKey.key()));
    }

    private PaperRegistries() {
    }

    static {
        IdentityHashMap byRegistryKey = new IdentityHashMap(REGISTRY_ENTRIES.size());
        IdentityHashMap byResourceKey = new IdentityHashMap(REGISTRY_ENTRIES.size());
        for (RegistryEntry<?, ?> entry : REGISTRY_ENTRIES) {
            byRegistryKey.put(entry.apiKey(), entry);
            byResourceKey.put(entry.mcKey(), entry);
        }
        BY_REGISTRY_KEY = Collections.unmodifiableMap(byRegistryKey);
        BY_RESOURCE_KEY = Collections.unmodifiableMap(byResourceKey);
    }
}

