/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.entry;

import io.papermc.paper.registry.PaperRegistryBuilder;
import io.papermc.paper.registry.RegistryHolder;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.WritableCraftRegistry;
import io.papermc.paper.registry.data.util.Conversions;
import io.papermc.paper.registry.entry.ApiRegistryEntry;
import io.papermc.paper.registry.entry.CraftRegistryEntry;
import io.papermc.paper.registry.entry.ModifiableRegistryEntry;
import io.papermc.paper.registry.entry.RegistryEntryInfo;
import io.papermc.paper.registry.entry.WritableRegistryEntry;
import io.papermc.paper.registry.event.RegistryEntryAddEventImpl;
import io.papermc.paper.registry.event.RegistryFreezeEventImpl;
import io.papermc.paper.registry.legacy.DelayedRegistryEntry;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.util.ApiVersion;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public interface RegistryEntry<M, B extends Keyed>
extends RegistryEntryInfo<M, B> {
    public RegistryHolder<B> createRegistryHolder(net.minecraft.core.Registry<M> var1);

    default public RegistryEntry<M, B> withSerializationUpdater(BiFunction<NamespacedKey, ApiVersion, NamespacedKey> updater) {
        return this;
    }

    @Deprecated
    default public RegistryEntry<M, B> delayed() {
        return new DelayedRegistryEntry(this);
    }

    private static <M, B extends Keyed> RegistryEntryInfo<M, B> possiblyUnwrap(RegistryEntryInfo<M, B> entry) {
        RegistryEntryInfo<M, B> registryEntryInfo;
        if (entry instanceof DelayedRegistryEntry) {
            DelayedRegistryEntry delayed = (DelayedRegistryEntry)entry;
            registryEntryInfo = delayed.delegate();
        } else {
            registryEntryInfo = entry;
        }
        return registryEntryInfo;
    }

    public static <M, B extends Keyed> RegistryEntry<M, B> entry(ResourceKey<? extends net.minecraft.core.Registry<M>> mcKey, RegistryKey<B> apiKey, Class<?> classToPreload, BiFunction<NamespacedKey, M, B> minecraftToBukkit) {
        return new CraftRegistryEntry<M, B>(mcKey, apiKey, classToPreload, minecraftToBukkit);
    }

    public static <M, B extends Keyed> RegistryEntry<M, B> apiOnly(ResourceKey<? extends net.minecraft.core.Registry<M>> mcKey, RegistryKey<B> apiKey, Supplier<Registry<B>> apiRegistrySupplier) {
        return new ApiRegistryEntry(mcKey, apiKey, apiRegistrySupplier);
    }

    public static <M, T extends Keyed, B extends PaperRegistryBuilder<M, T>> RegistryEntry<M, T> modifiable(ResourceKey<? extends net.minecraft.core.Registry<M>> mcKey, RegistryKey<T> apiKey, Class<?> toPreload, BiFunction<NamespacedKey, M, T> minecraftToBukkit, PaperRegistryBuilder.Filler<M, T, B> filler) {
        return new ModifiableRegistryEntry<M, T, B>(mcKey, apiKey, toPreload, minecraftToBukkit, filler);
    }

    public static <M, T extends Keyed, B extends PaperRegistryBuilder<M, T>> RegistryEntry<M, T> writable(ResourceKey<? extends net.minecraft.core.Registry<M>> mcKey, RegistryKey<T> apiKey, Class<?> toPreload, BiFunction<NamespacedKey, M, T> minecraftToBukkit, PaperRegistryBuilder.Filler<M, T, B> filler) {
        return new WritableRegistryEntry<M, T, B>(mcKey, apiKey, toPreload, minecraftToBukkit, filler);
    }

    public static interface Writable<M, T extends Keyed, B extends PaperRegistryBuilder<M, T>>
    extends Modifiable<M, T, B>,
    Addable<M, T, B> {
        public static boolean isWritable(@Nullable RegistryEntryInfo<?, ?> entry) {
            DelayedRegistryEntry delayed;
            return entry instanceof Writable || entry instanceof DelayedRegistryEntry && (delayed = (DelayedRegistryEntry)entry).delegate() instanceof Writable;
        }

        public static <M, T extends Keyed, B extends PaperRegistryBuilder<M, T>> Writable<M, T, B> asWritable(RegistryEntryInfo<M, T> entry) {
            return (Writable)RegistryEntry.possiblyUnwrap(entry);
        }
    }

    public static interface Addable<M, T extends Keyed, B extends PaperRegistryBuilder<M, T>>
    extends BuilderHolder<M, T, B> {
        default public RegistryFreezeEventImpl<T, B> createFreezeEvent(WritableCraftRegistry<M, T, B> writableRegistry, Conversions conversions) {
            return new RegistryFreezeEventImpl(this.apiKey(), writableRegistry.createApiWritableRegistry(conversions), conversions);
        }

        public static boolean isAddable(@Nullable RegistryEntryInfo<?, ?> entry) {
            DelayedRegistryEntry delayed;
            return entry instanceof Addable || entry instanceof DelayedRegistryEntry && (delayed = (DelayedRegistryEntry)entry).delegate() instanceof Addable;
        }

        public static <M, T extends Keyed, B extends PaperRegistryBuilder<M, T>> Addable<M, T, B> asAddable(RegistryEntryInfo<M, T> entry) {
            return (Addable)RegistryEntry.possiblyUnwrap(entry);
        }
    }

    public static interface Modifiable<M, T, B extends PaperRegistryBuilder<M, T>>
    extends BuilderHolder<M, T, B> {
        public static boolean isModifiable(@Nullable RegistryEntryInfo<?, ?> entry) {
            DelayedRegistryEntry delayed;
            return entry instanceof Modifiable || entry instanceof DelayedRegistryEntry && (delayed = (DelayedRegistryEntry)entry).delegate() instanceof Modifiable;
        }

        public static <M, T extends Keyed, B extends PaperRegistryBuilder<M, T>> Modifiable<M, T, B> asModifiable(RegistryEntryInfo<M, T> entry) {
            return (Modifiable)RegistryEntry.possiblyUnwrap(entry);
        }

        default public RegistryEntryAddEventImpl<T, B> createEntryAddEvent(TypedKey<T> key, B initialBuilder, Conversions conversions) {
            return new RegistryEntryAddEventImpl<T, B>(key, initialBuilder, this.apiKey(), conversions);
        }
    }

    public static interface BuilderHolder<M, T, B extends PaperRegistryBuilder<M, T>>
    extends RegistryEntryInfo<M, T> {
        public B fillBuilder(Conversions var1, TypedKey<T> var2, M var3);
    }
}

