/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import com.destroystokyo.paper.event.brigadier.AsyncPlayerSendCommandsEvent;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.brigadier.AmbiguityConsumer;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.mojang.logging.LogUtils;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.brigadier.PaperBrigadier;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.ChatFormatting;
import net.minecraft.DefaultUncaughtExceptionHandlerWithName;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.execution.ExecutionContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.ArgumentUtils;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.gametest.framework.TestCommand;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ClientboundCommandsPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.AdvancementCommands;
import net.minecraft.server.commands.AttributeCommand;
import net.minecraft.server.commands.BanIpCommands;
import net.minecraft.server.commands.BanListCommands;
import net.minecraft.server.commands.BanPlayerCommands;
import net.minecraft.server.commands.BossBarCommands;
import net.minecraft.server.commands.ClearInventoryCommands;
import net.minecraft.server.commands.CloneCommands;
import net.minecraft.server.commands.DamageCommand;
import net.minecraft.server.commands.DataPackCommand;
import net.minecraft.server.commands.DeOpCommands;
import net.minecraft.server.commands.DebugCommand;
import net.minecraft.server.commands.DebugConfigCommand;
import net.minecraft.server.commands.DebugMobSpawningCommand;
import net.minecraft.server.commands.DebugPathCommand;
import net.minecraft.server.commands.DefaultGameModeCommands;
import net.minecraft.server.commands.DifficultyCommand;
import net.minecraft.server.commands.EffectCommands;
import net.minecraft.server.commands.EmoteCommands;
import net.minecraft.server.commands.EnchantCommand;
import net.minecraft.server.commands.ExecuteCommand;
import net.minecraft.server.commands.ExperienceCommand;
import net.minecraft.server.commands.FillBiomeCommand;
import net.minecraft.server.commands.FillCommand;
import net.minecraft.server.commands.ForceLoadCommand;
import net.minecraft.server.commands.FunctionCommand;
import net.minecraft.server.commands.GameModeCommand;
import net.minecraft.server.commands.GameRuleCommand;
import net.minecraft.server.commands.GiveCommand;
import net.minecraft.server.commands.HelpCommand;
import net.minecraft.server.commands.ItemCommands;
import net.minecraft.server.commands.JfrCommand;
import net.minecraft.server.commands.KickCommand;
import net.minecraft.server.commands.KillCommand;
import net.minecraft.server.commands.ListPlayersCommand;
import net.minecraft.server.commands.LocateCommand;
import net.minecraft.server.commands.LootCommand;
import net.minecraft.server.commands.MsgCommand;
import net.minecraft.server.commands.OpCommand;
import net.minecraft.server.commands.PardonCommand;
import net.minecraft.server.commands.PardonIpCommand;
import net.minecraft.server.commands.ParticleCommand;
import net.minecraft.server.commands.PerfCommand;
import net.minecraft.server.commands.PlaceCommand;
import net.minecraft.server.commands.PlaySoundCommand;
import net.minecraft.server.commands.PublishCommand;
import net.minecraft.server.commands.RaidCommand;
import net.minecraft.server.commands.RandomCommand;
import net.minecraft.server.commands.RecipeCommand;
import net.minecraft.server.commands.ReloadCommand;
import net.minecraft.server.commands.ReturnCommand;
import net.minecraft.server.commands.RideCommand;
import net.minecraft.server.commands.SaveAllCommand;
import net.minecraft.server.commands.SaveOffCommand;
import net.minecraft.server.commands.SaveOnCommand;
import net.minecraft.server.commands.SayCommand;
import net.minecraft.server.commands.ScheduleCommand;
import net.minecraft.server.commands.ScoreboardCommand;
import net.minecraft.server.commands.SeedCommand;
import net.minecraft.server.commands.ServerPackCommand;
import net.minecraft.server.commands.SetBlockCommand;
import net.minecraft.server.commands.SetPlayerIdleTimeoutCommand;
import net.minecraft.server.commands.SetSpawnCommand;
import net.minecraft.server.commands.SetWorldSpawnCommand;
import net.minecraft.server.commands.SpawnArmorTrimsCommand;
import net.minecraft.server.commands.SpectateCommand;
import net.minecraft.server.commands.SpreadPlayersCommand;
import net.minecraft.server.commands.StopCommand;
import net.minecraft.server.commands.StopSoundCommand;
import net.minecraft.server.commands.SummonCommand;
import net.minecraft.server.commands.TagCommand;
import net.minecraft.server.commands.TeamCommand;
import net.minecraft.server.commands.TeamMsgCommand;
import net.minecraft.server.commands.TeleportCommand;
import net.minecraft.server.commands.TellRawCommand;
import net.minecraft.server.commands.TickCommand;
import net.minecraft.server.commands.TimeCommand;
import net.minecraft.server.commands.TitleCommand;
import net.minecraft.server.commands.TransferCommand;
import net.minecraft.server.commands.TriggerCommand;
import net.minecraft.server.commands.WardenSpawnTrackerCommand;
import net.minecraft.server.commands.WeatherCommand;
import net.minecraft.server.commands.WhitelistCommand;
import net.minecraft.server.commands.WorldBorderCommand;
import net.minecraft.server.commands.data.DataCommands;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.world.level.GameRules;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.command.VanillaCommandWrapper;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.command.UnknownCommandEvent;
import org.bukkit.event.player.PlayerCommandSendEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class Commands {
    private static final ThreadLocal<ExecutionContext<CommandSourceStack>> CURRENT_EXECUTION_CONTEXT = new ThreadLocal();
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int LEVEL_ALL = 0;
    public static final int LEVEL_MODERATORS = 1;
    public static final int LEVEL_GAMEMASTERS = 2;
    public static final int LEVEL_ADMINS = 3;
    public static final int LEVEL_OWNERS = 4;
    private final CommandDispatcher<CommandSourceStack> dispatcher = new CommandDispatcher();
    public static final ThreadPoolExecutor COMMAND_SENDING_POOL = new ThreadPoolExecutor(0, 2, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("Paper Async Command Builder Thread Pool - %1$d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandlerWithName(MinecraftServer.LOGGER)).build(), new ThreadPoolExecutor.DiscardPolicy());

    public Commands(CommandSelection environment, CommandBuildContext commandRegistryAccess) {
        AdvancementCommands.register(this.dispatcher);
        AttributeCommand.register(this.dispatcher, commandRegistryAccess);
        ExecuteCommand.register(this.dispatcher, commandRegistryAccess);
        BossBarCommands.register(this.dispatcher, commandRegistryAccess);
        ClearInventoryCommands.register(this.dispatcher, commandRegistryAccess);
        CloneCommands.register(this.dispatcher, commandRegistryAccess);
        DamageCommand.register(this.dispatcher, commandRegistryAccess);
        DataCommands.register(this.dispatcher);
        DataPackCommand.register(this.dispatcher);
        DebugCommand.register(this.dispatcher);
        DefaultGameModeCommands.register(this.dispatcher);
        DifficultyCommand.register(this.dispatcher);
        EffectCommands.register(this.dispatcher, commandRegistryAccess);
        EmoteCommands.register(this.dispatcher);
        EnchantCommand.register(this.dispatcher, commandRegistryAccess);
        ExperienceCommand.register(this.dispatcher);
        FillCommand.register(this.dispatcher, commandRegistryAccess);
        FillBiomeCommand.register(this.dispatcher, commandRegistryAccess);
        ForceLoadCommand.register(this.dispatcher);
        FunctionCommand.register(this.dispatcher);
        GameModeCommand.register(this.dispatcher);
        GameRuleCommand.register(this.dispatcher);
        GiveCommand.register(this.dispatcher, commandRegistryAccess);
        HelpCommand.register(this.dispatcher);
        ItemCommands.register(this.dispatcher, commandRegistryAccess);
        KickCommand.register(this.dispatcher);
        KillCommand.register(this.dispatcher);
        ListPlayersCommand.register(this.dispatcher);
        LocateCommand.register(this.dispatcher, commandRegistryAccess);
        LootCommand.register(this.dispatcher, commandRegistryAccess);
        MsgCommand.register(this.dispatcher);
        ParticleCommand.register(this.dispatcher, commandRegistryAccess);
        PlaceCommand.register(this.dispatcher);
        PlaySoundCommand.register(this.dispatcher);
        RandomCommand.register(this.dispatcher);
        ReloadCommand.register(this.dispatcher);
        RecipeCommand.register(this.dispatcher);
        ReturnCommand.register(this.dispatcher);
        RideCommand.register(this.dispatcher);
        SayCommand.register(this.dispatcher);
        ScheduleCommand.register(this.dispatcher);
        ScoreboardCommand.register(this.dispatcher, commandRegistryAccess);
        SeedCommand.register(this.dispatcher, environment != CommandSelection.INTEGRATED);
        SetBlockCommand.register(this.dispatcher, commandRegistryAccess);
        SetSpawnCommand.register(this.dispatcher);
        SetWorldSpawnCommand.register(this.dispatcher);
        SpectateCommand.register(this.dispatcher);
        SpreadPlayersCommand.register(this.dispatcher);
        StopSoundCommand.register(this.dispatcher);
        SummonCommand.register(this.dispatcher, commandRegistryAccess);
        TagCommand.register(this.dispatcher);
        TeamCommand.register(this.dispatcher, commandRegistryAccess);
        TeamMsgCommand.register(this.dispatcher);
        TeleportCommand.register(this.dispatcher);
        TellRawCommand.register(this.dispatcher, commandRegistryAccess);
        TickCommand.register(this.dispatcher);
        TimeCommand.register(this.dispatcher);
        TitleCommand.register(this.dispatcher, commandRegistryAccess);
        TriggerCommand.register(this.dispatcher);
        WeatherCommand.register(this.dispatcher);
        WorldBorderCommand.register(this.dispatcher);
        if (JvmProfiler.INSTANCE.isAvailable()) {
            JfrCommand.register(this.dispatcher);
        }
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            TestCommand.register(this.dispatcher);
            RaidCommand.register(this.dispatcher, commandRegistryAccess);
            DebugPathCommand.register(this.dispatcher);
            DebugMobSpawningCommand.register(this.dispatcher);
            WardenSpawnTrackerCommand.register(this.dispatcher);
            SpawnArmorTrimsCommand.register(this.dispatcher);
            ServerPackCommand.register(this.dispatcher);
            if (environment.includeDedicated) {
                DebugConfigCommand.register(this.dispatcher);
            }
        }
        if (environment.includeDedicated) {
            BanIpCommands.register(this.dispatcher);
            BanListCommands.register(this.dispatcher);
            BanPlayerCommands.register(this.dispatcher);
            DeOpCommands.register(this.dispatcher);
            OpCommand.register(this.dispatcher);
            PardonCommand.register(this.dispatcher);
            PardonIpCommand.register(this.dispatcher);
            PerfCommand.register(this.dispatcher);
            SaveAllCommand.register(this.dispatcher);
            SaveOffCommand.register(this.dispatcher);
            SaveOnCommand.register(this.dispatcher);
            SetPlayerIdleTimeoutCommand.register(this.dispatcher);
            StopCommand.register(this.dispatcher);
            TransferCommand.register(this.dispatcher);
            WhitelistCommand.register(this.dispatcher);
        }
        if (environment.includeIntegrated) {
            PublishCommand.register(this.dispatcher);
        }
        for (CommandNode node : this.dispatcher.getRoot().getChildren()) {
            if (node.getRequirement() != ArgumentBuilder.defaultRequirement()) continue;
            node.requirement = stack -> stack.source == CommandSource.NULL || stack.getBukkitSender().hasPermission(VanillaCommandWrapper.getPermission(node));
        }
        Iterator iterator = new ArrayList(this.dispatcher.getRoot().getChildren()).iterator();
        while (iterator.hasNext()) {
            CommandNode node;
            CommandNode flattenedAliasTarget = node = (CommandNode)iterator.next();
            while (flattenedAliasTarget.getRedirect() != null) {
                flattenedAliasTarget = flattenedAliasTarget.getRedirect();
            }
            this.dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)("minecraft:" + node.getName())).executes(flattenedAliasTarget.getCommand())).requires(flattenedAliasTarget.getRequirement())).redirect(flattenedAliasTarget)));
        }
        this.dispatcher.setConsumer(ExecutionCommandSource.resultConsumer());
    }

    public static <S> ParseResults<S> mapSource(ParseResults<S> parseResults, UnaryOperator<S> sourceMapper) {
        CommandContextBuilder commandcontextbuilder = parseResults.getContext();
        CommandContextBuilder commandcontextbuilder1 = commandcontextbuilder.withSource(sourceMapper.apply(commandcontextbuilder.getSource()));
        return new ParseResults(commandcontextbuilder1, parseResults.getReader(), parseResults.getExceptions());
    }

    public void dispatchServerCommand(CommandSourceStack sender, String command) {
        Joiner joiner = Joiner.on((String)" ");
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        ServerCommandEvent event = new ServerCommandEvent(sender.getBukkitSender(), command);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        command = event.getCommand();
        Object[] args = command.split(" ");
        if (args.length == 0) {
            return;
        }
        String newCommand = joiner.join(args);
        this.performPrefixedCommand(sender, newCommand, newCommand);
    }

    public void performPrefixedCommand(CommandSourceStack source, String command) {
        this.performPrefixedCommand(source, command, command);
    }

    public void performPrefixedCommand(CommandSourceStack commandlistenerwrapper, String s, String label) {
        s = s.startsWith("/") ? s.substring(1) : s;
        this.performCommand(this.dispatcher.parse(s, commandlistenerwrapper), s, label);
    }

    public void performCommand(ParseResults<CommandSourceStack> parseResults, String command) {
        this.performCommand(parseResults, command, command);
    }

    public void performCommand(ParseResults<CommandSourceStack> parseresults, String s, String label) {
        this.performCommand(parseresults, s, label, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performCommand(ParseResults<CommandSourceStack> parseresults, String s, String label, boolean throwCommandError) {
        CommandSourceStack commandlistenerwrapper = (CommandSourceStack)parseresults.getContext().getSource();
        commandlistenerwrapper.getServer().getProfiler().push(() -> "/" + s);
        ContextChain<CommandSourceStack> contextchain = this.finishParsing(parseresults, s, commandlistenerwrapper, label);
        try {
            if (contextchain != null) {
                Commands.executeCommandInContext(commandlistenerwrapper, executioncontext -> ExecutionContext.queueInitialCommandExecution(executioncontext, s, contextchain, commandlistenerwrapper, CommandResultCallback.EMPTY));
            }
        }
        catch (Exception exception) {
            if (throwCommandError) {
                throw exception;
            }
            MutableComponent ichatmutablecomponent = net.minecraft.network.chat.Component.literal(exception.getMessage() == null ? exception.getClass().getName() : exception.getMessage());
            LOGGER.error("Command exception: /{}", (Object)s, (Object)exception);
            if (commandlistenerwrapper.getServer().isDebugging() || LOGGER.isDebugEnabled()) {
                StackTraceElement[] astacktraceelement = exception.getStackTrace();
                for (int i = 0; i < Math.min(astacktraceelement.length, 3); ++i) {
                    ichatmutablecomponent.append("\n\n").append(astacktraceelement[i].getMethodName()).append("\n ").append(astacktraceelement[i].getFileName()).append(":").append(String.valueOf(astacktraceelement[i].getLineNumber()));
                }
            }
            commandlistenerwrapper.sendFailure(net.minecraft.network.chat.Component.translatable("command.failed").withStyle(chatmodifier -> chatmodifier.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, ichatmutablecomponent))));
            if (SharedConstants.IS_RUNNING_IN_IDE) {
                commandlistenerwrapper.sendFailure(net.minecraft.network.chat.Component.literal(Util.describeError(exception)));
                LOGGER.error("'/{}' threw an exception", (Object)s, (Object)exception);
            }
        }
        finally {
            commandlistenerwrapper.getServer().getProfiler().pop();
        }
    }

    @Nullable
    private ContextChain<CommandSourceStack> finishParsing(ParseResults<CommandSourceStack> parseresults, String s, CommandSourceStack commandlistenerwrapper, String label) {
        try {
            Commands.validateParseResults(parseresults);
            return (ContextChain)ContextChain.tryFlatten((CommandContext)parseresults.getContext().build(s)).orElseThrow(() -> CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext(parseresults.getReader()));
        }
        catch (CommandSyntaxException commandsyntaxexception) {
            TextComponent.Builder builder = Component.text();
            ((TextComponent.Builder)builder.color((TextColor)NamedTextColor.RED)).append(PaperBrigadier.componentFromMessage((Message)commandsyntaxexception.getRawMessage()));
            if (commandsyntaxexception.getInput() != null && commandsyntaxexception.getCursor() >= 0) {
                int i = Math.min(commandsyntaxexception.getInput().length(), commandsyntaxexception.getCursor());
                MutableComponent ichatmutablecomponent = net.minecraft.network.chat.Component.empty().withStyle(ChatFormatting.GRAY).withStyle(chatmodifier -> chatmodifier.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/" + label)));
                if (i > 10) {
                    ichatmutablecomponent.append(CommonComponents.ELLIPSIS);
                }
                ichatmutablecomponent.append(commandsyntaxexception.getInput().substring(Math.max(0, i - 10), i));
                if (i < commandsyntaxexception.getInput().length()) {
                    MutableComponent ichatmutablecomponent1 = net.minecraft.network.chat.Component.literal(commandsyntaxexception.getInput().substring(i)).withStyle(ChatFormatting.RED, ChatFormatting.UNDERLINE);
                    ichatmutablecomponent.append(ichatmutablecomponent1);
                }
                ichatmutablecomponent.append(net.minecraft.network.chat.Component.translatable("command.context.here").withStyle(ChatFormatting.RED, ChatFormatting.ITALIC));
                ((TextComponent.Builder)builder.append((Component)Component.newline())).append(PaperAdventure.asAdventure(ichatmutablecomponent));
            }
            UnknownCommandEvent event = new UnknownCommandEvent(commandlistenerwrapper.getBukkitSender(), s, (Component)(SpigotConfig.unknownCommandMessage.isEmpty() ? null : builder.build()));
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            if (event.message() != null) {
                commandlistenerwrapper.sendFailure(PaperAdventure.asVanilla(event.message()), false);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeCommandInContext(CommandSourceStack commandSource, Consumer<ExecutionContext<CommandSourceStack>> callback) {
        block9: {
            boolean flag;
            MinecraftServer minecraftserver = commandSource.getServer();
            ExecutionContext<CommandSourceStack> executioncontext = CURRENT_EXECUTION_CONTEXT.get();
            boolean bl = flag = executioncontext == null;
            if (flag) {
                int i = Math.max(1, minecraftserver.getGameRules().getInt(GameRules.RULE_MAX_COMMAND_CHAIN_LENGTH));
                int j = minecraftserver.getGameRules().getInt(GameRules.RULE_MAX_COMMAND_FORK_COUNT);
                try (ExecutionContext executioncontext1 = new ExecutionContext(i, j, minecraftserver.getProfiler());){
                    CURRENT_EXECUTION_CONTEXT.set(executioncontext1);
                    callback.accept(executioncontext1);
                    executioncontext1.runCommandQueue();
                    break block9;
                }
                finally {
                    CURRENT_EXECUTION_CONTEXT.set(null);
                }
            }
            callback.accept(executioncontext);
        }
    }

    public void sendCommands(ServerPlayer player) {
        if (SpigotConfig.tabComplete < 0) {
            player.connection.send(new ClientboundCommandsPacket((RootCommandNode<SharedSuggestionProvider>)new RootCommandNode()));
            return;
        }
        COMMAND_SENDING_POOL.execute(() -> this.sendAsync(player));
    }

    private void sendAsync(ServerPlayer player) {
        IdentityHashMap map = Maps.newIdentityHashMap();
        RootCommandNode rootcommandnode = new RootCommandNode();
        map.put(this.dispatcher.getRoot(), rootcommandnode);
        this.fillUsableCommands((CommandNode<CommandSourceStack>)this.dispatcher.getRoot(), (CommandNode<SharedSuggestionProvider>)rootcommandnode, player.createCommandSourceStack(), map);
        LinkedHashSet<String> bukkit = new LinkedHashSet<String>();
        for (CommandNode node : rootcommandnode.getChildren()) {
            bukkit.add(node.getName());
        }
        new AsyncPlayerSendCommandsEvent((Player)player.getBukkitEntity(), rootcommandnode, false).callEvent();
        MinecraftServer.getServer().execute(() -> this.runSync(player, bukkit, (RootCommandNode<SharedSuggestionProvider>)rootcommandnode));
    }

    private void runSync(ServerPlayer player, Collection<String> bukkit, RootCommandNode<SharedSuggestionProvider> rootcommandnode) {
        new AsyncPlayerSendCommandsEvent((Player)player.getBukkitEntity(), rootcommandnode, true).callEvent();
        PlayerCommandSendEvent event = new PlayerCommandSendEvent((Player)player.getBukkitEntity(), new LinkedHashSet<String>(bukkit));
        event.getPlayer().getServer().getPluginManager().callEvent((Event)event);
        for (String orig : bukkit) {
            if (event.getCommands().contains(orig)) continue;
            rootcommandnode.removeCommand(orig);
        }
        player.connection.send(new ClientboundCommandsPacket(rootcommandnode));
    }

    private void fillUsableCommands(CommandNode<CommandSourceStack> tree, CommandNode<SharedSuggestionProvider> result, CommandSourceStack source, Map<CommandNode<CommandSourceStack>, CommandNode<SharedSuggestionProvider>> resultNodes) {
        resultNodes.keySet().removeIf(node -> !SpigotConfig.sendNamespaced && node.getName().contains(":"));
        Iterator<CommandNode<CommandSourceStack>> iterator = tree.getChildren().iterator();
        boolean registeredAskServerSuggestionsForTree = false;
        while (iterator.hasNext()) {
            CommandNode<CommandSourceStack> commandnode2 = iterator.next();
            if (commandnode2.clientNode != null) {
                commandnode2 = commandnode2.clientNode;
            }
            if (!SpigotConfig.sendNamespaced && commandnode2.getName().contains(":") || !commandnode2.canUse(source)) continue;
            LiteralArgumentBuilder argumentbuilder = commandnode2.createBuilder();
            if (argumentbuilder.getRedirect() != null && resultNodes.get(argumentbuilder.getRedirect()) == null) {
                CommandNode<CommandSourceStack> redirect = argumentbuilder.getRedirect();
                LiteralArgumentBuilder builder = LiteralArgumentBuilder.literal((String)commandnode2.getName());
                builder.requires(redirect.getRequirement());
                if (redirect.getCommand() != null) {
                    builder.executes(redirect.getCommand());
                }
                for (CommandNode<CommandSourceStack> child : redirect.getChildren()) {
                    builder.then(child);
                }
                argumentbuilder = builder;
            }
            argumentbuilder.requires(icompletionprovider -> true);
            if (argumentbuilder.getCommand() != null) {
                argumentbuilder.executes((Command<CommandSourceStack>)((Command)commandcontext -> 0));
            }
            if (argumentbuilder instanceof RequiredArgumentBuilder) {
                RequiredArgumentBuilder requiredargumentbuilder = (RequiredArgumentBuilder)argumentbuilder;
                if (requiredargumentbuilder.getSuggestionsProvider() != null) {
                    requiredargumentbuilder.suggests(SuggestionProviders.safelySwap((SuggestionProvider<SharedSuggestionProvider>)requiredargumentbuilder.getSuggestionsProvider()));
                    registeredAskServerSuggestionsForTree = requiredargumentbuilder.getSuggestionsProvider() == SuggestionProviders.ASK_SERVER;
                } else if (GlobalConfiguration.get().commands.fixTargetSelectorTagCompletion && !registeredAskServerSuggestionsForTree && requiredargumentbuilder.getType() instanceof EntityArgument) {
                    requiredargumentbuilder.suggests((arg_0, arg_1) -> ((ArgumentType)requiredargumentbuilder.getType()).listSuggestions(arg_0, arg_1));
                    registeredAskServerSuggestionsForTree = true;
                }
            }
            if (argumentbuilder.getRedirect() != null) {
                argumentbuilder.redirect(resultNodes.get(argumentbuilder.getRedirect()));
            }
            CommandNode<SharedSuggestionProvider> commandnode3 = argumentbuilder.build();
            resultNodes.put(commandnode2, commandnode3);
            result.addChild(commandnode3);
            if (commandnode2.getChildren().isEmpty()) continue;
            this.fillUsableCommands(commandnode2, commandnode3, source, resultNodes);
        }
    }

    public static LiteralArgumentBuilder<CommandSourceStack> literal(String literal) {
        return LiteralArgumentBuilder.literal((String)literal);
    }

    public static <T> RequiredArgumentBuilder<CommandSourceStack, T> argument(String name, ArgumentType<T> type) {
        return RequiredArgumentBuilder.argument((String)name, type);
    }

    public static Predicate<String> createValidator(ParseFunction parser) {
        return s -> {
            try {
                parser.parse(new StringReader(s));
                return true;
            }
            catch (CommandSyntaxException commandsyntaxexception) {
                return false;
            }
        };
    }

    public CommandDispatcher<CommandSourceStack> getDispatcher() {
        return this.dispatcher;
    }

    public static <S> void validateParseResults(ParseResults<S> parse) throws CommandSyntaxException {
        CommandSyntaxException commandsyntaxexception = Commands.getParseException(parse);
        if (commandsyntaxexception != null) {
            throw commandsyntaxexception;
        }
    }

    @Nullable
    public static <S> CommandSyntaxException getParseException(ParseResults<S> parse) {
        return !parse.getReader().canRead() ? null : (parse.getExceptions().size() == 1 ? (CommandSyntaxException)parse.getExceptions().values().iterator().next() : (parse.getContext().getRange().isEmpty() ? CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext(parse.getReader()) : CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().createWithContext(parse.getReader())));
    }

    public static CommandBuildContext createValidationContext(final HolderLookup.Provider registryLookup) {
        return new CommandBuildContext(){

            @Override
            public Stream<ResourceKey<? extends Registry<?>>> listRegistries() {
                return registryLookup.listRegistries();
            }

            @Override
            public <T> Optional<HolderLookup.RegistryLookup<T>> lookup(ResourceKey<? extends Registry<? extends T>> registryRef) {
                return registryLookup.lookup(registryRef).map(this::createLookup);
            }

            private <T> HolderLookup.RegistryLookup.Delegate<T> createLookup(final HolderLookup.RegistryLookup<T> original) {
                return new HolderLookup.RegistryLookup.Delegate<T>(){

                    @Override
                    public HolderLookup.RegistryLookup<T> parent() {
                        return original;
                    }

                    @Override
                    public Optional<HolderSet.Named<T>> get(TagKey<T> tag) {
                        return Optional.of(this.getOrThrow(tag));
                    }

                    @Override
                    public HolderSet.Named<T> getOrThrow(TagKey<T> tag) {
                        Optional<HolderSet.Named<HolderSet.Named>> optional = this.parent().get(tag);
                        return optional.orElseGet(() -> HolderSet.emptyNamed(this.parent(), tag));
                    }
                };
            }
        };
    }

    public static void validate() {
        CommandBuildContext commandbuildcontext = Commands.createValidationContext(VanillaRegistries.createLookup());
        CommandDispatcher<CommandSourceStack> com_mojang_brigadier_commanddispatcher = new Commands(CommandSelection.ALL, commandbuildcontext).getDispatcher();
        RootCommandNode<CommandSourceStack> rootcommandnode = com_mojang_brigadier_commanddispatcher.getRoot();
        com_mojang_brigadier_commanddispatcher.findAmbiguities((AmbiguityConsumer<CommandSourceStack>)((AmbiguityConsumer)(commandnode, commandnode1, commandnode2, collection) -> LOGGER.warn("Ambiguity between arguments {} and {} with inputs: {}", new Object[]{com_mojang_brigadier_commanddispatcher.getPath(commandnode1), com_mojang_brigadier_commanddispatcher.getPath(commandnode2), collection})));
        Set<ArgumentType<?>> set = ArgumentUtils.findUsedArgumentTypes(rootcommandnode);
        Set set1 = set.stream().filter(argumenttype -> !ArgumentTypeInfos.isClassRecognized(argumenttype.getClass())).collect(Collectors.toSet());
        if (!set1.isEmpty()) {
            LOGGER.warn("Missing type registration for following arguments:\n {}", (Object)set1.stream().map(argumenttype -> "\t" + String.valueOf(argumenttype)).collect(Collectors.joining(",\n")));
            throw new IllegalStateException("Unregistered argument types");
        }
    }

    public static enum CommandSelection {
        ALL(true, true),
        DEDICATED(false, true),
        INTEGRATED(true, false);

        final boolean includeIntegrated;
        final boolean includeDedicated;

        private CommandSelection(boolean flag, boolean flag1) {
            this.includeIntegrated = flag;
            this.includeDedicated = flag1;
        }
    }

    @FunctionalInterface
    public static interface ParseFunction {
        public void parse(StringReader var1) throws CommandSyntaxException;
    }
}

