/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.collect.Iterables;
import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class EntityArgument
implements ArgumentType<EntitySelector> {
    private static final Collection<String> EXAMPLES = Arrays.asList("Player", "0123", "@e", "@e[type=foo]", "dd12be42-52a9-4a91-a8a1-11c01849e498");
    public static final SimpleCommandExceptionType ERROR_NOT_SINGLE_ENTITY = new SimpleCommandExceptionType((Message)Component.translatable("argument.entity.toomany"));
    public static final SimpleCommandExceptionType ERROR_NOT_SINGLE_PLAYER = new SimpleCommandExceptionType((Message)Component.translatable("argument.player.toomany"));
    public static final SimpleCommandExceptionType ERROR_ONLY_PLAYERS_ALLOWED = new SimpleCommandExceptionType((Message)Component.translatable("argument.player.entities"));
    public static final SimpleCommandExceptionType NO_ENTITIES_FOUND = new SimpleCommandExceptionType((Message)Component.translatable("argument.entity.notfound.entity"));
    public static final SimpleCommandExceptionType NO_PLAYERS_FOUND = new SimpleCommandExceptionType((Message)Component.translatable("argument.entity.notfound.player"));
    public static final SimpleCommandExceptionType ERROR_SELECTORS_NOT_ALLOWED = new SimpleCommandExceptionType((Message)Component.translatable("argument.entity.selector.not_allowed"));
    final boolean single;
    final boolean playersOnly;

    protected EntityArgument(boolean singleTarget, boolean playersOnly) {
        this.single = singleTarget;
        this.playersOnly = playersOnly;
    }

    public static EntityArgument entity() {
        return new EntityArgument(true, false);
    }

    public static Entity getEntity(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        return ((EntitySelector)context.getArgument(name, EntitySelector.class)).findSingleEntity((CommandSourceStack)context.getSource());
    }

    public static EntityArgument entities() {
        return new EntityArgument(false, false);
    }

    public static Collection<? extends Entity> getEntities(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        Collection<? extends Entity> collection = EntityArgument.getOptionalEntities(context, name);
        if (collection.isEmpty()) {
            throw NO_ENTITIES_FOUND.create();
        }
        return collection;
    }

    public static Collection<? extends Entity> getOptionalEntities(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        return ((EntitySelector)context.getArgument(name, EntitySelector.class)).findEntities((CommandSourceStack)context.getSource());
    }

    public static Collection<ServerPlayer> getOptionalPlayers(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        return ((EntitySelector)context.getArgument(name, EntitySelector.class)).findPlayers((CommandSourceStack)context.getSource());
    }

    public static EntityArgument player() {
        return new EntityArgument(true, true);
    }

    public static ServerPlayer getPlayer(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        return ((EntitySelector)context.getArgument(name, EntitySelector.class)).findSinglePlayer((CommandSourceStack)context.getSource());
    }

    public static EntityArgument players() {
        return new EntityArgument(false, true);
    }

    public static Collection<ServerPlayer> getPlayers(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        List<ServerPlayer> list = ((EntitySelector)context.getArgument(name, EntitySelector.class)).findPlayers((CommandSourceStack)context.getSource());
        if (list.isEmpty()) {
            throw NO_PLAYERS_FOUND.create();
        }
        return list;
    }

    public EntitySelector parse(StringReader stringreader) throws CommandSyntaxException {
        return this.parse(stringreader, true);
    }

    public <S> EntitySelector parse(StringReader stringreader, S s0) throws CommandSyntaxException {
        return this.parse(stringreader, EntitySelectorParser.allowSelectors(s0));
    }

    private EntitySelector parse(StringReader reader, boolean allowAtSelectors) throws CommandSyntaxException {
        return this.parse(reader, allowAtSelectors, false);
    }

    public EntitySelector parse(StringReader stringreader, boolean flag, boolean overridePermissions) throws CommandSyntaxException {
        boolean flag1 = false;
        EntitySelectorParser argumentparserselector = new EntitySelectorParser(stringreader, flag);
        EntitySelector entityselector = argumentparserselector.parse(overridePermissions);
        if (entityselector.getMaxResults() > 1 && this.single) {
            if (this.playersOnly) {
                stringreader.setCursor(0);
                throw ERROR_NOT_SINGLE_PLAYER.createWithContext((ImmutableStringReader)stringreader);
            }
            stringreader.setCursor(0);
            throw ERROR_NOT_SINGLE_ENTITY.createWithContext((ImmutableStringReader)stringreader);
        }
        if (entityselector.includesEntities() && this.playersOnly && !entityselector.isSelfSelector()) {
            stringreader.setCursor(0);
            throw ERROR_ONLY_PLAYERS_ALLOWED.createWithContext((ImmutableStringReader)stringreader);
        }
        return entityselector;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandcontext, SuggestionsBuilder suggestionsbuilder) {
        Object object = commandcontext.getSource();
        if (object instanceof SharedSuggestionProvider) {
            boolean bl;
            SharedSuggestionProvider icompletionprovider = (SharedSuggestionProvider)object;
            StringReader stringreader = new StringReader(suggestionsbuilder.getInput());
            stringreader.setCursor(suggestionsbuilder.getStart());
            if (object instanceof CommandSourceStack) {
                CommandSourceStack stack = (CommandSourceStack)object;
                bl = stack.bypassSelectorPermissions || stack.hasPermission(2, "minecraft.command.selector");
            } else {
                bl = icompletionprovider.hasPermission(2);
            }
            boolean permission = bl;
            EntitySelectorParser argumentparserselector = new EntitySelectorParser(stringreader, permission, true);
            try {
                argumentparserselector.parse();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            return argumentparserselector.fillSuggestions(suggestionsbuilder, suggestionsbuilder1 -> {
                Collection<String> collection;
                CommandSourceStack commandSourceStack;
                Entity patt0$temp;
                if (icompletionprovider instanceof CommandSourceStack && (patt0$temp = (commandSourceStack = (CommandSourceStack)icompletionprovider).getEntity()) instanceof ServerPlayer) {
                    ServerPlayer sourcePlayer = (ServerPlayer)patt0$temp;
                    collection = new ArrayList<String>();
                    for (ServerPlayer player : commandSourceStack.getServer().getPlayerList().getPlayers()) {
                        if (!sourcePlayer.getBukkitEntity().canSee(player.getBukkitEntity())) continue;
                        collection.add(player.getGameProfile().getName());
                    }
                } else {
                    collection = icompletionprovider.getOnlinePlayerNames();
                }
                Collection<String> iterable = this.playersOnly ? collection : Iterables.concat(collection, icompletionprovider.getSelectedEntities());
                SharedSuggestionProvider.suggest(iterable, suggestionsbuilder1);
            });
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static class Info
    implements ArgumentTypeInfo<EntityArgument, Template> {
        private static final byte FLAG_SINGLE = 1;
        private static final byte FLAG_PLAYERS_ONLY = 2;

        @Override
        public void serializeToNetwork(Template properties, FriendlyByteBuf buf) {
            int i = 0;
            if (properties.single) {
                i |= 1;
            }
            if (properties.playersOnly) {
                i |= 2;
            }
            buf.writeByte(i);
        }

        @Override
        public Template deserializeFromNetwork(FriendlyByteBuf buf) {
            byte b0 = buf.readByte();
            return new Template((b0 & 1) != 0, (b0 & 2) != 0);
        }

        @Override
        public void serializeToJson(Template properties, JsonObject json) {
            json.addProperty("amount", properties.single ? "single" : "multiple");
            json.addProperty("type", properties.playersOnly ? "players" : "entities");
        }

        @Override
        public Template unpack(EntityArgument argumentType) {
            return new Template(argumentType.single, argumentType.playersOnly);
        }

        public final class Template
        implements ArgumentTypeInfo.Template<EntityArgument> {
            final boolean single;
            final boolean playersOnly;

            Template(boolean flag, boolean flag1) {
                this.single = flag;
                this.playersOnly = flag1;
            }

            @Override
            public EntityArgument instantiate(CommandBuildContext commandRegistryAccess) {
                return new EntityArgument(this.single, this.playersOnly);
            }

            @Override
            public ArgumentTypeInfo<EntityArgument, ?> type() {
                return Info.this;
            }
        }
    }
}

