/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.collect.Lists;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class NbtPathArgument
implements ArgumentType<NbtPath> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo.bar", "foo[0]", "[0]", "[]", "{foo=bar}");
    public static final SimpleCommandExceptionType ERROR_INVALID_NODE = new SimpleCommandExceptionType((Message)Component.translatable("arguments.nbtpath.node.invalid"));
    public static final SimpleCommandExceptionType ERROR_DATA_TOO_DEEP = new SimpleCommandExceptionType((Message)Component.translatable("arguments.nbtpath.too_deep"));
    public static final DynamicCommandExceptionType ERROR_NOTHING_FOUND = new DynamicCommandExceptionType(path -> Component.translatableEscape("arguments.nbtpath.nothing_found", path));
    static final DynamicCommandExceptionType ERROR_EXPECTED_LIST = new DynamicCommandExceptionType(nbt -> Component.translatableEscape("commands.data.modify.expected_list", nbt));
    static final DynamicCommandExceptionType ERROR_INVALID_INDEX = new DynamicCommandExceptionType(index -> Component.translatableEscape("commands.data.modify.invalid_index", index));
    private static final char INDEX_MATCH_START = '[';
    private static final char INDEX_MATCH_END = ']';
    private static final char KEY_MATCH_START = '{';
    private static final char KEY_MATCH_END = '}';
    private static final char QUOTED_KEY_START = '\"';
    private static final char SINGLE_QUOTED_KEY_START = '\'';

    public static NbtPathArgument nbtPath() {
        return new NbtPathArgument();
    }

    public static NbtPath getPath(CommandContext<CommandSourceStack> context, String name) {
        return (NbtPath)context.getArgument(name, NbtPath.class);
    }

    public NbtPath parse(StringReader stringReader) throws CommandSyntaxException {
        ArrayList list = Lists.newArrayList();
        int i = stringReader.getCursor();
        Object2IntOpenHashMap object2IntMap = new Object2IntOpenHashMap();
        boolean bl = true;
        while (stringReader.canRead() && stringReader.peek() != ' ') {
            char c;
            Node node = NbtPathArgument.parseNode(stringReader, bl);
            list.add(node);
            object2IntMap.put((Object)node, stringReader.getCursor() - i);
            bl = false;
            if (!stringReader.canRead() || (c = stringReader.peek()) == ' ' || c == '[' || c == '{') continue;
            stringReader.expect('.');
        }
        return new NbtPath(stringReader.getString().substring(i, stringReader.getCursor()), list.toArray(new Node[0]), (Object2IntMap<Node>)object2IntMap);
    }

    private static Node parseNode(StringReader reader, boolean root) throws CommandSyntaxException {
        return switch (reader.peek()) {
            case '{' -> {
                if (!root) {
                    throw ERROR_INVALID_NODE.createWithContext((ImmutableStringReader)reader);
                }
                CompoundTag compoundTag = new TagParser(reader).readStruct();
                yield new MatchRootObjectNode(compoundTag);
            }
            case '[' -> {
                reader.skip();
                char i = reader.peek();
                if (i == '{') {
                    CompoundTag compoundTag2 = new TagParser(reader).readStruct();
                    reader.expect(']');
                    yield new MatchElementNode(compoundTag2);
                }
                if (i == ']') {
                    reader.skip();
                    yield AllElementsNode.INSTANCE;
                }
                int j = reader.readInt();
                reader.expect(']');
                yield new IndexedElementNode(j);
            }
            case '\"', '\'' -> NbtPathArgument.readObjectNode(reader, reader.readString());
            default -> NbtPathArgument.readObjectNode(reader, NbtPathArgument.readUnquotedName(reader));
        };
    }

    private static Node readObjectNode(StringReader reader, String name) throws CommandSyntaxException {
        if (reader.canRead() && reader.peek() == '{') {
            CompoundTag compoundTag = new TagParser(reader).readStruct();
            return new MatchObjectNode(name, compoundTag);
        }
        return new CompoundChildNode(name);
    }

    private static String readUnquotedName(StringReader reader) throws CommandSyntaxException {
        int i = reader.getCursor();
        while (reader.canRead() && NbtPathArgument.isAllowedInUnquotedName(reader.peek())) {
            reader.skip();
        }
        if (reader.getCursor() == i) {
            throw ERROR_INVALID_NODE.createWithContext((ImmutableStringReader)reader);
        }
        return reader.getString().substring(i, reader.getCursor());
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    private static boolean isAllowedInUnquotedName(char c) {
        return c != ' ' && c != '\"' && c != '\'' && c != '[' && c != ']' && c != '.' && c != '{' && c != '}';
    }

    static Predicate<Tag> createTagPredicate(CompoundTag filter) {
        return nbt -> NbtUtils.compareNbt(filter, nbt, true);
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static class NbtPath {
        private final String original;
        private final Object2IntMap<Node> nodeToOriginalPosition;
        private final Node[] nodes;
        public static final Codec<NbtPath> CODEC = Codec.STRING.comapFlatMap(path -> {
            try {
                NbtPath nbtPath = new NbtPathArgument().parse(new StringReader(path));
                return DataResult.success((Object)nbtPath);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                return DataResult.error(() -> "Failed to parse path " + path + ": " + commandSyntaxException.getMessage());
            }
        }, NbtPath::asString);

        public static NbtPath of(String path) throws CommandSyntaxException {
            return new NbtPathArgument().parse(new StringReader(path));
        }

        public NbtPath(String string, Node[] nodes, Object2IntMap<Node> nodeEndIndices) {
            this.original = string;
            this.nodes = nodes;
            this.nodeToOriginalPosition = nodeEndIndices;
        }

        public List<Tag> get(Tag element) throws CommandSyntaxException {
            List<Tag> list = Collections.singletonList(element);
            for (Node node : this.nodes) {
                if (!(list = node.get(list)).isEmpty()) continue;
                throw this.createNotFoundException(node);
            }
            return list;
        }

        public int countMatching(Tag element) {
            List<Tag> list = Collections.singletonList(element);
            for (Node node : this.nodes) {
                if (!(list = node.get(list)).isEmpty()) continue;
                return 0;
            }
            return list.size();
        }

        private List<Tag> getOrCreateParents(Tag start) throws CommandSyntaxException {
            List<Tag> list = Collections.singletonList(start);
            for (int i = 0; i < this.nodes.length - 1; ++i) {
                Node node = this.nodes[i];
                int j = i + 1;
                if (!(list = node.getOrCreate(list, this.nodes[j]::createPreferredParentTag)).isEmpty()) continue;
                throw this.createNotFoundException(node);
            }
            return list;
        }

        public List<Tag> getOrCreate(Tag element, Supplier<Tag> source) throws CommandSyntaxException {
            List<Tag> list = this.getOrCreateParents(element);
            Node node = this.nodes[this.nodes.length - 1];
            return node.getOrCreate(list, source);
        }

        private static int apply(List<Tag> elements, Function<Tag, Integer> operation) {
            return elements.stream().map(operation).reduce(0, (a, b) -> a + b);
        }

        public static boolean isTooDeep(Tag element, int depth) {
            block4: {
                block3: {
                    if (depth >= 512) {
                        return true;
                    }
                    if (!(element instanceof CompoundTag)) break block3;
                    CompoundTag compoundTag = (CompoundTag)element;
                    for (String string : compoundTag.getAllKeys()) {
                        Tag tag = compoundTag.get(string);
                        if (tag == null || !NbtPath.isTooDeep(tag, depth + 1)) continue;
                        return true;
                    }
                    break block4;
                }
                if (!(element instanceof ListTag)) break block4;
                ListTag listTag = (ListTag)element;
                for (Tag tag2 : listTag) {
                    if (!NbtPath.isTooDeep(tag2, depth + 1)) continue;
                    return true;
                }
            }
            return false;
        }

        public int set(Tag element, Tag source) throws CommandSyntaxException {
            if (NbtPath.isTooDeep(source, this.estimatePathDepth())) {
                throw ERROR_DATA_TOO_DEEP.create();
            }
            Tag tag = source.copy();
            List<Tag> list = this.getOrCreateParents(element);
            if (list.isEmpty()) {
                return 0;
            }
            Node node = this.nodes[this.nodes.length - 1];
            MutableBoolean mutableBoolean = new MutableBoolean(false);
            return NbtPath.apply(list, nbt -> node.setTag((Tag)nbt, () -> {
                if (mutableBoolean.isFalse()) {
                    mutableBoolean.setTrue();
                    return tag;
                }
                return tag.copy();
            }));
        }

        private int estimatePathDepth() {
            return this.nodes.length;
        }

        public int insert(int index, CompoundTag compound, List<Tag> elements) throws CommandSyntaxException {
            ArrayList<Tag> list = new ArrayList<Tag>(elements.size());
            for (Tag tag : elements) {
                Tag tag2 = tag.copy();
                list.add(tag2);
                if (!NbtPath.isTooDeep(tag2, this.estimatePathDepth())) continue;
                throw ERROR_DATA_TOO_DEEP.create();
            }
            List<Tag> collection = this.getOrCreate(compound, ListTag::new);
            int i = 0;
            boolean bl = false;
            for (Tag tag3 : collection) {
                if (!(tag3 instanceof CollectionTag)) {
                    throw ERROR_EXPECTED_LIST.create((Object)tag3);
                }
                CollectionTag collectionTag = (CollectionTag)tag3;
                boolean bl2 = false;
                int j = index < 0 ? collectionTag.size() + index + 1 : index;
                for (Tag tag4 : list) {
                    try {
                        if (!collectionTag.addTag(j, bl ? tag4.copy() : tag4)) continue;
                        ++j;
                        bl2 = true;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        throw ERROR_INVALID_INDEX.create((Object)j);
                    }
                }
                bl = true;
                i += bl2 ? 1 : 0;
            }
            return i;
        }

        public int remove(Tag element) {
            List<Tag> list = Collections.singletonList(element);
            for (int i = 0; i < this.nodes.length - 1; ++i) {
                list = this.nodes[i].get(list);
            }
            Node node = this.nodes[this.nodes.length - 1];
            return NbtPath.apply(list, node::removeTag);
        }

        private CommandSyntaxException createNotFoundException(Node node) {
            int i = this.nodeToOriginalPosition.getInt((Object)node);
            return ERROR_NOTHING_FOUND.create((Object)this.original.substring(0, i));
        }

        @Override
        public String toString() {
            return this.original;
        }

        public String asString() {
            return this.original;
        }
    }

    static interface Node {
        public void getTag(Tag var1, List<Tag> var2);

        public void getOrCreateTag(Tag var1, Supplier<Tag> var2, List<Tag> var3);

        public Tag createPreferredParentTag();

        public int setTag(Tag var1, Supplier<Tag> var2);

        public int removeTag(Tag var1);

        default public List<Tag> get(List<Tag> elements) {
            return this.collect(elements, this::getTag);
        }

        default public List<Tag> getOrCreate(List<Tag> elements, Supplier<Tag> supplier) {
            return this.collect(elements, (current, results) -> this.getOrCreateTag((Tag)current, supplier, (List<Tag>)results));
        }

        default public List<Tag> collect(List<Tag> elements, BiConsumer<Tag, List<Tag>> action) {
            ArrayList list = Lists.newArrayList();
            for (Tag tag : elements) {
                action.accept(tag, list);
            }
            return list;
        }
    }

    static class MatchRootObjectNode
    implements Node {
        private final Predicate<Tag> predicate;

        public MatchRootObjectNode(CompoundTag filter) {
            this.predicate = NbtPathArgument.createTagPredicate(filter);
        }

        @Override
        @Override
        public void getTag(Tag current, List<Tag> results) {
            if (current instanceof CompoundTag && this.predicate.test(current)) {
                results.add(current);
            }
        }

        @Override
        @Override
        public void getOrCreateTag(Tag current, Supplier<Tag> source, List<Tag> results) {
            this.getTag(current, results);
        }

        @Override
        @Override
        public Tag createPreferredParentTag() {
            return new CompoundTag();
        }

        @Override
        @Override
        public int setTag(Tag current, Supplier<Tag> source) {
            return 0;
        }

        @Override
        @Override
        public int removeTag(Tag current) {
            return 0;
        }
    }

    static class MatchElementNode
    implements Node {
        private final CompoundTag pattern;
        private final Predicate<Tag> predicate;

        public MatchElementNode(CompoundTag filter) {
            this.pattern = filter;
            this.predicate = NbtPathArgument.createTagPredicate(filter);
        }

        @Override
        @Override
        public void getTag(Tag current, List<Tag> results) {
            if (current instanceof ListTag) {
                ListTag listTag = (ListTag)current;
                listTag.stream().filter(this.predicate).forEach(results::add);
            }
        }

        @Override
        @Override
        public void getOrCreateTag(Tag current, Supplier<Tag> source, List<Tag> results) {
            MutableBoolean mutableBoolean = new MutableBoolean();
            if (current instanceof ListTag) {
                ListTag listTag = (ListTag)current;
                listTag.stream().filter(this.predicate).forEach(nbt -> {
                    results.add((Tag)nbt);
                    mutableBoolean.setTrue();
                });
                if (mutableBoolean.isFalse()) {
                    CompoundTag compoundTag = this.pattern.copy();
                    listTag.add(compoundTag);
                    results.add(compoundTag);
                }
            }
        }

        @Override
        @Override
        public Tag createPreferredParentTag() {
            return new ListTag();
        }

        @Override
        @Override
        public int setTag(Tag current, Supplier<Tag> source) {
            int i = 0;
            if (current instanceof ListTag) {
                ListTag listTag = (ListTag)current;
                int j = listTag.size();
                if (j == 0) {
                    listTag.add(source.get());
                    ++i;
                } else {
                    for (int k = 0; k < j; ++k) {
                        Tag tag2;
                        Tag tag = listTag.get(k);
                        if (!this.predicate.test(tag) || (tag2 = source.get()).equals(tag) || !listTag.setTag(k, tag2)) continue;
                        ++i;
                    }
                }
            }
            return i;
        }

        @Override
        @Override
        public int removeTag(Tag current) {
            int i = 0;
            if (current instanceof ListTag) {
                ListTag listTag = (ListTag)current;
                for (int j = listTag.size() - 1; j >= 0; --j) {
                    if (!this.predicate.test(listTag.get(j))) continue;
                    listTag.remove(j);
                    ++i;
                }
            }
            return i;
        }
    }

    static class AllElementsNode
    implements Node {
        public static final AllElementsNode INSTANCE = new AllElementsNode();

        private AllElementsNode() {
        }

        @Override
        @Override
        public void getTag(Tag current, List<Tag> results) {
            if (current instanceof CollectionTag) {
                results.addAll((CollectionTag)current);
            }
        }

        @Override
        @Override
        public void getOrCreateTag(Tag current, Supplier<Tag> source, List<Tag> results) {
            if (current instanceof CollectionTag) {
                CollectionTag collectionTag = (CollectionTag)current;
                if (collectionTag.isEmpty()) {
                    Tag tag = source.get();
                    if (collectionTag.addTag(0, tag)) {
                        results.add(tag);
                    }
                } else {
                    results.addAll(collectionTag);
                }
            }
        }

        @Override
        @Override
        public Tag createPreferredParentTag() {
            return new ListTag();
        }

        @Override
        @Override
        public int setTag(Tag current, Supplier<Tag> source) {
            if (current instanceof CollectionTag) {
                CollectionTag collectionTag = (CollectionTag)current;
                int i = collectionTag.size();
                if (i == 0) {
                    collectionTag.addTag(0, source.get());
                    return 1;
                }
                Tag tag = source.get();
                int j = i - (int)collectionTag.stream().filter((Predicate<Tag>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lnet/minecraft/nbt/Tag;)Z)((Tag)tag)).count();
                if (j == 0) {
                    return 0;
                }
                collectionTag.clear();
                if (!collectionTag.addTag(0, tag)) {
                    return 0;
                }
                for (int k = 1; k < i; ++k) {
                    collectionTag.addTag(k, source.get());
                }
                return j;
            }
            return 0;
        }

        @Override
        @Override
        public int removeTag(Tag current) {
            CollectionTag collectionTag;
            int i;
            if (current instanceof CollectionTag && (i = (collectionTag = (CollectionTag)current).size()) > 0) {
                collectionTag.clear();
                return i;
            }
            return 0;
        }
    }

    static class IndexedElementNode
    implements Node {
        private final int index;

        public IndexedElementNode(int index) {
            this.index = index;
        }

        @Override
        @Override
        public void getTag(Tag current, List<Tag> results) {
            if (current instanceof CollectionTag) {
                int j;
                CollectionTag collectionTag = (CollectionTag)current;
                int i = collectionTag.size();
                int n = j = this.index < 0 ? i + this.index : this.index;
                if (0 <= j && j < i) {
                    results.add((Tag)collectionTag.get(j));
                }
            }
        }

        @Override
        @Override
        public void getOrCreateTag(Tag current, Supplier<Tag> source, List<Tag> results) {
            this.getTag(current, results);
        }

        @Override
        @Override
        public Tag createPreferredParentTag() {
            return new ListTag();
        }

        @Override
        @Override
        public int setTag(Tag current, Supplier<Tag> source) {
            if (current instanceof CollectionTag) {
                int j;
                CollectionTag collectionTag = (CollectionTag)current;
                int i = collectionTag.size();
                int n = j = this.index < 0 ? i + this.index : this.index;
                if (0 <= j && j < i) {
                    Tag tag = (Tag)collectionTag.get(j);
                    Tag tag2 = source.get();
                    if (!tag2.equals(tag) && collectionTag.setTag(j, tag2)) {
                        return 1;
                    }
                }
            }
            return 0;
        }

        @Override
        @Override
        public int removeTag(Tag current) {
            if (current instanceof CollectionTag) {
                int j;
                CollectionTag collectionTag = (CollectionTag)current;
                int i = collectionTag.size();
                int n = j = this.index < 0 ? i + this.index : this.index;
                if (0 <= j && j < i) {
                    collectionTag.remove(j);
                    return 1;
                }
            }
            return 0;
        }
    }

    static class MatchObjectNode
    implements Node {
        private final String name;
        private final CompoundTag pattern;
        private final Predicate<Tag> predicate;

        public MatchObjectNode(String name, CompoundTag filter) {
            this.name = name;
            this.pattern = filter;
            this.predicate = NbtPathArgument.createTagPredicate(filter);
        }

        @Override
        @Override
        public void getTag(Tag current, List<Tag> results) {
            Tag tag;
            if (current instanceof CompoundTag && this.predicate.test(tag = ((CompoundTag)current).get(this.name))) {
                results.add(tag);
            }
        }

        @Override
        @Override
        public void getOrCreateTag(Tag current, Supplier<Tag> source, List<Tag> results) {
            if (current instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)current;
                Tag tag = compoundTag.get(this.name);
                if (tag == null) {
                    tag = this.pattern.copy();
                    compoundTag.put(this.name, tag);
                    results.add(tag);
                } else if (this.predicate.test(tag)) {
                    results.add(tag);
                }
            }
        }

        @Override
        @Override
        public Tag createPreferredParentTag() {
            return new CompoundTag();
        }

        @Override
        @Override
        public int setTag(Tag current, Supplier<Tag> source) {
            Tag tag2;
            CompoundTag compoundTag;
            Tag tag;
            if (current instanceof CompoundTag && this.predicate.test(tag = (compoundTag = (CompoundTag)current).get(this.name)) && !(tag2 = source.get()).equals(tag)) {
                compoundTag.put(this.name, tag2);
                return 1;
            }
            return 0;
        }

        @Override
        @Override
        public int removeTag(Tag current) {
            CompoundTag compoundTag;
            Tag tag;
            if (current instanceof CompoundTag && this.predicate.test(tag = (compoundTag = (CompoundTag)current).get(this.name))) {
                compoundTag.remove(this.name);
                return 1;
            }
            return 0;
        }
    }

    static class CompoundChildNode
    implements Node {
        private final String name;

        public CompoundChildNode(String name) {
            this.name = name;
        }

        @Override
        @Override
        public void getTag(Tag current, List<Tag> results) {
            Tag tag;
            if (current instanceof CompoundTag && (tag = ((CompoundTag)current).get(this.name)) != null) {
                results.add(tag);
            }
        }

        @Override
        @Override
        public void getOrCreateTag(Tag current, Supplier<Tag> source, List<Tag> results) {
            if (current instanceof CompoundTag) {
                Tag tag2;
                CompoundTag compoundTag = (CompoundTag)current;
                if (compoundTag.contains(this.name)) {
                    Tag tag = compoundTag.get(this.name);
                } else {
                    tag2 = source.get();
                    compoundTag.put(this.name, tag2);
                }
                results.add(tag2);
            }
        }

        @Override
        @Override
        public Tag createPreferredParentTag() {
            return new CompoundTag();
        }

        @Override
        @Override
        public int setTag(Tag current, Supplier<Tag> source) {
            if (current instanceof CompoundTag) {
                Tag tag2;
                CompoundTag compoundTag = (CompoundTag)current;
                Tag tag = source.get();
                if (!tag.equals(tag2 = compoundTag.put(this.name, tag))) {
                    return 1;
                }
            }
            return 0;
        }

        @Override
        @Override
        public int removeTag(Tag current) {
            CompoundTag compoundTag;
            if (current instanceof CompoundTag && (compoundTag = (CompoundTag)current).contains(this.name)) {
                compoundTag.remove(this.name);
                return 1;
            }
            return 0;
        }
    }
}

