/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;

public final class DataComponentPatch {
    public static final DataComponentPatch EMPTY = new DataComponentPatch(Reference2ObjectMaps.emptyMap());
    public static final Codec<DataComponentPatch> CODEC = Codec.dispatchedMap(PatchKey.CODEC, PatchKey::valueCodec).xmap(map -> {
        if (map.isEmpty()) {
            return EMPTY;
        }
        Reference2ObjectArrayMap reference2objectmap = new Reference2ObjectArrayMap(map.size());
        for (Map.Entry entry : map.entrySet()) {
            PatchKey datacomponentpatch_b = (PatchKey)entry.getKey();
            if (datacomponentpatch_b.removed()) {
                reference2objectmap.put(datacomponentpatch_b.type(), Optional.empty());
                continue;
            }
            reference2objectmap.put(datacomponentpatch_b.type(), Optional.of(entry.getValue()));
        }
        return new DataComponentPatch((Reference2ObjectMap<DataComponentType<?>, Optional<?>>)reference2objectmap);
    }, datacomponentpatch -> {
        Reference2ObjectArrayMap reference2objectmap = new Reference2ObjectArrayMap(datacomponentpatch.map.size());
        for (Map.Entry entry : Reference2ObjectMaps.fastIterable(datacomponentpatch.map)) {
            DataComponentType datacomponenttype = (DataComponentType)entry.getKey();
            if (datacomponenttype.isTransient()) continue;
            Optional optional = (Optional)entry.getValue();
            if (optional.isPresent()) {
                reference2objectmap.put((Object)new PatchKey(datacomponenttype, false), optional.get());
                continue;
            }
            reference2objectmap.put((Object)new PatchKey(datacomponenttype, true), (Object)Unit.INSTANCE);
        }
        return reference2objectmap;
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, DataComponentPatch> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, DataComponentPatch>(){

        @Override
        public DataComponentPatch decode(RegistryFriendlyByteBuf registryfriendlybytebuf) {
            DataComponentType datacomponenttype;
            int l;
            int i = registryfriendlybytebuf.readVarInt();
            int j = registryfriendlybytebuf.readVarInt();
            if (i == 0 && j == 0) {
                return EMPTY;
            }
            int k = i + j;
            Reference2ObjectArrayMap reference2objectmap = new Reference2ObjectArrayMap(Math.min(k, 65536));
            for (l = 0; l < i; ++l) {
                datacomponenttype = (DataComponentType)DataComponentType.STREAM_CODEC.decode(registryfriendlybytebuf);
                Object object = datacomponenttype.streamCodec().decode(registryfriendlybytebuf);
                reference2objectmap.put((Object)datacomponenttype, Optional.of(object));
            }
            for (l = 0; l < j; ++l) {
                datacomponenttype = (DataComponentType)DataComponentType.STREAM_CODEC.decode(registryfriendlybytebuf);
                reference2objectmap.put((Object)datacomponenttype, Optional.empty());
            }
            return new DataComponentPatch((Reference2ObjectMap<DataComponentType<?>, Optional<?>>)reference2objectmap);
        }

        @Override
        public void encode(RegistryFriendlyByteBuf registryfriendlybytebuf, DataComponentPatch datacomponentpatch) {
            if (datacomponentpatch.isEmpty()) {
                registryfriendlybytebuf.writeVarInt(0);
                registryfriendlybytebuf.writeVarInt(0);
            } else {
                int i = 0;
                int j = 0;
                for (Reference2ObjectMap.Entry it_unimi_dsi_fastutil_objects_reference2objectmap_entry : Reference2ObjectMaps.fastIterable(datacomponentpatch.map)) {
                    if (((Optional)it_unimi_dsi_fastutil_objects_reference2objectmap_entry.getValue()).isPresent()) {
                        ++i;
                        continue;
                    }
                    ++j;
                }
                registryfriendlybytebuf.writeVarInt(i);
                registryfriendlybytebuf.writeVarInt(j);
                for (Reference2ObjectMap.Entry it_unimi_dsi_fastutil_objects_reference2objectmap_entry : Reference2ObjectMaps.fastIterable(datacomponentpatch.map)) {
                    Optional optional = (Optional)it_unimi_dsi_fastutil_objects_reference2objectmap_entry.getValue();
                    if (!optional.isPresent()) continue;
                    DataComponentType datacomponenttype = (DataComponentType)it_unimi_dsi_fastutil_objects_reference2objectmap_entry.getKey();
                    DataComponentType.STREAM_CODEC.encode(registryfriendlybytebuf, datacomponenttype);
                    1.encodeComponent(registryfriendlybytebuf, datacomponenttype, optional.get());
                }
                for (Reference2ObjectMap.Entry it_unimi_dsi_fastutil_objects_reference2objectmap_entry : Reference2ObjectMaps.fastIterable(datacomponentpatch.map)) {
                    if (!((Optional)it_unimi_dsi_fastutil_objects_reference2objectmap_entry.getValue()).isEmpty()) continue;
                    DataComponentType datacomponenttype1 = (DataComponentType)it_unimi_dsi_fastutil_objects_reference2objectmap_entry.getKey();
                    DataComponentType.STREAM_CODEC.encode(registryfriendlybytebuf, datacomponenttype1);
                }
            }
        }

        private static <T> void encodeComponent(RegistryFriendlyByteBuf buf, DataComponentType<T> type, Object value) {
            try {
                type.streamCodec().encode(buf, value);
            }
            catch (Exception e) {
                throw new RuntimeException("Error encoding component " + String.valueOf(type), e);
            }
        }
    };
    private static final String REMOVED_PREFIX = "!";
    final Reference2ObjectMap<DataComponentType<?>, Optional<?>> map;

    DataComponentPatch(Reference2ObjectMap<DataComponentType<?>, Optional<?>> changedComponents) {
        this.map = changedComponents;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    public <T> Optional<? extends T> get(DataComponentType<? extends T> type) {
        return (Optional)this.map.get(type);
    }

    public Set<Map.Entry<DataComponentType<?>, Optional<?>>> entrySet() {
        return this.map.entrySet();
    }

    public int size() {
        return this.map.size();
    }

    public DataComponentPatch forget(Predicate<DataComponentType<?>> removedTypePredicate) {
        if (this.isEmpty()) {
            return EMPTY;
        }
        Reference2ObjectArrayMap reference2objectmap = new Reference2ObjectArrayMap(this.map);
        reference2objectmap.keySet().removeIf(removedTypePredicate);
        return reference2objectmap.isEmpty() ? EMPTY : new DataComponentPatch((Reference2ObjectMap<DataComponentType<?>, Optional<?>>)reference2objectmap);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public SplitResult split() {
        if (this.isEmpty()) {
            return SplitResult.EMPTY;
        }
        DataComponentMap.Builder datacomponentmap_a = DataComponentMap.builder();
        Set set = Sets.newIdentityHashSet();
        this.map.forEach((datacomponenttype, optional) -> {
            if (optional.isPresent()) {
                datacomponentmap_a.setUnchecked(datacomponenttype, optional.get());
            } else {
                set.add(datacomponenttype);
            }
        });
        return new SplitResult(datacomponentmap_a.build(), set);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DataComponentPatch) {
            DataComponentPatch datacomponentpatch = (DataComponentPatch)object;
            if (this.map.equals(datacomponentpatch.map)) {
                boolean flag = true;
                return flag;
            }
        }
        boolean flag = false;
        return flag;
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return DataComponentPatch.toString(this.map);
    }

    static String toString(Reference2ObjectMap<DataComponentType<?>, Optional<?>> changes) {
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append('{');
        boolean flag = true;
        for (Map.Entry entry : Reference2ObjectMaps.fastIterable(changes)) {
            if (flag) {
                flag = false;
            } else {
                stringbuilder.append(", ");
            }
            Optional optional = (Optional)entry.getValue();
            if (optional.isPresent()) {
                stringbuilder.append(entry.getKey());
                stringbuilder.append("=>");
                stringbuilder.append(optional.get());
                continue;
            }
            stringbuilder.append(REMOVED_PREFIX);
            stringbuilder.append(entry.getKey());
        }
        stringbuilder.append('}');
        return stringbuilder.toString();
    }

    public static class Builder {
        private final Reference2ObjectMap<DataComponentType<?>, Optional<?>> map = new Reference2ObjectArrayMap();

        Builder() {
        }

        public void copy(DataComponentPatch orig) {
            this.map.putAll(orig.map);
        }

        public void clear(DataComponentType<?> type) {
            this.map.remove(type);
        }

        public boolean isSet(DataComponentType<?> type) {
            return this.map.containsKey(type);
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Builder) {
                Builder patch = (Builder)object;
                return this.map.equals(patch.map);
            }
            return false;
        }

        public int hashCode() {
            return this.map.hashCode();
        }

        public <T> Builder set(DataComponentType<T> type, T value) {
            this.map.put(type, Optional.of(value));
            return this;
        }

        public <T> Builder remove(DataComponentType<T> type) {
            this.map.put(type, Optional.empty());
            return this;
        }

        public <T> Builder set(TypedDataComponent<T> component) {
            return this.set(component.type(), component.value());
        }

        public DataComponentPatch build() {
            return this.map.isEmpty() ? EMPTY : new DataComponentPatch(this.map);
        }
    }

    public record SplitResult(DataComponentMap added, Set<DataComponentType<?>> removed) {
        public static final SplitResult EMPTY = new SplitResult(DataComponentMap.EMPTY, Set.of());
    }

    private record PatchKey(DataComponentType<?> type, boolean removed) {
        public static final Codec<PatchKey> CODEC = Codec.STRING.flatXmap(s -> {
            ResourceLocation minecraftkey;
            DataComponentType<?> datacomponenttype;
            boolean flag = s.startsWith(DataComponentPatch.REMOVED_PREFIX);
            if (flag) {
                s = s.substring(DataComponentPatch.REMOVED_PREFIX.length());
            }
            return (datacomponenttype = BuiltInRegistries.DATA_COMPONENT_TYPE.get(minecraftkey = ResourceLocation.tryParse(s))) == null ? DataResult.error(() -> "No component with type: '" + String.valueOf(minecraftkey) + "'") : (datacomponenttype.isTransient() ? DataResult.error(() -> "'" + String.valueOf(minecraftkey) + "' is not a persistent component") : DataResult.success((Object)new PatchKey(datacomponenttype, flag)));
        }, datacomponentpatch_b -> {
            DataComponentType<?> datacomponenttype = datacomponentpatch_b.type();
            ResourceLocation minecraftkey = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey(datacomponenttype);
            return minecraftkey == null ? DataResult.error(() -> "Unregistered component: " + String.valueOf(datacomponenttype)) : DataResult.success((Object)(datacomponentpatch_b.removed() ? DataComponentPatch.REMOVED_PREFIX + String.valueOf(minecraftkey) : minecraftkey.toString()));
        });

        public Codec<?> valueCodec() {
            return this.removed ? Codec.EMPTY.codec() : this.type.codecOrThrow();
        }
    }
}

