/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.models.blockstates;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public interface Condition
extends Supplier<JsonElement> {
    public void validate(StateDefinition<?, ?> var1);

    public static TerminalCondition condition() {
        return new TerminalCondition();
    }

    public static Condition and(Condition ... conditions) {
        return new CompositeCondition(Operation.AND, Arrays.asList(conditions));
    }

    public static Condition or(Condition ... conditions) {
        return new CompositeCondition(Operation.OR, Arrays.asList(conditions));
    }

    public static class TerminalCondition
    implements Condition {
        private final Map<Property<?>, String> terms = Maps.newHashMap();

        private static <T extends Comparable<T>> String joinValues(Property<T> property, Stream<T> valueStream) {
            return valueStream.map(property::getName).collect(Collectors.joining("|"));
        }

        private static <T extends Comparable<T>> String getTerm(Property<T> property, T value, T[] otherValues) {
            return TerminalCondition.joinValues(property, Stream.concat(Stream.of(value), Stream.of(otherValues)));
        }

        private <T extends Comparable<T>> void putValue(Property<T> property, String value) {
            String string = this.terms.put(property, value);
            if (string != null) {
                throw new IllegalStateException("Tried to replace " + String.valueOf(property) + " value from " + string + " to " + value);
            }
        }

        public final <T extends Comparable<T>> TerminalCondition term(Property<T> property, T value) {
            this.putValue(property, property.getName(value));
            return this;
        }

        @SafeVarargs
        public final <T extends Comparable<T>> TerminalCondition term(Property<T> property, T value, T ... otherValues) {
            this.putValue(property, TerminalCondition.getTerm(property, value, otherValues));
            return this;
        }

        public final <T extends Comparable<T>> TerminalCondition negatedTerm(Property<T> property, T value) {
            this.putValue(property, "!" + property.getName(value));
            return this;
        }

        @SafeVarargs
        public final <T extends Comparable<T>> TerminalCondition negatedTerm(Property<T> property, T value, T ... otherValues) {
            this.putValue(property, "!" + TerminalCondition.getTerm(property, value, otherValues));
            return this;
        }

        @Override
        @Override
        public JsonElement get() {
            JsonObject jsonObject = new JsonObject();
            this.terms.forEach((property, value) -> jsonObject.addProperty(property.getName(), value));
            return jsonObject;
        }

        @Override
        @Override
        public void validate(StateDefinition<?, ?> stateManager) {
            List list = this.terms.keySet().stream().filter(property -> stateManager.getProperty(property.getName()) != property).collect(Collectors.toList());
            if (!list.isEmpty()) {
                throw new IllegalStateException("Properties " + String.valueOf(list) + " are missing from " + String.valueOf(stateManager));
            }
        }

        @Override
        public /* synthetic */ Object get() {
            return this.get();
        }
    }

    public static class CompositeCondition
    implements Condition {
        private final Operation operation;
        private final List<Condition> subconditions;

        CompositeCondition(Operation operator, List<Condition> components) {
            this.operation = operator;
            this.subconditions = components;
        }

        @Override
        @Override
        public void validate(StateDefinition<?, ?> stateManager) {
            this.subconditions.forEach(component -> component.validate(stateManager));
        }

        @Override
        @Override
        public JsonElement get() {
            JsonArray jsonArray = new JsonArray();
            this.subconditions.stream().map(Supplier::get).forEach(arg_0 -> ((JsonArray)jsonArray).add(arg_0));
            JsonObject jsonObject = new JsonObject();
            jsonObject.add(this.operation.id, (JsonElement)jsonArray);
            return jsonObject;
        }

        @Override
        public /* synthetic */ Object get() {
            return this.get();
        }
    }

    public static enum Operation {
        AND("AND"),
        OR("OR");

        final String id;

        private Operation(String name) {
            this.id = name;
        }
    }
}

