/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagVisitor;
import org.apache.commons.lang3.ArrayUtils;

public class LongArrayTag
extends CollectionTag<LongTag> {
    private static final int SELF_SIZE_IN_BYTES = 24;
    public static final TagType<LongArrayTag> TYPE = new TagType.VariableSize<LongArrayTag>(){

        @Override
        @Override
        public LongArrayTag load(DataInput dataInput, NbtAccounter nbtAccounter) throws IOException {
            return new LongArrayTag(1.readAccounted(dataInput, nbtAccounter));
        }

        @Override
        @Override
        public StreamTagVisitor.ValueResult parse(DataInput input, StreamTagVisitor visitor, NbtAccounter tracker) throws IOException {
            return visitor.visit(1.readAccounted(input, tracker));
        }

        private static long[] readAccounted(DataInput input, NbtAccounter tracker) throws IOException {
            tracker.accountBytes(24L);
            int i = input.readInt();
            tracker.accountBytes(8L, i);
            long[] ls = new long[i];
            for (int j = 0; j < i; ++j) {
                ls[j] = input.readLong();
            }
            return ls;
        }

        @Override
        @Override
        public void skip(DataInput input, NbtAccounter tracker) throws IOException {
            input.skipBytes(input.readInt() * 8);
        }

        @Override
        @Override
        public String getName() {
            return "LONG[]";
        }

        @Override
        @Override
        public String getPrettyName() {
            return "TAG_Long_Array";
        }

        @Override
        public /* synthetic */ Tag load(DataInput input, NbtAccounter tracker) throws IOException {
            return this.load(input, tracker);
        }
    };
    private long[] data;

    public LongArrayTag(long[] value) {
        this.data = value;
    }

    public LongArrayTag(LongSet value) {
        this.data = value.toLongArray();
    }

    public LongArrayTag(List<Long> value) {
        this(LongArrayTag.toArray(value));
    }

    private static long[] toArray(List<Long> list) {
        long[] ls = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Long long_ = list.get(i);
            ls[i] = long_ == null ? 0L : long_;
        }
        return ls;
    }

    @Override
    @Override
    public void write(DataOutput output) throws IOException {
        output.writeInt(this.data.length);
        for (long l : this.data) {
            output.writeLong(l);
        }
    }

    @Override
    @Override
    public int sizeInBytes() {
        return 24 + 8 * this.data.length;
    }

    @Override
    @Override
    public byte getId() {
        return 12;
    }

    @Override
    public TagType<LongArrayTag> getType() {
        return TYPE;
    }

    @Override
    @Override
    public String toString() {
        return this.getAsString();
    }

    @Override
    @Override
    public LongArrayTag copy() {
        long[] ls = new long[this.data.length];
        System.arraycopy(this.data, 0, ls, 0, this.data.length);
        return new LongArrayTag(ls);
    }

    @Override
    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof LongArrayTag && Arrays.equals(this.data, ((LongArrayTag)object).data);
    }

    @Override
    @Override
    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    @Override
    @Override
    public void accept(TagVisitor visitor) {
        visitor.visitLongArray(this);
    }

    public long[] getAsLongArray() {
        return this.data;
    }

    @Override
    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    @Override
    public LongTag get(int i) {
        return LongTag.valueOf(this.data[i]);
    }

    @Override
    @Override
    public LongTag set(int i, LongTag longTag) {
        long l = this.data[i];
        this.data[i] = longTag.getAsLong();
        return LongTag.valueOf(l);
    }

    @Override
    @Override
    public void add(int i, LongTag longTag) {
        this.data = ArrayUtils.add((long[])this.data, (int)i, (long)longTag.getAsLong());
    }

    @Override
    @Override
    public boolean setTag(int index, Tag element) {
        if (element instanceof NumericTag) {
            this.data[index] = ((NumericTag)element).getAsLong();
            return true;
        }
        return false;
    }

    @Override
    @Override
    public boolean addTag(int index, Tag element) {
        if (element instanceof NumericTag) {
            this.data = ArrayUtils.add((long[])this.data, (int)index, (long)((NumericTag)element).getAsLong());
            return true;
        }
        return false;
    }

    @Override
    @Override
    public LongTag remove(int i) {
        long l = this.data[i];
        this.data = ArrayUtils.remove((long[])this.data, (int)i);
        return LongTag.valueOf(l);
    }

    @Override
    @Override
    public byte getElementType() {
        return 4;
    }

    @Override
    @Override
    public void clear() {
        this.data = new long[0];
    }

    @Override
    @Override
    public StreamTagVisitor.ValueResult accept(StreamTagVisitor visitor) {
        return visitor.visit(this.data);
    }

    @Override
    public /* synthetic */ Tag remove(int i) {
        return this.remove(i);
    }

    @Override
    public /* synthetic */ void add(int i, Tag tag) {
        this.add(i, (LongTag)tag);
    }

    @Override
    public /* synthetic */ Tag set(int i, Tag tag) {
        return this.set(i, (LongTag)tag);
    }

    @Override
    public /* synthetic */ Tag copy() {
        return this.copy();
    }

    @Override
    public /* synthetic */ Object remove(int i) {
        return this.remove(i);
    }

    @Override
    public /* synthetic */ void add(int i, Object object) {
        this.add(i, (LongTag)object);
    }

    @Override
    public /* synthetic */ Object set(int i, Object object) {
        return this.set(i, (LongTag)object);
    }

    @Override
    public /* synthetic */ Object get(int i) {
        return this.get(i);
    }
}

