/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt.visitors;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.visitors.CollectToTag;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.nbt.visitors.FieldTree;

public class CollectFields
extends CollectToTag {
    private int fieldsToGetCount;
    private final Set<TagType<?>> wantedTypes;
    private final Deque<FieldTree> stack = new ArrayDeque<FieldTree>();

    public CollectFields(FieldSelector ... queries) {
        this.fieldsToGetCount = queries.length;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        FieldTree fieldTree = FieldTree.createRoot();
        for (FieldSelector fieldSelector : queries) {
            fieldTree.addEntry(fieldSelector);
            builder.add(fieldSelector.type());
        }
        this.stack.push(fieldTree);
        builder.add(CompoundTag.TYPE);
        this.wantedTypes = builder.build();
    }

    @Override
    @Override
    public StreamTagVisitor.ValueResult visitRootEntry(TagType<?> rootType) {
        if (rootType != CompoundTag.TYPE) {
            return StreamTagVisitor.ValueResult.HALT;
        }
        return super.visitRootEntry(rootType);
    }

    @Override
    @Override
    public StreamTagVisitor.EntryResult visitEntry(TagType<?> type) {
        FieldTree fieldTree = this.stack.element();
        if (this.depth() > fieldTree.depth()) {
            return super.visitEntry(type);
        }
        if (this.fieldsToGetCount <= 0) {
            return StreamTagVisitor.EntryResult.HALT;
        }
        if (!this.wantedTypes.contains(type)) {
            return StreamTagVisitor.EntryResult.SKIP;
        }
        return super.visitEntry(type);
    }

    @Override
    @Override
    public StreamTagVisitor.EntryResult visitEntry(TagType<?> type, String key) {
        FieldTree fieldTree2;
        FieldTree fieldTree = this.stack.element();
        if (this.depth() > fieldTree.depth()) {
            return super.visitEntry(type, key);
        }
        if (fieldTree.selectedFields().remove(key, type)) {
            --this.fieldsToGetCount;
            return super.visitEntry(type, key);
        }
        if (type == CompoundTag.TYPE && (fieldTree2 = fieldTree.fieldsToRecurse().get(key)) != null) {
            this.stack.push(fieldTree2);
            return super.visitEntry(type, key);
        }
        return StreamTagVisitor.EntryResult.SKIP;
    }

    @Override
    @Override
    public StreamTagVisitor.ValueResult visitContainerEnd() {
        if (this.depth() == this.stack.element().depth()) {
            this.stack.pop();
        }
        return super.visitContainerEnd();
    }

    public int getMissingFieldCount() {
        return this.fieldsToGetCount;
    }
}

