/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import io.netty.buffer.ByteBuf;

public class VarInt {
    private static final int MAX_VARINT_SIZE = 5;
    private static final int DATA_BITS_MASK = 127;
    private static final int CONTINUATION_BIT_MASK = 128;
    private static final int DATA_BITS_PER_BYTE = 7;
    private static final int[] VARINT_EXACT_BYTE_LENGTHS = new int[33];

    public static int getByteSize(int i) {
        return VARINT_EXACT_BYTE_LENGTHS[Integer.numberOfLeadingZeros(i)];
    }

    public static int getByteSizeOld(int i) {
        for (int j = 1; j < 5; ++j) {
            if ((i & -1 << j * 7) != 0) continue;
            return j;
        }
        return 5;
    }

    public static boolean hasContinuationBit(byte b) {
        return (b & 0x80) == 128;
    }

    public static int read(ByteBuf buf) {
        byte b;
        int i = 0;
        int j = 0;
        do {
            b = buf.readByte();
            i |= (b & 0x7F) << j++ * 7;
            if (j <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while (VarInt.hasContinuationBit(b));
        return i;
    }

    public static ByteBuf write(ByteBuf buf, int i) {
        if ((i & 0xFFFFFF80) == 0) {
            buf.writeByte(i);
        } else if ((i & 0xFFFFC000) == 0) {
            int w = (i & 0x7F | 0x80) << 8 | i >>> 7;
            buf.writeShort(w);
        } else {
            VarInt.writeOld(buf, i);
        }
        return buf;
    }

    public static ByteBuf writeOld(ByteBuf buf, int i) {
        while ((i & 0xFFFFFF80) != 0) {
            buf.writeByte(i & 0x7F | 0x80);
            i >>>= 7;
        }
        buf.writeByte(i);
        return buf;
    }

    static {
        for (int i = 0; i <= 32; ++i) {
            VarInt.VARINT_EXACT_BYTE_LENGTHS[i] = (int)Math.ceil((31.0 - (double)(i - 1)) / 7.0);
        }
        VarInt.VARINT_EXACT_BYTE_LENGTHS[32] = 1;
    }
}

