/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.common.custom;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.DebugEntityNameGenerator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public record BeeDebugPayload(BeeInfo beeInfo) implements CustomPacketPayload
{
    public static final StreamCodec<FriendlyByteBuf, BeeDebugPayload> STREAM_CODEC = CustomPacketPayload.codec(BeeDebugPayload::write, BeeDebugPayload::new);
    public static final CustomPacketPayload.Type<BeeDebugPayload> TYPE = CustomPacketPayload.createType("debug/bee");

    private BeeDebugPayload(FriendlyByteBuf buf) {
        this(new BeeInfo(buf));
    }

    private void write(FriendlyByteBuf buf) {
        this.beeInfo.write(buf);
    }

    @Override
    public CustomPacketPayload.Type<BeeDebugPayload> type() {
        return TYPE;
    }

    public record BeeInfo(UUID uuid, int id, Vec3 pos, @Nullable Path path, @Nullable BlockPos hivePos, @Nullable BlockPos flowerPos, int travelTicks, Set<String> goals, List<BlockPos> blacklistedHives) {
        public BeeInfo(FriendlyByteBuf buf) {
            this(buf.readUUID(), buf.readInt(), buf.readVec3(), buf.readNullable(Path::createFromStream), buf.readNullable(BlockPos.STREAM_CODEC), buf.readNullable(BlockPos.STREAM_CODEC), buf.readInt(), buf.readCollection(HashSet::new, FriendlyByteBuf::readUtf), buf.readList(BlockPos.STREAM_CODEC));
        }

        public void write(FriendlyByteBuf buf2) {
            buf2.writeUUID(this.uuid);
            buf2.writeInt(this.id);
            buf2.writeVec3(this.pos);
            buf2.writeNullable(this.path, (buf, path) -> path.writeToStream((FriendlyByteBuf)((Object)buf)));
            buf2.writeNullable(this.hivePos, BlockPos.STREAM_CODEC);
            buf2.writeNullable(this.flowerPos, BlockPos.STREAM_CODEC);
            buf2.writeInt(this.travelTicks);
            buf2.writeCollection(this.goals, FriendlyByteBuf::writeUtf);
            buf2.writeCollection(this.blacklistedHives, BlockPos.STREAM_CODEC);
        }

        public boolean hasHive(BlockPos pos) {
            return Objects.equals(pos, this.hivePos);
        }

        public String generateName() {
            return DebugEntityNameGenerator.getEntityName(this.uuid);
        }

        @Override
        @Override
        public String toString() {
            return this.generateName();
        }
    }
}

