/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Queues;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.resources.ResourceLocation;

public class ClientboundCommandsPacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<FriendlyByteBuf, ClientboundCommandsPacket> STREAM_CODEC = Packet.codec(ClientboundCommandsPacket::write, ClientboundCommandsPacket::new);
    private static final byte MASK_TYPE = 3;
    private static final byte FLAG_EXECUTABLE = 4;
    private static final byte FLAG_REDIRECT = 8;
    private static final byte FLAG_CUSTOM_SUGGESTIONS = 16;
    private static final byte TYPE_ROOT = 0;
    private static final byte TYPE_LITERAL = 1;
    private static final byte TYPE_ARGUMENT = 2;
    private final int rootIndex;
    private final List<Entry> entries;

    public ClientboundCommandsPacket(RootCommandNode<SharedSuggestionProvider> rootNode) {
        Object2IntMap<CommandNode<SharedSuggestionProvider>> object2IntMap = ClientboundCommandsPacket.enumerateNodes(rootNode);
        this.entries = ClientboundCommandsPacket.createEntries(object2IntMap);
        this.rootIndex = object2IntMap.getInt(rootNode);
    }

    private ClientboundCommandsPacket(FriendlyByteBuf buf) {
        this.entries = buf.readList(ClientboundCommandsPacket::readNode);
        this.rootIndex = buf.readVarInt();
        ClientboundCommandsPacket.validateEntries(this.entries);
    }

    private void write(FriendlyByteBuf buf) {
        buf.writeCollection(this.entries, (buf2, node) -> node.write((FriendlyByteBuf)((Object)buf2)));
        buf.writeVarInt(this.rootIndex);
    }

    private static void validateEntries(List<Entry> nodeDatas, BiPredicate<Entry, IntSet> validator) {
        IntOpenHashSet intSet = new IntOpenHashSet((IntCollection)IntSets.fromTo((int)0, (int)nodeDatas.size()));
        while (!intSet.isEmpty()) {
            boolean bl = intSet.removeIf(arg_0 -> ClientboundCommandsPacket.lambda$validateEntries$1(validator, nodeDatas, (IntSet)intSet, arg_0));
            if (bl) continue;
            throw new IllegalStateException("Server sent an impossible command tree");
        }
    }

    private static void validateEntries(List<Entry> nodeDatas) {
        ClientboundCommandsPacket.validateEntries(nodeDatas, Entry::canBuild);
        ClientboundCommandsPacket.validateEntries(nodeDatas, Entry::canResolve);
    }

    private static Object2IntMap<CommandNode<SharedSuggestionProvider>> enumerateNodes(RootCommandNode<SharedSuggestionProvider> commandTree) {
        CommandNode commandNode;
        Object2IntOpenHashMap object2IntMap = new Object2IntOpenHashMap();
        ArrayDeque queue = Queues.newArrayDeque();
        queue.add(commandTree);
        while ((commandNode = (CommandNode)queue.poll()) != null) {
            if (object2IntMap.containsKey((Object)commandNode)) continue;
            int i = object2IntMap.size();
            object2IntMap.put((Object)commandNode, i);
            queue.addAll(commandNode.getChildren());
            if (commandNode.getRedirect() == null) continue;
            queue.add(commandNode.getRedirect());
        }
        return object2IntMap;
    }

    private static List<Entry> createEntries(Object2IntMap<CommandNode<SharedSuggestionProvider>> nodes) {
        ObjectArrayList objectArrayList = new ObjectArrayList(nodes.size());
        objectArrayList.size(nodes.size());
        for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(nodes)) {
            objectArrayList.set(entry.getIntValue(), (Object)ClientboundCommandsPacket.createEntry((CommandNode)entry.getKey(), nodes));
        }
        return objectArrayList;
    }

    private static Entry readNode(FriendlyByteBuf buf) {
        byte b = buf.readByte();
        int[] is = buf.readVarIntArray();
        int i = (b & 8) != 0 ? buf.readVarInt() : 0;
        NodeStub nodeStub = ClientboundCommandsPacket.read(buf, b);
        return new Entry(nodeStub, b, i, is);
    }

    @Nullable
    private static NodeStub read(FriendlyByteBuf buf, byte flags) {
        int i = flags & 3;
        if (i == 2) {
            String string = buf.readUtf();
            int j = buf.readVarInt();
            ArgumentTypeInfo argumentTypeInfo = (ArgumentTypeInfo)BuiltInRegistries.COMMAND_ARGUMENT_TYPE.byId(j);
            if (argumentTypeInfo == null) {
                return null;
            }
            Object template = argumentTypeInfo.deserializeFromNetwork(buf);
            ResourceLocation resourceLocation = (flags & 0x10) != 0 ? buf.readResourceLocation() : null;
            return new ArgumentNodeStub(string, (ArgumentTypeInfo.Template<?>)template, resourceLocation);
        }
        if (i == 1) {
            String string2 = buf.readUtf();
            return new LiteralNodeStub(string2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static Entry createEntry(CommandNode<SharedSuggestionProvider> node, Object2IntMap<CommandNode<SharedSuggestionProvider>> nodes) {
        void nodeStub4;
        int k;
        int i = 0;
        if (node.getRedirect() != null) {
            i |= 8;
            int j = nodes.getInt(node.getRedirect());
        } else {
            k = 0;
        }
        if (node.getCommand() != null) {
            i |= 4;
        }
        if (node instanceof RootCommandNode) {
            i |= 0;
            Object nodeStub = null;
        } else if (node instanceof ArgumentCommandNode) {
            ArgumentCommandNode argumentCommandNode = (ArgumentCommandNode)node;
            ArgumentNodeStub nodeStub2 = new ArgumentNodeStub(argumentCommandNode);
            i |= 2;
            if (argumentCommandNode.getCustomSuggestions() != null) {
                i |= 0x10;
            }
        } else if (node instanceof LiteralCommandNode) {
            LiteralCommandNode literalCommandNode = (LiteralCommandNode)node;
            LiteralNodeStub nodeStub3 = new LiteralNodeStub(literalCommandNode.getLiteral());
            i |= 1;
        } else {
            throw new UnsupportedOperationException("Unknown node type " + String.valueOf(node));
        }
        int[] is = node.getChildren().stream().mapToInt(arg_0 -> nodes.getInt(arg_0)).toArray();
        return new Entry((NodeStub)nodeStub4, i, k, is);
    }

    @Override
    @Override
    public PacketType<ClientboundCommandsPacket> type() {
        return GamePacketTypes.CLIENTBOUND_COMMANDS;
    }

    @Override
    @Override
    public void handle(ClientGamePacketListener listener) {
        listener.handleCommands(this);
    }

    public RootCommandNode<SharedSuggestionProvider> getRoot(CommandBuildContext commandRegistryAccess) {
        return (RootCommandNode)new NodeResolver(commandRegistryAccess, this.entries).resolve(this.rootIndex);
    }

    private static /* synthetic */ boolean lambda$validateEntries$1(BiPredicate index, List list, IntSet intSet, int i) {
        return index.test((Entry)list.get(i), intSet);
    }

    static class Entry {
        @Nullable
        final NodeStub stub;
        final int flags;
        final int redirect;
        final int[] children;

        Entry(@Nullable NodeStub suggestableNode, int flags, int redirectNodeIndex, int[] childNodeIndices) {
            this.stub = suggestableNode;
            this.flags = flags;
            this.redirect = redirectNodeIndex;
            this.children = childNodeIndices;
        }

        public void write(FriendlyByteBuf buf) {
            buf.writeByte(this.flags);
            buf.writeVarIntArray(this.children);
            if ((this.flags & 8) != 0) {
                buf.writeVarInt(this.redirect);
            }
            if (this.stub != null) {
                this.stub.write(buf);
            }
        }

        public boolean canBuild(IntSet indices) {
            if ((this.flags & 8) != 0) {
                return !indices.contains(this.redirect);
            }
            return true;
        }

        public boolean canResolve(IntSet indices) {
            for (int i : this.children) {
                if (!indices.contains(i)) continue;
                return false;
            }
            return true;
        }
    }

    static interface NodeStub {
        public ArgumentBuilder<SharedSuggestionProvider, ?> build(CommandBuildContext var1);

        public void write(FriendlyByteBuf var1);
    }

    static class ArgumentNodeStub
    implements NodeStub {
        private final String id;
        private final ArgumentTypeInfo.Template<?> argumentType;
        @Nullable
        private final ResourceLocation suggestionId;

        @Nullable
        private static ResourceLocation getSuggestionId(@Nullable SuggestionProvider<SharedSuggestionProvider> provider) {
            return provider != null ? SuggestionProviders.getName(provider) : null;
        }

        ArgumentNodeStub(String name, ArgumentTypeInfo.Template<?> properties, @Nullable ResourceLocation id) {
            this.id = name;
            this.argumentType = properties;
            this.suggestionId = id;
        }

        public ArgumentNodeStub(ArgumentCommandNode<SharedSuggestionProvider, ?> node) {
            this(node.getName(), ArgumentTypeInfos.unpack(node.getType()), ArgumentNodeStub.getSuggestionId((SuggestionProvider<SharedSuggestionProvider>)node.getCustomSuggestions()));
        }

        @Override
        @Override
        public ArgumentBuilder<SharedSuggestionProvider, ?> build(CommandBuildContext commandRegistryAccess) {
            Object argumentType = this.argumentType.instantiate(commandRegistryAccess);
            RequiredArgumentBuilder requiredArgumentBuilder = RequiredArgumentBuilder.argument((String)this.id, argumentType);
            if (this.suggestionId != null) {
                requiredArgumentBuilder.suggests(SuggestionProviders.getProvider(this.suggestionId));
            }
            return requiredArgumentBuilder;
        }

        @Override
        @Override
        public void write(FriendlyByteBuf buf) {
            buf.writeUtf(this.id);
            ArgumentNodeStub.serializeCap(buf, this.argumentType);
            if (this.suggestionId != null) {
                buf.writeResourceLocation(this.suggestionId);
            }
        }

        private static <A extends ArgumentType<?>> void serializeCap(FriendlyByteBuf buf, ArgumentTypeInfo.Template<A> properties) {
            ArgumentNodeStub.serializeCap(buf, properties.type(), properties);
        }

        private static <A extends ArgumentType<?>, T extends ArgumentTypeInfo.Template<A>> void serializeCap(FriendlyByteBuf buf, ArgumentTypeInfo<A, T> serializer, ArgumentTypeInfo.Template<A> properties) {
            buf.writeVarInt(BuiltInRegistries.COMMAND_ARGUMENT_TYPE.getId(serializer));
            serializer.serializeToNetwork(properties, buf);
        }
    }

    static class LiteralNodeStub
    implements NodeStub {
        private final String id;

        LiteralNodeStub(String literal) {
            this.id = literal;
        }

        @Override
        @Override
        public ArgumentBuilder<SharedSuggestionProvider, ?> build(CommandBuildContext commandRegistryAccess) {
            return LiteralArgumentBuilder.literal((String)this.id);
        }

        @Override
        @Override
        public void write(FriendlyByteBuf buf) {
            buf.writeUtf(this.id);
        }
    }

    static class NodeResolver {
        private final CommandBuildContext context;
        private final List<Entry> entries;
        private final List<CommandNode<SharedSuggestionProvider>> nodes;

        NodeResolver(CommandBuildContext commandRegistryAccess, List<Entry> nodeDatas) {
            this.context = commandRegistryAccess;
            this.entries = nodeDatas;
            ObjectArrayList objectArrayList = new ObjectArrayList();
            objectArrayList.size(nodeDatas.size());
            this.nodes = objectArrayList;
        }

        public CommandNode<SharedSuggestionProvider> resolve(int index) {
            CommandNode<SharedSuggestionProvider> commandNode3;
            CommandNode<SharedSuggestionProvider> commandNode = this.nodes.get(index);
            if (commandNode != null) {
                return commandNode;
            }
            Entry entry = this.entries.get(index);
            if (entry.stub == null) {
                RootCommandNode commandNode2 = new RootCommandNode();
            } else {
                ArgumentBuilder<SharedSuggestionProvider, ?> argumentBuilder = entry.stub.build(this.context);
                if ((entry.flags & 8) != 0) {
                    argumentBuilder.redirect(this.resolve(entry.redirect));
                }
                if ((entry.flags & 4) != 0) {
                    argumentBuilder.executes((Command<SharedSuggestionProvider>)((Command)context -> 0));
                }
                commandNode3 = argumentBuilder.build();
            }
            this.nodes.set(index, commandNode3);
            for (int i : entry.children) {
                CommandNode<SharedSuggestionProvider> commandNode4 = this.resolve(i);
                if (commandNode4 instanceof RootCommandNode) continue;
                commandNode3.addChild(commandNode4);
            }
            return commandNode3;
        }
    }
}

