/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class AdvancementCommands {
    private static final DynamicCommandExceptionType ERROR_NO_ACTION_PERFORMED = new DynamicCommandExceptionType(message -> (Component)message);
    private static final Dynamic2CommandExceptionType ERROR_CRITERION_NOT_FOUND = new Dynamic2CommandExceptionType((advancement, criterion) -> Component.translatableEscape("commands.advancement.criterionNotFound", advancement, criterion));
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_ADVANCEMENTS = (context, builder) -> {
        Collection<AdvancementHolder> collection = ((CommandSourceStack)context.getSource()).getServer().getAdvancements().getAllAdvancements();
        return SharedSuggestionProvider.suggestResource(collection.stream().map(AdvancementHolder::id), builder);
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("advancement").requires(source -> source.hasPermission(2))).then(Commands.literal("grant").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.players()).then(Commands.literal("only").then(((RequiredArgumentBuilder)Commands.argument("advancement", ResourceLocationArgument.id()).suggests(SUGGEST_ADVANCEMENTS).executes(context -> AdvancementCommands.perform((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "targets"), Action.GRANT, AdvancementCommands.getAdvancements((CommandContext<CommandSourceStack>)context, ResourceLocationArgument.getAdvancement((CommandContext<CommandSourceStack>)context, "advancement"), Mode.ONLY)))).then(Commands.argument("criterion", StringArgumentType.greedyString()).suggests((context, builder) -> SharedSuggestionProvider.suggest(ResourceLocationArgument.getAdvancement((CommandContext<CommandSourceStack>)context, "advancement").value().criteria().keySet(), builder)).executes(context -> AdvancementCommands.performCriterion((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "targets"), Action.GRANT, ResourceLocationArgument.getAdvancement((CommandContext<CommandSourceStack>)context, "advancement"), StringArgumentType.getString((CommandContext)context, (String)"criterion"))))))).then(Commands.literal("from").then(Commands.argument("advancement", ResourceLocationArgument.id()).suggests(SUGGEST_ADVANCEMENTS).executes(context -> AdvancementCommands.perform((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "targets"), Action.GRANT, AdvancementCommands.getAdvancements((CommandContext<CommandSourceStack>)context, ResourceLocationArgument.getAdvancement((CommandContext<CommandSourceStack>)context, "advancement"), Mode.FROM)))))).then(Commands.literal("until").then(Commands.argument("advancement", ResourceLocationArgument.id()).suggests(SUGGEST_ADVANCEMENTS).executes(context -> AdvancementCommands.perform((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "targets"), Action.GRANT, AdvancementCommands.getAdvancements((CommandContext<CommandSourceStack>)context, ResourceLocationArgument.getAdvancement((CommandContext<CommandSourceStack>)context, "advancement"), Mode.UNTIL)))))).then(Commands.literal("through").then(Commands.argument("advancement", ResourceLocationArgument.id()).suggests(SUGGEST_ADVANCEMENTS).executes(context -> AdvancementCommands.perform((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "targets"), Action.GRANT, AdvancementCommands.getAdvancements((CommandContext<CommandSourceStack>)context, ResourceLocationArgument.getAdvancement((CommandContext<CommandSourceStack>)context, "advancement"), Mode.THROUGH)))))).then(Commands.literal("everything").executes(context -> AdvancementCommands.perform((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "targets"), Action.GRANT, ((CommandSourceStack)context.getSource()).getServer().getAdvancements().getAllAdvancements())))))).then(Commands.literal("revoke").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.players()).then(Commands.literal("only").then(((RequiredArgumentBuilder)Commands.argument("advancement", ResourceLocationArgument.id()).suggests(SUGGEST_ADVANCEMENTS).executes(context -> AdvancementCommands.perform((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "targets"), Action.REVOKE, AdvancementCommands.getAdvancements((CommandContext<CommandSourceStack>)context, ResourceLocationArgument.getAdvancement((CommandContext<CommandSourceStack>)context, "advancement"), Mode.ONLY)))).then(Commands.argument("criterion", StringArgumentType.greedyString()).suggests((context, builder) -> SharedSuggestionProvider.suggest(ResourceLocationArgument.getAdvancement((CommandContext<CommandSourceStack>)context, "advancement").value().criteria().keySet(), builder)).executes(context -> AdvancementCommands.performCriterion((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "targets"), Action.REVOKE, ResourceLocationArgument.getAdvancement((CommandContext<CommandSourceStack>)context, "advancement"), StringArgumentType.getString((CommandContext)context, (String)"criterion"))))))).then(Commands.literal("from").then(Commands.argument("advancement", ResourceLocationArgument.id()).suggests(SUGGEST_ADVANCEMENTS).executes(context -> AdvancementCommands.perform((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "targets"), Action.REVOKE, AdvancementCommands.getAdvancements((CommandContext<CommandSourceStack>)context, ResourceLocationArgument.getAdvancement((CommandContext<CommandSourceStack>)context, "advancement"), Mode.FROM)))))).then(Commands.literal("until").then(Commands.argument("advancement", ResourceLocationArgument.id()).suggests(SUGGEST_ADVANCEMENTS).executes(context -> AdvancementCommands.perform((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "targets"), Action.REVOKE, AdvancementCommands.getAdvancements((CommandContext<CommandSourceStack>)context, ResourceLocationArgument.getAdvancement((CommandContext<CommandSourceStack>)context, "advancement"), Mode.UNTIL)))))).then(Commands.literal("through").then(Commands.argument("advancement", ResourceLocationArgument.id()).suggests(SUGGEST_ADVANCEMENTS).executes(context -> AdvancementCommands.perform((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "targets"), Action.REVOKE, AdvancementCommands.getAdvancements((CommandContext<CommandSourceStack>)context, ResourceLocationArgument.getAdvancement((CommandContext<CommandSourceStack>)context, "advancement"), Mode.THROUGH)))))).then(Commands.literal("everything").executes(context -> AdvancementCommands.perform((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "targets"), Action.REVOKE, ((CommandSourceStack)context.getSource()).getServer().getAdvancements().getAllAdvancements())))))));
    }

    private static int perform(CommandSourceStack source, Collection<ServerPlayer> targets, Action operation, Collection<AdvancementHolder> selection) throws CommandSyntaxException {
        int i = 0;
        for (ServerPlayer serverPlayer : targets) {
            i += operation.perform(serverPlayer, selection);
        }
        if (i == 0) {
            if (selection.size() == 1) {
                if (targets.size() == 1) {
                    throw ERROR_NO_ACTION_PERFORMED.create((Object)Component.translatable(operation.getKey() + ".one.to.one.failure", Advancement.name(selection.iterator().next()), targets.iterator().next().getDisplayName()));
                }
                throw ERROR_NO_ACTION_PERFORMED.create((Object)Component.translatable(operation.getKey() + ".one.to.many.failure", Advancement.name(selection.iterator().next()), targets.size()));
            }
            if (targets.size() == 1) {
                throw ERROR_NO_ACTION_PERFORMED.create((Object)Component.translatable(operation.getKey() + ".many.to.one.failure", selection.size(), targets.iterator().next().getDisplayName()));
            }
            throw ERROR_NO_ACTION_PERFORMED.create((Object)Component.translatable(operation.getKey() + ".many.to.many.failure", selection.size(), targets.size()));
        }
        if (selection.size() == 1) {
            if (targets.size() == 1) {
                source.sendSuccess(() -> Component.translatable(operation.getKey() + ".one.to.one.success", Advancement.name((AdvancementHolder)selection.iterator().next()), ((ServerPlayer)targets.iterator().next()).getDisplayName()), true);
            } else {
                source.sendSuccess(() -> Component.translatable(operation.getKey() + ".one.to.many.success", Advancement.name((AdvancementHolder)selection.iterator().next()), targets.size()), true);
            }
        } else if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable(operation.getKey() + ".many.to.one.success", selection.size(), ((ServerPlayer)targets.iterator().next()).getDisplayName()), true);
        } else {
            source.sendSuccess(() -> Component.translatable(operation.getKey() + ".many.to.many.success", selection.size(), targets.size()), true);
        }
        return i;
    }

    private static int performCriterion(CommandSourceStack source, Collection<ServerPlayer> targets, Action operation, AdvancementHolder advancement, String criterion) throws CommandSyntaxException {
        int i = 0;
        Advancement advancement2 = advancement.value();
        if (!advancement2.criteria().containsKey(criterion)) {
            throw ERROR_CRITERION_NOT_FOUND.create((Object)Advancement.name(advancement), (Object)criterion);
        }
        for (ServerPlayer serverPlayer : targets) {
            if (!operation.performCriterion(serverPlayer, advancement, criterion)) continue;
            ++i;
        }
        if (i == 0) {
            if (targets.size() == 1) {
                throw ERROR_NO_ACTION_PERFORMED.create((Object)Component.translatable(operation.getKey() + ".criterion.to.one.failure", criterion, Advancement.name(advancement), targets.iterator().next().getDisplayName()));
            }
            throw ERROR_NO_ACTION_PERFORMED.create((Object)Component.translatable(operation.getKey() + ".criterion.to.many.failure", criterion, Advancement.name(advancement), targets.size()));
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable(operation.getKey() + ".criterion.to.one.success", criterion, Advancement.name(advancement), ((ServerPlayer)targets.iterator().next()).getDisplayName()), true);
        } else {
            source.sendSuccess(() -> Component.translatable(operation.getKey() + ".criterion.to.many.success", criterion, Advancement.name(advancement), targets.size()), true);
        }
        return i;
    }

    private static List<AdvancementHolder> getAdvancements(CommandContext<CommandSourceStack> context, AdvancementHolder advancement, Mode selection) {
        AdvancementTree advancementTree = ((CommandSourceStack)context.getSource()).getServer().getAdvancements().tree();
        AdvancementNode advancementNode = advancementTree.get(advancement);
        if (advancementNode == null) {
            return List.of(advancement);
        }
        ArrayList<AdvancementHolder> list = new ArrayList<AdvancementHolder>();
        if (selection.parents) {
            for (AdvancementNode advancementNode2 = advancementNode.parent(); advancementNode2 != null; advancementNode2 = advancementNode2.parent()) {
                list.add(advancementNode2.holder());
            }
        }
        list.add(advancement);
        if (selection.children) {
            AdvancementCommands.addChildren(advancementNode, list);
        }
        return list;
    }

    private static void addChildren(AdvancementNode parent, List<AdvancementHolder> childList) {
        for (AdvancementNode advancementNode : parent.children()) {
            childList.add(advancementNode.holder());
            AdvancementCommands.addChildren(advancementNode, childList);
        }
    }

    static enum Action {
        GRANT("grant"){

            @Override
            @Override
            protected boolean perform(ServerPlayer player, AdvancementHolder advancement) {
                AdvancementProgress advancementProgress = player.getAdvancements().getOrStartProgress(advancement);
                if (advancementProgress.isDone()) {
                    return false;
                }
                for (String string : advancementProgress.getRemainingCriteria()) {
                    player.getAdvancements().award(advancement, string);
                }
                return true;
            }

            @Override
            @Override
            protected boolean performCriterion(ServerPlayer player, AdvancementHolder advancement, String criterion) {
                return player.getAdvancements().award(advancement, criterion);
            }
        }
        ,
        REVOKE("revoke"){

            @Override
            @Override
            protected boolean perform(ServerPlayer player, AdvancementHolder advancement) {
                AdvancementProgress advancementProgress = player.getAdvancements().getOrStartProgress(advancement);
                if (!advancementProgress.hasProgress()) {
                    return false;
                }
                for (String string : advancementProgress.getCompletedCriteria()) {
                    player.getAdvancements().revoke(advancement, string);
                }
                return true;
            }

            @Override
            @Override
            protected boolean performCriterion(ServerPlayer player, AdvancementHolder advancement, String criterion) {
                return player.getAdvancements().revoke(advancement, criterion);
            }
        };

        private final String key;

        Action(String name) {
            this.key = "commands.advancement." + name;
        }

        public int perform(ServerPlayer player, Iterable<AdvancementHolder> advancements) {
            int i = 0;
            for (AdvancementHolder advancementHolder : advancements) {
                if (!this.perform(player, advancementHolder)) continue;
                ++i;
            }
            return i;
        }

        protected abstract boolean perform(ServerPlayer var1, AdvancementHolder var2);

        protected abstract boolean performCriterion(ServerPlayer var1, AdvancementHolder var2, String var3);

        protected String getKey() {
            return this.key;
        }
    }

    static enum Mode {
        ONLY(false, false),
        THROUGH(true, true),
        FROM(false, true),
        UNTIL(true, false),
        EVERYTHING(true, true);

        final boolean parents;
        final boolean children;

        private Mode(boolean before, boolean after) {
            this.parents = before;
            this.children = after;
        }
    }
}

