/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.net.InetAddresses;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.IpBanListEntry;
import org.bukkit.event.player.PlayerKickEvent;

public class BanIpCommands {
    private static final SimpleCommandExceptionType ERROR_INVALID_IP = new SimpleCommandExceptionType((Message)Component.translatable("commands.banip.invalid"));
    private static final SimpleCommandExceptionType ERROR_ALREADY_BANNED = new SimpleCommandExceptionType((Message)Component.translatable("commands.banip.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("ban-ip").requires(source -> source.hasPermission(3))).then(((RequiredArgumentBuilder)Commands.argument("target", StringArgumentType.word()).executes(context -> BanIpCommands.banIpOrName((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"target"), null))).then(Commands.argument("reason", MessageArgument.message()).executes(context -> BanIpCommands.banIpOrName((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"target"), MessageArgument.getMessage((CommandContext<CommandSourceStack>)context, "reason")))))));
    }

    private static int banIpOrName(CommandSourceStack source, String target, @Nullable Component reason) throws CommandSyntaxException {
        if (InetAddresses.isInetAddress((String)target)) {
            return BanIpCommands.banIp(source, target, reason);
        }
        ServerPlayer serverPlayer = source.getServer().getPlayerList().getPlayerByName(target);
        if (serverPlayer != null) {
            return BanIpCommands.banIp(source, serverPlayer.getIpAddress(), reason);
        }
        throw ERROR_INVALID_IP.create();
    }

    private static int banIp(CommandSourceStack source, String targetIp, @Nullable Component reason) throws CommandSyntaxException {
        IpBanList ipBanList = source.getServer().getPlayerList().getIpBans();
        if (ipBanList.isBanned(targetIp)) {
            throw ERROR_ALREADY_BANNED.create();
        }
        List<ServerPlayer> list = source.getServer().getPlayerList().getPlayersWithAddress(targetIp);
        IpBanListEntry ipBanListEntry = new IpBanListEntry(targetIp, null, source.getTextName(), null, reason == null ? null : reason.getString());
        ipBanList.add(ipBanListEntry);
        source.sendSuccess(() -> Component.translatable("commands.banip.success", targetIp, ipBanListEntry.getReason()), true);
        if (!list.isEmpty()) {
            source.sendSuccess(() -> Component.translatable("commands.banip.info", list.size(), EntitySelector.joinNames(list)), true);
        }
        for (ServerPlayer serverPlayer : list) {
            serverPlayer.connection.disconnect(Component.translatable("multiplayer.disconnect.ip_banned"), PlayerKickEvent.Cause.IP_BANNED);
        }
        return list.size();
    }
}

