/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.item.ItemPredicateArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class ClearInventoryCommands {
    private static final DynamicCommandExceptionType ERROR_SINGLE = new DynamicCommandExceptionType(playerName -> Component.translatableEscape("clear.failed.single", playerName));
    private static final DynamicCommandExceptionType ERROR_MULTIPLE = new DynamicCommandExceptionType(playerCount -> Component.translatableEscape("clear.failed.multiple", playerCount));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandRegistryAccess) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("clear").requires(source -> source.hasPermission(2))).executes(context -> ClearInventoryCommands.clearUnlimited((CommandSourceStack)context.getSource(), Collections.singleton(((CommandSourceStack)context.getSource()).getPlayerOrException()), stack -> true))).then(((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.players()).executes(context -> ClearInventoryCommands.clearUnlimited((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "targets"), stack -> true))).then(((RequiredArgumentBuilder)Commands.argument("item", ItemPredicateArgument.itemPredicate(commandRegistryAccess)).executes(context -> ClearInventoryCommands.clearUnlimited((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "targets"), ItemPredicateArgument.getItemPredicate((CommandContext<CommandSourceStack>)context, "item")))).then(Commands.argument("maxCount", IntegerArgumentType.integer((int)0)).executes(context -> ClearInventoryCommands.clearInventory((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "targets"), ItemPredicateArgument.getItemPredicate((CommandContext<CommandSourceStack>)context, "item"), IntegerArgumentType.getInteger((CommandContext)context, (String)"maxCount"))))))));
    }

    private static int clearUnlimited(CommandSourceStack source, Collection<ServerPlayer> targets, Predicate<ItemStack> item) throws CommandSyntaxException {
        return ClearInventoryCommands.clearInventory(source, targets, item, -1);
    }

    private static int clearInventory(CommandSourceStack source, Collection<ServerPlayer> targets, Predicate<ItemStack> item, int maxCount) throws CommandSyntaxException {
        int i = 0;
        for (ServerPlayer serverPlayer : targets) {
            i += serverPlayer.getInventory().clearOrCountMatchingItems(item, maxCount, serverPlayer.inventoryMenu.getCraftSlots());
            serverPlayer.containerMenu.broadcastChanges();
            serverPlayer.inventoryMenu.slotsChanged(serverPlayer.getInventory());
        }
        if (i == 0) {
            if (targets.size() == 1) {
                throw ERROR_SINGLE.create((Object)targets.iterator().next().getName());
            }
            throw ERROR_MULTIPLE.create((Object)targets.size());
        }
        int j = i;
        if (maxCount == 0) {
            if (targets.size() == 1) {
                source.sendSuccess(() -> Component.translatable("commands.clear.test.single", j, ((ServerPlayer)targets.iterator().next()).getDisplayName()), true);
            } else {
                source.sendSuccess(() -> Component.translatable("commands.clear.test.multiple", j, targets.size()), true);
            }
        } else if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable("commands.clear.success.single", j, ((ServerPlayer)targets.iterator().next()).getDisplayName()), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.clear.success.multiple", j, targets.size()), true);
        }
        return i;
    }
}

