/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import org.bukkit.entity.Player;

public class ListPlayersCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("list").executes(commandcontext -> ListPlayersCommand.listPlayers((CommandSourceStack)commandcontext.getSource()))).then(Commands.literal("uuids").executes(commandcontext -> ListPlayersCommand.listPlayersWithUuids((CommandSourceStack)commandcontext.getSource())))));
    }

    private static int listPlayers(CommandSourceStack source) {
        return ListPlayersCommand.format(source, net.minecraft.world.entity.player.Player::getDisplayName);
    }

    private static int listPlayersWithUuids(CommandSourceStack source) {
        return ListPlayersCommand.format(source, entityplayer -> Component.translatable("commands.list.nameAndId", entityplayer.getName(), Component.translationArg(entityplayer.getGameProfile().getId())));
    }

    private static int format(CommandSourceStack source, Function<ServerPlayer, Component> nameProvider) {
        PlayerList playerlist = source.getServer().getPlayerList();
        List<ServerPlayer> players = playerlist.getPlayers();
        if (source.getBukkitSender() instanceof Player) {
            Player sender = (Player)source.getBukkitSender();
            players = players.stream().filter(ep -> sender.canSee((Player)ep.getBukkitEntity())).collect(Collectors.toList());
        }
        List<ServerPlayer> list = players;
        Component ichatbasecomponent = ComponentUtils.formatList(list, nameProvider);
        source.sendSuccess(() -> Component.translatable("commands.list.players", list.size(), playerlist.getMaxPlayers(), ichatbasecomponent), false);
        return list.size();
    }
}

