/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceOrIdArgument;
import net.minecraft.commands.arguments.SlotArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.commands.ItemCommands;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class LootCommand {
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_LOOT_TABLE = (commandcontext, suggestionsbuilder) -> {
        ReloadableServerRegistries.Holder reloadableserverregistries_b = ((CommandSourceStack)commandcontext.getSource()).getServer().reloadableRegistries();
        return SharedSuggestionProvider.suggestResource(reloadableserverregistries_b.getKeys(Registries.LOOT_TABLE), suggestionsbuilder);
    };
    private static final DynamicCommandExceptionType ERROR_NO_HELD_ITEMS = new DynamicCommandExceptionType(object -> Component.translatableEscape("commands.drop.no_held_items", object));
    private static final DynamicCommandExceptionType ERROR_NO_LOOT_TABLE = new DynamicCommandExceptionType(object -> Component.translatableEscape("commands.drop.no_loot_table", object));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandRegistryAccess) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)LootCommand.addTargets((LiteralArgumentBuilder)Commands.literal("loot").requires(commandlistenerwrapper -> commandlistenerwrapper.hasPermission(2)), (argumentbuilder, commandloot_b) -> ((ArgumentBuilder)((ArgumentBuilder)((ArgumentBuilder)argumentbuilder.then(Commands.literal("fish").then(Commands.argument("loot_table", ResourceOrIdArgument.lootTable(commandRegistryAccess)).suggests(SUGGEST_LOOT_TABLE).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("pos", BlockPosArgument.blockPos()).executes(commandcontext -> LootCommand.dropFishingLoot((CommandContext<CommandSourceStack>)commandcontext, ResourceOrIdArgument.getLootTable((CommandContext<CommandSourceStack>)commandcontext, "loot_table"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandcontext, "pos"), ItemStack.EMPTY, commandloot_b))).then(Commands.argument("tool", ItemArgument.item(commandRegistryAccess)).executes(commandcontext -> LootCommand.dropFishingLoot((CommandContext<CommandSourceStack>)commandcontext, ResourceOrIdArgument.getLootTable((CommandContext<CommandSourceStack>)commandcontext, "loot_table"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandcontext, "pos"), ItemArgument.getItem(commandcontext, "tool").createItemStack(1, false), commandloot_b)))).then(Commands.literal("mainhand").executes(commandcontext -> LootCommand.dropFishingLoot((CommandContext<CommandSourceStack>)commandcontext, ResourceOrIdArgument.getLootTable((CommandContext<CommandSourceStack>)commandcontext, "loot_table"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandcontext, "pos"), LootCommand.getSourceHandItem((CommandSourceStack)commandcontext.getSource(), EquipmentSlot.MAINHAND), commandloot_b)))).then(Commands.literal("offhand").executes(commandcontext -> LootCommand.dropFishingLoot((CommandContext<CommandSourceStack>)commandcontext, ResourceOrIdArgument.getLootTable((CommandContext<CommandSourceStack>)commandcontext, "loot_table"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandcontext, "pos"), LootCommand.getSourceHandItem((CommandSourceStack)commandcontext.getSource(), EquipmentSlot.OFFHAND), commandloot_b))))))).then(Commands.literal("loot").then(Commands.argument("loot_table", ResourceOrIdArgument.lootTable(commandRegistryAccess)).suggests(SUGGEST_LOOT_TABLE).executes(commandcontext -> LootCommand.dropChestLoot((CommandContext<CommandSourceStack>)commandcontext, ResourceOrIdArgument.getLootTable((CommandContext<CommandSourceStack>)commandcontext, "loot_table"), commandloot_b))))).then(Commands.literal("kill").then(Commands.argument("target", EntityArgument.entity()).executes(commandcontext -> LootCommand.dropKillLoot((CommandContext<CommandSourceStack>)commandcontext, EntityArgument.getEntity((CommandContext<CommandSourceStack>)commandcontext, "target"), commandloot_b))))).then(Commands.literal("mine").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("pos", BlockPosArgument.blockPos()).executes(commandcontext -> LootCommand.dropBlockLoot((CommandContext<CommandSourceStack>)commandcontext, BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandcontext, "pos"), ItemStack.EMPTY, commandloot_b))).then(Commands.argument("tool", ItemArgument.item(commandRegistryAccess)).executes(commandcontext -> LootCommand.dropBlockLoot((CommandContext<CommandSourceStack>)commandcontext, BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandcontext, "pos"), ItemArgument.getItem(commandcontext, "tool").createItemStack(1, false), commandloot_b)))).then(Commands.literal("mainhand").executes(commandcontext -> LootCommand.dropBlockLoot((CommandContext<CommandSourceStack>)commandcontext, BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandcontext, "pos"), LootCommand.getSourceHandItem((CommandSourceStack)commandcontext.getSource(), EquipmentSlot.MAINHAND), commandloot_b)))).then(Commands.literal("offhand").executes(commandcontext -> LootCommand.dropBlockLoot((CommandContext<CommandSourceStack>)commandcontext, BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandcontext, "pos"), LootCommand.getSourceHandItem((CommandSourceStack)commandcontext.getSource(), EquipmentSlot.OFFHAND), commandloot_b)))))));
    }

    private static <T extends ArgumentBuilder<CommandSourceStack, T>> T addTargets(T rootArgument, TailProvider sourceConstructor) {
        return ((ArgumentBuilder)((ArgumentBuilder)((ArgumentBuilder)rootArgument.then(((LiteralArgumentBuilder)Commands.literal("replace").then(Commands.literal("entity").then(Commands.argument("entities", EntityArgument.entities()).then(sourceConstructor.construct((ArgumentBuilder<CommandSourceStack, ?>)Commands.argument("slot", SlotArgument.slot()), (commandcontext, list, commandloot_a) -> LootCommand.entityReplace(EntityArgument.getEntities((CommandContext<CommandSourceStack>)commandcontext, "entities"), SlotArgument.getSlot((CommandContext<CommandSourceStack>)commandcontext, "slot"), list.size(), list, commandloot_a)).then(sourceConstructor.construct((ArgumentBuilder<CommandSourceStack, ?>)Commands.argument("count", IntegerArgumentType.integer((int)0)), (commandcontext, list, commandloot_a) -> LootCommand.entityReplace(EntityArgument.getEntities((CommandContext<CommandSourceStack>)commandcontext, "entities"), SlotArgument.getSlot((CommandContext<CommandSourceStack>)commandcontext, "slot"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"count"), list, commandloot_a))))))).then(Commands.literal("block").then(Commands.argument("targetPos", BlockPosArgument.blockPos()).then(sourceConstructor.construct((ArgumentBuilder<CommandSourceStack, ?>)Commands.argument("slot", SlotArgument.slot()), (commandcontext, list, commandloot_a) -> LootCommand.blockReplace((CommandSourceStack)commandcontext.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandcontext, "targetPos"), SlotArgument.getSlot((CommandContext<CommandSourceStack>)commandcontext, "slot"), list.size(), list, commandloot_a)).then(sourceConstructor.construct((ArgumentBuilder<CommandSourceStack, ?>)Commands.argument("count", IntegerArgumentType.integer((int)0)), (commandcontext, list, commandloot_a) -> LootCommand.blockReplace((CommandSourceStack)commandcontext.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandcontext, "targetPos"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"slot"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"count"), list, commandloot_a)))))))).then(Commands.literal("insert").then(sourceConstructor.construct((ArgumentBuilder<CommandSourceStack, ?>)Commands.argument("targetPos", BlockPosArgument.blockPos()), (commandcontext, list, commandloot_a) -> LootCommand.blockDistribute((CommandSourceStack)commandcontext.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandcontext, "targetPos"), list, commandloot_a))))).then(Commands.literal("give").then(sourceConstructor.construct((ArgumentBuilder<CommandSourceStack, ?>)Commands.argument("players", EntityArgument.players()), (commandcontext, list, commandloot_a) -> LootCommand.playerGive(EntityArgument.getPlayers((CommandContext<CommandSourceStack>)commandcontext, "players"), list, commandloot_a))))).then(Commands.literal("spawn").then(sourceConstructor.construct((ArgumentBuilder<CommandSourceStack, ?>)Commands.argument("targetPos", Vec3Argument.vec3()), (commandcontext, list, commandloot_a) -> LootCommand.dropInWorld((CommandSourceStack)commandcontext.getSource(), Vec3Argument.getVec3((CommandContext<CommandSourceStack>)commandcontext, "targetPos"), list, commandloot_a))));
    }

    private static Container getContainer(CommandSourceStack source, BlockPos pos) throws CommandSyntaxException {
        BlockEntity tileentity = source.getLevel().getBlockEntity(pos);
        if (!(tileentity instanceof Container)) {
            throw ItemCommands.ERROR_TARGET_NOT_A_CONTAINER.create((Object)pos.getX(), (Object)pos.getY(), (Object)pos.getZ());
        }
        return (Container)((Object)tileentity);
    }

    private static int blockDistribute(CommandSourceStack source, BlockPos targetPos, List<ItemStack> stacks, Callback messageSender) throws CommandSyntaxException {
        Container iinventory = LootCommand.getContainer(source, targetPos);
        ArrayList list1 = Lists.newArrayListWithCapacity((int)stacks.size());
        for (ItemStack itemstack : stacks) {
            if (!LootCommand.distributeToContainer(iinventory, itemstack.copy())) continue;
            iinventory.setChanged();
            list1.add(itemstack);
        }
        messageSender.accept(list1);
        return list1.size();
    }

    private static boolean distributeToContainer(Container inventory, ItemStack stack) {
        boolean flag = false;
        for (int i = 0; i < inventory.getContainerSize() && !stack.isEmpty(); ++i) {
            ItemStack itemstack1 = inventory.getItem(i);
            if (!inventory.canPlaceItem(i, stack)) continue;
            if (itemstack1.isEmpty()) {
                inventory.setItem(i, stack);
                flag = true;
                break;
            }
            if (!LootCommand.canMergeItems(itemstack1, stack)) continue;
            int j = stack.getMaxStackSize() - itemstack1.getCount();
            int k = Math.min(stack.getCount(), j);
            stack.shrink(k);
            itemstack1.grow(k);
            flag = true;
        }
        return flag;
    }

    private static int blockReplace(CommandSourceStack source, BlockPos targetPos, int slot, int stackCount, List<ItemStack> stacks, Callback messageSender) throws CommandSyntaxException {
        Container iinventory = LootCommand.getContainer(source, targetPos);
        int k = iinventory.getContainerSize();
        if (slot >= 0 && slot < k) {
            ArrayList list1 = Lists.newArrayListWithCapacity((int)stacks.size());
            for (int l = 0; l < stackCount; ++l) {
                ItemStack itemstack;
                int i1 = slot + l;
                ItemStack itemStack = itemstack = l < stacks.size() ? stacks.get(l) : ItemStack.EMPTY;
                if (!iinventory.canPlaceItem(i1, itemstack)) continue;
                iinventory.setItem(i1, itemstack);
                list1.add(itemstack);
            }
            messageSender.accept(list1);
            return list1.size();
        }
        throw ItemCommands.ERROR_TARGET_INAPPLICABLE_SLOT.create((Object)slot);
    }

    private static boolean canMergeItems(ItemStack first, ItemStack second) {
        return first.getCount() <= first.getMaxStackSize() && ItemStack.isSameItemSameComponents(first, second);
    }

    private static int playerGive(Collection<ServerPlayer> players, List<ItemStack> stacks, Callback messageSender) throws CommandSyntaxException {
        ArrayList list1 = Lists.newArrayListWithCapacity((int)stacks.size());
        for (ItemStack itemstack : stacks) {
            for (ServerPlayer entityplayer : players) {
                if (!entityplayer.getInventory().add(itemstack.copy())) continue;
                list1.add(itemstack);
            }
        }
        messageSender.accept(list1);
        return list1.size();
    }

    private static void setSlots(Entity entity, List<ItemStack> stacks, int slot, int stackCount, List<ItemStack> addedStacks) {
        for (int k = 0; k < stackCount; ++k) {
            ItemStack itemstack = k < stacks.size() ? stacks.get(k) : ItemStack.EMPTY;
            SlotAccess slotaccess = entity.getSlot(slot + k);
            if (slotaccess == SlotAccess.NULL || !slotaccess.set(itemstack.copy())) continue;
            addedStacks.add(itemstack);
        }
    }

    private static int entityReplace(Collection<? extends Entity> targets, int slot, int stackCount, List<ItemStack> stacks, Callback messageSender) throws CommandSyntaxException {
        ArrayList list1 = Lists.newArrayListWithCapacity((int)stacks.size());
        for (Entity entity : targets) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer entityplayer = (ServerPlayer)entity;
                LootCommand.setSlots(entity, stacks, slot, stackCount, list1);
                entityplayer.containerMenu.broadcastChanges();
                continue;
            }
            LootCommand.setSlots(entity, stacks, slot, stackCount, list1);
        }
        messageSender.accept(list1);
        return list1.size();
    }

    private static int dropInWorld(CommandSourceStack source, Vec3 pos, List<ItemStack> stacks, Callback messageSender) throws CommandSyntaxException {
        ServerLevel worldserver = source.getLevel();
        stacks.removeIf(ItemStack::isEmpty);
        stacks.forEach(itemstack -> {
            ItemEntity entityitem = new ItemEntity(worldserver, pos.x, pos.y, pos.z, itemstack.copy());
            entityitem.setDefaultPickUpDelay();
            worldserver.addFreshEntity(entityitem);
        });
        messageSender.accept(stacks);
        return stacks.size();
    }

    private static void callback(CommandSourceStack source, List<ItemStack> stacks) {
        if (stacks.size() == 1) {
            ItemStack itemstack = stacks.get(0);
            source.sendSuccess(() -> Component.translatable("commands.drop.success.single", itemstack.getCount(), itemstack.getDisplayName()), false);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.drop.success.multiple", stacks.size()), false);
        }
    }

    private static void callback(CommandSourceStack source, List<ItemStack> stacks, ResourceKey<LootTable> lootTable) {
        if (stacks.size() == 1) {
            ItemStack itemstack = stacks.get(0);
            source.sendSuccess(() -> Component.translatable("commands.drop.success.single_with_table", itemstack.getCount(), itemstack.getDisplayName(), Component.translationArg(lootTable.location())), false);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.drop.success.multiple_with_table", stacks.size(), Component.translationArg(lootTable.location())), false);
        }
    }

    private static ItemStack getSourceHandItem(CommandSourceStack source, EquipmentSlot slot) throws CommandSyntaxException {
        Entity entity = source.getEntityOrException();
        if (entity instanceof LivingEntity) {
            return ((LivingEntity)entity).getItemBySlot(slot);
        }
        throw ERROR_NO_HELD_ITEMS.create((Object)entity.getDisplayName());
    }

    private static int dropBlockLoot(CommandContext<CommandSourceStack> context, BlockPos pos, ItemStack stack, DropConsumer constructor) throws CommandSyntaxException {
        CommandSourceStack commandlistenerwrapper = (CommandSourceStack)context.getSource();
        ServerLevel worldserver = commandlistenerwrapper.getLevel();
        BlockState iblockdata = worldserver.getBlockState(pos);
        BlockEntity tileentity = worldserver.getBlockEntity(pos);
        LootParams.Builder lootparams_a = new LootParams.Builder(worldserver).withParameter(LootContextParams.ORIGIN, Vec3.atCenterOf(pos)).withParameter(LootContextParams.BLOCK_STATE, iblockdata).withOptionalParameter(LootContextParams.BLOCK_ENTITY, tileentity).withOptionalParameter(LootContextParams.THIS_ENTITY, commandlistenerwrapper.getEntity()).withParameter(LootContextParams.TOOL, stack);
        List<ItemStack> list = iblockdata.getDrops(lootparams_a);
        return constructor.accept(context, list, list1 -> LootCommand.callback(commandlistenerwrapper, list1, iblockdata.getBlock().getLootTable()));
    }

    private static int dropKillLoot(CommandContext<CommandSourceStack> context, Entity entity, DropConsumer constructor) throws CommandSyntaxException {
        if (!(entity instanceof LivingEntity)) {
            throw ERROR_NO_LOOT_TABLE.create((Object)entity.getDisplayName());
        }
        ResourceKey<LootTable> resourcekey = ((LivingEntity)entity).getLootTable();
        CommandSourceStack commandlistenerwrapper = (CommandSourceStack)context.getSource();
        LootParams.Builder lootparams_a = new LootParams.Builder(commandlistenerwrapper.getLevel());
        Entity entity1 = commandlistenerwrapper.getEntity();
        if (entity1 instanceof Player) {
            Player entityhuman = (Player)entity1;
            lootparams_a.withParameter(LootContextParams.LAST_DAMAGE_PLAYER, entityhuman);
        }
        lootparams_a.withParameter(LootContextParams.DAMAGE_SOURCE, entity.damageSources().magic());
        lootparams_a.withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, entity1);
        lootparams_a.withOptionalParameter(LootContextParams.ATTACKING_ENTITY, entity1);
        lootparams_a.withParameter(LootContextParams.THIS_ENTITY, entity);
        lootparams_a.withParameter(LootContextParams.ORIGIN, commandlistenerwrapper.getPosition());
        LootParams lootparams = lootparams_a.create(LootContextParamSets.ENTITY);
        LootTable loottable = commandlistenerwrapper.getServer().reloadableRegistries().getLootTable(resourcekey);
        ObjectArrayList<ItemStack> list = loottable.getRandomItems(lootparams);
        return constructor.accept(context, (List<ItemStack>)list, list1 -> LootCommand.callback(commandlistenerwrapper, list1, resourcekey));
    }

    private static int dropChestLoot(CommandContext<CommandSourceStack> context, Holder<LootTable> lootTable, DropConsumer constructor) throws CommandSyntaxException {
        CommandSourceStack commandlistenerwrapper = (CommandSourceStack)context.getSource();
        LootParams lootparams = new LootParams.Builder(commandlistenerwrapper.getLevel()).withOptionalParameter(LootContextParams.THIS_ENTITY, commandlistenerwrapper.getEntity()).withParameter(LootContextParams.ORIGIN, commandlistenerwrapper.getPosition()).create(LootContextParamSets.CHEST);
        return LootCommand.drop(context, lootTable, lootparams, constructor);
    }

    private static int dropFishingLoot(CommandContext<CommandSourceStack> context, Holder<LootTable> lootTable, BlockPos pos, ItemStack stack, DropConsumer constructor) throws CommandSyntaxException {
        CommandSourceStack commandlistenerwrapper = (CommandSourceStack)context.getSource();
        LootParams lootparams = new LootParams.Builder(commandlistenerwrapper.getLevel()).withParameter(LootContextParams.ORIGIN, Vec3.atCenterOf(pos)).withParameter(LootContextParams.TOOL, stack).withOptionalParameter(LootContextParams.THIS_ENTITY, commandlistenerwrapper.getEntity()).create(LootContextParamSets.FISHING);
        return LootCommand.drop(context, lootTable, lootparams, constructor);
    }

    private static int drop(CommandContext<CommandSourceStack> context, Holder<LootTable> lootTable, LootParams lootContextParameters, DropConsumer constructor) throws CommandSyntaxException {
        CommandSourceStack commandlistenerwrapper = (CommandSourceStack)context.getSource();
        ObjectArrayList<ItemStack> list = lootTable.value().getRandomItems(lootContextParameters);
        return constructor.accept(context, (List<ItemStack>)list, list1 -> LootCommand.callback(commandlistenerwrapper, list1));
    }

    @FunctionalInterface
    private static interface TailProvider {
        public ArgumentBuilder<CommandSourceStack, ?> construct(ArgumentBuilder<CommandSourceStack, ?> var1, DropConsumer var2);
    }

    @FunctionalInterface
    private static interface DropConsumer {
        public int accept(CommandContext<CommandSourceStack> var1, List<ItemStack> var2, Callback var3) throws CommandSyntaxException;
    }

    @FunctionalInterface
    private static interface Callback {
        public void accept(List<ItemStack> var1) throws CommandSyntaxException;
    }
}

