/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.destroystokyo.paper.event.player.PlayerSetSpawnEvent;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.AngleArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class SetSpawnCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("spawnpoint").requires(commandlistenerwrapper -> commandlistenerwrapper.hasPermission(2))).executes(commandcontext -> SetSpawnCommand.setSpawn((CommandSourceStack)commandcontext.getSource(), Collections.singleton(((CommandSourceStack)commandcontext.getSource()).getPlayerOrException()), BlockPos.containing(((CommandSourceStack)commandcontext.getSource()).getPosition()), 0.0f))).then(((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.players()).executes(commandcontext -> SetSpawnCommand.setSpawn((CommandSourceStack)commandcontext.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)commandcontext, "targets"), BlockPos.containing(((CommandSourceStack)commandcontext.getSource()).getPosition()), 0.0f))).then(((RequiredArgumentBuilder)Commands.argument("pos", BlockPosArgument.blockPos()).executes(commandcontext -> SetSpawnCommand.setSpawn((CommandSourceStack)commandcontext.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)commandcontext, "targets"), BlockPosArgument.getSpawnablePos((CommandContext<CommandSourceStack>)commandcontext, "pos"), 0.0f))).then(Commands.argument("angle", AngleArgument.angle()).executes(commandcontext -> SetSpawnCommand.setSpawn((CommandSourceStack)commandcontext.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)commandcontext, "targets"), BlockPosArgument.getSpawnablePos((CommandContext<CommandSourceStack>)commandcontext, "pos"), AngleArgument.getAngle((CommandContext<CommandSourceStack>)commandcontext, "angle"))))))));
    }

    private static int setSpawn(CommandSourceStack source, Collection<ServerPlayer> targets, BlockPos pos, float angle) {
        ResourceKey<Level> resourcekey = source.getLevel().dimension();
        Iterator<ServerPlayer> iterator = targets.iterator();
        ArrayList<ServerPlayer> actualTargets = new ArrayList<ServerPlayer>();
        while (iterator.hasNext()) {
            ServerPlayer entityplayer = iterator.next();
            if (!entityplayer.setRespawnPosition(resourcekey, pos, angle, true, false, PlayerSetSpawnEvent.Cause.COMMAND)) continue;
            actualTargets.add(entityplayer);
        }
        if (actualTargets.isEmpty()) {
            return 0;
        }
        String s = resourcekey.location().toString();
        if (actualTargets.size() == 1) {
            source.sendSuccess(() -> Component.translatable("commands.spawnpoint.success.single", pos.getX(), pos.getY(), pos.getZ(), Float.valueOf(angle), s, ((ServerPlayer)actualTargets.iterator().next()).getDisplayName()), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.spawnpoint.success.multiple", pos.getX(), pos.getY(), pos.getZ(), Float.valueOf(angle), s, actualTargets.size()), true);
        }
        return actualTargets.size();
    }
}

